/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing.oracle;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleShardingKeyBuilder;
import oracle.jdbc.pool.OracleDataSource;
import oracle.ons.ONS;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.ChunkEventHandler;
import oracle.ucp.routing.ChunkInfo;
import oracle.ucp.routing.ShardInfo;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.routing.oracle.ChunkInfoImpl;
import oracle.ucp.util.UCPErrorHandler;

public class OracleShardRoutingCache
extends ShardRoutingCache {
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String URL = "url";
    public static final String REGION = "region";
    public static final String SERVICE_NAME = "serviceName";
    private Properties dataSourceProperties = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    OracleShardRoutingCache(final ONS ons) throws UniversalConnectionPoolException {
        ONSDriver onsDriver = new ONSDriver(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            protected ONS getONS() throws UniversalConnectionPoolException {
                return ons;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleShardRoutingCache.class, ONS.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("getONS", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        this.startEventHandler(onsDriver);
    }

    public OracleShardRoutingCache(Properties dataSourceProps) throws UniversalConnectionPoolException {
        if (dataSourceProps == null) {
            throw new IllegalArgumentException("Invalid datasource properties provided");
        }
        String serviceName = dataSourceProps.getProperty(SERVICE_NAME, null);
        if (serviceName == null) {
            throw new IllegalStateException("Service name must be set on datasource properties.");
        }
        this.dataSourceProperties = dataSourceProps;
        this.initializeCache();
    }

    public void initializeCache() throws UniversalConnectionPoolException {
        String serviceName = this.dataSourceProperties.getProperty(SERVICE_NAME);
        try (Connection conn = this.getConnectionFromDatasource();){
            String onsConfStr;
            if (this.dataSourceProperties.containsKey(REGION) && (onsConfStr = this.getOnsConfig(conn, this.dataSourceProperties.getProperty(REGION))) != null) {
                ONSDriver onsDrvr = ONSDriver.instance();
                onsDrvr.start(onsConfStr);
                this.startEventHandler(onsDrvr);
            }
            this.shardingMetadata.compareAndSet(null, this.fetchShardingMetadata(conn, serviceName));
            this.buildTopologyForInstance(conn, serviceName);
            if (this.getRoutingTableSize() == 0) {
                UCPErrorHandler.throwUniversalConnectionPoolException(280);
            }
        }
        catch (SQLException e) {
            throw new UniversalConnectionPoolException(e);
        }
    }

    @Override
    protected PreparedStatement prepareStatementForChunkMetaData(Connection oConn, String serviceName) throws SQLException {
        boolean isMultipleTableFamilySupported = this.multipleTableFamilySupported(oConn);
        String regionName = this.dataSourceProperties != null ? this.dataSourceProperties.getProperty(REGION, null) : null;
        String regionCaluse = regionName != null ? " and (s.locality = 0 OR (s.locality = 1 AND d.region_name = ?))" : "";
        String sql = isMultipleTableFamilySupported ? "SELECT c.CHUNK_NAME, c.SHARD_KEY_LOW, c.SHARD_KEY_HIGH, c.GROUP_KEY_LOW, c.GROUP_KEY_HIGH, c.PRIORITY, c.INST_ID, c.CHUNK_ID, c.SHARD_NAME, c.CHUNK_UNIQUE_ID from local_chunks c, gsmadmin_internal.service s, gsmadmin_internal.sha_databases d, local_table_family_services tfs where tfs.SERVICE_NAME=? and s.network_name = tfs.service_name and c.shard_name = d.db_unique_name and d.db_up = 'Y' and ((S.ROLE IS NULL) OR S.ROLE = 0 OR (S.ROLE=1 AND D.IS_PRIMARY='Y') OR (S.ROLE IN (2,3,4) AND D.IS_PRIMARY='N'))" + regionCaluse + " and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL  and CHUNK_NAME is not NULL" : "SELECT c.CHUNK_NAME, c.SHARD_KEY_LOW, c.SHARD_KEY_HIGH, c.GROUP_KEY_LOW, c.GROUP_KEY_HIGH, c.PRIORITY, c.INST_ID, c.CHUNK_ID, c.SHARD_NAME, c.CHUNK_UNIQUE_ID from local_chunks c, gsmadmin_internal.service s, gsmadmin_internal.sha_databases d where s.network_name = ? and c.shard_name = d.db_unique_name and d.db_up = 'Y' and ((S.ROLE IS NULL) OR S.ROLE = 0 OR (S.ROLE=1 AND D.IS_PRIMARY='Y') OR (S.ROLE IN (2,3,4) AND D.IS_PRIMARY='N'))" + regionCaluse + " and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and CHUNK_NAME is not NULL";
        PreparedStatement ps = oConn.prepareStatement(sql);
        ps.setString(1, serviceName);
        if (regionName != null) {
            ps.setString(2, regionName);
        }
        return ps;
    }

    private Connection getConnectionFromDatasource() throws SQLException {
        OracleDataSource datasource = new OracleDataSource();
        String url = this.dataSourceProperties.getProperty(URL);
        datasource.setURL(url);
        datasource.setConnectionProperties(this.dataSourceProperties);
        return datasource.getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getOnsConfig(Connection conn, String onsConfigStr) throws UniversalConnectionPoolException {
        String onsSql = "select gsmadmin_internal.dbms_gsm_utility.getgdsonsconfig('" + onsConfigStr + "') from dual";
        try (Statement stmt = conn.createStatement();
             ResultSet rset = stmt.executeQuery(onsSql);){
            if (!rset.next()) return null;
            String string = rset.getString(1);
            return string;
        }
        catch (SQLException e) {
            throw new UniversalConnectionPoolException(e);
        }
    }

    public OracleShardingKeyBuilder getShardingKeyBuilder() throws UniversalConnectionPoolException {
        try {
            return new OracleDataSource().createShardingKeyBuilder();
        }
        catch (SQLException e) {
            throw new UniversalConnectionPoolException(e);
        }
    }

    public void reloadCache(Properties dataSourceProps) throws UniversalConnectionPoolException {
        this.destroy();
        if (dataSourceProps == null) {
            throw new IllegalArgumentException("Invalid datasource properties provided");
        }
        String serviceName = dataSourceProps.getProperty(SERVICE_NAME, null);
        if (serviceName == null) {
            throw new IllegalStateException("Service name must be set on datasource properties.");
        }
        this.dataSourceProperties = dataSourceProps;
        this.initializeCache();
    }

    Set<ServiceMember> getInstancesForShardKey(JDBCConnectionRetrievalInfo cri) {
        HashSet<ServiceMember> instances = new HashSet<ServiceMember>();
        this.chunks(cri).stream().forEach(chunk -> instances.addAll(chunk.instances()));
        return instances;
    }

    public Set<ShardInfo> getShardInfoForKey(OracleShardingKey key, OracleShardingKey superKey) {
        HashSet<ShardInfo> shardInfo = new HashSet<ShardInfo>();
        this.chunks(superKey, key).forEach(chunk -> shardInfo.addAll(chunk.shardInfo()));
        return shardInfo;
    }

    public ChunkInfo getChunkInfoForKey(OracleShardingKey key, OracleShardingKey superKey) {
        List<Chunk> chunkList = this.chunks(superKey, key);
        if (!chunkList.isEmpty()) {
            Chunk chunk = chunkList.get(0);
            int chunkUniqueId = chunk.getUniqueId();
            return new ChunkInfoImpl(chunkUniqueId, chunk.shardInfo());
        }
        return null;
    }

    private List<Chunk> chunks(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return new ArrayList<Chunk>();
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        return this.chunks(jdbcCri.getSuperShardingKey(), jdbcCri.getShardingKey());
    }

    @Override
    protected ChunkEventHandler prepareChunkEventHandler() {
        return new ChunkEventHandler(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            protected void onEvent(ChunkEventHandler.Event event) {
                if (OracleShardRoutingCache.this.dataSourceProperties != null) {
                    try {
                        OracleShardRoutingCache.this.clearCache();
                        try (Connection conn = OracleShardRoutingCache.this.getConnectionFromDatasource();){
                            OracleShardRoutingCache.this.buildTopologyForInstance(conn, OracleShardRoutingCache.this.dataSourceProperties.getProperty(OracleShardRoutingCache.SERVICE_NAME));
                        }
                    }
                    catch (SQLException e) {
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                    }
                }
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(OracleShardRoutingCache.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("onEvent", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    protected boolean isMaxPerShardReached(ServiceMember member) {
        return false;
    }

    @Override
    protected Service service() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$20 = OracleShardRoutingCache.class.getDeclaredConstructor(Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = OracleShardRoutingCache.class.getDeclaredConstructor(ONS.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = OracleShardRoutingCache.class.getDeclaredMethod("access$300", OracleShardRoutingCache.class, Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = OracleShardRoutingCache.class.getDeclaredMethod("access$200", OracleShardRoutingCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = OracleShardRoutingCache.class.getDeclaredMethod("access$100", OracleShardRoutingCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = OracleShardRoutingCache.class.getDeclaredMethod("access$000", OracleShardRoutingCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = OracleShardRoutingCache.class.getDeclaredMethod("lambda$getInstancesForShardKey$0", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = OracleShardRoutingCache.class.getDeclaredMethod("lambda$getShardInfoForKey$1", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = OracleShardRoutingCache.class.getDeclaredMethod("service", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = OracleShardRoutingCache.class.getDeclaredMethod("isMaxPerShardReached", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = OracleShardRoutingCache.class.getDeclaredMethod("prepareChunkEventHandler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = OracleShardRoutingCache.class.getDeclaredMethod("chunks", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = OracleShardRoutingCache.class.getDeclaredMethod("getChunkInfoForKey", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = OracleShardRoutingCache.class.getDeclaredMethod("getShardInfoForKey", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = OracleShardRoutingCache.class.getDeclaredMethod("getInstancesForShardKey", JDBCConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = OracleShardRoutingCache.class.getDeclaredMethod("reloadCache", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = OracleShardRoutingCache.class.getDeclaredMethod("getShardingKeyBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = OracleShardRoutingCache.class.getDeclaredMethod("getOnsConfig", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = OracleShardRoutingCache.class.getDeclaredMethod("getConnectionFromDatasource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = OracleShardRoutingCache.class.getDeclaredMethod("prepareStatementForChunkMetaData", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = OracleShardRoutingCache.class.getDeclaredMethod("initializeCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

