/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class DataSourceConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    protected DataSource m_dataSource;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public DataSourceConnectionFactoryAdapter(DataSource dataSource) throws UniversalConnectionPoolException {
        if (null == dataSource) {
            UCPErrorHandler.throwUniversalConnectionPoolException(256);
        }
        this.m_dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        void connectionRequestInfo;
        boolean bl;
        boolean bl2 = bl = (0x30000000000000L & TraceControllerImpl.feature) != 0L;
        if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        JDBCConnectionRetrievalInfo JDBCConnectionRequestInfo = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
        Connection connection = null;
        try {
            connection = this.m_dataSource.getConnection(JDBCConnectionRequestInfo.getUser(), JDBCConnectionRequestInfo.getPassword());
        }
        catch (Throwable e) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$1, DataSourceConnectionFactoryAdapter.class, $$$methodRef$$$1, this, e);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
        }
        return connection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeConnection(Object object) throws UniversalConnectionPoolException {
        void connection;
        boolean bl;
        boolean bl2 = bl = (0x30000000000000L & TraceControllerImpl.feature) != 0L;
        if (!(connection instanceof Connection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(258);
        }
        Connection javaSQLConnection = (Connection)connection;
        try {
            javaSQLConnection.close();
        }
        catch (SQLException sqlException) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$2, DataSourceConnectionFactoryAdapter.class, $$$methodRef$$$2, this, sqlException);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(255, sqlException);
        }
    }

    static {
        try {
            $$$methodRef$$$3 = DataSourceConnectionFactoryAdapter.class.getDeclaredConstructor(DataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$2 = DataSourceConnectionFactoryAdapter.class.getDeclaredMethod("closeConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$1 = DataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$0 = DataSourceConnectionFactoryAdapter.class.getDeclaredMethod("getDataSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
    }
}

