/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatistics;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatisticsImpl;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleJDBCConnectionPool
extends JDBCConnectionPool
implements RACManagerImpl.RACCallbackExtended {
    private final AtomicReference<String> m_onsConfigurationString = new AtomicReference<String>("");
    RACManager m_racManager = null;
    Boolean isDRCPEnabled = null;
    Boolean isDRCPMultiTagEnabled = null;
    String drcpPLSQLCallbackName = null;
    private Boolean isStrictWSAffinity = false;
    private Boolean isStrictXAAffinity = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;

    public OracleJDBCConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        String instanceName;
        void cri;
        boolean bl;
        boolean bl2 = bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        assert (cri != null);
        OracleJDBCConnectionRetrievalInfo criToCreate = null;
        if (cri instanceof OracleJDBCConnectionRetrievalInfo) {
            OracleJDBCConnectionRetrievalInfo ocri = (OracleJDBCConnectionRetrievalInfo)cri;
            instanceName = ocri.getInstanceName();
            Object object = criToCreate = null == instanceName || "".equals(instanceName) ? null : cri;
        }
        if (null == criToCreate) {
            RACInstance racInstance = null != this.m_racManager ? this.m_racManager.getMostDesirableInstanceToGrow() : null;
            String string = instanceName = null == racInstance ? null : racInstance.getInstance();
            if (null != instanceName && !"".equals(instanceName)) {
                if (bl) {
                    this.ilogFinest($$$loggerRef$$$0, OracleJDBCConnectionPool.class, $$$methodRef$$$0, this, "about to set most desired instance " + instanceName);
                }
                criToCreate = new OracleJDBCConnectionRetrievalInfo((JDBCConnectionRetrievalInfo)cri, instanceName);
            } else {
                criToCreate = cri;
            }
        }
        return super.createOnePooledConnection(criToCreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws UniversalConnectionPoolException {
        JDBCUniversalPooledConnection conn;
        super.start();
        String sqlStr = this.getSQLForValidateConnection();
        if (this.getValidateConnectionOnBorrow() && null != sqlStr && !"".equals(sqlStr) && null != (conn = (JDBCUniversalPooledConnection)this.createOnePooledConnection())) {
            boolean invalidSQL = false;
            Statement stmt = null;
            try {
                stmt = conn.getSQLConnection(conn.getPhysicalConnection()).createStatement();
                stmt.execute(sqlStr);
            }
            catch (SQLRecoverableException sQLRecoverableException) {
            }
            catch (SQLException e) {
                this.setValidateConnectionOnBorrow(false);
                invalidSQL = true;
            }
            finally {
                if (null != stmt) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
                this.closePhysicalConnection(conn.getPhysicalConnection());
            }
            if (invalidSQL) {
                this.purge();
                throw UCPErrorHandler.newUniversalConnectionPoolException(151);
            }
        }
    }

    @Override
    public boolean isRuntimeLoadBalancingEnabled() {
        if (this.m_racManager != null) {
            return this.m_racManager.isRuntimeLoadBalancingEnabled();
        }
        return false;
    }

    @Override
    public void tearDownConnectionsForInstance(OracleDatabaseInstanceInfo dbInstance, int numConnectionsToTearDown) {
        String instanceName = dbInstance.getInstanceName();
        String dbName = dbInstance.getDatabaseName();
        AtomicInteger tearDownCount = new AtomicInteger(numConnectionsToTearDown);
    }

    @Override
    public synchronized void registerConnectionAffinityCallback(ConnectionAffinityCallback affCbk) throws UniversalConnectionPoolException {
        super.registerConnectionAffinityCallback(affCbk);
        if (this.m_racManager != null) {
            this.m_racManager.registerConnectionAffinityCallback(affCbk);
        }
    }

    @Override
    public synchronized void removeConnectionAffinityCallback() throws UniversalConnectionPoolException {
        super.removeConnectionAffinityCallback();
        if (this.m_racManager != null) {
            this.m_racManager.unregisterConnectionAffinityCallback(this.getConnectionAffinityCallback());
        }
    }

    @DisableTrace
    UniversalPooledConnection getConnectionToNamedInstance() {
        return this.createOnePooledConnection();
    }

    @Override
    @DisableTrace
    public OracleJDBCConnectionPoolStatistics getStatistics() {
        return new OracleJDBCConnectionPoolStatisticsImpl(this);
    }

    @DisableTrace
    public long getSuccessfulAffinityBasedBorrowCount() {
        return this.core.connectionSource().loadBalancerStats(null).affBorrows.successful.total().longValue();
    }

    @DisableTrace
    public long getSuccessfulAffinityBasedBorrowCount(String serviceName) {
        return this.core.connectionSource().loadBalancerStats((String)serviceName).affBorrows.successful.total().longValue();
    }

    @DisableTrace
    public long getFailedAffinityBasedBorrowCount() {
        return this.core.connectionSource().loadBalancerStats(null).affBorrows.failed.total().longValue();
    }

    @DisableTrace
    public long getFailedAffinityBasedBorrowCount(String serviceName) {
        return this.core.connectionSource().loadBalancerStats((String)serviceName).affBorrows.failed.total().longValue();
    }

    @DisableTrace
    public long getSuccessfulRCLBBasedBorrowCount() {
        return this.core.connectionSource().loadBalancerStats(null).lbBorrows.successful.total().longValue();
    }

    @DisableTrace
    public long getSuccessfulRCLBBasedBorrowCount(String serviceName) {
        return this.core.connectionSource().loadBalancerStats((String)serviceName).lbBorrows.successful.total().longValue();
    }

    @DisableTrace
    public long getFailedRCLBBasedBorrowCount() {
        return this.core.connectionSource().loadBalancerStats(null).lbBorrows.failed.total().longValue();
    }

    @DisableTrace
    public long getFailedRCLBBasedBorrowCount(String serviceName) {
        return this.core.connectionSource().loadBalancerStats((String)serviceName).lbBorrows.failed.total().longValue();
    }

    @DisableTrace
    public String getFCFProcessingInfo() {
        return this.core.connectionSource().failoverDriverStats(null).toString();
    }

    @DisableTrace
    public String getFCFProcessingInfo(String serviceName) {
        return this.core.connectionSource().failoverDriverStats(serviceName).toString();
    }

    @DisableTrace
    public String getFCFProcessingInfoProcessedOnly() {
        return this.core.connectionSource().failoverDriverStats(null).toStringProcessedOnly();
    }

    @DisableTrace
    public String getFCFProcessingInfoProcessedOnly(String serviceName) {
        return this.core.connectionSource().failoverDriverStats(serviceName).toStringProcessedOnly();
    }

    @DisableTrace
    public long getConnectionRepurposeCount() {
        return this.core.repurposeCount();
    }

    @DisableTrace
    public String getShardConnectionStats(String serviceName) {
        return this.core.connectionSource().shardConnectionStats(serviceName);
    }

    @Override
    public void closePhysicalConnection(final Object physicalConnection) {
        UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void run() {
                OracleJDBCConnectionPool.this.superClosePhysicalConnection(physicalConnection);
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleJDBCConnectionPool.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    public void superClosePhysicalConnection(Object physicalConnection) {
        super.closePhysicalConnection(physicalConnection);
    }

    @Override
    public void initiateDownEventProcessing(OracleFailoverEvent event) {
        throw new IllegalStateException("obsolete");
    }

    @Override
    public int initiateUpEventProcessing(OracleFailoverEvent event) {
        throw new IllegalStateException("obsolete");
    }

    @Override
    public FailoverablePooledConnection openNewConnection(String url, RACInstance racInstance) {
        throw new IllegalStateException("this method is obsolete");
    }

    @Override
    @DisableTrace
    public String getUrl() {
        JDBCConnectionFactoryAdapter cfa = (JDBCConnectionFactoryAdapter)this.getConnectionFactoryAdapter();
        return cfa.getUrl();
    }

    @Override
    @DisableTrace
    public String getPoolName() {
        return this.getName();
    }

    @Override
    @DisableTrace
    public int getRoomToGrowPool() {
        return 0;
    }

    @Override
    public boolean isValid(FailoverablePooledConnection fpc) {
        OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)fpc;
        return oupc.isValid();
    }

    @Override
    public FailoverablePooledConnection getAvailableConnectionToInstance(ConnectionRetrievalInfo cri, RACInstance racInstance) throws UniversalConnectionPoolException {
        throw new IllegalStateException("obsolete");
    }

    @Override
    public Collection<FailoverablePooledConnection> getAvailableConnections(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        throw new IllegalStateException("obsolete");
    }

    @Override
    public void lbaEventOccurred(OracleLoadBalancingEvent rlbEvent) throws UniversalConnectionPoolException {
    }

    void setRACManager(RACManager racMngr) {
        this.m_racManager = racMngr;
    }

    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        JDBCConnectionRetrievalInfo jdbcCri;
        if (cri instanceof JDBCConnectionRetrievalInfo && (jdbcCri = (JDBCConnectionRetrievalInfo)cri).getServiceName() == null) {
            cri = jdbcCri.getCopyWithService(this.getServiceName());
        }
        return super.borrowConnection(cri);
    }

    protected void onAddingConnectionToPool(UniversalPooledConnection pooledConnection) {
    }

    protected void onRemovingConnectionFromPool(UniversalPooledConnection pooledConnection) {
    }

    public void useStrictWebSessionAffinity(boolean strict) {
        this.isStrictWSAffinity = strict;
    }

    public void useStrictXAAffinity(boolean strict) {
        this.isStrictXAAffinity = strict;
    }

    protected boolean isDRCPEnabled(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        return false;
    }

    protected boolean isDRCPMultiTagEnabled(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        return false;
    }

    protected String getDRCPPLSQLCallbackName(UniversalPooledConnection pc) throws UniversalConnectionPoolException {
        return null;
    }

    static {
        try {
            $$$methodRef$$$24 = OracleJDBCConnectionPool.class.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$23 = OracleJDBCConnectionPool.class.getDeclaredMethod("getDRCPPLSQLCallbackName", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$22 = OracleJDBCConnectionPool.class.getDeclaredMethod("isDRCPMultiTagEnabled", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$21 = OracleJDBCConnectionPool.class.getDeclaredMethod("isDRCPEnabled", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$20 = OracleJDBCConnectionPool.class.getDeclaredMethod("useStrictXAAffinity", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$19 = OracleJDBCConnectionPool.class.getDeclaredMethod("useStrictWebSessionAffinity", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$18 = OracleJDBCConnectionPool.class.getDeclaredMethod("onRemovingConnectionFromPool", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$17 = OracleJDBCConnectionPool.class.getDeclaredMethod("onAddingConnectionToPool", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$16 = OracleJDBCConnectionPool.class.getDeclaredMethod("borrowConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$15 = OracleJDBCConnectionPool.class.getDeclaredMethod("setRACManager", RACManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$14 = OracleJDBCConnectionPool.class.getDeclaredMethod("lbaEventOccurred", OracleLoadBalancingEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$13 = OracleJDBCConnectionPool.class.getDeclaredMethod("getAvailableConnections", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$12 = OracleJDBCConnectionPool.class.getDeclaredMethod("getAvailableConnectionToInstance", ConnectionRetrievalInfo.class, RACInstance.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$11 = OracleJDBCConnectionPool.class.getDeclaredMethod("isValid", FailoverablePooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$10 = OracleJDBCConnectionPool.class.getDeclaredMethod("openNewConnection", String.class, RACInstance.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$9 = OracleJDBCConnectionPool.class.getDeclaredMethod("initiateUpEventProcessing", OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$8 = OracleJDBCConnectionPool.class.getDeclaredMethod("initiateDownEventProcessing", OracleFailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$7 = OracleJDBCConnectionPool.class.getDeclaredMethod("superClosePhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$6 = OracleJDBCConnectionPool.class.getDeclaredMethod("closePhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$5 = OracleJDBCConnectionPool.class.getDeclaredMethod("removeConnectionAffinityCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = OracleJDBCConnectionPool.class.getDeclaredMethod("registerConnectionAffinityCallback", ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = OracleJDBCConnectionPool.class.getDeclaredMethod("tearDownConnectionsForInstance", OracleDatabaseInstanceInfo.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = OracleJDBCConnectionPool.class.getDeclaredMethod("isRuntimeLoadBalancingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = OracleJDBCConnectionPool.class.getDeclaredMethod("start", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = OracleJDBCConnectionPool.class.getDeclaredMethod("createOnePooledConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

