/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class DriverConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    protected Driver m_driver;
    protected final Properties m_connectionProperties;
    protected final Properties m_connectionFactoryProperties;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public DriverConnectionFactoryAdapter(Driver driver, String url, Properties connectionFactoryProperties, Properties connectionProperties) throws UniversalConnectionPoolException {
        if (null == driver) {
            UCPErrorHandler.throwUniversalConnectionPoolException(268);
        }
        if (url == null || "".equals(url)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(269);
        }
        this.m_driver = driver;
        this.m_url = url;
        this.m_connectionFactoryProperties = connectionFactoryProperties;
        this.m_connectionProperties = connectionProperties;
    }

    public Driver getDriver() {
        return this.m_driver;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        void connectionRequestInfo;
        boolean bl;
        boolean bl2 = bl = (0x30000000000000L & TraceControllerImpl.feature) != 0L;
        if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        Connection connection = null;
        try {
            Properties connProps = new Properties();
            connProps.putAll((Map<?, ?>)this.m_connectionProperties);
            connProps.putAll((Map<?, ?>)this.m_connectionFactoryProperties);
            connection = this.m_driver.connect(this.m_url, connProps);
        }
        catch (SQLException sqlException) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$1, DriverConnectionFactoryAdapter.class, $$$methodRef$$$1, this, sqlException);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(257, sqlException);
        }
        return connection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeConnection(Object object) throws UniversalConnectionPoolException {
        void connection;
        boolean bl;
        boolean bl2 = bl = (0x30000000000000L & TraceControllerImpl.feature) != 0L;
        if (!(connection instanceof Connection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(258);
        }
        Connection javaSQLConnection = (Connection)connection;
        try {
            javaSQLConnection.close();
        }
        catch (SQLException sqlException) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$2, DriverConnectionFactoryAdapter.class, $$$methodRef$$$2, this, sqlException);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(255, sqlException);
        }
    }

    static {
        try {
            $$$methodRef$$$3 = DriverConnectionFactoryAdapter.class.getDeclaredConstructor(Driver.class, String.class, Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$2 = DriverConnectionFactoryAdapter.class.getDeclaredMethod("closeConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$1 = DriverConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$0 = DriverConnectionFactoryAdapter.class.getDeclaredMethod("getDriver", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
    }
}

