/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.common.UniversalConnectionPoolBase;

@DisableTrace
public class UniversalConnectionPoolStatisticsImpl
implements UniversalConnectionPoolStatistics {
    private final UniversalConnectionPoolBase m_cp;

    protected UniversalConnectionPoolStatisticsImpl(UniversalConnectionPoolBase cp) {
        assert (cp != null);
        this.m_cp = cp;
    }

    @Override
    public int getTotalConnectionsCount() {
        return this.m_cp.getTotalConnectionsCount();
    }

    @Override
    public int getAvailableConnectionsCount() {
        return this.m_cp.getAvailableConnectionsCount();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        return this.m_cp.getBorrowedConnectionsCount();
    }

    @Override
    public int getAverageBorrowedConnectionsCount() {
        return this.m_cp.getAverageBorrowedConnectionsCount();
    }

    @Override
    public int getPeakConnectionsCount() {
        return this.m_cp.getPeakConnectionsCount();
    }

    @Override
    public int getRemainingPoolCapacityCount() {
        int count = this.m_cp.getMaxPoolSize() - this.m_cp.getTotalConnectionsCount();
        return count > 0 ? count : 0;
    }

    @Override
    public int getLabeledConnectionsCount() {
        return 0;
    }

    @Override
    public int getConnectionsCreatedCount() {
        return this.m_cp.getConnectionsCreatedCount();
    }

    @Override
    public int getConnectionsClosedCount() {
        return this.m_cp.getConnectionsClosedCount();
    }

    @Override
    public long getAverageConnectionWaitTime() {
        long averageConnectionWaitTime = 0L;
        long totalCount = this.m_cp.getCumulativeSuccessfulConnectionWaitCount() + this.m_cp.getCumulativeFailedConnectionWaitCount();
        if (totalCount > 0L) {
            long totalTime = this.m_cp.getCumulativeSuccessfulConnectionWaitTime() + this.m_cp.getCumulativeFailedConnectionWaitTime();
            averageConnectionWaitTime = Math.round(totalTime / totalCount);
        }
        return averageConnectionWaitTime;
    }

    @Override
    public long getPeakConnectionWaitTime() {
        return this.m_cp.getPeakConnectionWaitTime();
    }

    @Override
    public int getAbandonedConnectionsCount() {
        return this.m_cp.getAbandonedConnectionsCount();
    }

    @Override
    public int getPendingRequestsCount() {
        return this.m_cp.getPendingRequestsCount();
    }

    @Override
    public long getCumulativeConnectionWaitTime() {
        return this.m_cp.getCumulativeSuccessfulConnectionWaitTime() + this.m_cp.getCumulativeFailedConnectionWaitTime();
    }

    @Override
    public long getCumulativeConnectionBorrowedCount() {
        return this.m_cp.getCumulativeConnectionBorrowedCount();
    }

    @Override
    public long getCumulativeConnectionUseTime() {
        return this.m_cp.getCumulativeConnectionUseTime();
    }

    @Override
    public long getCumulativeConnectionReturnedCount() {
        return this.m_cp.getCumulativeConnectionReturnedCount();
    }

    @Override
    public long getCumulativeSuccessfulConnectionWaitTime() {
        return this.m_cp.getCumulativeSuccessfulConnectionWaitTime();
    }

    @Override
    public long getCumulativeSuccessfulConnectionWaitCount() {
        return this.m_cp.getCumulativeSuccessfulConnectionWaitCount();
    }

    @Override
    public long getCumulativeFailedConnectionWaitTime() {
        return this.m_cp.getCumulativeFailedConnectionWaitTime();
    }

    @Override
    public long getCumulativeFailedConnectionWaitCount() {
        return this.m_cp.getCumulativeFailedConnectionWaitCount();
    }

    @DisableTrace
    public String toString() {
        return "AvailableConnectionsCount=" + this.getAvailableConnectionsCount() + ",\n" + "BorrowedConnectionsCount=" + this.getBorrowedConnectionsCount() + ",\n" + "TotalConnectionsCount=" + this.getTotalConnectionsCount() + ",\n" + "ConnectionsCreatedCount=" + this.getConnectionsCreatedCount() + ",\n" + "ConnectionsClosedCount=" + this.getConnectionsClosedCount() + ",\n" + "AbandonedConnectionsCount=" + this.getAbandonedConnectionsCount() + ",\n" + "LabeledConnectionsCount=" + this.getLabeledConnectionsCount() + ",\n" + "PendingRequestsCount=" + this.getPendingRequestsCount() + ",\n" + "RemainingPoolCapacityCount=" + this.getRemainingPoolCapacityCount() + ",\n" + "PeakConnectionsCount=" + this.getPeakConnectionsCount() + ",\n" + "PeakConnectionWaitTime=" + this.getPeakConnectionWaitTime() + ",\n" + "AverageBorrowedConnectionsCount=" + this.getAverageBorrowedConnectionsCount() + ",\n" + "AverageConnectionWaitTime=" + this.getAverageConnectionWaitTime() + ",\n" + "CumulativeConnectionBorrowedCount=" + this.getCumulativeConnectionBorrowedCount() + ",\n" + "CumulativeConnectionReturnedCount=" + this.getCumulativeConnectionReturnedCount() + ",\n" + "CumulativeConnectionUseTime=" + this.getCumulativeConnectionUseTime() + ",\n" + "CumulativeConnectionWaitTime=" + this.getCumulativeConnectionWaitTime() + ",\n" + "CumulativeSuccessfulConnectionWaitCount=" + this.getCumulativeSuccessfulConnectionWaitCount() + ",\n" + "CumulativeSuccessfulConnectionWaitTime=" + this.getCumulativeSuccessfulConnectionWaitTime() + ",\n" + "CumulativeFailedConnectionWaitCount=" + this.getCumulativeFailedConnectionWaitCount() + ",\n" + "CumulativeFailedConnectionWaitTime=" + this.getCumulativeFailedConnectionWaitTime() + "\n";
    }
}

