/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.OracleFailoverEventImpl;
import oracle.ucp.util.logging.UCPLoggerFactory;

final class ONSDatabaseFailoverEvent
extends OracleFailoverEventImpl {
    private static final Logger logger = UCPLoggerFactory.createLogger(ONSDatabaseFailoverEvent.class.getCanonicalName());
    private static final String ONS_FAILOVER_EVENT_DELIMITER = "{} =";

    ONSDatabaseFailoverEvent(String eventType, byte[] eventBody) throws UniversalConnectionPoolException {
        super(eventType);
        logger.log(Level.FINEST, "eventType: {0}, eventBody: {1}", new Object[]{eventType, new String(eventBody)});
        StringTokenizer strTokens = null;
        try {
            strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), ONS_FAILOVER_EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.FINEST, "tokenizer encoding", e);
        }
        String st = null;
        String val = null;
        String key = null;
        String timestampValueStr = null;
        String timezoneValueStr = null;
        while (strTokens.hasMoreTokens()) {
            val = null;
            st = strTokens.nextToken();
            if (st.equals("=") && strTokens.hasMoreTokens()) {
                val = strTokens.nextToken();
            } else {
                key = st;
            }
            if (key.equalsIgnoreCase("version") && val != null && !val.startsWith("1.")) {
                logger.log(Level.FINEST, "Invalid Event version {0}", val);
                this.setValidity(false);
                return;
            }
            if (key.equalsIgnoreCase("service") && val != null) {
                this.setServiceName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("instance") && val != null && !val.equals(" ")) {
                this.setInstanceName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("database") && val != null) {
                this.setDbUniqueName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("host") && val != null) {
                this.setHostName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("status") && val != null) {
                this.setStatus(val);
                continue;
            }
            if (key.equalsIgnoreCase("card") && val != null) {
                try {
                    this.setCardinality(Integer.parseInt(val));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    logger.log(Level.FINEST, "invalid cardinality", nfe);
                    this.setValidity(false);
                    return;
                }
            }
            if (key.equalsIgnoreCase("reason") && val != null) {
                this.setReason(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("timestamp") && val != null) {
                String space = strTokens.nextToken();
                String hmsValue = strTokens.nextToken();
                timestampValueStr = val + " " + hmsValue;
                continue;
            }
            if (!key.equalsIgnoreCase("timezone") || val == null) continue;
            timezoneValueStr = "GMT" + val;
        }
        if (timestampValueStr == null && timezoneValueStr == null) {
            logger.log(Level.FINER, "Older server, no timestamp/timezone in HA event");
        } else {
            if (timezoneValueStr == null) {
                logger.log(Level.WARNING, "NO timezone in HA event");
                this.setValidity(false);
                return;
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            format.setLenient(false);
            Date ts = null;
            String tsWithZoneString = timestampValueStr + " " + timezoneValueStr;
            try {
                ts = format.parse(tsWithZoneString);
            }
            catch (ParseException pe) {
                logger.log(Level.WARNING, "Invalid timestamp/timezone in HA event: ", tsWithZoneString);
                this.setValidity(false);
                return;
            }
            if (ts == null) {
                logger.log(Level.WARNING, "Invalid timestamp/timezone in HA event: ", tsWithZoneString);
                this.setValidity(false);
                return;
            }
            this.setTimestamp(ts);
            this.setTimeZone(timezoneValueStr);
        }
        strTokens = null;
    }
}

