/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import oracle.ucp.jdbc.oracle.FailoverStatisticsItem;

class FailoverStatisticsAccumulator {
    static final int RING_CAPACITY = 64;
    final FailoverStatisticsItem[] ring = new FailoverStatisticsItem[64];
    int pointer = 0;

    FailoverStatisticsAccumulator() {
    }

    private int next(int i) {
        return (i + 1) % 64;
    }

    private int previous(int i) {
        int j = i - 1;
        return j < 0 ? 63 : j;
    }

    void addItem(FailoverStatisticsItem item) {
        this.ring[this.pointer] = item;
        this.pointer = this.next(this.pointer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = this.pointer;
        do {
            FailoverStatisticsItem item;
            if (null == (item = this.ring[i = this.previous(i)])) continue;
            sb.append(item.toString());
        } while (i != this.pointer);
        return sb.toString();
    }

    public String toStringProcessedOnly() {
        StringBuilder sb = new StringBuilder();
        int i = this.pointer;
        do {
            FailoverStatisticsItem item;
            if (null == (item = this.ring[i = this.previous(i)]) || FailoverStatisticsItem.Type.NOT_PROCESSED == item.type) continue;
            sb.append(item.toString());
        } while (i != this.pointer);
        return sb.toString();
    }
}

