/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.rsi.RSIException;
import oracle.rsi.diagnostics.RSIDiagnosable;
import oracle.rsi.internal.Metadata;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.ROWID;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.ZONEIDMAP;

public class TypeConverter {
    private static final MathContext[] S_MATHCTX = new MathContext[]{new MathContext(1), new MathContext(2), new MathContext(3), new MathContext(4), new MathContext(5), new MathContext(6), new MathContext(7), new MathContext(8), new MathContext(9), new MathContext(10)};
    private static final Object s_factoryLock = new Object();
    private static final int ONE_BILLION = 1000000000;

    public static Datum toDatum(Metadata.ColumnMetadata columnMetadata, Object object, Metadata.NLSContext nLSContext, Integer n) {
        SQLType sQLType = columnMetadata.getSQLType();
        switch (sQLType.getVendorTypeNumber()) {
            case 101: {
                return BINARY_DOUBLEConverter.toBINARY_DOUBLE(object);
            }
            case 100: {
                return BINARY_FLOATConverter.toBINARY_FLOAT(object);
            }
            case 2: {
                return NUMBERConverter.toNUMBER(object);
            }
            case 1: {
                return CHARConverter.toCHAR(columnMetadata, object, nLSContext, n, true);
            }
            case 12: {
                return CHARConverter.toCHAR(columnMetadata, object, nLSContext, n, false);
            }
            case 91: {
                return DATEConverter.toDATE(object);
            }
            case 93: {
                return TIMESTAMPConverter.toTIMESTAMP(object);
            }
            case -101: {
                return TIMESTAMPTZConverter.toTIMESTAMPTZ(columnMetadata, object);
            }
            case -102: {
                return TIMESTAMPLTZConverter.toTIMESTAMPLTZ(columnMetadata, object, nLSContext);
            }
            case -103: {
                return INTERVALYMConverter.toINTERVALYM(object);
            }
            case -104: {
                return INTERVALDSConverter.toINTERVALDS(object);
            }
            case -2: {
                return RAWConverter.toRAW(columnMetadata, object);
            }
            case -8: {
                return ROWIDConverter.toROWID(object);
            }
        }
        throw new RSIException("Unsupported type: " + String.valueOf(sQLType));
    }

    private static DatatypeFactory getDatatypeFactory() {
        return DataTypeFactorySingleton.datatypeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GregorianCalendar parseTimestamp(String string, TimeZone timeZone, int n, int[] nArray) {
        int n2;
        XMLGregorianCalendar xMLGregorianCalendar;
        Object object = s_factoryLock;
        synchronized (object) {
            xMLGregorianCalendar = TypeConverter.getDatatypeFactory().newXMLGregorianCalendar(string);
        }
        if (nArray != null && nArray.length != 0 && n >= 0 && n < S_MATHCTX.length) {
            object = xMLGregorianCalendar.getFractionalSecond();
            nArray[0] = object != null ? ((BigDecimal)object).add(BigDecimal.ONE).round(S_MATHCTX[n]).movePointRight(9).intValueExact() - 1000000000 : 0;
        }
        xMLGregorianCalendar.setFractionalSecond(null);
        object = xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE ? timeZone : null;
        GregorianCalendar gregorianCalendar = xMLGregorianCalendar.toGregorianCalendar((TimeZone)object, null, DataTypeFactorySingleton.defaultCalendar);
        if (nArray != null && nArray[0] == 1000000000) {
            gregorianCalendar.add(13, 1);
            nArray[0] = 0;
        }
        if (gregorianCalendar.get(1) == 1582 && gregorianCalendar.get(2) == 9 && (n2 = gregorianCalendar.get(5)) > 4 && n2 < 15) {
            gregorianCalendar.set(5, 15);
        }
        return gregorianCalendar;
    }

    private static String jdbcTimestampToXMLdateTime(String string) {
        int n;
        String string2 = string;
        if (string.length() > 10 && (n = string.indexOf(32)) != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(n, 'T');
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private static class Utils {
        private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

        private Utils() {
        }

        private static boolean isString(Object object) {
            return object instanceof String || object instanceof CharSequence || object instanceof Character;
        }

        private static String toString(Object object) {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof CharSequence) {
                return ((CharSequence)object).toString();
            }
            if (object instanceof Character) {
                return ((Character)object).toString();
            }
            throw new RSIException("Not a String type");
        }

        public static byte[] hexStringToByte(String string) {
            int n = string.length();
            int n2 = (n + 1) / 2;
            byte[] byArray = new byte[n2];
            boolean bl = n % 2 == 1;
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                byte by = i == 0 && bl ? (byte)0 : Utils.hexDigitToByte(string.charAt(n3++));
                byte by2 = Utils.hexDigitToByte(string.charAt(n3++));
                byArray[i] = (byte)(by << 4 | by2);
            }
            return byArray;
        }

        private static byte hexDigitToByte(int n) {
            int n2 = Character.digit(n, 16);
            if (n2 < 0) {
                throw new NumberFormatException("Bad hexa digit char: " + n);
            }
            return (byte)n2;
        }

        public static String toUpperHexString(byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                stringBuilder.append(HEX_CHARS[(by & 0xF0) >>> 4]);
                stringBuilder.append(HEX_CHARS[by & 0xF]);
            }
            return stringBuilder.toString();
        }

        public static String lpad(String string, int n, char c) {
            if (string == null) {
                return string;
            }
            int n2 = n - string.length();
            if (n2 <= 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(n);
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(c);
            }
            return stringBuilder.append(string).toString();
        }
    }

    private static class DataTypeFactorySingleton {
        static DatatypeFactory datatypeFactory = null;
        static XMLGregorianCalendar defaultCalendar = null;

        private DataTypeFactorySingleton() {
        }

        static {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
                defaultCalendar = datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar());
                defaultCalendar.setDay(1);
                defaultCalendar.setHour(0);
                defaultCalendar.setMinute(0);
                defaultCalendar.setSecond(0);
                defaultCalendar.setFractionalSecond(BigDecimal.ZERO);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                RSIDiagnosable.getInstance().trace(Level.SEVERE, "DataTypeFactorySingleton", "static block", "DataTypeFactory initialization failed.", null, new Object[0]);
            }
        }
    }

    private static class ROWIDConverter {
        private ROWIDConverter() {
        }

        static Datum toROWID(Object object) {
            try {
                if (object == null) {
                    return new ROWID();
                }
                if (object instanceof ROWID) {
                    return (ROWID)object;
                }
                if (object instanceof ByteBuffer) {
                    byte[] byArray = new byte[]{};
                    ByteBuffer byteBuffer = (ByteBuffer)object;
                    byArray = new byte[byteBuffer.limit()];
                    byteBuffer.rewind();
                    byteBuffer.get(byArray);
                    return new ROWID(byArray);
                }
                if (object.getClass().isArray() && object.getClass().getComponentType() == Byte.TYPE) {
                    return new ROWID((byte[])object);
                }
                if (Utils.isString(object)) {
                    return new ROWID(Utils.toString(object).trim());
                }
                String string = "Invalid type supplied for ROWID: " + String.valueOf(object.getClass());
                throw new RSIException(string);
            }
            catch (Exception exception) {
                throw new RSIException(exception.getMessage(), exception);
            }
        }
    }

    private static class RAWConverter {
        private RAWConverter() {
        }

        static Datum toRAW(Metadata.ColumnMetadata columnMetadata, Object object) {
            if (object == null) {
                return new RAW();
            }
            if (object instanceof RAW) {
                return (RAW)object;
            }
            if (object instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)object;
                byte[] byArray = new byte[byteBuffer.limit()];
                byteBuffer.rewind();
                byteBuffer.get(byArray);
                if (byArray.length > columnMetadata.getLength()) {
                    throw new RSIException("Maximum column length exceeded.");
                }
                return new RAW(byArray);
            }
            if (object.getClass().isArray() && object.getClass().getComponentType() == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                if (byArray.length > columnMetadata.getLength()) {
                    throw new RSIException("Maximum column length exceeded.");
                }
                return new RAW(byArray);
            }
            if (Utils.isString(object)) {
                String string = Utils.toString(object).trim();
                byte[] byArray = Utils.hexStringToByte(string);
                if (byArray.length > columnMetadata.getLength()) {
                    throw new RSIException("Maximum column length exceeded.");
                }
                return new RAW(byArray);
            }
            String string = "Invalid type supplied for RAW: " + String.valueOf(object.getClass());
            throw new RSIException(string);
        }
    }

    private static class INTERVALDSConverter {
        private INTERVALDSConverter() {
        }

        static Datum toINTERVALDS(Object object) {
            if (object == null) {
                return new INTERVALDS();
            }
            if (object instanceof INTERVALDS) {
                return (INTERVALDS)object;
            }
            if (object instanceof byte[]) {
                return new INTERVALDS((byte[])object);
            }
            if (Utils.isString(object)) {
                return new INTERVALDS(Utils.toString(object).trim());
            }
            String string = "Invalid type supplied for INTERVALDS: " + String.valueOf(object.getClass());
            throw new RSIException(string);
        }
    }

    private static class INTERVALYMConverter {
        private INTERVALYMConverter() {
        }

        static Datum toINTERVALYM(Object object) {
            if (object == null) {
                return new INTERVALYM();
            }
            if (object instanceof INTERVALYM) {
                return (INTERVALYM)object;
            }
            if (object instanceof byte[]) {
                return new INTERVALYM((byte[])object);
            }
            if (Utils.isString(object)) {
                return new INTERVALYM(Utils.toString(object).trim());
            }
            String string = "Invalid type supplied for INTERVALYM: " + String.valueOf(object.getClass());
            throw new RSIException(string);
        }
    }

    private static class TIMESTAMPLTZConverter {
        private TIMESTAMPLTZConverter() {
        }

        static Datum toTIMESTAMPLTZ(Metadata.ColumnMetadata columnMetadata, Object object, Metadata.NLSContext nLSContext) {
            if (object == null) {
                return new TIMESTAMPLTZ();
            }
            if (object instanceof TIMESTAMPLTZ) {
                return (TIMESTAMPLTZ)object;
            }
            if (object instanceof byte[]) {
                return new TIMESTAMPLTZ((byte[])object);
            }
            if (object instanceof Date) {
                GregorianCalendar gregorianCalendar = nLSContext.getDatabaseCalendar();
                gregorianCalendar.setTime((Date)object);
                TIMESTAMPLTZ tIMESTAMPLTZ = new TIMESTAMPLTZ();
                tIMESTAMPLTZ.setShareBytes(TIMESTAMPConverter.toBytes(gregorianCalendar, 0, null));
                return tIMESTAMPLTZ;
            }
            if (object instanceof Timestamp) {
                GregorianCalendar gregorianCalendar = nLSContext.getDatabaseCalendar();
                gregorianCalendar.setTimeInMillis(((Timestamp)object).getTime());
                TIMESTAMPLTZ tIMESTAMPLTZ = new TIMESTAMPLTZ();
                tIMESTAMPLTZ.setShareBytes(TIMESTAMPConverter.toBytes(gregorianCalendar, ((Timestamp)object).getNanos(), null));
                return tIMESTAMPLTZ;
            }
            if (Utils.isString(object)) {
                String string = Utils.toString(object).trim();
                if (string.isEmpty()) {
                    return new TIMESTAMPTZ();
                }
                if (!columnMetadata.getInputFormat().equalsIgnoreCase("xmlschema")) {
                    string = TypeConverter.jdbcTimestampToXMLdateTime(string);
                }
                int[] nArray = new int[1];
                GregorianCalendar gregorianCalendar = TypeConverter.parseTimestamp(string, Metadata.NLSContext.getSessionCalendar().getTimeZone(), columnMetadata.getScale(), nArray);
                GregorianCalendar gregorianCalendar2 = nLSContext.getDatabaseCalendar();
                gregorianCalendar2.setTimeInMillis(gregorianCalendar.getTimeInMillis());
                TIMESTAMPLTZ tIMESTAMPLTZ = new TIMESTAMPLTZ();
                tIMESTAMPLTZ.setShareBytes(TIMESTAMPConverter.toBytes(gregorianCalendar2, nArray[0], null));
                return tIMESTAMPLTZ;
            }
            String string = "Invalid type supplied for TIMESTAMPLTZ: " + String.valueOf(object.getClass());
            throw new RSIException(string);
        }
    }

    private static class TIMESTAMPTZConverter {
        private static final int SIZE_TIMESTAMPTZ = 13;
        private static final int MINUTE_MILLISECOND = 60000;
        private static final int HOUR_MILLISECOND = 3600000;
        private static final int OFFSET_HOUR = 20;
        private static final int OFFSET_MINUTE = 60;
        private static final int MIN_TZ_OFFSET = -46740000;
        private static final int MAX_TZ_OFFSET = 53940000;
        private static byte REGIONIDBIT = (byte)-128;
        private static final Calendar GMT_CAL = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);

        private TIMESTAMPTZConverter() {
        }

        static Datum toTIMESTAMPTZ(Metadata.ColumnMetadata columnMetadata, Object object) {
            if (object == null) {
                return new TIMESTAMPTZ();
            }
            if (object instanceof TIMESTAMPTZ) {
                return (TIMESTAMPTZ)object;
            }
            if (object instanceof byte[]) {
                return new TIMESTAMPTZ((byte[])object);
            }
            if (object instanceof Date) {
                Calendar calendar = Calendar.getInstance(Metadata.NLSContext.getSessionCalendar().getTimeZone());
                calendar.setTime((Date)object);
                TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ();
                tIMESTAMPTZ.setShareBytes(TIMESTAMPTZConverter.toBytes(calendar, 0));
                return tIMESTAMPTZ;
            }
            if (object instanceof Timestamp) {
                Calendar calendar = Calendar.getInstance(Metadata.NLSContext.getSessionCalendar().getTimeZone());
                calendar.setTimeInMillis(((Timestamp)object).getTime());
                TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ();
                tIMESTAMPTZ.setShareBytes(TIMESTAMPTZConverter.toBytes(calendar, ((Timestamp)object).getNanos()));
                return tIMESTAMPTZ;
            }
            if (Utils.isString(object)) {
                String string = Utils.toString(object).trim();
                if (string.isEmpty()) {
                    return new TIMESTAMPTZ();
                }
                if (!columnMetadata.getInputFormat().equalsIgnoreCase("xmlschema")) {
                    string = TypeConverter.jdbcTimestampToXMLdateTime(string);
                }
                int[] nArray = new int[1];
                GregorianCalendar gregorianCalendar = TypeConverter.parseTimestamp(string, Metadata.NLSContext.getSessionCalendar().getTimeZone(), columnMetadata.getScale(), nArray);
                TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ();
                tIMESTAMPTZ.setShareBytes(TIMESTAMPTZConverter.toBytes(gregorianCalendar, nArray[0]));
                return tIMESTAMPTZ;
            }
            String string = "Invalid type supplied for TIMESTAMPTZ: " + String.valueOf(object.getClass());
            throw new RSIException(string);
        }

        private static byte[] toBytes(Calendar calendar, int n) {
            int n2;
            if (calendar == null) {
                return null;
            }
            byte[] byArray = new byte[13];
            TimeZone timeZone = calendar.getTimeZone();
            int n3 = ZONEIDMAP.getID((String)timeZone.getID());
            if (!ZONEIDMAP.isValidID((int)n3)) {
                n2 = timeZone.getRawOffset();
                byArray[11] = (byte)(n2 / 3600000 + 20);
                byArray[12] = (byte)(n2 % 3600000 / 60000 + 60);
                if (n2 < -46740000 || n2 > 53940000) {
                    StringBuffer stringBuffer = TIMESTAMPTZConverter.formatTimezone(byArray[11], byArray[12], null);
                    throw new RSIException("Invalid timezone offset : " + stringBuffer.toString());
                }
            } else {
                n2 = timeZone.getOffset(calendar.getTimeInMillis());
                byArray[11] = (byte)TIMESTAMPTZConverter.setHighOrderbits(n3);
                byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
                byArray[12] = (byte)TIMESTAMPTZConverter.setLowOrderbits(n3);
            }
            Calendar calendar2 = (Calendar)GMT_CAL.clone();
            calendar2.clear();
            calendar2.set(0, calendar.get(0));
            calendar2.set(1, calendar.get(1));
            calendar2.set(2, calendar.get(2));
            calendar2.set(5, calendar.get(5));
            calendar2.set(11, calendar.get(11));
            calendar2.set(12, calendar.get(12));
            calendar2.set(13, calendar.get(13));
            calendar2.add(14, -n2);
            return TIMESTAMPConverter.toBytes(calendar2, n, byArray);
        }

        private static int setHighOrderbits(int n) {
            return (n & 0x1FC0) >> 6;
        }

        private static int setLowOrderbits(int n) {
            return (n & 0x3F) << 2;
        }

        private static int getHighOrderbits(int n) {
            return (n & 0x7F) << 6;
        }

        private static int getLowOrderbits(int n) {
            return (n & 0xFC) >> 2;
        }

        private static StringBuffer formatTimezone(int n, int n2, StringBuffer stringBuffer) {
            StringBuffer stringBuffer2 = stringBuffer == null ? new StringBuffer() : stringBuffer;
            stringBuffer2.append(' ');
            if ((n & REGIONIDBIT) != 0) {
                int n3 = TIMESTAMPTZConverter.getHighOrderbits(n) + TIMESTAMPTZConverter.getLowOrderbits(n2);
                if (ZONEIDMAP.isValidID((int)n3)) {
                    return stringBuffer2.append(ZONEIDMAP.getRegion((int)n3));
                }
                throw new RSIException("Invalid timezone region id : " + n3);
            }
            int n4 = n - 20;
            int n5 = n2 - 60;
            stringBuffer2.append(n4 < 0 ? (char)'-' : '+');
            stringBuffer2.append(Utils.lpad(Integer.toString(Math.abs(n4)), 2, '0'));
            stringBuffer2.append(':');
            stringBuffer2.append(Utils.lpad(Integer.toString(Math.abs(n5)), 2, '0'));
            return stringBuffer2;
        }
    }

    private static class DATEConverter {
        private static final int SIZE_DATE = 7;
        private static final int MIN_YEAR = -4712;
        private static final int MAX_YEAR = 9999;

        private DATEConverter() {
        }

        static Datum toDATE(Object object) {
            try {
                if (object == null) {
                    return new DATE();
                }
                if (object instanceof DATE) {
                    return (DATE)object;
                }
                if (Utils.isString(object)) {
                    return new DATE(Utils.toString(object).trim());
                }
                return new DATE(object);
            }
            catch (SQLException sQLException) {
                throw new RSIException(sQLException.getMessage(), sQLException);
            }
        }

        static byte[] toBytes(Calendar calendar, byte[] byArray) {
            if (calendar == null) {
                return null;
            }
            byte[] byArray2 = byArray;
            if (byArray2 == null || byArray2.length < 7) {
                byArray2 = new byte[7];
            }
            int n = calendar.get(1);
            if (calendar.get(0) == 0) {
                n = -n;
            }
            if (n < -4712 || n > 9999) {
                throw new RSIException("Invalid year: " + n);
            }
            byArray2[0] = (byte)(n / 100 + 100);
            byArray2[1] = (byte)(n % 100 + 100);
            byArray2[2] = (byte)(calendar.get(2) + 1);
            byArray2[3] = (byte)calendar.get(5);
            byArray2[4] = (byte)(calendar.get(11) + 1);
            byArray2[5] = (byte)(calendar.get(12) + 1);
            byArray2[6] = (byte)(calendar.get(13) + 1);
            return byArray2;
        }
    }

    private static class TIMESTAMPConverter {
        private static final int MIN_NANOS = 0;
        private static final int MAX_NANOS = 999999999;
        private static final int SIZE_TIMESTAMP = 11;
        private static final int SIZE_TIMESTAMP_NOFRAC = 7;

        private TIMESTAMPConverter() {
        }

        static Datum toTIMESTAMP(Object object) {
            if (object == null) {
                return new TIMESTAMP();
            }
            if (object instanceof TIMESTAMP) {
                return (TIMESTAMP)object;
            }
            if (object instanceof byte[]) {
                return new TIMESTAMP((byte[])object);
            }
            if (object instanceof Time) {
                return new TIMESTAMP((Time)object);
            }
            if (object instanceof Date) {
                return new TIMESTAMP((Date)object);
            }
            if (object instanceof Timestamp) {
                return new TIMESTAMP((Timestamp)object);
            }
            if (object instanceof DATE) {
                return new TIMESTAMP((DATE)object);
            }
            if (Utils.isString(object)) {
                return new TIMESTAMP(Utils.toString(object).trim());
            }
            String string = "Invalid type supplied for TIMESTAMP: " + String.valueOf(object.getClass());
            throw new RSIException(string);
        }

        static byte[] toBytes(Calendar calendar, int n, byte[] byArray) throws RSIException {
            if (calendar == null) {
                return null;
            }
            int n2 = n == 0 ? 7 : 11;
            byte[] byArray2 = byArray;
            if (byArray2 == null || byArray2.length < n2) {
                byArray2 = new byte[n2];
            }
            byArray2 = DATEConverter.toBytes(calendar, byArray2);
            if (n < 0 || n > 999999999) {
                throw new RSIException("Invalid nano value : " + n);
            }
            if (byArray2.length > 7) {
                byArray2[7] = (byte)(n >> 24);
                byArray2[8] = (byte)(n >> 16 & 0xFF);
                byArray2[9] = (byte)(n >> 8 & 0xFF);
                byArray2[10] = (byte)(n & 0xFF);
            }
            return byArray2;
        }
    }

    private static class BINARY_DOUBLEConverter {
        private BINARY_DOUBLEConverter() {
        }

        static Datum toBINARY_DOUBLE(Object object) {
            try {
                if (object == null) {
                    return new BINARY_DOUBLE();
                }
                if (object instanceof BINARY_DOUBLE) {
                    return (BINARY_DOUBLE)object;
                }
                if (object instanceof Double) {
                    return new BINARY_DOUBLE((Double)object);
                }
                if (Utils.isString(object)) {
                    return new BINARY_DOUBLE(Utils.toString(object).trim());
                }
                if (object instanceof Boolean) {
                    return new BINARY_DOUBLE((Boolean)object);
                }
                if (object instanceof byte[]) {
                    return new BINARY_DOUBLE((byte[])object);
                }
                String string = "Invalid type supplied for BINARY_DOUBLE: " + String.valueOf(object.getClass());
                throw new RSIException(string);
            }
            catch (SQLException sQLException) {
                throw new RSIException(sQLException.getMessage(), sQLException);
            }
        }
    }

    private static class BINARY_FLOATConverter {
        private BINARY_FLOATConverter() {
        }

        static Datum toBINARY_FLOAT(Object object) {
            try {
                if (object == null) {
                    return new BINARY_FLOAT();
                }
                if (object instanceof BINARY_FLOAT) {
                    return (BINARY_FLOAT)object;
                }
                if (object instanceof Float) {
                    return new BINARY_FLOAT((Float)object);
                }
                if (Utils.isString(object)) {
                    return new BINARY_FLOAT(Utils.toString(object).trim());
                }
                if (object instanceof Boolean) {
                    return new BINARY_FLOAT((Boolean)object);
                }
                if (object instanceof byte[]) {
                    return new BINARY_FLOAT((byte[])object);
                }
                String string = "Invalid type supplied for BINARY_FLOAT: " + String.valueOf(object.getClass());
                throw new RSIException(string);
            }
            catch (SQLException sQLException) {
                throw new RSIException(sQLException.getMessage(), sQLException);
            }
        }
    }

    private static class NUMBERConverter {
        private NUMBERConverter() {
        }

        static Datum toNUMBER(Object object) {
            try {
                if (object == null) {
                    return new NUMBER();
                }
                if (object instanceof NUMBER) {
                    return (NUMBER)object;
                }
                return new NUMBER(object);
            }
            catch (SQLException sQLException) {
                throw new RSIException(sQLException.getMessage(), sQLException);
            }
        }
    }

    private static class CHARConverter {
        private static final byte[] EMPTY_BYTES = new byte[0];

        private CHARConverter() {
        }

        static Datum toCHAR(Metadata.ColumnMetadata columnMetadata, Object object, Metadata.NLSContext nLSContext, Integer n, boolean bl) {
            byte[] byArray;
            String string;
            CharacterSet characterSet = CharacterSet.make((int)2);
            CHAR cHAR = new CHAR(EMPTY_BYTES, characterSet);
            if (object == null) {
                return cHAR;
            }
            int n2 = !columnMetadata.isNChar() && n != null ? n.intValue() : columnMetadata.getCharsetId();
            int n3 = columnMetadata.getCharsetForm();
            int n4 = columnMetadata.getLength();
            int n5 = columnMetadata.getSpare3();
            CharacterSet characterSet2 = Metadata.NLSContext.getCharacterSet(n2);
            cHAR = new CHAR(cHAR.shareBytes(), characterSet2 != null ? characterSet2 : CHAR.DEFAULT_CHARSET);
            if (Utils.isString(object)) {
                string = Utils.toString(object);
            } else if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean) {
                byArray = null;
                if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
                    byArray = NUMBER.toBytes((long)((Number)object).longValue());
                } else if (object instanceof Double) {
                    try {
                        byArray = NUMBER.toBytes((double)((Double)object));
                    }
                    catch (SQLException sQLException) {
                        throw new RSIException(sQLException.getMessage());
                    }
                } else if (object instanceof Boolean) {
                    byArray = NUMBER.toBytes((boolean)((Boolean)object));
                }
                if (!NUMBER.isValid((byte[])byArray)) {
                    throw new RSIException("Invalid Number.");
                }
                string = NUMBER.toString((byte[])byArray);
            } else if (object instanceof Datum) {
                if (!(object instanceof CHAR)) {
                    String string2 = "Invalid type supplied for " + columnMetadata.getSQLType().getName() + ": " + String.valueOf(object.getClass());
                    throw new RSIException(string2);
                }
                try {
                    string = ((CHAR)object).getString();
                }
                catch (SQLException sQLException) {
                    throw new RSIException(sQLException.getMessage());
                }
            } else if (object.getClass().isArray() && object.getClass().getComponentType() == Byte.TYPE) {
                byArray = (byte[])object;
                string = Metadata.NLSContext.getCharacterSet(n2).toStringWithReplacement(byArray, 0, byArray.length);
            } else {
                String string3 = "Invalid type supplied for " + columnMetadata.getSQLType().getName() + ": " + String.valueOf(object.getClass());
                throw new RSIException(string3);
            }
            int n6 = string.length();
            if (n6 == 0) {
                return cHAR;
            }
            if (n6 > n5) {
                String string4 = "Value exceeds char length limit(" + n5 + ") actual(" + n6 + ")";
                throw new RSIException(string4);
            }
            if (characterSet2 == null) {
                throw new RSIException("Unsupported charset");
            }
            byte[] byArray2 = characterSet2.convertWithReplacement(string);
            int n7 = byArray2.length;
            if (n7 > n4) {
                String string5 = "Value exceeds byte length limit(" + n4 + ") actual(" + n7 + ")";
                throw new RSIException(string5);
            }
            if (bl) {
                byte[] byArray3 = nLSContext.padToLength(byArray2, n6, n4, n5, n3);
                cHAR.setShareBytes(byArray3);
            } else {
                cHAR.setShareBytes(byArray2);
            }
            return cHAR;
        }
    }
}

