/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.lang.reflect.Executable;
import java.util.BitSet;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.OracleJsonExceptions;

public class StreamContext {
    int depth;
    BitSet stack = new BitSet();
    BitSet hasChildren = new BitSet();
    boolean pendingKey;
    boolean done;
    OracleJsonExceptions.ExceptionFactory exceptionFactory;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public StreamContext(OracleJsonExceptions.ExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
        this.init();
    }

    void init() {
        this.stack.clear();
        this.hasChildren.clear();
        this.depth = 0;
        this.pendingKey = false;
        this.done = false;
    }

    public void startObject() {
        this.beginValue();
        ++this.depth;
        this.stack.set(this.depth);
        this.hasChildren.clear(this.depth);
    }

    public void pendingKey() {
        if (!this.inObject() || this.pendingKey) {
            throw OracleJsonExceptions.BAD_KEY.create(this.exceptionFactory, new Object[0]);
        }
        this.pendingKey = true;
    }

    public void startArray() {
        this.beginValue();
        ++this.depth;
        this.stack.clear(this.depth);
        this.hasChildren.clear(this.depth);
    }

    public void end() {
        if (this.pendingKey) {
            throw OracleJsonExceptions.EXPECTED_VALUE.create(this.exceptionFactory, new Object[0]);
        }
        if (this.depth == 0) {
            throw OracleJsonExceptions.BAD_END.create(this.exceptionFactory, new Object[0]);
        }
        --this.depth;
        if (this.depth == 0) {
            this.done = true;
        }
    }

    public void primitive() {
        this.beginValue();
        if (this.depth == 0) {
            this.done = true;
        }
    }

    private void beginValue() {
        if (this.inObject() && !this.pendingKey) {
            throw OracleJsonExceptions.MISSING_KEY.create(this.exceptionFactory, new Object[0]);
        }
        if (this.done) {
            throw OracleJsonExceptions.EXTRA_EVENTS.create(this.exceptionFactory, new Object[0]);
        }
        this.pendingKey = false;
        this.hasChildren.set(this.depth);
    }

    public boolean inObject() {
        return this.depth > 0 && this.stack.get(this.depth);
    }

    public boolean hasChildren() {
        return this.hasChildren.get(this.depth);
    }

    public void close() {
        if (!this.done) {
            throw OracleJsonExceptions.GENERATION_INCOMPLETE.create(this.exceptionFactory, new Object[0]);
        }
    }

    public void setExceptionFactory(OracleJsonExceptions.ExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
    }

    static {
        try {
            $$$methodRef$$$11 = StreamContext.class.getDeclaredConstructor(OracleJsonExceptions.ExceptionFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = StreamContext.class.getDeclaredMethod("setExceptionFactory", OracleJsonExceptions.ExceptionFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = StreamContext.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = StreamContext.class.getDeclaredMethod("hasChildren", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = StreamContext.class.getDeclaredMethod("inObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = StreamContext.class.getDeclaredMethod("beginValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = StreamContext.class.getDeclaredMethod("primitive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = StreamContext.class.getDeclaredMethod("end", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = StreamContext.class.getDeclaredMethod("startArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = StreamContext.class.getDeclaredMethod("pendingKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = StreamContext.class.getDeclaredMethod("startObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = StreamContext.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

