/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.nl;

import java.lang.reflect.Executable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.UninitializedObjectException;

public final class NVTokens {
    public static final int TKN_NONE = 0;
    public static final int TKN_LPAREN = 1;
    public static final int TKN_RPAREN = 2;
    public static final int TKN_COMMA = 3;
    public static final int TKN_EQUAL = 4;
    public static final int TKN_LITERAL = 8;
    public static final int TKN_EOS = 9;
    private static final char TKN_LPAREN_VALUE = '(';
    private static final char TKN_RPAREN_VALUE = ')';
    private static final char TKN_COMMA_VALUE = ',';
    private static final char TKN_EQUAL_VALUE = '=';
    private static final char TKN_BKSLASH_VALUE = '\\';
    private static final char TKN_DQUOTE_VALUE = '\"';
    private static final char TKN_SQUOTE_VALUE = '\'';
    private static final char TKN_EOS_VALUE = '%';
    private static final char TKN_SPC_VALUE = ' ';
    private static final char TKN_TAB_VALUE = '\t';
    private static final char TKN_LF_VALUE = '\n';
    private static final char TKN_CR_VALUE = '\r';
    private Vector _tkType = null;
    private Vector _tkValue = null;
    private int _numTokens = 0;
    private int _tkPos = 0;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    private static boolean _isWhiteSpace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r';
    }

    private static String _trimWhiteSpace(String string) {
        int n2;
        int n3 = string.length();
        int n4 = n3;
        for (n2 = 0; n2 < n3 && NVTokens._isWhiteSpace(string.charAt(n2)); ++n2) {
        }
        while (n2 < n4 && NVTokens._isWhiteSpace(string.charAt(n4 - 1))) {
            --n4;
        }
        return string.substring(n2, n4);
    }

    public boolean parseTokens(String string) {
        this._numTokens = 0;
        this._tkPos = 0;
        this._tkType = new Vector(25, 25);
        this._tkValue = new Vector(25, 25);
        int n2 = string.length();
        boolean bl = false;
        char[] cArray = string.toCharArray();
        int n3 = 0;
        block6: while (n3 < n2) {
            while (n3 < n2 && NVTokens._isWhiteSpace(cArray[n3])) {
                ++n3;
            }
            if (n3 >= n2) continue;
            switch (cArray[n3]) {
                case '(': {
                    bl = false;
                    this._addToken(1, '(');
                    ++n3;
                    continue block6;
                }
                case '=': {
                    bl = true;
                    this._addToken(4, '=');
                    ++n3;
                    continue block6;
                }
                case ')': {
                    bl = false;
                    this._addToken(2, ')');
                    ++n3;
                    continue block6;
                }
                case ',': {
                    bl = false;
                    this._addToken(3, ',');
                    ++n3;
                    continue block6;
                }
            }
            int n4 = n3;
            int n5 = -1;
            boolean bl2 = false;
            char c2 = '\"';
            if (cArray[n3] == '\'' || cArray[n3] == '\"') {
                bl2 = true;
                c2 = cArray[n3];
                ++n3;
            }
            while (n3 < n2) {
                if (cArray[n3] == '\\') {
                    n3 += 2;
                    continue;
                }
                if (bl2) {
                    if (cArray[n3] == c2) {
                        n5 = ++n3;
                        break;
                    }
                } else if (cArray[n3] == '(' || cArray[n3] == ')' || cArray[n3] == ',' && !bl || cArray[n3] == '=' && !bl) {
                    n5 = n3;
                    break;
                }
                ++n3;
            }
            if (n5 == -1) {
                n5 = n3;
            }
            this._addToken(8, NVTokens._trimWhiteSpace(string.substring(n4, n5)));
        }
        this._addToken(9, '%');
        return true;
    }

    public int getToken() throws NLException {
        if (this._tkType == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos < this._numTokens) {
            return (Integer)this._tkType.elementAt(this._tkPos);
        }
        throw new NLException("NoLiterals-04610", "");
    }

    public int popToken() throws UninitializedObjectException, NLException {
        int n2 = 0;
        if (this._tkType == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos >= this._numTokens) {
            throw new NLException("NoLiterals-04610", "");
        }
        n2 = (Integer)this._tkType.elementAt(this._tkPos++);
        return n2;
    }

    public String getLiteral() throws NLException {
        String string = null;
        if (this._tkValue == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos >= this._numTokens) {
            throw new NLException("NoLiterals-04610", "");
        }
        string = (String)this._tkValue.elementAt(this._tkPos);
        return string;
    }

    public String popLiteral() throws NLException {
        String string = null;
        if (this._tkValue == null) {
            throw new UninitializedObjectException("ParseError-04604", "");
        }
        if (this._tkPos >= this._numTokens) {
            throw new NLException("NoLiterals-04610", "");
        }
        string = (String)this._tkValue.elementAt(this._tkPos++);
        return string;
    }

    public void eatToken() {
        if (this._tkPos < this._numTokens) {
            ++this._tkPos;
        }
    }

    @DisableTrace
    public String toString() {
        if (this._tkType == null) {
            return "*NO TOKENS*";
        }
        String string = "Tokens";
        for (int i2 = 0; i2 < this._numTokens; ++i2) {
            string = string + " : " + this._tkValue.elementAt(i2);
        }
        return string;
    }

    public void println() {
        System.out.println(this.toString());
    }

    private void _addToken(int n2, char c2) {
        this._addToken(n2, String.valueOf(c2));
    }

    private void _addToken(int n2, String string) {
        this._tkType.addElement(new Integer(n2));
        this._tkValue.addElement(string);
        ++this._numTokens;
    }

    static {
        try {
            $$$methodRef$$$11 = NVTokens.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NVTokens.class.getDeclaredMethod("_addToken", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NVTokens.class.getDeclaredMethod("_addToken", Integer.TYPE, Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NVTokens.class.getDeclaredMethod("println", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NVTokens.class.getDeclaredMethod("eatToken", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NVTokens.class.getDeclaredMethod("popLiteral", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NVTokens.class.getDeclaredMethod("getLiteral", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NVTokens.class.getDeclaredMethod("popToken", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NVTokens.class.getDeclaredMethod("getToken", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NVTokens.class.getDeclaredMethod("parseTokens", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NVTokens.class.getDeclaredMethod("_trimWhiteSpace", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NVTokens.class.getDeclaredMethod("_isWhiteSpace", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

