/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pooling.kdtree;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.jdbc.pooling.kdtree.Point;
import oracle.jdbc.pooling.kdtree.Range;

public class KDTree<T> {
    private final T data;
    private final Point point;
    private final AtomicReference<KDTree> left = new AtomicReference<Object>(null);
    private final AtomicReference<KDTree> right = new AtomicReference<Object>(null);
    private int depth = 0;
    private final int len;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public KDTree(T t2, Point point) {
        this.data = t2;
        this.point = point;
        this.len = point.size();
    }

    public KDTree(KDTree<T> kDTree) {
        this.data = kDTree.data;
        this.point = new Point(kDTree.point);
        this.len = this.point.size();
    }

    public void merge(KDTree<T> kDTree) {
        this.merge(kDTree, 0);
    }

    private void merge(KDTree<T> kDTree, int n2) {
        if (null != kDTree) {
            if (!this.point.sameSpace(kDTree.point)) {
                throw new IllegalArgumentException("incompatible space metrics");
            }
            this.merge(kDTree.left.getAndSet(null), n2);
            this.merge(kDTree.right.getAndSet(null), n2);
            kDTree.depth = n2 + 1;
            if (this.point.get(n2 % this.len).compareTo(kDTree.point.get(n2 % this.len)) >= 0) {
                if (!this.point.equals(kDTree.point) && !this.right.compareAndSet(null, kDTree)) {
                    this.right.get().merge(kDTree, n2 + 1);
                }
            } else if (!this.left.compareAndSet(null, kDTree)) {
                this.left.get().merge(kDTree, n2 + 1);
            }
        }
    }

    public List<KDTree<T>> search(Range[] rangeArray) {
        ArrayList<KDTree<T>> arrayList = new ArrayList<KDTree<T>>();
        this.search(arrayList, rangeArray, 0, false);
        return arrayList;
    }

    public List<KDTree<T>> searchCopy(Range[] rangeArray) {
        ArrayList<KDTree<T>> arrayList = new ArrayList<KDTree<T>>();
        this.search(arrayList, rangeArray, 0, true);
        return arrayList;
    }

    private void search(List<KDTree<T>> list, Range[] rangeArray, int n2, boolean bl) {
        if (!this.point.sameSpace(rangeArray)) {
            throw new IllegalArgumentException("incompatible vectors");
        }
        if (this.point.within(rangeArray)) {
            list.add(bl ? new KDTree<T>(this) : this);
        }
        Range range = rangeArray[n2 % this.len];
        Comparable comparable = this.point.get(n2 % this.len);
        if ((range.infinite() || comparable.compareTo(range.high()) <= 0) && null != this.left.get()) {
            this.left.get().search(list, rangeArray, n2 + 1, bl);
        }
        if ((range.infinite() || comparable.compareTo(range.low()) >= 0) && null != this.right.get()) {
            this.right.get().search(list, rangeArray, n2 + 1, bl);
        }
    }

    KDTree[] split(Range[] rangeArray) {
        KDTree[] kDTreeArray = new KDTree[2];
        this.split(kDTreeArray, rangeArray);
        return kDTreeArray;
    }

    private void split(KDTree[] kDTreeArray, Range[] rangeArray) {
        int n2;
        KDTree<T> kDTree = new KDTree<T>(this);
        int n3 = n2 = this.point.within(rangeArray) ? 0 : 1;
        if (null == kDTreeArray[n2]) {
            kDTreeArray[n2] = kDTree;
        } else {
            kDTreeArray[n2].merge(kDTree);
        }
        if (null != this.left.get()) {
            this.left.get().split(kDTreeArray, rangeArray);
        }
        if (null != this.right.get()) {
            this.right.get().split(kDTreeArray, rangeArray);
        }
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.data).append(' ').append(this.depth).append(' ').append(this.point).append(" {\n");
        for (n3 = 0; n3 < n2 + 2; ++n3) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(null != this.left.get() ? this.left.get().toString(n2 + 2) : "null").append(",\n");
        for (n3 = 0; n3 < n2 + 2; ++n3) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(null != this.right.get() ? this.right.get().toString(n2 + 2) : "null").append("}");
        return stringBuilder.toString();
    }

    public T getData() {
        return this.data;
    }

    static {
        try {
            $$$methodRef$$$11 = KDTree.class.getDeclaredConstructor(KDTree.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = KDTree.class.getDeclaredConstructor(Object.class, Point.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = KDTree.class.getDeclaredMethod("getData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = KDTree.class.getDeclaredMethod("toString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = KDTree.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = KDTree.class.getDeclaredMethod("split", KDTree[].class, Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = KDTree.class.getDeclaredMethod("split", Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = KDTree.class.getDeclaredMethod("search", List.class, Range[].class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = KDTree.class.getDeclaredMethod("searchCopy", Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = KDTree.class.getDeclaredMethod("search", Range[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = KDTree.class.getDeclaredMethod("merge", KDTree.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = KDTree.class.getDeclaredMethod("merge", KDTree.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

