/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.TimeoutInterruptHandler;

class TimeoutSocketChannel
extends SocketChannel {
    private SocketChannel socketChannel;
    private Selector sel;
    private SelectionKey sk;
    private int soTimeout = 0;
    TimeoutInterruptHandler.InterruptTask interruptTask;
    NetStatImpl netStat = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutSocketChannel(SocketAddress socketAddress, int n2, NetStatImpl netStatImpl) throws IOException {
        super(null);
        this.netStat = netStatImpl;
        this.scheduleInterrupt(n2);
        try {
            this.socketChannel = SocketChannel.open(socketAddress);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
    }

    void setNetStat(NetStatImpl netStatImpl) {
        this.netStat = netStatImpl;
    }

    public void disconnect() throws IOException {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
        }
        finally {
            this.cleanup();
        }
    }

    public void setSoTimeout(int n2) {
        this.soTimeout = n2;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public Socket socket() {
        return this.socketChannel.socket();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.socketChannel.isConnectionPending();
    }

    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        return this.socketChannel.connect(socketAddress);
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        try {
            if (this.socketChannel == null) throw new IOException("Socket channel is closed");
            if (!this.socketChannel.isOpen()) {
                throw new IOException("Socket channel is closed");
            }
            if (this.soTimeout == 0) {
                try {
                    int n2 = this.socketChannel.read(byteBuffer);
                    if (this.netStat == null) return n2;
                    this.netStat.incrementBytesReceived(n2);
                    return n2;
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                    throw new SocketTimeoutException("Socket read interrupted");
                }
            }
            if (this.sel == null) {
                this.sel = Selector.open();
            }
            this.socketChannel.configureBlocking(false);
            try {
                int n3 = this.socketChannel.read(byteBuffer);
                if (n3 != 0) {
                    int n4 = n3;
                    return n4;
                }
                this.sk = this.socketChannel.register(this.sel, 1);
                int n5 = this.sel.select(this.soTimeout);
                if (n5 <= 0) throw new SocketTimeoutException("Socket read timed out");
                if (!this.sk.isReadable()) throw new SocketTimeoutException("Socket read timed out");
                n3 = this.socketChannel.read(byteBuffer);
                if (n3 == 0) throw new SocketTimeoutException("Socket read timed out");
                if (this.netStat != null) {
                    this.netStat.incrementBytesReceived(n3);
                }
                int n6 = n3;
                return n6;
            }
            finally {
                if (this.sk != null) {
                    this.sk.cancel();
                    this.sel.selectNow();
                    this.sk = null;
                }
                if (this.socketChannel != null && this.socketChannel.isOpen()) {
                    this.socketChannel.configureBlocking(true);
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            try {
                Socket socket = this.socketChannel.socket();
                socket.sendUrgentData(33);
                this.disconnect();
                throw socketTimeoutException;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw socketTimeoutException;
        }
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout());
        try {
            if (this.socketChannel == null) {
                throw new IOException("Socket channel is closed");
            }
            int n2 = this.socketChannel.write(byteBuffer);
            if (this.netStat != null) {
                this.netStat.incrementBytesSent(n2);
            }
            int n3 = n2;
            return n3;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return -1;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    public Channel getAdapteeChannel() {
        return this.socketChannel;
    }

    @DisableTrace
    public String toString() {
        return "TimeoutSocketChannel[" + this.socket().toString() + "]";
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.socketChannel.getRemoteAddress();
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        return this.socketChannel.shutdownOutput();
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        return this.socketChannel.shutdownInput();
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t2) throws IOException {
        return this.socketChannel.setOption((SocketOption)socketOption, (Object)t2);
    }

    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        return this.socketChannel.bind(socketAddress);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.socketChannel.supportedOptions();
    }

    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        return this.socketChannel.getOption(socketOption);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.socketChannel.getLocalAddress();
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        throw new IOException("Unsupported feature");
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        throw new IOException("Unsupported feature");
    }

    private void scheduleInterrupt(int n2) {
        if (n2 > 0) {
            this.interruptTask = TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, n2, Thread.currentThread());
        }
    }

    private void handleInterrupt() throws InterruptedIOException {
        Thread.interrupted();
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.interruptTask != null && this.interruptTask.isInterrupted()) {
            throw new InterruptedIOException("Socket read timed out");
        }
        throw new InterruptedIOException("Operation interrupted");
    }

    private void cleanup() {
        this.socketChannel = null;
        if (this.sel != null && this.sel.isOpen()) {
            try {
                this.sel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void cancelTimeout() {
        if (this.interruptTask != null) {
            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
            if (this.interruptTask.isInterrupted()) {
                Thread.interrupted();
            }
            this.interruptTask = null;
        }
    }

    static {
        try {
            $$$methodRef$$$30 = TimeoutSocketChannel.class.getDeclaredConstructor(SocketAddress.class, Integer.TYPE, NetStatImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = TimeoutSocketChannel.class.getDeclaredMethod("bind", SocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = TimeoutSocketChannel.class.getDeclaredMethod("setOption", SocketOption.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = TimeoutSocketChannel.class.getDeclaredMethod("cancelTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = TimeoutSocketChannel.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = TimeoutSocketChannel.class.getDeclaredMethod("handleInterrupt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = TimeoutSocketChannel.class.getDeclaredMethod("scheduleInterrupt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = TimeoutSocketChannel.class.getDeclaredMethod("implConfigureBlocking", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = TimeoutSocketChannel.class.getDeclaredMethod("implCloseSelectableChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = TimeoutSocketChannel.class.getDeclaredMethod("getLocalAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = TimeoutSocketChannel.class.getDeclaredMethod("getOption", SocketOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = TimeoutSocketChannel.class.getDeclaredMethod("supportedOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = TimeoutSocketChannel.class.getDeclaredMethod("bind", SocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = TimeoutSocketChannel.class.getDeclaredMethod("setOption", SocketOption.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TimeoutSocketChannel.class.getDeclaredMethod("shutdownInput", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TimeoutSocketChannel.class.getDeclaredMethod("shutdownOutput", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TimeoutSocketChannel.class.getDeclaredMethod("getRemoteAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TimeoutSocketChannel.class.getDeclaredMethod("getAdapteeChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TimeoutSocketChannel.class.getDeclaredMethod("write", ByteBuffer[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TimeoutSocketChannel.class.getDeclaredMethod("write", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TimeoutSocketChannel.class.getDeclaredMethod("read", ByteBuffer[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TimeoutSocketChannel.class.getDeclaredMethod("read", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TimeoutSocketChannel.class.getDeclaredMethod("finishConnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TimeoutSocketChannel.class.getDeclaredMethod("connect", SocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TimeoutSocketChannel.class.getDeclaredMethod("isConnectionPending", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TimeoutSocketChannel.class.getDeclaredMethod("isConnected", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimeoutSocketChannel.class.getDeclaredMethod("socket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimeoutSocketChannel.class.getDeclaredMethod("getSoTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimeoutSocketChannel.class.getDeclaredMethod("setSoTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimeoutSocketChannel.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimeoutSocketChannel.class.getDeclaredMethod("setNetStat", NetStatImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

