/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEvent;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.ReplayContext;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.EndReplayCallback;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;
import oracle.jdbc.replay.driver.TxnFailoverManager;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.jdbc.replay.driver.TxnReplayableStatement;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.OracleDataSource;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
class TxnFailoverManagerImpl
implements TxnFailoverManager,
LogicalTransactionIdEventListener {
    private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
    private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
    private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
    private CallHistoryEntry head;
    private CallHistoryEntry tail;
    private ReplayLifecycle lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
    private static final int DIRECTIVE_ENQUEUE_CALL = 1;
    private static final int DIRECTIVE_REQ_SCOPE_CRSR = 2;
    private static final int DIRECTIVE_REPLAY_ENABLED = 4;
    private static final int DIRECTIVE_EMPTY_QUEUE = 8;
    private Object replayResult;
    private long requestStartTime;
    private long replayInitiationTimeout = 300L;
    private static final int REPLAY_RETRIES = 3;
    private int replayRetries = 0;
    private LogicalTransactionId ltxid = null;
    private LogicalTransactionId oldLtxidForPrepareReplay = null;
    private ReplayContext[] replayContext = null;
    private ReplayContext cxtBeforePrepareReplay;
    private OracleDataSource replayDataSource = null;
    private TxnReplayableBase connectionProxy;
    private OracleConnection originalOconn = null;
    private String connectionProxyName;
    private Method callHittingOutage;
    private Method callCausingReplayError;
    private int replayErrorCode;
    private String replayErrorMessage;
    private boolean doNotAbortConn = false;
    private boolean isReplayInDynamicMode = true;
    private boolean isStateRestorationEnabled = false;
    private Properties savedSessionProps = null;
    private Properties savedClientInfo = null;
    private String savedCurrentSchema = null;
    private boolean savedAutoCommit = true;
    private static final int QUEUE_NUMBER = 2;
    private static final int NOT_IN_QUEUE = -1;
    private static int activeQueues;
    private static final int INIT_EMPTY_COUNT = 0;
    private static final int NA_EMPTY_COUNT = -1;
    private static final int REQ_SCOPE_EMPTY_COUNT = Integer.MAX_VALUE;
    private int[] queueEmptyCounts = new int[2];
    boolean seenRoundtripCallInRequest = false;
    boolean didReplayingLastCallDisableReplay = false;
    short nestedLevelOfTopLevelCalls = 0;
    private static final HashSet<String> postExecuteGetCalls;
    private static final String NULL_METHOD_NAME = "NULL METHOD";
    ReplayStatisticsImpl acStatistics = null;
    private boolean callingDisableFromEndRequest = false;
    boolean lobStreamInRequest = false;
    private static final ExecutorService executor;
    private static final String PREPARE_REPLAY = "DECLARE PROCEDURE PREPARE_REPLAY_WRAPPER(ltxid IN RAW, is_replay IN NUMBER, ac IN NUMBER, fncode IN BINARY_INTEGER, sql_text IN VARCHAR2, is_committed OUT NUMBER, is_embedded OUT NUMBER) IS attempting_replay BOOLEAN; auto_commit BOOLEAN; committed BOOLEAN; embedded BOOLEAN; BEGIN if is_replay = 1 then attempting_replay := true; else attempting_replay := false; end if; if ac = 1 then auto_commit := true; else auto_commit := false; end if; DBMS_APP_CONT_PRVT.PREPARE_REPLAY(ltxid, attempting_replay, auto_commit, fncode, sql_text, committed, embedded); if committed then is_committed := 1; else is_committed := 0; end if; if embedded then is_embedded := 1; else is_embedded := 0; end if; END; BEGIN PREPARE_REPLAY_WRAPPER(?,?,?,?,?,?,?); END;";
    static final String NLS_CALENDAR_PROPERTY = "AUTH_NLS_LXCCALENDAR";
    static final String NLS_CURRENCY_PROPERTY = "AUTH_NLS_LXCCURRENCY";
    static final String NLS_DATE_FORMAT_PROPERTY = "AUTH_NLS_LXCDATEFM";
    static final String NLS_DATE_LANGUAGE_PROPERTY = "AUTH_NLS_LXCDATELANG";
    static final String NLS_DUAL_CURRENCY_PROPERTY = "AUTH_NLS_LXCUNIONCUR";
    static final String NLS_ISO_CURRENCY_PROPERTY = "AUTH_NLS_LXCISOCURR";
    static final String NLS_LANGUAGE_PROPERTY = "AUTH_NLS_LXLAN";
    static final String NLS_LENGTH_SEMANTICS_PROPERTY = "SESSION_NLS_LXCNLSLENSEM";
    static final String NLS_NCHAR_CONV_EXCP_PROPERTY = "SESSION_NLS_LXCNCHAREXCP";
    static final String NLS_NUMERIC_CHARACTERS_PROPERTY = "AUTH_NLS_LXCNUMERICS";
    static final String NLS_SORT_PROPERTY = "AUTH_NLS_LXCSORT";
    static final String NLS_TERRITORY_PROPERTY = "AUTH_NLS_LXCTERRITORY";
    static final String NLS_TIME_FORMAT_PROPERTY = "AUTH_NLS_LXCTIMEFM";
    static final String NLS_TIME_TZ_FORMAT_PROPERTY = "AUTH_NLS_LXCTTZNFM";
    static final String NLS_TIMESTAMP_FORMAT_PROPERTY = "AUTH_NLS_LXCSTMPFM";
    static final String NLS_TIMESTAMP_TZ_FORMAT_PROPERTY = "AUTH_NLS_LXCSTZNFM";
    private static final String FAILOVER_TYPE_PROPERTY = "AUTH_FAILOVER_TYPE";
    private static final int FAILOVER_TYPE_TRANSACTION = 8;
    private static final int SESSION_STATE_CONSISTENCY_STATIC = 16;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;

    private TxnFailoverManagerImpl(TxnReplayableBase txnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        this.connectionProxy = txnReplayableBase;
        this.connectionProxyName = this.connectionProxy.thisProxyNameInLog;
        this.replayDataSource = oracleDataSource;
        OracleConnection oracleConnection = (OracleConnection)txnReplayableBase.getDelegate();
        this.ltxid = oracleConnection.getLogicalTransactionId();
        this.replayContext = null;
        activeQueues = 2;
        this.queueEmptyCounts = new int[2];
        for (int i2 = 0; i2 < activeQueues; ++i2) {
            this.queueEmptyCounts[i2] = 0;
        }
        oracleConnection.addLogicalTransactionIdEventListener(this);
        this.acStatistics = new ReplayStatisticsImpl();
        this.replayDataSource.updateReplayStatistics(this.acStatistics);
    }

    static TxnFailoverManager getFailoverManager(TxnReplayableBase txnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        return new TxnFailoverManagerImpl(txnReplayableBase, oracleDataSource);
    }

    private void append(CallHistoryEntry callHistoryEntry) {
        callHistoryEntry.prevEntry = this.tail;
        callHistoryEntry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = callHistoryEntry;
        }
        this.tail = callHistoryEntry;
        if (this.head == null) {
            this.head = callHistoryEntry;
        }
        JDBCReplayable jDBCReplayable = (JDBCReplayable)callHistoryEntry.jdbcProxy;
        jDBCReplayable.addToSameProxyList(callHistoryEntry);
    }

    private void remove(CallHistoryEntry callHistoryEntry) {
        if (callHistoryEntry.nextEntry != null) {
            callHistoryEntry.nextEntry.prevEntry = callHistoryEntry.prevEntry;
        }
        if (callHistoryEntry.prevEntry != null) {
            callHistoryEntry.prevEntry.nextEntry = callHistoryEntry.nextEntry;
        }
        if (this.head == callHistoryEntry) {
            this.head = callHistoryEntry.nextEntry;
        }
        if (this.tail == callHistoryEntry) {
            this.tail = callHistoryEntry.prevEntry;
        }
        JDBCReplayable jDBCReplayable = (JDBCReplayable)callHistoryEntry.jdbcProxy;
        jDBCReplayable.removeFromSameProxyList(callHistoryEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CallHistoryEntry record(Object object, Method method, Object[] objectArray, String string) {
        this.acStatistics.incrementTotalProtectedCalls();
        if (this.tail != null && this.tail.method != null && "started".equals(this.tail.callStatus)) {
            this.nestedLevelOfTopLevelCalls = (short)(this.nestedLevelOfTopLevelCalls + 1);
            return null;
        }
        TxnFailoverManagerImpl txnFailoverManagerImpl = this;
        synchronized (txnFailoverManagerImpl) {
            CallHistoryEntry callHistoryEntry = new CallHistoryEntry(object, method, objectArray, string);
            this.append(callHistoryEntry);
            return callHistoryEntry;
        }
    }

    private String dumpHistory() {
        String string = "Dump History: \n";
        if (this.head != null) {
            CallHistoryEntry callHistoryEntry = this.head;
            while (true) {
                string = string + callHistoryEntry.toString();
                if (callHistoryEntry == this.tail) break;
                callHistoryEntry = callHistoryEntry.nextEntry;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Object object, CallHistoryEntry callHistoryEntry, Object object2, String string, long l2, SQLException sQLException) {
        int n2;
        int n3;
        Object object3;
        int n4;
        Object object4;
        if (this.nestedLevelOfTopLevelCalls > 0) {
            this.nestedLevelOfTopLevelCalls = (short)(this.nestedLevelOfTopLevelCalls - 1);
            return;
        }
        ReplayContext[] replayContextArray = null;
        boolean bl = false;
        ReplayContext[] replayContextArray2 = null;
        int n5 = -1;
        int n6 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            object4 = (OracleConnection)this.connectionProxy.getDelegate();
            replayContextArray = object4.getReplayContext();
            Object object5 = object4 = callHistoryEntry == null ? this.tail : callHistoryEntry;
        }
        catch (SQLException sQLException2) {
            try {
                bl = true;
                Object object6 = object4 = callHistoryEntry == null ? this.tail : callHistoryEntry;
            }
            catch (Throwable throwable) {
                CallHistoryEntry callHistoryEntry2;
                CallHistoryEntry callHistoryEntry3 = callHistoryEntry2 = callHistoryEntry == null ? this.tail : callHistoryEntry;
                if (!bl) {
                    if (replayContextArray != null) {
                        this.replayContext = replayContextArray;
                        replayContextArray2 = new ReplayContext[replayContextArray.length];
                        if (replayContextArray.length > 0) {
                            this.seenRoundtripCallInRequest = true;
                        }
                        for (int i2 = 0; i2 < replayContextArray.length; ++i2) {
                            ReplayContext replayContext = replayContextArray[i2];
                            int n7 = (int)replayContext.getDirectives();
                            short s2 = replayContext.getQueue();
                            if ((n7 & 4) == 0) {
                                bl = true;
                                if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                                    this.didReplayingLastCallDisableReplay = true;
                                }
                                long l3 = replayContext.getErrorCode();
                                this.disableReplayInternal(callHistoryEntry2.method, 384, "Replay disabled by server Continuity Management", null);
                                return;
                            }
                            if ((n7 & 8) == 8) {
                                short s3 = s2;
                                this.queueEmptyCounts[s3] = this.queueEmptyCounts[s3] + 1;
                            }
                            assert ((n7 & 1) == 1 || !bl3) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                            if ((n7 & 1) == 1) {
                                replayContextArray2[i2] = replayContext;
                                n5 = s2;
                                n6 = this.queueEmptyCounts[s2];
                                bl3 = true;
                            }
                            if ((n7 & 2) != 2) continue;
                            bl2 = true;
                        }
                    } else {
                        if (callHistoryEntry2.replayContext != null) {
                            return;
                        }
                        n5 = -1;
                        n6 = 0;
                    }
                } else {
                    this.disableReplayInternal(callHistoryEntry2.method, 383, "Replay disabled because getting replay context failed", null);
                }
                throw throwable;
            }
            if (!bl) {
                if (replayContextArray != null) {
                    this.replayContext = replayContextArray;
                    replayContextArray2 = new ReplayContext[replayContextArray.length];
                    if (replayContextArray.length > 0) {
                        this.seenRoundtripCallInRequest = true;
                    }
                    for (n4 = 0; n4 < replayContextArray.length; ++n4) {
                        object3 = replayContextArray[n4];
                        n3 = (int)object3.getDirectives();
                        n2 = object3.getQueue();
                        if ((n3 & 4) == 0) {
                            bl = true;
                            if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                                this.didReplayingLastCallDisableReplay = true;
                            }
                            long l4 = object3.getErrorCode();
                            this.disableReplayInternal(((CallHistoryEntry)object4).method, 384, "Replay disabled by server Continuity Management", null);
                            return;
                        }
                        if ((n3 & 8) == 8) {
                            int n8 = n2;
                            this.queueEmptyCounts[n8] = this.queueEmptyCounts[n8] + 1;
                        }
                        assert ((n3 & 1) == 1 || !bl3) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                        if ((n3 & 1) == 1) {
                            replayContextArray2[n4] = object3;
                            n5 = n2;
                            n6 = this.queueEmptyCounts[n2];
                            bl3 = true;
                        }
                        if ((n3 & 2) != 2) continue;
                        bl2 = true;
                    }
                } else {
                    if (((CallHistoryEntry)object4).replayContext != null) {
                        return;
                    }
                    n5 = -1;
                    n6 = 0;
                }
            } else {
                this.disableReplayInternal(((CallHistoryEntry)object4).method, 383, "Replay disabled because getting replay context failed", null);
            }
        }
        if (!bl) {
            if (replayContextArray != null) {
                this.replayContext = replayContextArray;
                replayContextArray2 = new ReplayContext[replayContextArray.length];
                if (replayContextArray.length > 0) {
                    this.seenRoundtripCallInRequest = true;
                }
                for (n4 = 0; n4 < replayContextArray.length; ++n4) {
                    object3 = replayContextArray[n4];
                    n3 = (int)object3.getDirectives();
                    n2 = object3.getQueue();
                    if ((n3 & 4) == 0) {
                        bl = true;
                        if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                            this.didReplayingLastCallDisableReplay = true;
                        }
                        long l5 = object3.getErrorCode();
                        this.disableReplayInternal(((CallHistoryEntry)object4).method, 384, "Replay disabled by server Continuity Management", null);
                        return;
                    }
                    if ((n3 & 8) == 8) {
                        int n9 = n2;
                        this.queueEmptyCounts[n9] = this.queueEmptyCounts[n9] + 1;
                    }
                    assert ((n3 & 1) == 1 || !bl3) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                    if ((n3 & 1) == 1) {
                        replayContextArray2[n4] = object3;
                        n5 = n2;
                        n6 = this.queueEmptyCounts[n2];
                        bl3 = true;
                    }
                    if ((n3 & 2) != 2) continue;
                    bl2 = true;
                }
            } else {
                if (((CallHistoryEntry)object4).replayContext != null) {
                    return;
                }
                n5 = -1;
                n6 = 0;
            }
        } else {
            this.disableReplayInternal(((CallHistoryEntry)object4).method, 383, "Replay disabled because getting replay context failed", null);
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED && this.tail != null) {
            object4 = callHistoryEntry == null ? this.tail : callHistoryEntry;
            Object object7 = this;
            synchronized (object7) {
                object3 = object4 == null || ((CallHistoryEntry)object4).method == null ? NULL_METHOD_NAME : ((CallHistoryEntry)object4).method.getName();
                ((CallHistoryEntry)object4).result = object2;
                ((CallHistoryEntry)object4).checksum = l2;
                if (replayContextArray2 != null) {
                    if (((CallHistoryEntry)object4).replayContext == null) {
                        ((CallHistoryEntry)object4).replayContext = replayContextArray2;
                    } else {
                        ReplayContext[] replayContextArray3 = new ReplayContext[((CallHistoryEntry)object4).replayContext.length + replayContextArray2.length];
                        System.arraycopy(((CallHistoryEntry)object4).replayContext, 0, replayContextArray3, 0, ((CallHistoryEntry)object4).replayContext.length);
                        System.arraycopy(replayContextArray2, 0, replayContextArray3, ((CallHistoryEntry)object4).replayContext.length, replayContextArray2.length);
                        ((CallHistoryEntry)object4).replayContext = replayContextArray3;
                    }
                }
                ((CallHistoryEntry)object4).callException = sQLException;
                ((CallHistoryEntry)object4).queueId = n5;
                ((CallHistoryEntry)object4).queueEmptyCount = n6;
                ((CallHistoryEntry)object4).serverAsksToEnqueue = bl3;
                ((CallHistoryEntry)object4).callStatus = string;
                if (replayContextArray2 != null) {
                    for (ReplayContext replayContext : replayContextArray2) {
                        if (replayContext != null) continue;
                    }
                }
            }
            if (!this.isSessionStateConsistencyDynamic() && bl2) {
                object7 = ((TxnReplayableResultSet)((CallHistoryEntry)object4).jdbcProxy).creatorCallEntry;
                ((CallHistoryEntry)object7).queueEmptyCount = Integer.MAX_VALUE;
            }
        }
    }

    synchronized void purge() {
        CallHistoryEntry callHistoryEntry = this.head;
        while (callHistoryEntry != null) {
            this.remove(callHistoryEntry);
            callHistoryEntry = callHistoryEntry.nextEntry;
        }
    }

    synchronized void purgeForSameProxy(Set<Object> set, CallHistoryEntry callHistoryEntry) {
        Object object = callHistoryEntry == null ? null : callHistoryEntry.jdbcProxy;
        CallHistoryEntry callHistoryEntry2 = callHistoryEntry;
        while (callHistoryEntry2 != null) {
            Object object2 = callHistoryEntry2.result;
            if (object2 != null && object2 instanceof JDBCReplayable && !set.contains(object2)) {
                JDBCReplayable jDBCReplayable = (JDBCReplayable)object2;
                jDBCReplayable.purgeSameProxyList();
                set.add(jDBCReplayable);
            }
            this.remove(callHistoryEntry2);
            callHistoryEntry2 = callHistoryEntry2.nextEntrySameProxy;
        }
    }

    synchronized boolean isEmpty() {
        return this.head == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object handleOutage(Method method, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.callHittingOutage = method;
        TxnFailoverManagerImpl txnFailoverManagerImpl = this;
        synchronized (txnFailoverManagerImpl) {
            this.acStatistics.incrementTotalCallsAffectedByOutages();
            this.replayRetries = 0;
            do {
                ReplayLifecycle replayLifecycle;
                try {
                    return this.handleOutageInternal(sQLRecoverableException, this.replayRetries);
                }
                catch (SQLRecoverableException sQLRecoverableException2) {
                    replayLifecycle = this.lifecycle;
                    switch (replayLifecycle) {
                        case ENABLED_NOT_REPLAYING: 
                        case REPLAYING: 
                        case REPLAYING_CALLBACK: 
                        case REPLAYING_LASTCALL: {
                            ++this.replayRetries;
                            this.acStatistics.incrementTotalCallsAffectedByOutagesDuringReplay();
                            break;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    replayLifecycle = this.lifecycle;
                    switch (replayLifecycle) {
                        case INTERNALLY_FAILED: {
                            ++this.replayRetries;
                            this.lifecycle = ReplayLifecycle.REPLAYING;
                            break;
                        }
                        case REPLAYING_CALLBACK: {
                            ++this.replayRetries;
                            break;
                        }
                        case ALWAYS_DISABLED: 
                        case INTERNALLY_DISABLED: 
                        case EXTERNALLY_DISABLED: {
                            if (this.didReplayingLastCallDisableReplay) {
                                this.acStatistics.incrementSuccessfulReplayCount();
                                throw sQLException;
                            }
                            this.throwOriginalExceptionWithReplayError(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
                        }
                        case REPLAYING_LASTCALL: {
                            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
                            this.acStatistics.incrementSuccessfulReplayCount();
                            throw sQLException;
                        }
                    }
                }
            } while (this.replayRetries <= 3);
            this.disableReplayAndThrowOriginalError(null, 378, "Replay disabled because maximum number of retries is exceeded", sQLRecoverableException);
            return null;
        }
    }

    synchronized Object handleOutageInternal(SQLRecoverableException sQLRecoverableException, int n2) throws SQLException {
        this.acStatistics.incrementTotalReplayAttempts();
        this.didReplayingLastCallDisableReplay = false;
        ReplayLifecycle replayLifecycle = this.lifecycle;
        if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
            if (this.replayErrorCode == 0) {
                this.doNotAbortConn = true;
                this.replayErrorCode = 370;
                this.replayErrorMessage = "Replay disabled";
            }
            this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
        }
        if (this.lifecycle == ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.acStatistics.incrementTotalCallsTriggeringReplay();
        }
        if (n2 == 0) {
            this.originalOconn = (OracleConnection)this.connectionProxy.getDelegate();
        }
        short s2 = this.originalOconn.getExecutingRPCFunctionCode();
        if (!this.seenRoundtripCallInRequest && s2 == 0) {
            this.replayResult = this.replayWithLocalCallsOnly(sQLRecoverableException, n2);
        } else {
            OracleConnection oracleConnection;
            boolean bl = this.originalOconn.isProxySession();
            boolean bl2 = ((TxnReplayableConnection)this.connectionProxy).autoCommitBeforeOutage;
            OracleConnection oracleConnection2 = this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL && this.tail.replayContext != null && this.tail.replayContext.length != 0 ? (OracleConnection)this.connectionProxy.getDelegate() : this.originalOconn;
            s2 = oracleConnection2.getExecutingRPCFunctionCode();
            String string = oracleConnection2.getExecutingRPCSQL();
            ReplayContext replayContext = oracleConnection2.getLastReplayContext();
            if (replayContext != null) {
                this.cxtBeforePrepareReplay = replayContext;
            }
            if ((oracleConnection = (OracleConnection)this.replayDataSource.getConnectionNoProxy(((TxnReplayableConnection)this.connectionProxy).originalConnectionBuilder)) == null) {
                this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", sQLRecoverableException);
            }
            if (!this.checkACEnabled(oracleConnection)) {
                this.disableReplayAndThrowException(null, 369, "Replay disabled because it reconnected to AC-disabled instance", sQLRecoverableException);
            }
            this.connectionProxy.setDelegate(oracleConnection);
            oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
            this.oldLtxidForPrepareReplay = this.ltxid;
            if (bl) {
                this.invokeCallbackAfterReconnect(oracleConnection, sQLRecoverableException);
                this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
            }
            this.ltxid = oracleConnection.getLogicalTransactionId();
            oracleConnection.addLogicalTransactionIdEventListener(this);
            String string2 = this.tail.method.getName();
            oracleConnection.setReplayContext(new ReplayContext[]{this.cxtBeforePrepareReplay});
            boolean bl3 = this.prepareReplay(oracleConnection, sQLRecoverableException, bl2, s2, string);
            if (bl3) {
                if (this.isSessionStateConsistencyDynamic()) {
                    if (string2.equals("execute")) {
                        return false;
                    }
                    if (string2.equals("commit")) {
                        return null;
                    }
                    return null;
                }
                this.queueEmptyCounts[1] = this.queueEmptyCounts[1] + 1;
            }
            long l2 = System.currentTimeMillis();
            if (this.requestStartTime + this.replayInitiationTimeout * 1000L < l2) {
                this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", sQLRecoverableException);
            }
            oracleConnection.getReplayContext();
            if (!bl) {
                this.invokeCallbackAfterReconnect(oracleConnection, sQLRecoverableException);
            }
            this.lifecycle = ReplayLifecycle.REPLAYING;
            this.beginReplay(oracleConnection, sQLRecoverableException);
            this.replayResult = this.replayAllBeforeLastCall(sQLRecoverableException);
            if (this.tail.replayContext == null || this.tail.replayContext.length == 0) {
                this.endReplay(oracleConnection, sQLRecoverableException);
            } else {
                oracleConnection.registerEndReplayCallback(new EndReplayCallback(this, oracleConnection, sQLRecoverableException));
            }
            if (!bl3) {
                this.replayResult = this.replayLastCall(sQLRecoverableException);
            } else if (!this.isSessionStateConsistencyDynamic()) {
                this.tail.callStatus = "completed";
                this.tail.queueId = 1;
                this.tail.queueEmptyCount = this.queueEmptyCounts[1];
                this.tail.serverAsksToEnqueue = false;
                this.replayResult = string2.equals("execute") ? Boolean.valueOf(false) : (string2.equals("commit") ? null : null);
            }
        }
        if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        }
        this.acStatistics.incrementSuccessfulReplayCount();
        this.originalOconn = null;
        return this.replayResult;
    }

    synchronized Object replayWithLocalCallsOnly(SQLRecoverableException sQLRecoverableException, int n2) throws SQLException {
        boolean bl = this.originalOconn.isProxySession();
        OracleConnection oracleConnection = (OracleConnection)this.replayDataSource.getConnectionNoProxy(((TxnReplayableConnection)this.connectionProxy).originalConnectionBuilder);
        if (oracleConnection == null) {
            this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", sQLRecoverableException);
        }
        if (!this.checkACEnabled(oracleConnection)) {
            this.disableReplayAndThrowException(null, 369, "Replay disabled because it reconnected to AC-disabled instance", sQLRecoverableException);
        }
        this.connectionProxy.setDelegate(oracleConnection);
        oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
        if (bl) {
            this.invokeCallbackAfterReconnect(oracleConnection, sQLRecoverableException);
            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        }
        this.ltxid = oracleConnection.getLogicalTransactionId();
        oracleConnection.addLogicalTransactionIdEventListener(this);
        long l2 = System.currentTimeMillis();
        if (this.requestStartTime + this.replayInitiationTimeout * 1000L < l2) {
            this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", sQLRecoverableException);
        }
        if (!bl) {
            this.invokeCallbackAfterReconnect(oracleConnection, sQLRecoverableException);
        }
        oracleConnection.getReplayContext();
        if (this.isReplayInDynamicMode) {
            oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
        } else {
            oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
        }
        this.lifecycle = ReplayLifecycle.REPLAYING;
        this.replayResult = this.replayAllBeforeLastCall(sQLRecoverableException);
        this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
        this.replayResult = this.replayLastCall(sQLRecoverableException);
        return this.replayResult;
    }

    private void invokeCallbackAfterReconnect(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
        if (this.isStateRestorationEnabled) {
            this.restoreSavedSessionState(oracleConnection);
        } else {
            this.restoreAutoCommit(oracleConnection);
        }
        ConnectionInitializationCallback connectionInitializationCallback = this.replayDataSource.getConnectionInitializationCallback();
        if (connectionInitializationCallback != null) {
            try {
                connectionInitializationCallback.initialize((Connection)((Object)this.connectionProxy));
            }
            catch (SQLRecoverableException sQLRecoverableException2) {
                throw sQLRecoverableException2;
            }
            catch (SQLException sQLException) {
                this.disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", sQLRecoverableException);
            }
            EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
            if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                this.disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", sQLRecoverableException);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized Object replayAllBeforeLastCall(SQLRecoverableException var1_1) throws SQLException {
        var2_2 = null;
        var3_3 = this.head;
        while (var3_3 != this.tail) {
            var4_4 = var3_3.method == null ? "NULL METHOD" : var3_3.method.getName();
            var5_5 = (TxnReplayableBase)var3_3.jdbcProxy;
            var6_6 = var5_5.thisProxyNameInLog;
            if (this.isSessionStateConsistencyDynamic() && (var3_3.replayContext == null || var3_3.serverAsksToEnqueue)) ** GOTO lbl12
            if (this.isSessionStateConsistencyDynamic() || !var5_5.isCreatingCallReplayable) ** GOTO lbl-1000
            if (var3_3.replayContext == null && !TxnFailoverManagerImpl.postExecuteGetCalls.contains(var4_4) || var3_3.replayContext == null && TxnFailoverManagerImpl.postExecuteGetCalls.contains(var4_4) && var5_5.isCurrentExecuteReplayable || var3_3.serverAsksToEnqueue && var3_3.replayContext != null && var3_3.queueId >= 0 && var3_3.queueId < this.queueEmptyCounts.length && var3_3.queueEmptyCount == this.queueEmptyCounts[var3_3.queueId]) ** GOTO lbl12
            if (var3_3.queueEmptyCount == 0x7FFFFFFF) {
lbl12:
                // 3 sources

                var2_2 = var5_5.replayOneCall(var3_3, var1_1);
                if (!this.isSessionStateConsistencyDynamic() && var5_5 instanceof TxnReplayableStatement && var4_4.startsWith("execute")) {
                    var5_5.isCurrentExecuteReplayable = true;
                }
                if (!this.isSessionStateConsistencyDynamic() && var3_3.result != null && var3_3.result instanceof TxnReplayableBase) {
                    ((TxnReplayableBase)var3_3.result).isCreatingCallReplayable = true;
                }
                if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                    this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, var1_1);
                }
            } else lbl-1000:
            // 2 sources

            {
                if (!this.isSessionStateConsistencyDynamic() && var5_5 instanceof TxnReplayableStatement && var4_4.startsWith("execute")) {
                    var5_5.isCurrentExecuteReplayable = false;
                }
                if (!this.isSessionStateConsistencyDynamic() && var3_3.result != null && var3_3.result instanceof TxnReplayableBase) {
                    ((TxnReplayableBase)var3_3.result).isCreatingCallReplayable = false;
                }
                if (!this.isSessionStateConsistencyDynamic() && !var5_5.isCreatingCallReplayable && !"next".equals(var4_4) && var3_3.serverAsksToEnqueue && var3_3.replayContext != null && var3_3.queueId >= 0 && var3_3.queueId < this.queueEmptyCounts.length && var3_3.queueEmptyCount == this.queueEmptyCounts[var3_3.queueId]) {
                    this.disableReplayAndThrowException(var3_3.method, 399, "Replay disabled because server sent conflicting queueing instructions", var1_1);
                }
            }
            var3_3 = var3_3.nextEntry;
        }
        return var2_2;
    }

    private synchronized Object replayLastCall(SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object = null;
        if (this.tail != null) {
            CallHistoryEntry callHistoryEntry = this.tail;
            String string = callHistoryEntry.method == null ? NULL_METHOD_NAME : callHistoryEntry.method.getName();
            TxnReplayableBase txnReplayableBase = (TxnReplayableBase)callHistoryEntry.jdbcProxy;
            String string2 = txnReplayableBase.thisProxyNameInLog;
            if (this.isSessionStateConsistencyDynamic() && (callHistoryEntry.replayContext == null || callHistoryEntry.serverAsksToEnqueue) || !this.isSessionStateConsistencyDynamic() && txnReplayableBase.isCreatingCallReplayable && (callHistoryEntry.replayContext == null && !postExecuteGetCalls.contains(string) || callHistoryEntry.replayContext == null && postExecuteGetCalls.contains(string) && txnReplayableBase.isCurrentExecuteReplayable || callHistoryEntry.serverAsksToEnqueue && callHistoryEntry.replayContext != null && callHistoryEntry.queueId >= 0 && callHistoryEntry.queueId < this.queueEmptyCounts.length && callHistoryEntry.queueEmptyCount == this.queueEmptyCounts[callHistoryEntry.queueId] || callHistoryEntry.queueEmptyCount == Integer.MAX_VALUE)) {
                object = ((JDBCReplayable)this.tail.jdbcProxy).replayOneCall(this.tail, sQLRecoverableException);
            } else {
                this.disableReplayAndThrowException(this.tail.method, 372, "Replay disabled because of nonreplayable call", sQLRecoverableException);
            }
        }
        return object;
    }

    ReplayLifecycle getReplayLifecycle() {
        return this.lifecycle;
    }

    void setDataSource(OracleDataSource oracleDataSource) {
        this.replayDataSource = oracleDataSource;
    }

    void setReplayInitiationTimeout(int n2) throws SQLException {
        this.replayInitiationTimeout = n2;
    }

    boolean isSessionStateConsistencyDynamic() {
        return this.isReplayInDynamicMode;
    }

    void setSessionStateConsistency(boolean bl) throws SQLException {
        this.isReplayInDynamicMode = !bl;
    }

    void setSessionStateRestoration(boolean bl) throws SQLException {
        this.isStateRestorationEnabled = bl;
    }

    synchronized void beginRequest() throws SQLException {
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            return;
        }
        if (this.lifecycle == ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) {
            throw DatabaseError.createSqlException(391);
        }
        OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        if (this.isStateRestorationEnabled) {
            this.saveCurrentSessionState(oracleConnection);
        } else {
            this.saveAutoCommit(oracleConnection);
        }
        this.requestStartTime = System.currentTimeMillis();
        oracleConnection.getReplayContext();
        if (this.isReplayInDynamicMode) {
            oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
        } else {
            oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
        }
        EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
        if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            SQLException sQLException = DatabaseError.createSqlException(392);
            throw sQLException;
        }
        this.replayErrorCode = 0;
        this.replayErrorMessage = "";
        this.callCausingReplayError = null;
        this.seenRoundtripCallInRequest = false;
        this.callingDisableFromEndRequest = false;
        oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
        this.lobStreamInRequest = false;
        this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        this.acStatistics.incrementTotalRequests();
    }

    synchronized void endRequest() throws SQLException {
        boolean bl;
        OracleConnection oracleConnection;
        block13: {
            block12: {
                oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END));
                this.callingDisableFromEndRequest = true;
                bl = oracleConnection.isClosed();
                if (!bl) {
                    boolean bl2 = oracleConnection.getAutoCommit();
                    int n2 = oracleConnection.getTxnMode();
                    EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
                    if (!bl2 && n2 != 1 && enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                        try {
                            oracleConnection.rollback();
                        }
                        catch (SQLException sQLException) {
                        }
                        SQLException sQLException = DatabaseError.createSqlException(393);
                        throw sQLException;
                    }
                }
                this.acStatistics.incrementTotalCompletedRequests();
                this.lobStreamInRequest = false;
                if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                    if (!bl) {
                        oracleConnection.pingDatabase();
                    }
                    return;
                }
                if (this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED) break block12;
                if (this.lifecycle != ReplayLifecycle.EXTERNALLY_DISABLED) break block13;
            }
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            if (!bl) {
                oracleConnection.pingDatabase();
            }
            return;
        }
        this.disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
        if (!bl) {
            oracleConnection.pingDatabase();
        }
        this.callingDisableFromEndRequest = false;
    }

    void disableReplay() throws SQLException {
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            return;
        }
        this.disableReplayInternal(null, 370, "Replay disabled", null);
        this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
    }

    void disableReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        if (!this.callingDisableFromEndRequest) {
            this.acStatistics.incrementReplayDisablingCount();
        }
        ReplayLifecycle replayLifecycle = this.lifecycle;
        OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
        }
        this.purge();
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
        for (int i2 = 0; i2 < activeQueues; ++i2) {
            this.queueEmptyCounts[i2] = 0;
        }
        try {
            oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.NO_CHECKSUM);
            if (!this.seenRoundtripCallInRequest) {
                if (!this.isReplayInDynamicMode) {
                    oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
                } else {
                    oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN));
                }
            } else if (!this.isReplayInDynamicMode) {
                if (!this.callingDisableFromEndRequest) {
                    oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
                }
            } else {
                oracleConnection.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
            }
        }
        catch (SQLException sQLException) {
        }
    }

    void failReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        ReplayLifecycle replayLifecycle = this.lifecycle;
        if (this.lifecycle == ReplayLifecycle.REPLAYING || this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK || this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
        }
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
        this.originalOconn = null;
    }

    void throwReplayExceptionInternal(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        if (n2 == 0) {
            return;
        }
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        throw sQLException;
    }

    void disableReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void disableReplayAndThrowSQLException(Method method, int n2, String string, SQLException sQLException) throws SQLException {
        this.disableReplayInternal(method, n2, string, null);
        this.killConnectionBeforeReplayDisabledException();
        throw sQLException;
    }

    void disableReplayAndThrowOriginalError(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwOriginalExceptionWithReplayError(n2, string, sQLRecoverableException);
    }

    void failReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.failReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void throwOriginalExceptionWithReplayError(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLRecoverableException {
        if (!this.doNotAbortConn) {
            this.killConnectionBeforeReplayDisabledException();
        }
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        sQLRecoverableException.setNextException(sQLException);
        this.acStatistics.incrementFailedReplayCount();
        this.originalOconn = null;
        assert (this.callHittingOutage != null) : "Failed-call Method object is null";
        throw sQLRecoverableException;
    }

    void killConnectionBeforeReplayDisabledException() {
        final OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        try {
            oracleConnection.abort();
        }
        catch (SQLException sQLException) {
        }
        try {
            executor.submit(new Runnable(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    TxnFailoverManagerImpl.this.closePhysicalConnection(oracleConnection);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredConstructor(TxnFailoverManagerImpl.class, OracleConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
        }
        catch (Exception exception) {
        }
    }

    void enableTxnMonitoring(OracleConnection oracleConnection) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(MONITOR_TXN);
            statement.close();
        }
        catch (SQLException sQLException) {
            this.disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
            this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
            throw DatabaseError.createSqlException(395);
        }
    }

    void beginReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(BEGIN_REPLAY);
            statement.close();
            oracleConnection.setReplayingMode(true);
            this.lifecycle = ReplayLifecycle.REPLAYING;
        }
        catch (SQLRecoverableException sQLRecoverableException2) {
            throw sQLRecoverableException2;
        }
        catch (SQLException sQLException) {
            this.disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", sQLRecoverableException);
        }
    }

    void endReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(END_REPLAY);
            statement.close();
            oracleConnection.setReplayingMode(false);
            oracleConnection.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
            if (!this.isReplayInDynamicMode) {
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            } else {
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            }
            oracleConnection.getReplayContext();
            this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
        }
        catch (SQLRecoverableException sQLRecoverableException2) {
            throw sQLRecoverableException2;
        }
        catch (SQLException sQLException) {
            this.disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", sQLRecoverableException);
        }
    }

    boolean prepareReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException, boolean bl, short s2, String string) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            if (!this.isReplayInDynamicMode) {
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
            }
            CallableStatement callableStatement = oracleConnection.prepareCall(PREPARE_REPLAY);
            callableStatement.setObject(1, (Object)this.oldLtxidForPrepareReplay);
            callableStatement.setInt(2, this.seenRoundtripCallInRequest ? 1 : 0);
            callableStatement.setInt(3, bl ? 1 : 0);
            callableStatement.setInt(4, (int)s2);
            callableStatement.setString(5, string);
            callableStatement.registerOutParameter(6, -7);
            callableStatement.registerOutParameter(7, -7);
            callableStatement.execute();
            bl2 = callableStatement.getBoolean(6);
            bl3 = callableStatement.getBoolean(7);
            callableStatement.close();
        }
        catch (SQLRecoverableException sQLRecoverableException2) {
            throw sQLRecoverableException2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.disableReplayAndThrowException(null, 385, "Replay disabled because server prepare_replay call failed", sQLRecoverableException);
        }
        if (!bl3) {
            return bl2;
        }
        this.disableReplayAndThrowException(null, 386, "Replay disabled because of embedded commit", sQLRecoverableException);
        return false;
    }

    JDBCReplayable getConnectionProxy() {
        return this.connectionProxy;
    }

    private boolean isReplayFailure(SQLException sQLException) {
        int n2;
        boolean bl = false;
        if (sQLException instanceof SQLException && (n2 = sQLException.getErrorCode()) >= 370 && n2 < 400) {
            bl = true;
        }
        return bl;
    }

    private void closePhysicalConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
        }
    }

    LogicalTransactionId getLogicalTransactionId() {
        return this.ltxid;
    }

    void setLogicalTransactionId(LogicalTransactionId logicalTransactionId) {
        this.ltxid = logicalTransactionId;
    }

    @Override
    public void onLogicalTransactionIdEvent(LogicalTransactionIdEvent logicalTransactionIdEvent) {
        LogicalTransactionId logicalTransactionId = logicalTransactionIdEvent.getLogicalTransactionId();
        this.setLogicalTransactionId(logicalTransactionId);
    }

    ReplayContext[] getReplayContext() {
        return this.replayContext;
    }

    void setReplayContext(ReplayContext[] replayContextArray) {
        this.replayContext = replayContextArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActiveQueues(int n2) {
        int n3;
        int n4 = (n2 + 1 - this.queueEmptyCounts.length) / 2 * 2;
        int n5 = this.queueEmptyCounts.length + n4;
        int[] nArray = new int[n5];
        System.arraycopy(this.queueEmptyCounts, 0, nArray, 0, this.queueEmptyCounts.length);
        for (n3 = this.queueEmptyCounts.length; n3 <= n2; ++n3) {
            nArray[n3] = 0;
        }
        for (n3 = n2 + 1; n3 <= n5; ++n3) {
            nArray[n3] = 0;
        }
        TxnFailoverManagerImpl txnFailoverManagerImpl = this;
        synchronized (txnFailoverManagerImpl) {
            this.queueEmptyCounts = nArray;
            activeQueues = n5;
        }
    }

    ReplayStatistics getReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        ReplayStatistics replayStatistics = null;
        switch (statisticsReportType) {
            case FOR_CURRENT_CONNECTION: {
                replayStatistics = this.acStatistics;
                break;
            }
            case FOR_ALL_CONNECTIONS: {
                replayStatistics = this.replayDataSource.getReplayStatistics();
            }
        }
        return replayStatistics;
    }

    void clearReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        switch (statisticsReportType) {
            case FOR_CURRENT_CONNECTION: {
                this.acStatistics.clear();
                break;
            }
            case FOR_ALL_CONNECTIONS: {
                this.replayDataSource.clearReplayStatistics();
            }
        }
    }

    protected ProxyFactory getProxyFactory() throws SQLException {
        return this.replayDataSource.getProxyFactory();
    }

    boolean isLobStreamInRequest() {
        return this.lobStreamInRequest;
    }

    void setLobStreamInRequest(boolean bl) {
        this.lobStreamInRequest = bl;
    }

    void saveAutoCommit(OracleConnection oracleConnection) throws SQLException {
        this.savedAutoCommit = oracleConnection.getAutoCommit();
    }

    void saveCurrentSessionState(OracleConnection oracleConnection) throws SQLException {
        this.savedSessionProps = oracleConnection.getServerSessionInfo();
        this.savedClientInfo = oracleConnection.getClientInfo();
        this.savedCurrentSchema = oracleConnection.getCurrentSchema();
        this.saveAutoCommit(oracleConnection);
    }

    void restoreAutoCommit(OracleConnection oracleConnection) throws SQLException {
        if (!this.savedAutoCommit) {
            oracleConnection.setAutoCommit(this.savedAutoCommit);
        }
    }

    void restoreSavedSessionState(OracleConnection oracleConnection) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("ALTER SESSION SET").append(" NLS_CALENDAR = '").append(this.savedSessionProps.get(NLS_CALENDAR_PROPERTY)).append("'").append(" NLS_CURRENCY = '").append(this.savedSessionProps.get(NLS_CURRENCY_PROPERTY)).append("'").append(" NLS_DATE_FORMAT = '").append(this.savedSessionProps.get(NLS_DATE_FORMAT_PROPERTY)).append("'").append(" NLS_DATE_LANGUAGE = '").append(this.savedSessionProps.get(NLS_DATE_LANGUAGE_PROPERTY)).append("'").append(" NLS_DUAL_CURRENCY = '").append(this.savedSessionProps.get(NLS_DUAL_CURRENCY_PROPERTY)).append("'").append(" NLS_ISO_CURRENCY = '").append(this.savedSessionProps.get(NLS_ISO_CURRENCY_PROPERTY)).append("'").append(" NLS_LANGUAGE = '").append(this.savedSessionProps.get(NLS_LANGUAGE_PROPERTY)).append("'").append(" NLS_LENGTH_SEMANTICS = '").append(this.savedSessionProps.get(NLS_LENGTH_SEMANTICS_PROPERTY)).append("'").append(" NLS_NCHAR_CONV_EXCP = '").append(this.savedSessionProps.get(NLS_NCHAR_CONV_EXCP_PROPERTY)).append("'").append(" NLS_NUMERIC_CHARACTERS = '").append(this.savedSessionProps.get(NLS_NUMERIC_CHARACTERS_PROPERTY)).append("'").append(" NLS_SORT = '").append(this.savedSessionProps.get(NLS_SORT_PROPERTY)).append("'").append(" NLS_TERRITORY = '").append(this.savedSessionProps.get(NLS_TERRITORY_PROPERTY)).append("'").append(" NLS_TIME_FORMAT = '").append(this.savedSessionProps.get(NLS_TIME_FORMAT_PROPERTY)).append("'").append(" NLS_TIME_TZ_FORMAT = '").append(this.savedSessionProps.get(NLS_TIME_TZ_FORMAT_PROPERTY)).append("'").append(" NLS_TIMESTAMP_FORMAT = '").append(this.savedSessionProps.get(NLS_TIMESTAMP_FORMAT_PROPERTY)).append("'").append(" NLS_TIMESTAMP_TZ_FORMAT = '").append(this.savedSessionProps.get(NLS_TIMESTAMP_TZ_FORMAT_PROPERTY)).append("'");
        if (!this.savedCurrentSchema.equals(oracleConnection.getCurrentSchema())) {
            stringBuilder.append(" CURRENT_SCHEMA = ").append(this.savedCurrentSchema);
        }
        String string = stringBuilder.toString();
        try (Statement statement = oracleConnection.createStatement();){
            statement.execute(string);
        }
        oracleConnection.setClientInfo(this.savedClientInfo);
        this.restoreAutoCommit(oracleConnection);
    }

    private boolean checkACEnabled(OracleConnection oracleConnection) throws SQLException {
        Properties properties = oracleConnection.getServerSessionInfo();
        String string = properties.getProperty(FAILOVER_TYPE_PROPERTY);
        if (string != null && !"".equals(string)) {
            int n2;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            return (n2 & 8) == 8 && this.isReplayInDynamicMode == ((n2 & 0x10) == 0);
        }
        return false;
    }

    static {
        try {
            $$$methodRef$$$57 = TxnFailoverManagerImpl.class.getDeclaredConstructor(TxnReplayableBase.class, OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$56 = TxnFailoverManagerImpl.class.getDeclaredMethod("access$000", TxnFailoverManagerImpl.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$55 = TxnFailoverManagerImpl.class.getDeclaredMethod("checkACEnabled", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$54 = TxnFailoverManagerImpl.class.getDeclaredMethod("restoreSavedSessionState", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$53 = TxnFailoverManagerImpl.class.getDeclaredMethod("restoreAutoCommit", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$52 = TxnFailoverManagerImpl.class.getDeclaredMethod("saveCurrentSessionState", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$51 = TxnFailoverManagerImpl.class.getDeclaredMethod("saveAutoCommit", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$50 = TxnFailoverManagerImpl.class.getDeclaredMethod("setLobStreamInRequest", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$49 = TxnFailoverManagerImpl.class.getDeclaredMethod("isLobStreamInRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$48 = TxnFailoverManagerImpl.class.getDeclaredMethod("getProxyFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$47 = TxnFailoverManagerImpl.class.getDeclaredMethod("clearReplayStatistics", ReplayableConnection.StatisticsReportType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$46 = TxnFailoverManagerImpl.class.getDeclaredMethod("getReplayStatistics", ReplayableConnection.StatisticsReportType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$45 = TxnFailoverManagerImpl.class.getDeclaredMethod("addActiveQueues", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$44 = TxnFailoverManagerImpl.class.getDeclaredMethod("setReplayContext", ReplayContext[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$43 = TxnFailoverManagerImpl.class.getDeclaredMethod("getReplayContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$42 = TxnFailoverManagerImpl.class.getDeclaredMethod("onLogicalTransactionIdEvent", LogicalTransactionIdEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$41 = TxnFailoverManagerImpl.class.getDeclaredMethod("setLogicalTransactionId", LogicalTransactionId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$40 = TxnFailoverManagerImpl.class.getDeclaredMethod("getLogicalTransactionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$39 = TxnFailoverManagerImpl.class.getDeclaredMethod("closePhysicalConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$38 = TxnFailoverManagerImpl.class.getDeclaredMethod("isReplayFailure", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$37 = TxnFailoverManagerImpl.class.getDeclaredMethod("getConnectionProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$36 = TxnFailoverManagerImpl.class.getDeclaredMethod("prepareReplay", OracleConnection.class, SQLRecoverableException.class, Boolean.TYPE, Short.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$35 = TxnFailoverManagerImpl.class.getDeclaredMethod("endReplay", OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$34 = TxnFailoverManagerImpl.class.getDeclaredMethod("beginReplay", OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$33 = TxnFailoverManagerImpl.class.getDeclaredMethod("enableTxnMonitoring", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$32 = TxnFailoverManagerImpl.class.getDeclaredMethod("killConnectionBeforeReplayDisabledException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$31 = TxnFailoverManagerImpl.class.getDeclaredMethod("throwOriginalExceptionWithReplayError", Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$30 = TxnFailoverManagerImpl.class.getDeclaredMethod("failReplayAndThrowException", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$29 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowOriginalError", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$28 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowSQLException", Method.class, Integer.TYPE, String.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$27 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowException", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = TxnFailoverManagerImpl.class.getDeclaredMethod("throwReplayExceptionInternal", Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = TxnFailoverManagerImpl.class.getDeclaredMethod("failReplayInternal", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayInternal", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = TxnFailoverManagerImpl.class.getDeclaredMethod("endRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = TxnFailoverManagerImpl.class.getDeclaredMethod("beginRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = TxnFailoverManagerImpl.class.getDeclaredMethod("setSessionStateRestoration", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = TxnFailoverManagerImpl.class.getDeclaredMethod("setSessionStateConsistency", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = TxnFailoverManagerImpl.class.getDeclaredMethod("isSessionStateConsistencyDynamic", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnFailoverManagerImpl.class.getDeclaredMethod("setReplayInitiationTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnFailoverManagerImpl.class.getDeclaredMethod("setDataSource", OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnFailoverManagerImpl.class.getDeclaredMethod("getReplayLifecycle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnFailoverManagerImpl.class.getDeclaredMethod("replayLastCall", SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnFailoverManagerImpl.class.getDeclaredMethod("replayAllBeforeLastCall", SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnFailoverManagerImpl.class.getDeclaredMethod("invokeCallbackAfterReconnect", OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnFailoverManagerImpl.class.getDeclaredMethod("replayWithLocalCallsOnly", SQLRecoverableException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnFailoverManagerImpl.class.getDeclaredMethod("handleOutageInternal", SQLRecoverableException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnFailoverManagerImpl.class.getDeclaredMethod("handleOutage", Method.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnFailoverManagerImpl.class.getDeclaredMethod("isEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnFailoverManagerImpl.class.getDeclaredMethod("purgeForSameProxy", Set.class, CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnFailoverManagerImpl.class.getDeclaredMethod("purge", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnFailoverManagerImpl.class.getDeclaredMethod("update", Object.class, CallHistoryEntry.class, Object.class, String.class, Long.TYPE, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnFailoverManagerImpl.class.getDeclaredMethod("dumpHistory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnFailoverManagerImpl.class.getDeclaredMethod("record", Object.class, Method.class, Object[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnFailoverManagerImpl.class.getDeclaredMethod("remove", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnFailoverManagerImpl.class.getDeclaredMethod("append", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnFailoverManagerImpl.class.getDeclaredMethod("getFailoverManager", TxnReplayableBase.class, OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        activeQueues = 2;
        postExecuteGetCalls = new HashSet<String>(Arrays.asList("getGeneratedKeys", "getMoreResults", "getResultSet", "getUpdateCount", "getMetaData", "getArray", "getBigDecimal", "getBlob", "getBoolean", "getByte", "getBytes", "getCharacterStream", "getClob", "getDate", "getDouble", "getFloat", "getInt", "getLong", "getNCharacterStream", "getNClob", "getNString", "getObject", "getRef", "getRowId", "getShort", "getSQLXML", "getString", "getTime", "getTimestamp", "getURL", "wasNull", "getReturnResultSet", "getARRAY", "getAsciiStream", "getBFILE", "getBfile", "getBinaryStream", "getBLOB", "getCHAR", "getCLOB", "getCursor", "getCustomDatum", "getORAData", "getAnyDataEmbeddedObject", "getDATE", "getNUMBER", "getOPAQUE", "getOracleObject", "getRAW", "getREF", "getROWID", "getSTRUCT", "getINTERVALYM", "getINTERVALDS", "getTIMESTAMP", "getTIMESTAMPTZ", "getTIMESTAMPLTZ", "getUnicodeStream", "getPlsqlIndexTable", "getOraclePlsqlIndexTable"));
        executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(null, runnable, THREAD_NAME);
                thread.setPriority(5);
                thread.setDaemon(true);
                return thread;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("newThread", Runnable.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
    }

    static final class ReplayLifecycle
    extends Enum<ReplayLifecycle> {
        public static final /* enum */ ReplayLifecycle ENABLED_NOT_REPLAYING;
        public static final /* enum */ ReplayLifecycle INTERNALLY_FAILED;
        public static final /* enum */ ReplayLifecycle INTERNALLY_DISABLED;
        public static final /* enum */ ReplayLifecycle ALWAYS_DISABLED;
        public static final /* enum */ ReplayLifecycle EXTERNALLY_DISABLED;
        public static final /* enum */ ReplayLifecycle REPLAYING_CALLBACK;
        public static final /* enum */ ReplayLifecycle REPLAYING;
        public static final /* enum */ ReplayLifecycle REPLAYING_LASTCALL;
        private static final /* synthetic */ ReplayLifecycle[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static ReplayLifecycle[] values() {
            return (ReplayLifecycle[])$VALUES.clone();
        }

        public static ReplayLifecycle valueOf(String string) {
            return Enum.valueOf(ReplayLifecycle.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = ReplayLifecycle.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ReplayLifecycle.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ReplayLifecycle.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            ENABLED_NOT_REPLAYING = new ReplayLifecycle();
            INTERNALLY_FAILED = new ReplayLifecycle();
            INTERNALLY_DISABLED = new ReplayLifecycle();
            ALWAYS_DISABLED = new ReplayLifecycle();
            EXTERNALLY_DISABLED = new ReplayLifecycle();
            REPLAYING_CALLBACK = new ReplayLifecycle();
            REPLAYING = new ReplayLifecycle();
            REPLAYING_LASTCALL = new ReplayLifecycle();
            $VALUES = new ReplayLifecycle[]{ENABLED_NOT_REPLAYING, INTERNALLY_FAILED, INTERNALLY_DISABLED, ALWAYS_DISABLED, EXTERNALLY_DISABLED, REPLAYING_CALLBACK, REPLAYING, REPLAYING_LASTCALL};
        }
    }

    static class CallHistoryEntry {
        Object jdbcProxy;
        Method method;
        Object[] args;
        Object result;
        String callStatus;
        long checksum;
        boolean openAcrossPurge;
        int queueId;
        int queueEmptyCount;
        ReplayContext[] replayContext;
        boolean serverAsksToEnqueue;
        SQLException callException;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        CallHistoryEntry nextEntrySameProxy = null;
        CallHistoryEntry prevEntrySameProxy = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        CallHistoryEntry(Object object, Method method, Object[] objectArray, String string) {
            this.jdbcProxy = object;
            this.method = method;
            this.args = objectArray;
            this.result = null;
            this.callStatus = string;
            this.openAcrossPurge = false;
        }

        @DisableTrace
        public String toString() {
            String string = "CallHistoryEntry: method.getName()=" + this.method.getName() + ", queueId=" + this.queueId + ", queueEmptyCount=" + this.queueEmptyCount + ", serverAsksToEnqueue=" + this.serverAsksToEnqueue + ", replayContext=" + this.replayContext;
            if (this.replayContext != null) {
                for (int i2 = 0; i2 < this.replayContext.length; ++i2) {
                    string = string + this.replayContext[i2];
                }
            }
            return string + "\n";
        }

        static {
            try {
                $$$methodRef$$$0 = CallHistoryEntry.class.getDeclaredConstructor(Object.class, Method.class, Object[].class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

