/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy._Proxy_;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OldUpdatableResultSet
extends OracleResultSet {
    protected static final int MAX_CHAR_BUFFER_SIZE = 1024;
    protected static final int MAX_BYTE_BUFFER_SIZE = 1024;
    protected static final int ASCII_STREAM = 1;
    protected static final int BINARY_STREAM = 2;
    protected static final int UNICODE_STREAM = 3;
    protected static final int VALUE_NULL = 1;
    protected static final int VALUE_NOT_NULL = 2;
    protected static final int VALUE_UNKNOWN = 3;
    protected static final int VALUE_IN_RSET = 4;
    static final int concurrencyType = 1008;
    static final int BEGIN_COLUMN_INDEX = 0;
    private int wasNull;
    private static int _MIN_STREAM_SIZE;
    OracleResultSet resultSet;
    boolean isRowDeleted = false;
    boolean isCachedRset;
    OracleStatement scrollStmt;
    ResultSetMetaData rsetMetaData;
    private int columnCount;
    private OraclePreparedStatement deleteStmt;
    private OraclePreparedStatement insertStmt;
    private OraclePreparedStatement updateStmt;
    private int[] indexColsChanged;
    private Object[] rowBuffer;
    private boolean[] m_nullIndicator;
    private int[][] typeInfo;
    private boolean isInserting;
    private boolean isUpdating;
    ArrayList tempClobsToFree = null;
    ArrayList tempBlobsToFree = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;
    private static Executable $$$methodRef$$$95;
    private static Logger $$$loggerRef$$$95;
    private static Executable $$$methodRef$$$96;
    private static Logger $$$loggerRef$$$96;
    private static Executable $$$methodRef$$$97;
    private static Logger $$$loggerRef$$$97;
    private static Executable $$$methodRef$$$98;
    private static Logger $$$loggerRef$$$98;
    private static Executable $$$methodRef$$$99;
    private static Logger $$$loggerRef$$$99;
    private static Executable $$$methodRef$$$100;
    private static Logger $$$loggerRef$$$100;
    private static Executable $$$methodRef$$$101;
    private static Logger $$$loggerRef$$$101;
    private static Executable $$$methodRef$$$102;
    private static Logger $$$loggerRef$$$102;
    private static Executable $$$methodRef$$$103;
    private static Logger $$$loggerRef$$$103;
    private static Executable $$$methodRef$$$104;
    private static Logger $$$loggerRef$$$104;
    private static Executable $$$methodRef$$$105;
    private static Logger $$$loggerRef$$$105;
    private static Executable $$$methodRef$$$106;
    private static Logger $$$loggerRef$$$106;
    private static Executable $$$methodRef$$$107;
    private static Logger $$$loggerRef$$$107;
    private static Executable $$$methodRef$$$108;
    private static Logger $$$loggerRef$$$108;
    private static Executable $$$methodRef$$$109;
    private static Logger $$$loggerRef$$$109;
    private static Executable $$$methodRef$$$110;
    private static Logger $$$loggerRef$$$110;
    private static Executable $$$methodRef$$$111;
    private static Logger $$$loggerRef$$$111;
    private static Executable $$$methodRef$$$112;
    private static Logger $$$loggerRef$$$112;
    private static Executable $$$methodRef$$$113;
    private static Logger $$$loggerRef$$$113;
    private static Executable $$$methodRef$$$114;
    private static Logger $$$loggerRef$$$114;
    private static Executable $$$methodRef$$$115;
    private static Logger $$$loggerRef$$$115;
    private static Executable $$$methodRef$$$116;
    private static Logger $$$loggerRef$$$116;
    private static Executable $$$methodRef$$$117;
    private static Logger $$$loggerRef$$$117;
    private static Executable $$$methodRef$$$118;
    private static Logger $$$loggerRef$$$118;
    private static Executable $$$methodRef$$$119;
    private static Logger $$$loggerRef$$$119;
    private static Executable $$$methodRef$$$120;
    private static Logger $$$loggerRef$$$120;
    private static Executable $$$methodRef$$$121;
    private static Logger $$$loggerRef$$$121;
    private static Executable $$$methodRef$$$122;
    private static Logger $$$loggerRef$$$122;
    private static Executable $$$methodRef$$$123;
    private static Logger $$$loggerRef$$$123;
    private static Executable $$$methodRef$$$124;
    private static Logger $$$loggerRef$$$124;
    private static Executable $$$methodRef$$$125;
    private static Logger $$$loggerRef$$$125;
    private static Executable $$$methodRef$$$126;
    private static Logger $$$loggerRef$$$126;
    private static Executable $$$methodRef$$$127;
    private static Logger $$$loggerRef$$$127;
    private static Executable $$$methodRef$$$128;
    private static Logger $$$loggerRef$$$128;
    private static Executable $$$methodRef$$$129;
    private static Logger $$$loggerRef$$$129;
    private static Executable $$$methodRef$$$130;
    private static Logger $$$loggerRef$$$130;
    private static Executable $$$methodRef$$$131;
    private static Logger $$$loggerRef$$$131;
    private static Executable $$$methodRef$$$132;
    private static Logger $$$loggerRef$$$132;
    private static Executable $$$methodRef$$$133;
    private static Logger $$$loggerRef$$$133;
    private static Executable $$$methodRef$$$134;
    private static Logger $$$loggerRef$$$134;
    private static Executable $$$methodRef$$$135;
    private static Logger $$$loggerRef$$$135;
    private static Executable $$$methodRef$$$136;
    private static Logger $$$loggerRef$$$136;
    private static Executable $$$methodRef$$$137;
    private static Logger $$$loggerRef$$$137;
    private static Executable $$$methodRef$$$138;
    private static Logger $$$loggerRef$$$138;
    private static Executable $$$methodRef$$$139;
    private static Logger $$$loggerRef$$$139;
    private static Executable $$$methodRef$$$140;
    private static Logger $$$loggerRef$$$140;
    private static Executable $$$methodRef$$$141;
    private static Logger $$$loggerRef$$$141;
    private static Executable $$$methodRef$$$142;
    private static Logger $$$loggerRef$$$142;
    private static Executable $$$methodRef$$$143;
    private static Logger $$$loggerRef$$$143;
    private static Executable $$$methodRef$$$144;
    private static Logger $$$loggerRef$$$144;
    private static Executable $$$methodRef$$$145;
    private static Logger $$$loggerRef$$$145;
    private static Executable $$$methodRef$$$146;
    private static Logger $$$loggerRef$$$146;
    private static Executable $$$methodRef$$$147;
    private static Logger $$$loggerRef$$$147;
    private static Executable $$$methodRef$$$148;
    private static Logger $$$loggerRef$$$148;
    private static Executable $$$methodRef$$$149;
    private static Logger $$$loggerRef$$$149;
    private static Executable $$$methodRef$$$150;
    private static Logger $$$loggerRef$$$150;
    private static Executable $$$methodRef$$$151;
    private static Logger $$$loggerRef$$$151;
    private static Executable $$$methodRef$$$152;
    private static Logger $$$loggerRef$$$152;
    private static Executable $$$methodRef$$$153;
    private static Logger $$$loggerRef$$$153;
    private static Executable $$$methodRef$$$154;
    private static Logger $$$loggerRef$$$154;
    private static Executable $$$methodRef$$$155;
    private static Logger $$$loggerRef$$$155;
    private static Executable $$$methodRef$$$156;
    private static Logger $$$loggerRef$$$156;
    private static Executable $$$methodRef$$$157;
    private static Logger $$$loggerRef$$$157;
    private static Executable $$$methodRef$$$158;
    private static Logger $$$loggerRef$$$158;
    private static Executable $$$methodRef$$$159;
    private static Logger $$$loggerRef$$$159;
    private static Executable $$$methodRef$$$160;
    private static Logger $$$loggerRef$$$160;
    private static Executable $$$methodRef$$$161;
    private static Logger $$$loggerRef$$$161;
    private static Executable $$$methodRef$$$162;
    private static Logger $$$loggerRef$$$162;
    private static Executable $$$methodRef$$$163;
    private static Logger $$$loggerRef$$$163;
    private static Executable $$$methodRef$$$164;
    private static Logger $$$loggerRef$$$164;
    private static Executable $$$methodRef$$$165;
    private static Logger $$$loggerRef$$$165;
    private static Executable $$$methodRef$$$166;
    private static Logger $$$loggerRef$$$166;
    private static Executable $$$methodRef$$$167;
    private static Logger $$$loggerRef$$$167;
    private static Executable $$$methodRef$$$168;
    private static Logger $$$loggerRef$$$168;
    private static Executable $$$methodRef$$$169;
    private static Logger $$$loggerRef$$$169;
    private static Executable $$$methodRef$$$170;
    private static Logger $$$loggerRef$$$170;
    private static Executable $$$methodRef$$$171;
    private static Logger $$$loggerRef$$$171;
    private static Executable $$$methodRef$$$172;
    private static Logger $$$loggerRef$$$172;
    private static Executable $$$methodRef$$$173;
    private static Logger $$$loggerRef$$$173;
    private static Executable $$$methodRef$$$174;
    private static Logger $$$loggerRef$$$174;
    private static Executable $$$methodRef$$$175;
    private static Logger $$$loggerRef$$$175;
    private static Executable $$$methodRef$$$176;
    private static Logger $$$loggerRef$$$176;
    private static Executable $$$methodRef$$$177;
    private static Logger $$$loggerRef$$$177;
    private static Executable $$$methodRef$$$178;
    private static Logger $$$loggerRef$$$178;
    private static Executable $$$methodRef$$$179;
    private static Logger $$$loggerRef$$$179;
    private static Executable $$$methodRef$$$180;
    private static Logger $$$loggerRef$$$180;
    private static Executable $$$methodRef$$$181;
    private static Logger $$$loggerRef$$$181;
    private static Executable $$$methodRef$$$182;
    private static Logger $$$loggerRef$$$182;
    private static Executable $$$methodRef$$$183;
    private static Logger $$$loggerRef$$$183;
    private static Executable $$$methodRef$$$184;
    private static Logger $$$loggerRef$$$184;
    private static Executable $$$methodRef$$$185;
    private static Logger $$$loggerRef$$$185;
    private static Executable $$$methodRef$$$186;
    private static Logger $$$loggerRef$$$186;
    private static Executable $$$methodRef$$$187;
    private static Logger $$$loggerRef$$$187;
    private static Executable $$$methodRef$$$188;
    private static Logger $$$loggerRef$$$188;
    private static Executable $$$methodRef$$$189;
    private static Logger $$$loggerRef$$$189;
    private static Executable $$$methodRef$$$190;
    private static Logger $$$loggerRef$$$190;
    private static Executable $$$methodRef$$$191;
    private static Logger $$$loggerRef$$$191;
    private static Executable $$$methodRef$$$192;
    private static Logger $$$loggerRef$$$192;
    private static Executable $$$methodRef$$$193;
    private static Logger $$$loggerRef$$$193;
    private static Executable $$$methodRef$$$194;
    private static Logger $$$loggerRef$$$194;
    private static Executable $$$methodRef$$$195;
    private static Logger $$$loggerRef$$$195;
    private static Executable $$$methodRef$$$196;
    private static Logger $$$loggerRef$$$196;
    private static Executable $$$methodRef$$$197;
    private static Logger $$$loggerRef$$$197;
    private static Executable $$$methodRef$$$198;
    private static Logger $$$loggerRef$$$198;
    private static Executable $$$methodRef$$$199;
    private static Logger $$$loggerRef$$$199;
    private static Executable $$$methodRef$$$200;
    private static Logger $$$loggerRef$$$200;
    private static Executable $$$methodRef$$$201;
    private static Logger $$$loggerRef$$$201;

    OldUpdatableResultSet(OracleStatement oracleStatement, OracleResultSet oracleResultSet) throws SQLException {
        super(oracleStatement.connection);
        this.resultSet = oracleResultSet;
        this.scrollStmt = oracleStatement;
        this.deleteStmt = null;
        this.insertStmt = null;
        this.updateStmt = null;
        this.indexColsChanged = null;
        this.rowBuffer = null;
        this.m_nullIndicator = null;
        this.typeInfo = null;
        this.isInserting = false;
        this.isUpdating = false;
        this.wasNull = -1;
        this.rsetMetaData = null;
        this.columnCount = 0;
        this.getInternalMetadata();
        this.isCachedRset = true;
    }

    void ensureOpen() throws SQLException {
        if (this.closed) {
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
        }
        if (this.resultSet == null || this.scrollStmt == null || this.scrollStmt.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.close();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.insertStmt != null) {
                this.insertStmt.close();
            }
            if (this.updateStmt != null) {
                this.updateStmt.close();
            }
            if (this.deleteStmt != null) {
                this.deleteStmt.close();
            }
            if (this.scrollStmt != null) {
                this.scrollStmt.notifyCloseRset();
            }
            this.cancelRowInserts();
            this.connection = LogicalConnection.closedConnection;
            this.resultSet = null;
            this.scrollStmt = null;
            this.rsetMetaData = null;
            this.scrollStmt = null;
            this.deleteStmt = null;
            this.insertStmt = null;
            this.updateStmt = null;
            this.indexColsChanged = null;
            this.rowBuffer = null;
            this.m_nullIndicator = null;
            this.typeInfo = null;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            switch (this.wasNull) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 4: {
                    return this.resultSet.wasNull();
                }
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24).fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.scrollStmt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            SQLWarning sQLWarning = this.resultSet.getWarnings();
            if (this.sqlWarning == null) {
                return sQLWarning;
            }
            SQLWarning sQLWarning2 = this.sqlWarning;
            while (sQLWarning2.getNextWarning() != null) {
                sQLWarning2 = sQLWarning2.getNextWarning();
            }
            sQLWarning2.setNextWarning(sQLWarning);
            return this.sqlWarning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.sqlWarning = null;
            this.resultSet.clearWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.resultSet.getAuthorizationIndicator(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            if (this.isRowDeleted) {
                this.isRowDeleted = false;
                return this.resultSet.isValidRow();
            }
            return this.resultSet.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                return this.resultSet.isFirst();
            }
            return this.resultSet.isBeforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.isAfterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.resultSet.isFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.resultSet.isLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            this.resultSet.beforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            this.resultSet.afterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.last();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.resultSet.getRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.absolute(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            if (this.isRowDeleted) {
                --n2;
                this.isRowDeleted = false;
            }
            return this.resultSet.relative(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.previous();
        }
    }

    void addToTempLobsToFree(Clob clob) {
        if (this.tempClobsToFree == null) {
            this.tempClobsToFree = new ArrayList();
        }
        this.tempClobsToFree.add(clob);
    }

    void addToTempLobsToFree(Blob blob) {
        if (this.tempBlobsToFree == null) {
            this.tempBlobsToFree = new ArrayList();
        }
        this.tempBlobsToFree.add(blob);
    }

    void cleanTempLobs() {
        this.cleanTempClobs(this.tempClobsToFree);
        this.cleanTempBlobs(this.tempBlobsToFree);
        this.tempClobsToFree = null;
        this.tempBlobsToFree = null;
    }

    void cleanTempBlobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((BLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {
                }
            }
        }
    }

    void cleanTempClobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((CLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {
                }
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.findColumn(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.resultSet.setFetchDirection(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchDirection() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.getFetchDirection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.resultSet.setFetchSize(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.getFetchSize();
        }
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen();
        return this.scrollStmt.realRsetType.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureOpen();
        return 1008;
    }

    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName").fillInStackTrace();
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.isRowDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (!this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 83).fillInStackTrace();
            }
            this.prepareInsertRowStatement();
            this.prepareInsertRowBinds();
            this.executeInsertRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            int n2 = this.getNumColumnsChanged();
            if (n2 > 0) {
                this.prepareUpdateRowStatement(n2);
                this.prepareUpdateRowBinds(n2);
                this.executeUpdateRow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            this.prepareDeleteRowStatement();
            this.prepareDeleteRowBinds();
            this.executeDeleteRow();
            this.isRowDeleted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            this.resultSet.refreshRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRowUpdates() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isUpdating) {
                this.isUpdating = false;
                this.clearRowBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToInsertRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isOnInsertRow()) {
                return;
            }
            this.isRowDeleted = false;
            this.isInserting = true;
            if (this.rowBuffer == null) {
                this.rowBuffer = new Object[this.getColumnCount()];
            }
            if (this.m_nullIndicator == null) {
                this.m_nullIndicator = new boolean[this.getColumnCount()];
            }
            this.clearRowBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            this.cancelRowInserts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            assert (clazz != null) : "type: null";
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            T t2 = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    t2 = datum.toClass(clazz);
                }
            } else {
                this.setIsNull(4);
                t2 = this.resultSet.getObject(n2, clazz);
            }
            return t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNull(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            this.setRowBufferAt(n2, null);
        }
    }

    @Override
    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            this.columnCount = this.resultSet.getColumnCount();
        }
        return this.columnCount;
    }

    ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.rsetMetaData == null) {
            this.rsetMetaData = this.resultSet.getMetaData();
        }
        return this.rsetMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRowChanges() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.isInserting) {
                this.cancelRowInserts();
            }
            if (this.isUpdating) {
                this.cancelRowUpdates();
            }
        }
    }

    boolean isOnInsertRow() {
        return this.isInserting;
    }

    private void cancelRowInserts() {
        if (this.isInserting) {
            this.isInserting = false;
            this.clearRowBuffer();
        }
    }

    boolean isUpdatingRow() {
        return this.isUpdating;
    }

    private void clearRowBuffer() {
        int n2;
        if (this.rowBuffer != null) {
            for (n2 = 0; n2 < this.rowBuffer.length; ++n2) {
                this.rowBuffer[n2] = null;
            }
        }
        if (this.m_nullIndicator != null) {
            for (n2 = 0; n2 < this.m_nullIndicator.length; ++n2) {
                this.m_nullIndicator[n2] = false;
            }
        }
        if (this.typeInfo != null) {
            for (n2 = 0; n2 < this.typeInfo.length; ++n2) {
                if (this.typeInfo[n2] == null) continue;
                for (int i2 = 0; i2 < this.typeInfo[n2].length; ++i2) {
                    this.typeInfo[n2][i2] = 0;
                }
            }
        }
        this.cleanTempLobs();
    }

    protected void setRowBufferAt(int n2, Datum datum) throws SQLException {
        this.setRowBufferAt(n2, datum, null);
    }

    protected void setRowBufferAt(int n2, Object object, int[] nArray) throws SQLException {
        if (!this.isInserting) {
            if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            this.isUpdating = true;
        }
        if (n2 < 1 || n2 > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setRowBufferAt").fillInStackTrace();
        }
        if (this.rowBuffer == null) {
            this.rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                this.m_nullIndicator[i2] = false;
            }
        }
        if (nArray != null) {
            if (this.typeInfo == null) {
                this.typeInfo = new int[this.getColumnCount()][];
            }
            this.typeInfo[n2 - 1] = nArray;
        }
        this.rowBuffer[n2 - 1] = object;
        this.m_nullIndicator[n2 - 1] = object == null;
    }

    protected Datum getRowBufferDatumAt(int n2) throws SQLException {
        Object object;
        if (n2 < 1 || n2 > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt").fillInStackTrace();
        }
        Datum datum = null;
        if (this.rowBuffer != null && (object = this.rowBuffer[n2 - 1]) != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else {
                OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
                datum = SQLUtil.makeOracleDatum(this.connection, object, oracleResultSetMetaData.getColumnType(n2), null, oracleResultSetMetaData.isNCHAR(n2));
                this.rowBuffer[n2 - 1] = datum;
            }
        }
        return datum;
    }

    protected Object getRowBufferAt(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt").fillInStackTrace();
        }
        if (this.rowBuffer != null) {
            return this.rowBuffer[n2 - 1];
        }
        return null;
    }

    protected boolean isRowBufferUpdatedAt(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt").fillInStackTrace();
        }
        if (this.rowBuffer == null) {
            return false;
        }
        return this.rowBuffer[n2 - 1] != null || this.m_nullIndicator[n2 - 1];
    }

    private void prepareInsertRowStatement() throws SQLException {
        if (this.insertStmt == null) {
            String string = this.scrollStmt.sqlObject.getInsertSqlForUpdatableResultSet(this);
            PreparedStatement preparedStatement = this.connection.prepareStatement(string);
            this.insertStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
            this.insertStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
            if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.insertStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareInsertRowBinds() throws SQLException {
        int n2 = 1;
        n2 = this.prepareSubqueryBinds(this.insertStmt, n2);
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        for (int i2 = 1; i2 <= this.getColumnCount(); ++i2) {
            Object object = this.getRowBufferAt(i2);
            if (object != null) {
                if (object instanceof Reader) {
                    if (oracleResultSetMetaData.isNCHAR(i2)) {
                        this.insertStmt.setFormOfUse(n2 + i2 - 1, (short)2);
                    }
                    this.insertStmt.setCharacterStream(n2 + i2 - 1, (Reader)object, this.typeInfo[i2 - 1][0]);
                    continue;
                }
                if (object instanceof InputStream) {
                    if (this.typeInfo[i2 - 1][1] == 2) {
                        this.insertStmt.setBinaryStream(n2 + i2 - 1, (InputStream)object, this.typeInfo[i2 - 1][0]);
                        continue;
                    }
                    if (this.typeInfo[i2 - 1][1] != 1) continue;
                    this.insertStmt.setAsciiStream(n2 + i2 - 1, (InputStream)object, this.typeInfo[i2 - 1][0]);
                    continue;
                }
                Datum datum = this.getRowBufferDatumAt(i2);
                if (oracleResultSetMetaData.isNCHAR(i2)) {
                    this.insertStmt.setFormOfUse(n2 + i2 - 1, (short)2);
                }
                this.insertStmt.setOracleObject(n2 + i2 - 1, datum);
                continue;
            }
            int n3 = this.getInternalMetadata().getColumnType(i2);
            if (n3 == 2006 || n3 == 2002 || n3 == 2008 || n3 == 2007 || n3 == 2003 || n3 == 2009) {
                this.insertStmt.setNull(n2 + i2 - 1, n3, this.getInternalMetadata().getColumnTypeName(i2));
                continue;
            }
            this.insertStmt.setNull(n2 + i2 - 1, n3);
        }
    }

    private void executeInsertRow() throws SQLException {
        if (this.insertStmt.executeUpdate() != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
        }
    }

    private int getNumColumnsChanged() throws SQLException {
        int n2 = 0;
        if (this.indexColsChanged == null) {
            this.indexColsChanged = new int[this.getColumnCount()];
        }
        if (this.rowBuffer != null) {
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                if (this.rowBuffer[i2] == null && (this.rowBuffer[i2] != null || !this.m_nullIndicator[i2])) continue;
                this.indexColsChanged[n2++] = i2;
            }
        }
        return n2;
    }

    private void prepareUpdateRowStatement(int n2) throws SQLException {
        if (this.updateStmt != null) {
            this.updateStmt.close();
        }
        String string = this.scrollStmt.sqlObject.getUpdateSqlForUpdatableResultSet(this, n2, this.rowBuffer, this.indexColsChanged);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string);
        this.updateStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
        this.updateStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
        if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
            this.updateStmt.setEscapeProcessing(true);
        }
    }

    private void prepareUpdateRowBinds(int n2) throws SQLException {
        int n3 = 1;
        n3 = this.prepareSubqueryBinds(this.updateStmt, n3);
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.indexColsChanged[i2];
            Object object = this.getRowBufferAt(n4 + 1);
            if (object != null) {
                if (object instanceof Reader) {
                    if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                        this.updateStmt.setFormOfUse(n3, (short)2);
                    }
                    this.updateStmt.setCharacterStream(n3++, (Reader)object, this.typeInfo[n4][0]);
                    continue;
                }
                if (object instanceof InputStream) {
                    if (this.typeInfo[n4][1] == 2) {
                        this.updateStmt.setBinaryStream(n3++, (InputStream)object, this.typeInfo[n4][0]);
                        continue;
                    }
                    if (this.typeInfo[n4][1] != 1) continue;
                    this.updateStmt.setAsciiStream(n3++, (InputStream)object, this.typeInfo[n4][0]);
                    continue;
                }
                Datum datum = this.getRowBufferDatumAt(n4 + 1);
                if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                    this.updateStmt.setFormOfUse(n3, (short)2);
                }
                this.updateStmt.setOracleObject(n3++, datum);
                continue;
            }
            int n5 = this.getInternalMetadata().getColumnType(n4 + 1);
            if (n5 == 2006 || n5 == 2002 || n5 == 2008 || n5 == 2007 || n5 == 2003 || n5 == 2009) {
                this.updateStmt.setNull(n3++, n5, this.getInternalMetadata().getColumnTypeName(n4 + 1));
                continue;
            }
            if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                this.updateStmt.setFormOfUse(n3, (short)2);
            }
            this.updateStmt.setNull(n3++, n5);
        }
        this.prepareCompareSelfBinds(this.updateStmt, n3);
    }

    private void executeUpdateRow() throws SQLException {
        try {
            if (this.updateStmt.executeUpdate() == 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
            }
            if (this.isCachedRset) {
                this.refreshRows(this.getRow(), 1);
                this.cancelRowUpdates();
            }
        }
        finally {
            if (this.updateStmt != null) {
                this.updateStmt.close();
                this.updateStmt = null;
            }
        }
    }

    @Override
    int refreshRows(long l2, int n2) throws SQLException {
        return this.resultSet.refreshRows(l2 - 1L, n2);
    }

    private void prepareDeleteRowStatement() throws SQLException {
        if (this.deleteStmt == null) {
            String string = this.scrollStmt.sqlObject.getDeleteSqlForUpdatableResultSet(this);
            PreparedStatement preparedStatement = this.connection.prepareStatement(string);
            this.deleteStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
            this.deleteStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
            if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.deleteStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareDeleteRowBinds() throws SQLException {
        int n2 = 1;
        n2 = this.prepareSubqueryBinds(this.deleteStmt, n2);
        this.prepareCompareSelfBinds(this.deleteStmt, n2);
    }

    private void executeDeleteRow() throws SQLException {
        if (this.deleteStmt.executeUpdate() == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
        }
        if (this.isCachedRset) {
            this.removeCurrentRowFromCache();
        }
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
        this.resultSet.removeCurrentRowFromCache();
    }

    private int prepareCompareSelfBinds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        oraclePreparedStatement.setRowId(n2, ((InsensitiveScrollableResultSet)this.resultSet).getPrependedRowId());
        return n2 + 1;
    }

    private int prepareSubqueryBinds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        return n2 + this.scrollStmt.copyBinds(oraclePreparedStatement, n2 - 1);
    }

    protected void setIsNull(int n2) {
        this.wasNull = n2;
    }

    protected void setIsNull(boolean bl) {
        this.setIsNull(bl ? 1 : 2);
    }

    @Override
    protected void doneFetchingRows(boolean bl) throws SQLException {
        this.resultSet.doneFetchingRows(bl);
    }

    @Override
    OracleStatement getOracleStatement() throws SQLException {
        return this.resultSet == null ? null : this.resultSet.getOracleStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Datum datum = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
            } else {
                datum = this.resultSet.getOracleObject(n2);
                this.setIsNull(4);
            }
            return datum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            String string = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    string = datum.stringValue(this.connection);
                }
            } else {
                this.setIsNull(4);
                string = this.resultSet.getString(n2);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            boolean bl = false;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    bl = datum.booleanValue();
                }
            } else {
                this.setIsNull(4);
                bl = this.resultSet.getBoolean(n2);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            byte by = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    by = datum.byteValue();
                }
            } else {
                this.setIsNull(4);
                by = this.resultSet.getByte(n2);
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            short s2 = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                long l2 = this.getLong(n2);
                if (l2 > 65537L || l2 < -65538L) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort").fillInStackTrace();
                }
                s2 = (short)l2;
            } else {
                this.setIsNull(4);
                s2 = this.resultSet.getShort(n2);
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            int n3 = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    n3 = datum.intValue();
                }
            } else {
                this.setIsNull(4);
                n3 = this.resultSet.getInt(n2);
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            long l2 = 0L;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    l2 = datum.longValue();
                }
            } else {
                this.setIsNull(4);
                l2 = this.resultSet.getLong(n2);
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            float f2 = 0.0f;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    f2 = datum.floatValue();
                }
            } else {
                this.setIsNull(4);
                f2 = this.resultSet.getFloat(n2);
            }
            return f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            double d2 = 0.0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    d2 = datum.doubleValue();
                }
            } else {
                this.setIsNull(4);
                d2 = this.resultSet.getDouble(n2);
            }
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            BigDecimal bigDecimal = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    bigDecimal = datum.bigDecimalValue();
                }
            } else {
                this.setIsNull(4);
                bigDecimal = this.resultSet.getBigDecimal(n2);
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            byte[] byArray = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    byArray = datum.getBytes();
                }
            } else {
                this.setIsNull(4);
                byArray = this.resultSet.getBytes(n2);
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Date date = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    date = datum.dateValue();
                }
            } else {
                this.setIsNull(4);
                date = this.resultSet.getDate(n2);
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Time time = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    time = datum.timeValue();
                }
            } else {
                this.setIsNull(4);
                time = this.resultSet.getTime(n2);
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Timestamp timestamp = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    timestamp = datum.timestampValue();
                }
            } else {
                this.setIsNull(4);
                timestamp = this.resultSet.getTimestamp(n2);
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            InputStream inputStream = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object != null) {
                    if (object instanceof InputStream) {
                        inputStream = (InputStream)object;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(n2);
                        inputStream = datum.asciiStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                inputStream = this.resultSet.getAsciiStream(n2);
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            InputStream inputStream = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object == null) return inputStream;
                if (object instanceof InputStream) {
                    return (InputStream)object;
                }
                Datum datum = this.getRowBufferDatumAt(n2);
                DBConversion dBConversion = this.connection.conversion;
                byte[] byArray = datum.shareBytes();
                if (datum instanceof RAW) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                }
                if (!(datum instanceof CHAR)) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream").fillInStackTrace();
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
            }
            this.setIsNull(4);
            return this.resultSet.getUnicodeStream(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            InputStream inputStream = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object != null) {
                    if (object instanceof InputStream) {
                        inputStream = (InputStream)object;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(n2);
                        inputStream = datum.binaryStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                inputStream = this.resultSet.getBinaryStream(n2);
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Object object = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    object = datum.toJdbc();
                }
            } else {
                this.setIsNull(4);
                object = this.resultSet.getObject(n2);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (oracleDataFactory == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            Object object = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object2 = this.getObject(n2);
                this.setIsNull(object2 == null);
                object = oracleDataFactory.create(object2, 0);
            } else {
                this.setIsNull(4);
                object = this.resultSet.getObject(n2, oracleDataFactory);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Reader reader = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object != null) {
                    if (object instanceof Reader) {
                        reader = (Reader)object;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(n2);
                        reader = datum.characterStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                reader = this.resultSet.getCharacterStream(n2);
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            BigDecimal bigDecimal = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    bigDecimal = datum.bigDecimalValue();
                }
            } else {
                this.setIsNull(4);
                bigDecimal = this.resultSet.getBigDecimal(n2);
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Object object = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    object = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc();
                }
            } else {
                this.setIsNull(4);
                object = this.resultSet.getObject(n2, map);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.getREF(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.getBLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.getCLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.getARRAY(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Date date = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        date = ((DATE)datum).dateValue(calendar);
                    } else if (datum instanceof TIMESTAMP) {
                        Timestamp timestamp = ((TIMESTAMP)datum).timestampValue(calendar);
                        long l2 = timestamp.getTime();
                        date = new Date(l2);
                    } else {
                        DATE dATE = new DATE(datum.stringValue(this.connection));
                        if (dATE != null) {
                            date = dATE.dateValue(calendar);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                date = this.resultSet.getDate(n2, calendar);
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Time time = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        time = ((DATE)datum).timeValue(calendar);
                    } else if (datum instanceof TIMESTAMP) {
                        Timestamp timestamp = ((TIMESTAMP)datum).timestampValue(calendar);
                        long l2 = timestamp.getTime();
                        time = new Time(l2);
                    } else {
                        DATE dATE = new DATE(datum.stringValue(this.connection));
                        if (dATE != null) {
                            time = dATE.timeValue(calendar);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                time = this.resultSet.getTime(n2, calendar);
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Timestamp timestamp = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        timestamp = ((DATE)datum).timestampValue(calendar);
                    } else if (datum instanceof TIMESTAMP) {
                        timestamp = ((TIMESTAMP)datum).timestampValue(calendar);
                    } else {
                        DATE dATE = new DATE(datum.stringValue(this.connection));
                        if (dATE != null) {
                            timestamp = dATE.timestampValue(calendar);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                timestamp = this.resultSet.getTimestamp(n2, calendar);
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            URL uRL = null;
            int n3 = this.getInternalMetadata().getColumnType(n2);
            int n4 = SQLUtil.getInternalType(n3);
            if (n4 == 96 || n4 == 1 || n4 == 8) {
                try {
                    String string = this.getString(n2);
                    if (string == null) {
                        uRL = null;
                    }
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136).fillInStackTrace();
                }
            } else {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getURL").fillInStackTrace();
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            ResultSet resultSet = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor").fillInStackTrace();
            }
            this.setIsNull(4);
            resultSet = this.resultSet.getCursor(n2);
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            ROWID rOWID = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof ROWID)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID").fillInStackTrace();
                }
                rOWID = (ROWID)datum;
            } else {
                this.setIsNull(4);
                rOWID = this.resultSet.getROWID(n2);
            }
            return rOWID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            NUMBER nUMBER = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof NUMBER)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER").fillInStackTrace();
                }
                nUMBER = (NUMBER)datum;
            } else {
                this.setIsNull(4);
                nUMBER = this.resultSet.getNUMBER(n2);
            }
            return nUMBER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            DATE dATE = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                datum = this.getRowBufferDatumAt(n2);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        return (DATE)datum;
                    }
                    if (!(datum instanceof TIMESTAMP)) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE").fillInStackTrace();
                    Timestamp timestamp = ((TIMESTAMP)datum).timestampValue();
                    return new DATE(timestamp);
                }
            } else {
                this.setIsNull(4);
                return this.resultSet.getDATE(n2);
            }
            this.setIsNull(datum == null);
            return dATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            TIMESTAMP tIMESTAMP = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMP)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP").fillInStackTrace();
                }
                tIMESTAMP = (TIMESTAMP)datum;
            } else {
                this.setIsNull(4);
                tIMESTAMP = this.resultSet.getTIMESTAMP(n2);
            }
            return tIMESTAMP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            TIMESTAMPTZ tIMESTAMPTZ = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMPTZ)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ").fillInStackTrace();
                }
                tIMESTAMPTZ = (TIMESTAMPTZ)datum;
            } else {
                this.setIsNull(4);
                tIMESTAMPTZ = this.resultSet.getTIMESTAMPTZ(n2);
            }
            return tIMESTAMPTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMPLTZ)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ").fillInStackTrace();
                }
                tIMESTAMPLTZ = (TIMESTAMPLTZ)datum;
            } else {
                this.setIsNull(4);
                tIMESTAMPLTZ = this.resultSet.getTIMESTAMPLTZ(n2);
            }
            return tIMESTAMPLTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            INTERVALDS iNTERVALDS = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof INTERVALDS)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS").fillInStackTrace();
                }
                iNTERVALDS = (INTERVALDS)datum;
            } else {
                this.setIsNull(4);
                iNTERVALDS = this.resultSet.getINTERVALDS(n2);
            }
            return iNTERVALDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            INTERVALYM iNTERVALYM = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof INTERVALYM)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM").fillInStackTrace();
                }
                iNTERVALYM = (INTERVALYM)datum;
            } else {
                this.setIsNull(4);
                iNTERVALYM = this.resultSet.getINTERVALYM(n2);
            }
            return iNTERVALYM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            ARRAY aRRAY = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof ARRAY)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY").fillInStackTrace();
                }
                aRRAY = (ARRAY)datum;
            } else {
                this.setIsNull(4);
                aRRAY = this.resultSet.getARRAY(n2);
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            STRUCT sTRUCT = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof STRUCT)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT").fillInStackTrace();
                }
                sTRUCT = (STRUCT)datum;
            } else {
                this.setIsNull(4);
                sTRUCT = this.resultSet.getSTRUCT(n2);
            }
            return sTRUCT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            OPAQUE oPAQUE = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof OPAQUE)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE").fillInStackTrace();
                }
                oPAQUE = (OPAQUE)datum;
            } else {
                this.setIsNull(4);
                oPAQUE = this.resultSet.getOPAQUE(n2);
            }
            return oPAQUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            REF rEF = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof REF)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF").fillInStackTrace();
                }
                rEF = (REF)datum;
            } else {
                this.setIsNull(4);
                rEF = this.resultSet.getREF(n2);
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            CHAR cHAR = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof CHAR)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR").fillInStackTrace();
                }
                cHAR = (CHAR)datum;
            } else {
                this.setIsNull(4);
                cHAR = this.resultSet.getCHAR(n2);
            }
            return cHAR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            RAW rAW = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof RAW)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW").fillInStackTrace();
                }
                rAW = (RAW)datum;
            } else {
                this.setIsNull(4);
                rAW = this.resultSet.getRAW(n2);
            }
            return rAW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            BLOB bLOB = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof BLOB)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB").fillInStackTrace();
                }
                bLOB = (BLOB)datum;
            } else {
                this.setIsNull(4);
                bLOB = this.resultSet.getBLOB(n2);
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCLOB getNCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            NCLOB nCLOB = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof NCLOB)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB").fillInStackTrace();
                }
                nCLOB = (NCLOB)datum;
            } else {
                this.setIsNull(4);
                nCLOB = (NCLOB)this.resultSet.getNClob(n2);
            }
            return nCLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            CLOB cLOB = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof CLOB)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB").fillInStackTrace();
                }
                cLOB = (CLOB)datum;
            } else {
                this.setIsNull(4);
                cLOB = this.resultSet.getCLOB(n2);
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            BFILE bFILE = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof BFILE)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE").fillInStackTrace();
                }
                bFILE = (BFILE)datum;
            } else {
                this.setIsNull(4);
                bFILE = this.resultSet.getBFILE(n2);
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.getBFILE(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (customDatumFactory == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            CustomDatum customDatum = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                customDatum = customDatumFactory.create(datum, 0);
            } else {
                this.setIsNull(4);
                customDatum = this.resultSet.getCustomDatum(n2, customDatumFactory);
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (oRADataFactory == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            ORAData oRAData = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                oRAData = oRADataFactory.create(datum, 0);
            } else {
                this.setIsNull(4);
                oRAData = this.resultSet.getORAData(n2, oRADataFactory);
            }
            return oRAData;
        }
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        this.ensureOpen();
        if (this.isRowDeleted) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
        }
        NCLOB nCLOB = this.getNCLOB(n2);
        if (nCLOB == null) {
            return null;
        }
        if (!(nCLOB instanceof NClob)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 184).fillInStackTrace();
        }
        return nCLOB;
    }

    @Override
    public String getNString(int n2) throws SQLException {
        this.ensureOpen();
        if (this.isRowDeleted) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
        }
        return this.getString(n2);
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        this.ensureOpen();
        if (this.isRowDeleted) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
        }
        return this.getCharacterStream(n2);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        this.ensureOpen();
        if (this.isRowDeleted) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
        }
        return this.getROWID(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            SQLXML sQLXML = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof SQLXML)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSQLXML").fillInStackTrace();
                }
                sQLXML = (SQLXML)((Object)datum);
            } else {
                this.setIsNull(4);
                sQLXML = this.resultSet.getSQLXML(n2);
            }
            return sQLXML;
        }
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        this.updateROWID(n2, (ROWID)rowId);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.updateCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateCharacterStream(n2, reader);
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.updateOracleObject(n2, (Datum)((Object)sQLXML));
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        this.updateString(n2, string);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        this.updateClob(n2, (Clob)nClob);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateAsciiStream(n2, inputStream, (int)l2);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(n2, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateBinaryStream(n2, inputStream, (int)l2);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n2, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.updateCharacterStream(n2, reader, (int)l2);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateCharacterStream(n2, reader, Integer.MAX_VALUE);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateBlob").fillInStackTrace();
        }
        Blob blob = this.connection.createBlob();
        this.addToTempLobsToFree(blob);
        int n3 = ((BLOB)blob).getBufferSize();
        OutputStream outputStream = blob.setBinaryStream(1L);
        byte[] byArray = new byte[n3];
        try {
            int n4;
            while ((n4 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n4);
            }
            outputStream.close();
            this.updateBlob(n2, blob);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        if (inputStream == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateBlob").fillInStackTrace();
        }
        Blob blob = this.connection.createBlob();
        this.addToTempLobsToFree(blob);
        int n3 = ((BLOB)blob).getBufferSize();
        OutputStream outputStream = blob.setBinaryStream(1L);
        byte[] byArray = new byte[n3];
        try {
            int n4;
            for (long i2 = l2; i2 > 0L && (n4 = inputStream.read(byArray, 0, Math.min(n3, (int)i2))) != -1; i2 -= (long)n4) {
                outputStream.write(byArray, 0, n4);
            }
            outputStream.close();
            this.updateBlob(n2, blob);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        this.updateClob(n2, reader, l2, (short)1);
    }

    void updateClob(int n2, Reader reader, long l2, short s2) throws SQLException {
        if (reader == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateClob").fillInStackTrace();
        }
        Clob clob = s2 == 1 ? this.connection.createClob() : this.connection.createNClob();
        this.addToTempLobsToFree(clob);
        int n3 = ((CLOB)clob).getBufferSize();
        Writer writer = clob.setCharacterStream(1L);
        char[] cArray = new char[n3];
        try {
            int n4;
            for (long i2 = l2; i2 > 0L && (n4 = reader.read(cArray, 0, Math.min(n3, (int)i2))) != -1; i2 -= (long)n4) {
                writer.write(cArray, 0, n4);
            }
            writer.close();
            this.updateClob(n2, clob);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        if (reader == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateClob").fillInStackTrace();
        }
        Clob clob = this.connection.createClob();
        this.addToTempLobsToFree(clob);
        int n3 = ((CLOB)clob).getBufferSize();
        Writer writer = clob.setCharacterStream(1L);
        char[] cArray = new char[n3];
        try {
            int n4;
            while ((n4 = reader.read(cArray)) != -1) {
                writer.write(cArray, 0, n4);
            }
            writer.close();
            this.updateClob(n2, clob);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    void updateClob(int n2, InputStream inputStream, int n3) throws SQLException {
        this.updateClob(n2, inputStream, n3, (short)1);
    }

    void updateClob(int n2, InputStream inputStream, int n3, short s2) throws SQLException {
        if (inputStream == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateClob").fillInStackTrace();
        }
        Clob clob = s2 == 1 ? this.connection.createClob() : this.connection.createNClob();
        this.addToTempLobsToFree(clob);
        int n4 = ((CLOB)clob).getBufferSize();
        OutputStream outputStream = clob.setAsciiStream(1L);
        byte[] byArray = new byte[n4];
        try {
            int n5;
            for (long i2 = (long)n3; i2 > 0L && (n5 = inputStream.read(byArray, 0, Math.min(n4, (int)i2))) != -1; i2 -= (long)n5) {
                outputStream.write(byArray, 0, n5);
            }
            outputStream.close();
            this.updateClob(n2, clob);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    void updateNClob(int n2, InputStream inputStream, int n3) throws SQLException {
        if (inputStream == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateNClob").fillInStackTrace();
        }
        NClob nClob = this.connection.createNClob();
        this.addToTempLobsToFree(nClob);
        int n4 = ((NCLOB)nClob).getBufferSize();
        OutputStream outputStream = nClob.setAsciiStream(1L);
        byte[] byArray = new byte[n4];
        try {
            int n5;
            for (long i2 = (long)n3; i2 > 0L && (n5 = inputStream.read(byArray, 0, Math.min(n4, (int)i2))) != -1; i2 -= (long)n5) {
                outputStream.write(byArray, 0, n5);
            }
            outputStream.close();
            this.updateNClob(n2, nClob);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        if (reader == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateNClob").fillInStackTrace();
        }
        NClob nClob = this.connection.createNClob();
        this.addToTempLobsToFree(nClob);
        int n3 = ((CLOB)((Object)nClob)).getBufferSize();
        Writer writer = nClob.setCharacterStream(1L);
        char[] cArray = new char[n3];
        try {
            int n4;
            for (long i2 = l2; i2 > 0L && (n4 = reader.read(cArray, 0, Math.min(n3, (int)i2))) != -1; i2 -= (long)n4) {
                writer.write(cArray, 0, n4);
            }
            writer.close();
            this.updateNClob(n2, nClob);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        if (reader == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateNClob").fillInStackTrace();
        }
        NClob nClob = this.connection.createNClob();
        this.addToTempLobsToFree(nClob);
        int n3 = ((CLOB)((Object)nClob)).getBufferSize();
        Writer writer = nClob.setCharacterStream(1L);
        char[] cArray = new char[n3];
        try {
            int n4;
            while ((n4 = reader.read(cArray)) != -1) {
                writer.write(cArray, 0, n4);
            }
            writer.close();
            this.updateNClob(n2, nClob);
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (string == null || string.length() == 0) {
                this.updateNull(n2);
            } else {
                this.updateObject(n2, (Object)string);
            }
        }
    }

    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.updateObject(n2, (Object)bl);
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        this.updateObject(n2, (Object)by);
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        this.updateObject(n2, (Object)s2);
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        this.updateObject(n2, (Object)n3);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        this.updateObject(n2, (Object)l2);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        this.updateObject(n2, (Object)Float.valueOf(f2));
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        this.updateObject(n2, (Object)d2);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n2, (Object)bigDecimal);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.updateObject(n2, (Object)byArray);
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        this.updateObject(n2, (Object)date);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        this.updateObject(n2, (Object)time);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.updateObject(n2, (Object)timestamp);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        block11: {
            block12: {
                this.ensureOpen();
                if (this.isRowDeleted) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
                }
                OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
                int n4 = oracleResultSetMetaData.getColumnType(n2);
                if (inputStream == null || n3 <= 0) break block12;
                switch (n4) {
                    case 2005: {
                        this.updateClob(n2, inputStream, n3);
                        break block11;
                    }
                    case 2011: {
                        this.updateNClob(n2, inputStream, n3);
                        break block11;
                    }
                    case 2004: {
                        this.updateBlob(n2, inputStream, (long)n3);
                        break block11;
                    }
                    case -1: {
                        int[] nArray = new int[]{n3, 1};
                        this.setRowBufferAt(n2, inputStream, nArray);
                        break block11;
                    }
                    default: {
                        try {
                            int n5;
                            int n6 = 0;
                            byte[] byArray = new byte[1024];
                            char[] cArray = new char[1024];
                            StringBuilder stringBuilder = new StringBuilder(1024);
                            for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n5)) != -1; n5 -= n6) {
                                DBConversion cfr_ignored_0 = this.connection.conversion;
                                DBConversion.asciiBytesToJavaChars(byArray, n6, cArray);
                                stringBuilder.append(cArray, 0, n6);
                            }
                            inputStream.close();
                            if (n5 == n3) {
                                this.updateNull(n2);
                                return;
                            }
                            this.updateString(n2, stringBuilder.toString());
                            break block11;
                        }
                        catch (IOException iOException) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
                        }
                    }
                }
            }
            this.setRowBufferAt(n2, null);
        }
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        block9: {
            block10: {
                this.ensureOpen();
                if (this.isRowDeleted) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
                }
                int n4 = this.getInternalMetadata().getColumnType(n2);
                if (inputStream == null || n3 <= 0) break block10;
                switch (n4) {
                    case 2004: {
                        this.updateBlob(n2, inputStream, (long)n3);
                        break block9;
                    }
                    case -4: {
                        int[] nArray = new int[]{n3, 2};
                        this.setRowBufferAt(n2, inputStream, nArray);
                        break block9;
                    }
                    default: {
                        try {
                            int n5;
                            int n6 = 0;
                            byte[] byArray = new byte[1024];
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                            for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n5)) != -1; n5 -= n6) {
                                byteArrayOutputStream.write(byArray, 0, n6);
                            }
                            inputStream.close();
                            if (n5 == n3) {
                                this.updateNull(n2);
                                return;
                            }
                            this.updateBytes(n2, byteArrayOutputStream.toByteArray());
                            break block9;
                        }
                        catch (IOException iOException) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
                        }
                    }
                }
            }
            this.setRowBufferAt(n2, null);
        }
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        block10: {
            block11: {
                int n4 = 0;
                this.ensureOpen();
                if (this.isRowDeleted) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
                }
                OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
                int n5 = oracleResultSetMetaData.getColumnType(n2);
                if (reader == null || n3 <= 0) break block11;
                switch (n5) {
                    case 2005: {
                        this.updateClob(n2, reader, (long)n3);
                        break block10;
                    }
                    case 2011: {
                        this.updateNClob(n2, reader, (long)n3);
                        break block10;
                    }
                    case -1: {
                        int[] nArray = new int[]{n3};
                        this.setRowBufferAt(n2, reader, nArray);
                        break block10;
                    }
                    default: {
                        try {
                            int n6;
                            char[] cArray = new char[1024];
                            StringBuilder stringBuilder = new StringBuilder(1024);
                            for (n6 = n3; n6 > 0 && (n4 = n6 >= 1024 ? reader.read(cArray) : reader.read(cArray, 0, n6)) != -1; n6 -= n4) {
                                stringBuilder.append(cArray, 0, n4);
                            }
                            reader.close();
                            if (n6 == n3) {
                                this.updateNull(n2);
                                return;
                            }
                            this.updateString(n2, stringBuilder.toString());
                            break block10;
                        }
                        catch (IOException iOException) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
                        }
                    }
                }
            }
            this.setRowBufferAt(n2, null);
        }
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.updateObject(n2, object);
    }

    @Override
    public void updateObject(int n2, Object object, SQLType sQLType) throws SQLException {
        if (sQLType == null) {
            throw new IllegalArgumentException("null SQLType");
        }
        int n3 = sQLType.getVendorTypeNumber();
        this.updateObject(n2, object, n3, false);
    }

    @Override
    public void updateObject(int n2, Object object, SQLType sQLType, int n3) throws SQLException {
        this.updateObject(n2, object, sQLType);
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        this.updateObject(n2, object, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObject(int n2, Object object, int n3, boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (object != null && object instanceof Reader) {
                this.updateCharacterStream(n2, (Reader)object);
            } else {
                Datum datum = null;
                if (object != null) {
                    Object object2;
                    if (object instanceof OracleData) {
                        object2 = ((OracleData)object).toJDBCObject(this.connection);
                        if (object2 instanceof _Proxy_) {
                            final _Proxy_ _Proxy_2 = (_Proxy_)object2;
                            object2 = AccessController.doPrivileged(new PrivilegedAction<Object>(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;

                                @Override
                                public Object run() {
                                    return ProxyFactory.extractDelegate(_Proxy_2);
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OldUpdatableResultSet.class, _Proxy_.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                    try {
                                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                }
                            });
                        }
                        object = object2;
                    }
                    if (object instanceof Datum) {
                        datum = (Datum)object;
                    } else {
                        object2 = (OracleResultSetMetaData)this.getInternalMetadata();
                        int n4 = n2;
                        int n5 = bl ? ((OracleResultSetMetaData)object2).getColumnType(n4) : n3;
                        switch (n5) {
                            case -15: 
                            case -9: 
                            case -1: 
                            case 1: 
                            case 12: {
                                if (object instanceof byte[]) {
                                    byte[] byArray = (byte[])object;
                                    char[] cArray = new char[byArray.length * 3];
                                    int n6 = DBConversion.RAWBytesToHexChars(byArray, byArray.length, cArray);
                                    object = new String(cArray, 0, n6);
                                    break;
                                }
                                if (!(object instanceof Boolean)) break;
                                object = "" + ((Boolean)object != false ? 1 : 0);
                                break;
                            }
                            case 93: {
                                if (!(object instanceof Calendar)) break;
                                object = JavaToJavaConverter.convert(object, TIMESTAMP.class, this.connection, 0, null);
                                break;
                            }
                            case 91: {
                                if (!(object instanceof String)) break;
                                object = Date.valueOf((String)object);
                            }
                        }
                        datum = SQLUtil.makeOracleDatum(this.connection, object, n5, null, ((OracleResultSetMetaData)object2).isNCHAR(n4));
                    }
                }
                this.setRowBufferAt(n2, datum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOracleObject(int n2, Datum datum) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setRowBufferAt(n2, datum);
        }
    }

    @Override
    public void updateROWID(int n2, ROWID rOWID) throws SQLException {
        this.updateOracleObject(n2, (Datum)rOWID);
    }

    @Override
    public void updateNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        this.updateOracleObject(n2, (Datum)nUMBER);
    }

    @Override
    public void updateDATE(int n2, DATE dATE) throws SQLException {
        this.updateOracleObject(n2, (Datum)dATE);
    }

    @Override
    public void updateINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        this.updateOracleObject(n2, (Datum)iNTERVALYM);
    }

    @Override
    public void updateINTERVALDS(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        this.updateOracleObject(n2, (Datum)iNTERVALDS);
    }

    @Override
    public void updateTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMP);
    }

    @Override
    public void updateTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMPTZ);
    }

    @Override
    public void updateTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMPLTZ);
    }

    @Override
    public void updateARRAY(int n2, ARRAY aRRAY) throws SQLException {
        this.updateOracleObject(n2, (Datum)aRRAY);
    }

    @Override
    public void updateSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        this.updateOracleObject(n2, (Datum)sTRUCT);
    }

    public void updateOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        this.updateOracleObject(n2, (Datum)oPAQUE);
    }

    @Override
    public void updateREF(int n2, REF rEF) throws SQLException {
        this.updateOracleObject(n2, (Datum)rEF);
    }

    @Override
    public void updateCHAR(int n2, CHAR cHAR) throws SQLException {
        this.updateOracleObject(n2, (Datum)cHAR);
    }

    @Override
    public void updateRAW(int n2, RAW rAW) throws SQLException {
        this.updateOracleObject(n2, (Datum)rAW);
    }

    @Override
    public void updateBLOB(int n2, BLOB bLOB) throws SQLException {
        this.updateOracleObject(n2, (Datum)bLOB);
    }

    @Override
    public void updateCLOB(int n2, CLOB cLOB) throws SQLException {
        this.updateOracleObject(n2, (Datum)cLOB);
    }

    @Override
    public void updateBFILE(int n2, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n2, (Datum)bFILE);
    }

    @Override
    public void updateBfile(int n2, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n2, (Datum)bFILE);
    }

    @Override
    public void updateCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        throw new Error("wanna do datum = ((CustomDatum) x).toDatum(m_comm)");
    }

    @Override
    public void updateORAData(int n2, ORAData oRAData) throws SQLException {
        Datum datum = oRAData.toDatum(this.connection);
        this.updateOracleObject(n2, datum);
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        this.updateREF(n2, (REF)ref);
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.updateBLOB(n2, (BLOB)blob);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        this.updateCLOB(n2, (CLOB)clob);
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        this.updateARRAY(n2, (ARRAY)array);
    }

    static {
        try {
            $$$methodRef$$$201 = OldUpdatableResultSet.class.getDeclaredConstructor(OracleStatement.class, OracleResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$201 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$200 = OldUpdatableResultSet.class.getDeclaredMethod("updateArray", Integer.TYPE, Array.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$200 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$199 = OldUpdatableResultSet.class.getDeclaredMethod("updateClob", Integer.TYPE, Clob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$199 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$198 = OldUpdatableResultSet.class.getDeclaredMethod("updateBlob", Integer.TYPE, Blob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$198 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$197 = OldUpdatableResultSet.class.getDeclaredMethod("updateRef", Integer.TYPE, Ref.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$197 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$196 = OldUpdatableResultSet.class.getDeclaredMethod("updateORAData", Integer.TYPE, ORAData.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$196 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$195 = OldUpdatableResultSet.class.getDeclaredMethod("updateCustomDatum", Integer.TYPE, CustomDatum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$195 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$194 = OldUpdatableResultSet.class.getDeclaredMethod("updateBfile", Integer.TYPE, BFILE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$194 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$193 = OldUpdatableResultSet.class.getDeclaredMethod("updateBFILE", Integer.TYPE, BFILE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$193 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$192 = OldUpdatableResultSet.class.getDeclaredMethod("updateCLOB", Integer.TYPE, CLOB.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$192 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$191 = OldUpdatableResultSet.class.getDeclaredMethod("updateBLOB", Integer.TYPE, BLOB.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$191 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$190 = OldUpdatableResultSet.class.getDeclaredMethod("updateRAW", Integer.TYPE, RAW.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$190 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$189 = OldUpdatableResultSet.class.getDeclaredMethod("updateCHAR", Integer.TYPE, CHAR.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$189 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$188 = OldUpdatableResultSet.class.getDeclaredMethod("updateREF", Integer.TYPE, REF.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$188 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$187 = OldUpdatableResultSet.class.getDeclaredMethod("updateOPAQUE", Integer.TYPE, OPAQUE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$187 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$186 = OldUpdatableResultSet.class.getDeclaredMethod("updateSTRUCT", Integer.TYPE, STRUCT.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$186 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$185 = OldUpdatableResultSet.class.getDeclaredMethod("updateARRAY", Integer.TYPE, ARRAY.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$185 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$184 = OldUpdatableResultSet.class.getDeclaredMethod("updateTIMESTAMPLTZ", Integer.TYPE, TIMESTAMPLTZ.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$184 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$183 = OldUpdatableResultSet.class.getDeclaredMethod("updateTIMESTAMPTZ", Integer.TYPE, TIMESTAMPTZ.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$183 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$182 = OldUpdatableResultSet.class.getDeclaredMethod("updateTIMESTAMP", Integer.TYPE, TIMESTAMP.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$182 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$181 = OldUpdatableResultSet.class.getDeclaredMethod("updateINTERVALDS", Integer.TYPE, INTERVALDS.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$181 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$180 = OldUpdatableResultSet.class.getDeclaredMethod("updateINTERVALYM", Integer.TYPE, INTERVALYM.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$180 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$179 = OldUpdatableResultSet.class.getDeclaredMethod("updateDATE", Integer.TYPE, DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$179 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$178 = OldUpdatableResultSet.class.getDeclaredMethod("updateNUMBER", Integer.TYPE, NUMBER.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$178 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$177 = OldUpdatableResultSet.class.getDeclaredMethod("updateROWID", Integer.TYPE, ROWID.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$177 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$176 = OldUpdatableResultSet.class.getDeclaredMethod("updateOracleObject", Integer.TYPE, Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$176 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$175 = OldUpdatableResultSet.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$175 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$174 = OldUpdatableResultSet.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$174 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$173 = OldUpdatableResultSet.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class, SQLType.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$173 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$172 = OldUpdatableResultSet.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class, SQLType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$172 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$171 = OldUpdatableResultSet.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$171 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$170 = OldUpdatableResultSet.class.getDeclaredMethod("updateCharacterStream", Integer.TYPE, Reader.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$170 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$169 = OldUpdatableResultSet.class.getDeclaredMethod("updateBinaryStream", Integer.TYPE, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$169 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$168 = OldUpdatableResultSet.class.getDeclaredMethod("updateAsciiStream", Integer.TYPE, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$168 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$167 = OldUpdatableResultSet.class.getDeclaredMethod("updateTimestamp", Integer.TYPE, Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$167 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$166 = OldUpdatableResultSet.class.getDeclaredMethod("updateTime", Integer.TYPE, Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$166 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$165 = OldUpdatableResultSet.class.getDeclaredMethod("updateDate", Integer.TYPE, Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$165 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$164 = OldUpdatableResultSet.class.getDeclaredMethod("updateBytes", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$164 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$163 = OldUpdatableResultSet.class.getDeclaredMethod("updateBigDecimal", Integer.TYPE, BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$163 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$162 = OldUpdatableResultSet.class.getDeclaredMethod("updateDouble", Integer.TYPE, Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$162 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$161 = OldUpdatableResultSet.class.getDeclaredMethod("updateFloat", Integer.TYPE, Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$161 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$160 = OldUpdatableResultSet.class.getDeclaredMethod("updateLong", Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$160 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$159 = OldUpdatableResultSet.class.getDeclaredMethod("updateInt", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$159 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$158 = OldUpdatableResultSet.class.getDeclaredMethod("updateShort", Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$158 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$157 = OldUpdatableResultSet.class.getDeclaredMethod("updateByte", Integer.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$157 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$156 = OldUpdatableResultSet.class.getDeclaredMethod("updateBoolean", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$156 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$155 = OldUpdatableResultSet.class.getDeclaredMethod("updateString", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$155 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$154 = OldUpdatableResultSet.class.getDeclaredMethod("updateNClob", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$154 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$153 = OldUpdatableResultSet.class.getDeclaredMethod("updateNClob", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$153 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$152 = OldUpdatableResultSet.class.getDeclaredMethod("updateNClob", Integer.TYPE, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$152 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$151 = OldUpdatableResultSet.class.getDeclaredMethod("updateClob", Integer.TYPE, InputStream.class, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$151 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$150 = OldUpdatableResultSet.class.getDeclaredMethod("updateClob", Integer.TYPE, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$150 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$149 = OldUpdatableResultSet.class.getDeclaredMethod("updateClob", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$149 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$148 = OldUpdatableResultSet.class.getDeclaredMethod("updateClob", Integer.TYPE, Reader.class, Long.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$148 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$147 = OldUpdatableResultSet.class.getDeclaredMethod("updateClob", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$147 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$146 = OldUpdatableResultSet.class.getDeclaredMethod("updateBlob", Integer.TYPE, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$146 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$145 = OldUpdatableResultSet.class.getDeclaredMethod("updateBlob", Integer.TYPE, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$145 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$144 = OldUpdatableResultSet.class.getDeclaredMethod("updateCharacterStream", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$144 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$143 = OldUpdatableResultSet.class.getDeclaredMethod("updateCharacterStream", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$143 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$142 = OldUpdatableResultSet.class.getDeclaredMethod("updateBinaryStream", Integer.TYPE, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$142 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$141 = OldUpdatableResultSet.class.getDeclaredMethod("updateBinaryStream", Integer.TYPE, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$141 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$140 = OldUpdatableResultSet.class.getDeclaredMethod("updateAsciiStream", Integer.TYPE, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$140 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$139 = OldUpdatableResultSet.class.getDeclaredMethod("updateAsciiStream", Integer.TYPE, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$139 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$138 = OldUpdatableResultSet.class.getDeclaredMethod("updateNClob", Integer.TYPE, NClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$138 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$137 = OldUpdatableResultSet.class.getDeclaredMethod("updateNString", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$137 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$136 = OldUpdatableResultSet.class.getDeclaredMethod("updateSQLXML", Integer.TYPE, SQLXML.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$136 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$135 = OldUpdatableResultSet.class.getDeclaredMethod("updateNCharacterStream", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$135 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$134 = OldUpdatableResultSet.class.getDeclaredMethod("updateNCharacterStream", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$134 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$133 = OldUpdatableResultSet.class.getDeclaredMethod("updateRowId", Integer.TYPE, RowId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$133 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$132 = OldUpdatableResultSet.class.getDeclaredMethod("getSQLXML", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$132 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$131 = OldUpdatableResultSet.class.getDeclaredMethod("getRowId", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$131 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$130 = OldUpdatableResultSet.class.getDeclaredMethod("getNCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$130 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$129 = OldUpdatableResultSet.class.getDeclaredMethod("getNString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$129 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$128 = OldUpdatableResultSet.class.getDeclaredMethod("getNClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$128 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$127 = OldUpdatableResultSet.class.getDeclaredMethod("getORAData", Integer.TYPE, ORADataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$127 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$126 = OldUpdatableResultSet.class.getDeclaredMethod("getCustomDatum", Integer.TYPE, CustomDatumFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$126 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$125 = OldUpdatableResultSet.class.getDeclaredMethod("getBfile", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$125 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$124 = OldUpdatableResultSet.class.getDeclaredMethod("getBFILE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$124 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$123 = OldUpdatableResultSet.class.getDeclaredMethod("getCLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$123 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$122 = OldUpdatableResultSet.class.getDeclaredMethod("getNCLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$122 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$121 = OldUpdatableResultSet.class.getDeclaredMethod("getBLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$121 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$120 = OldUpdatableResultSet.class.getDeclaredMethod("getRAW", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$120 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$119 = OldUpdatableResultSet.class.getDeclaredMethod("getCHAR", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$119 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$118 = OldUpdatableResultSet.class.getDeclaredMethod("getREF", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$118 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$117 = OldUpdatableResultSet.class.getDeclaredMethod("getOPAQUE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$117 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$116 = OldUpdatableResultSet.class.getDeclaredMethod("getSTRUCT", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$116 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$115 = OldUpdatableResultSet.class.getDeclaredMethod("getARRAY", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$115 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$114 = OldUpdatableResultSet.class.getDeclaredMethod("getINTERVALYM", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$114 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$113 = OldUpdatableResultSet.class.getDeclaredMethod("getINTERVALDS", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$113 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$112 = OldUpdatableResultSet.class.getDeclaredMethod("getTIMESTAMPLTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$112 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$111 = OldUpdatableResultSet.class.getDeclaredMethod("getTIMESTAMPTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$111 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$110 = OldUpdatableResultSet.class.getDeclaredMethod("getTIMESTAMP", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$110 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$109 = OldUpdatableResultSet.class.getDeclaredMethod("getDATE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$109 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$108 = OldUpdatableResultSet.class.getDeclaredMethod("getNUMBER", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$108 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$107 = OldUpdatableResultSet.class.getDeclaredMethod("getROWID", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$107 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$106 = OldUpdatableResultSet.class.getDeclaredMethod("getCursor", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$106 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$105 = OldUpdatableResultSet.class.getDeclaredMethod("getURL", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$105 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$104 = OldUpdatableResultSet.class.getDeclaredMethod("getTimestamp", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$104 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$103 = OldUpdatableResultSet.class.getDeclaredMethod("getTime", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$103 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$102 = OldUpdatableResultSet.class.getDeclaredMethod("getDate", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$102 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$101 = OldUpdatableResultSet.class.getDeclaredMethod("getArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$101 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$100 = OldUpdatableResultSet.class.getDeclaredMethod("getClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$100 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$99 = OldUpdatableResultSet.class.getDeclaredMethod("getBlob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$99 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$98 = OldUpdatableResultSet.class.getDeclaredMethod("getRef", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$98 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$97 = OldUpdatableResultSet.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$97 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$96 = OldUpdatableResultSet.class.getDeclaredMethod("getBigDecimal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$96 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$95 = OldUpdatableResultSet.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$95 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$94 = OldUpdatableResultSet.class.getDeclaredMethod("getObject", Integer.TYPE, OracleDataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$93 = OldUpdatableResultSet.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$92 = OldUpdatableResultSet.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$91 = OldUpdatableResultSet.class.getDeclaredMethod("getUnicodeStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$90 = OldUpdatableResultSet.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$89 = OldUpdatableResultSet.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$88 = OldUpdatableResultSet.class.getDeclaredMethod("getTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$87 = OldUpdatableResultSet.class.getDeclaredMethod("getDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$86 = OldUpdatableResultSet.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$85 = OldUpdatableResultSet.class.getDeclaredMethod("getBigDecimal", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$84 = OldUpdatableResultSet.class.getDeclaredMethod("getDouble", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$83 = OldUpdatableResultSet.class.getDeclaredMethod("getFloat", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$82 = OldUpdatableResultSet.class.getDeclaredMethod("getLong", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$81 = OldUpdatableResultSet.class.getDeclaredMethod("getInt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$80 = OldUpdatableResultSet.class.getDeclaredMethod("getShort", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$79 = OldUpdatableResultSet.class.getDeclaredMethod("getByte", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$78 = OldUpdatableResultSet.class.getDeclaredMethod("getBoolean", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$77 = OldUpdatableResultSet.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$76 = OldUpdatableResultSet.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$75 = OldUpdatableResultSet.class.getDeclaredMethod("getOracleStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$74 = OldUpdatableResultSet.class.getDeclaredMethod("doneFetchingRows", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$73 = OldUpdatableResultSet.class.getDeclaredMethod("setIsNull", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$72 = OldUpdatableResultSet.class.getDeclaredMethod("setIsNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$71 = OldUpdatableResultSet.class.getDeclaredMethod("prepareSubqueryBinds", OraclePreparedStatement.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$70 = OldUpdatableResultSet.class.getDeclaredMethod("prepareCompareSelfBinds", OraclePreparedStatement.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$69 = OldUpdatableResultSet.class.getDeclaredMethod("removeCurrentRowFromCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$68 = OldUpdatableResultSet.class.getDeclaredMethod("executeDeleteRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$67 = OldUpdatableResultSet.class.getDeclaredMethod("prepareDeleteRowBinds", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$66 = OldUpdatableResultSet.class.getDeclaredMethod("prepareDeleteRowStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$65 = OldUpdatableResultSet.class.getDeclaredMethod("refreshRows", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = OldUpdatableResultSet.class.getDeclaredMethod("executeUpdateRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = OldUpdatableResultSet.class.getDeclaredMethod("prepareUpdateRowBinds", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = OldUpdatableResultSet.class.getDeclaredMethod("prepareUpdateRowStatement", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = OldUpdatableResultSet.class.getDeclaredMethod("getNumColumnsChanged", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = OldUpdatableResultSet.class.getDeclaredMethod("executeInsertRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = OldUpdatableResultSet.class.getDeclaredMethod("prepareInsertRowBinds", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = OldUpdatableResultSet.class.getDeclaredMethod("prepareInsertRowStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = OldUpdatableResultSet.class.getDeclaredMethod("isRowBufferUpdatedAt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = OldUpdatableResultSet.class.getDeclaredMethod("getRowBufferAt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = OldUpdatableResultSet.class.getDeclaredMethod("getRowBufferDatumAt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = OldUpdatableResultSet.class.getDeclaredMethod("setRowBufferAt", Integer.TYPE, Object.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = OldUpdatableResultSet.class.getDeclaredMethod("setRowBufferAt", Integer.TYPE, Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = OldUpdatableResultSet.class.getDeclaredMethod("clearRowBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = OldUpdatableResultSet.class.getDeclaredMethod("isUpdatingRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = OldUpdatableResultSet.class.getDeclaredMethod("cancelRowInserts", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OldUpdatableResultSet.class.getDeclaredMethod("isOnInsertRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OldUpdatableResultSet.class.getDeclaredMethod("cancelRowChanges", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OldUpdatableResultSet.class.getDeclaredMethod("getInternalMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OldUpdatableResultSet.class.getDeclaredMethod("getColumnCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OldUpdatableResultSet.class.getDeclaredMethod("updateNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OldUpdatableResultSet.class.getDeclaredMethod("getObject", Integer.TYPE, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OldUpdatableResultSet.class.getDeclaredMethod("moveToCurrentRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OldUpdatableResultSet.class.getDeclaredMethod("moveToInsertRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OldUpdatableResultSet.class.getDeclaredMethod("cancelRowUpdates", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OldUpdatableResultSet.class.getDeclaredMethod("refreshRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OldUpdatableResultSet.class.getDeclaredMethod("deleteRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OldUpdatableResultSet.class.getDeclaredMethod("updateRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OldUpdatableResultSet.class.getDeclaredMethod("insertRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OldUpdatableResultSet.class.getDeclaredMethod("rowDeleted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OldUpdatableResultSet.class.getDeclaredMethod("rowInserted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OldUpdatableResultSet.class.getDeclaredMethod("rowUpdated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OldUpdatableResultSet.class.getDeclaredMethod("getCursorName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OldUpdatableResultSet.class.getDeclaredMethod("getConcurrency", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OldUpdatableResultSet.class.getDeclaredMethod("getType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OldUpdatableResultSet.class.getDeclaredMethod("getFetchSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OldUpdatableResultSet.class.getDeclaredMethod("setFetchSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OldUpdatableResultSet.class.getDeclaredMethod("getFetchDirection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OldUpdatableResultSet.class.getDeclaredMethod("setFetchDirection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OldUpdatableResultSet.class.getDeclaredMethod("findColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OldUpdatableResultSet.class.getDeclaredMethod("getMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OldUpdatableResultSet.class.getDeclaredMethod("cleanTempClobs", ArrayList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OldUpdatableResultSet.class.getDeclaredMethod("cleanTempBlobs", ArrayList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OldUpdatableResultSet.class.getDeclaredMethod("cleanTempLobs", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OldUpdatableResultSet.class.getDeclaredMethod("addToTempLobsToFree", Blob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OldUpdatableResultSet.class.getDeclaredMethod("addToTempLobsToFree", Clob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OldUpdatableResultSet.class.getDeclaredMethod("previous", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OldUpdatableResultSet.class.getDeclaredMethod("relative", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OldUpdatableResultSet.class.getDeclaredMethod("absolute", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OldUpdatableResultSet.class.getDeclaredMethod("getRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OldUpdatableResultSet.class.getDeclaredMethod("last", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OldUpdatableResultSet.class.getDeclaredMethod("first", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OldUpdatableResultSet.class.getDeclaredMethod("afterLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OldUpdatableResultSet.class.getDeclaredMethod("beforeFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OldUpdatableResultSet.class.getDeclaredMethod("isLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OldUpdatableResultSet.class.getDeclaredMethod("isFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OldUpdatableResultSet.class.getDeclaredMethod("isAfterLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OldUpdatableResultSet.class.getDeclaredMethod("isBeforeFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OldUpdatableResultSet.class.getDeclaredMethod("next", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OldUpdatableResultSet.class.getDeclaredMethod("getAuthorizationIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OldUpdatableResultSet.class.getDeclaredMethod("clearWarnings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OldUpdatableResultSet.class.getDeclaredMethod("getWarnings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OldUpdatableResultSet.class.getDeclaredMethod("getStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OldUpdatableResultSet.class.getDeclaredMethod("wasNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OldUpdatableResultSet.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OldUpdatableResultSet.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        _MIN_STREAM_SIZE = 4000;
    }
}

