/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.common;

public class MalformedURLException
extends Exception {
    private final String url;
    private final int errorIndex;

    public MalformedURLException(String s, String url, int errorIndex) {
        super(MalformedURLException.getErrorString(s, url, errorIndex));
        this.url = url;
        this.errorIndex = errorIndex < url.length() ? errorIndex : url.length() - 1;
    }

    public MalformedURLException(String s, String url, int errorIndex, Exception cause) {
        super(MalformedURLException.getErrorString(s, url, errorIndex));
        this.initCause(cause);
        this.url = url;
        this.errorIndex = errorIndex < url.length() ? errorIndex : url.length() - 1;
    }

    public MalformedURLException(String s) {
        super(s);
        this.url = null;
        this.errorIndex = -1;
    }

    public String getURL() {
        return this.url;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    private static String getErrorString(String msg, String url, int position) {
        position = position < url.length() ? position : url.length() - 1;
        StringBuilder errorStr = new StringBuilder();
        if (msg != null) {
            errorStr.append(msg);
        } else {
            errorStr.append("Invalid value '").append(url.charAt(position)).append("'");
        }
        errorStr.append(" at index ").append(position);
        return errorStr.toString();
    }
}

