/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;

public class ExecutionEventNotifier
implements Diagnosable {
    private static final String CLASS_NAME = ExecutionEventNotifier.class.getName();
    private TraceEventListener traceEventListener;
    private TraceEventListener.JdbcExecutionEvent event;
    private Object userContext;
    private List<Object> params = new ArrayList<Object>();

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    public ExecutionEventNotifier setTraceEventListener(TraceEventListener traceEventListener) {
        this.traceEventListener = traceEventListener;
        return this;
    }

    public ExecutionEventNotifier setJdbcExecutionEvent(TraceEventListener.JdbcExecutionEvent event) {
        this.event = event;
        return this;
    }

    public ExecutionEventNotifier setUserContext(Object userContext) {
        this.userContext = userContext;
        return this;
    }

    public ExecutionEventNotifier addParam(Object param) {
        this.params.add(param);
        return this;
    }

    public Object sendNotification() {
        try {
            if (this.traceEventListener != null && this.event != null && this.traceEventListener.isDesiredEvent(this.event)) {
                this.userContext = this.traceEventListener.onExecutionEventReceived(this.event, this.userContext, this.params.toArray());
                return this.userContext;
            }
        }
        catch (Exception ex) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "notify", "TraceEventListener threw an exception", null, ex);
        }
        return null;
    }
}

