/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.utils;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Enumeration;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.utils.WalletLocation;
import oracle.jdbc.internal.OpaqueString;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.SSLConfig;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleWallet;

public final class OracleWalletUtils {
    private static final String SECRET_STORE_CONNECT = "oracle.security.client.connect_string";
    private static final String SECRET_STORE_USERNAME = "oracle.security.client.username";
    private static final String SECRET_STORE_PASSWORD = "oracle.security.client.password";
    private static final String SECRET_STORE_DEFAULT_USERNAME = "oracle.security.client.default_username";
    private static final String SECRET_STORE_DEFAULT_PASSWORD = "oracle.security.client.default_password";
    private static final String CLASS_NAME = OracleWalletUtils.class.getName();

    private OracleWalletUtils() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SEPSCredentials getSecretStoreCredentials(String connectString, WalletLocation walletLocation, OpaqueString walletPassword) throws SQLException {
        SEPSCredentials sEPSCredentials;
        OracleWallet wallet;
        OpaqueString password;
        String username;
        block10: {
            username = null;
            password = null;
            if (walletLocation == null) {
                return null;
            }
            wallet = OracleWalletUtils.openWallet(walletLocation, walletPassword);
            if (wallet != null) break block10;
            SEPSCredentials sEPSCredentials2 = null;
            CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getSecretStoreCredentials", "Searched {0} for SEPS credentials keyed to connection string {1}. Found username? {2}. Found password? {3}.", (String)null, null, (Object)walletLocation, (Object)connectString, (Object)(username == null ? "NO" : "YES"), (Object)(OpaqueString.isNull(password) ? "NO" : "YES"));
            return sEPSCredentials2;
        }
        try {
            OracleSecretStore secretStore = wallet.getSecretStore();
            if (secretStore.containsAlias(SECRET_STORE_DEFAULT_USERNAME)) {
                username = new String(secretStore.getSecret(SECRET_STORE_DEFAULT_USERNAME));
            }
            if (secretStore.containsAlias(SECRET_STORE_DEFAULT_PASSWORD)) {
                password = OpaqueString.newOpaqueString(secretStore.getSecret(SECRET_STORE_DEFAULT_PASSWORD));
            }
            Enumeration list = secretStore.internalAliases();
            String alias = null;
            while (list.hasMoreElements()) {
                alias = (String)list.nextElement();
                if (!alias.startsWith(SECRET_STORE_CONNECT) || !connectString.equalsIgnoreCase(new String(secretStore.getSecret(alias)))) continue;
                String idx = alias.substring(SECRET_STORE_CONNECT.length());
                username = new String(secretStore.getSecret(SECRET_STORE_USERNAME + idx));
                password = OpaqueString.newOpaqueString(secretStore.getSecret(SECRET_STORE_PASSWORD + idx));
                break;
            }
            sEPSCredentials = new SEPSCredentials(username, password);
        }
        catch (NoClassDefFoundError classNotFoundException) {
            try {
                throw OracleWalletUtils.oraclePkiNotFound(classNotFoundException);
                catch (Exception exception) {
                    throw OracleWalletUtils.secretStoreError(walletLocation, exception);
                }
            }
            catch (Throwable throwable) {
                CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getSecretStoreCredentials", "Searched {0} for SEPS credentials keyed to connection string {1}. Found username? {2}. Found password? {3}.", (String)null, null, (Object)walletLocation, (Object)connectString, (Object)(username == null ? "NO" : "YES"), (Object)(OpaqueString.isNull(password) ? "NO" : "YES"));
                throw throwable;
            }
        }
        CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getSecretStoreCredentials", "Searched {0} for SEPS credentials keyed to connection string {1}. Found username? {2}. Found password? {3}.", (String)null, null, (Object)walletLocation, (Object)connectString, (Object)(username == null ? "NO" : "YES"), (Object)(OpaqueString.isNull(password) ? "NO" : "YES"));
        return sEPSCredentials;
    }

    public static OpaqueString getSecret(WalletLocation walletLocation, OpaqueString password, String secretName) throws SQLException {
        try {
            OracleWallet wallet = OracleWalletUtils.openWallet(walletLocation, password);
            if (wallet == null) {
                throw OracleWalletUtils.secretStoreError(walletLocation, null);
            }
            OracleSecretStore secretStore = wallet.getSecretStore();
            return OpaqueString.newOpaqueString(secretStore.getSecret(secretName));
        }
        catch (NoClassDefFoundError classNotFoundException) {
            throw OracleWalletUtils.oraclePkiNotFound(classNotFoundException);
        }
        catch (Exception exception) {
            throw OracleWalletUtils.secretStoreError(walletLocation, exception);
        }
    }

    public static OracleWallet openWallet(WalletLocation walletLocation, OpaqueString password) throws IOException {
        if (password == null) {
            password = OpaqueString.NULL;
        }
        OracleWallet wallet = new OracleWallet();
        if (walletLocation instanceof WalletLocation.DataURILocation) {
            String base64Wallet = ((WalletLocation.DataURILocation)walletLocation).opaqueUriString().map(clearText -> SSLConfig.extractBase64FromDataURI(new String((char[])clearText)));
            byte[] decodedWallet = Base64.getDecoder().decode(base64Wallet);
            password.peek(passwordChars -> wallet.setWalletArray(decodedWallet, passwordChars));
            return wallet;
        }
        String locationString = WalletLocation.switchExpression(walletLocation, WalletLocation.SystemLocation::systemString, WalletLocation.PathLocation::pathString, WalletLocation.FileURILocation::uriString, sqlNetLocation -> OracleWalletUtils.sqlNetLocationToURI(sqlNetLocation.sqlNetString()), null);
        if (!wallet.exists(locationString)) {
            return null;
        }
        password.peek(passwordChars -> wallet.open(locationString, passwordChars));
        return wallet;
    }

    private static String sqlNetLocationToURI(String walletLocation) throws NetException {
        return OracleWalletUtils.sqlNetLocationToURI(walletLocation, CommonDiagnosable.getInstance());
    }

    public static String sqlNetLocationToURI(String walletLocation, Diagnosable diagnosable) throws NetException {
        if (walletLocation.startsWith("(")) {
            return "file:" + OracleWalletUtils.parseWalletLocationDirectory(walletLocation, diagnosable);
        }
        return walletLocation;
    }

    public static String sqlNetLocationToUnixPath(String walletLocation, Diagnosable diagnosable) throws NetException {
        if (walletLocation.startsWith("(")) {
            return OracleWalletUtils.parseWalletLocationDirectory(walletLocation, diagnosable);
        }
        return walletLocation;
    }

    private static String parseWalletLocationDirectory(String walletLocation, Diagnosable diagnosable) throws NetException {
        try {
            NVNavigator nav = new NVNavigator();
            NVPair nvpWallet = new NVFactory().createNVPair(walletLocation);
            NVPair nvpMethod = nav.findNVPair(nvpWallet, "METHOD");
            NVPair nvpMethodData = nav.findNVPair(nvpWallet, "METHOD_DATA");
            NVPair nvpDirectory = nav.findNVPair(nvpMethodData, "DIRECTORY");
            String method = nvpMethod.getAtom();
            diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "processWalletLocation", "Wallet Parameter Configuration : Method {0}, Directory {1}", (String)null, null, (Object)method, (Object)nvpDirectory.getAtom());
            if (!method.equalsIgnoreCase("FILE")) {
                throw new NetException(17961, method);
            }
            return nvpDirectory.getAtom();
        }
        catch (Exception ex) {
            diagnosable.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "processWalletLocation", "Error in parsing wallet location {0}", (String)null, null, (Object)ex);
            throw (NetException)new NetException(17956).initCause(ex);
        }
    }

    private static SQLException oraclePkiNotFound(Throwable cause) {
        return (SQLException)DatabaseError.createSqlException(167, cause).fillInStackTrace();
    }

    private static SQLException secretStoreError(WalletLocation walletLocation, Exception cause) {
        String path;
        NetException suppressedException = null;
        if (walletLocation instanceof WalletLocation.SQLNetLocation) {
            String sqlNetString = ((WalletLocation.SQLNetLocation)walletLocation).sqlNetString();
            try {
                path = OracleWalletUtils.sqlNetLocationToURI(sqlNetString);
            }
            catch (NetException netException) {
                suppressedException = netException;
                path = sqlNetString;
            }
        } else {
            path = WalletLocation.switchExpression(walletLocation, WalletLocation.SystemLocation::systemString, WalletLocation.PathLocation::pathString, WalletLocation.FileURILocation::uriString, null, dataUriLocation -> "[Redacted Data URI]");
        }
        SQLException sqlException = DatabaseError.createSqlException(null, 168, path, (Throwable)cause);
        if (suppressedException != null) {
            sqlException.addSuppressed(suppressedException);
        }
        sqlException.fillInStackTrace();
        return sqlException;
    }

    public static final class SEPSCredentials {
        private final String username;
        private final OpaqueString password;

        public SEPSCredentials(String username, OpaqueString password) {
            this.username = username;
            this.password = password == null ? OpaqueString.NULL : password;
        }

        public String username() {
            return this.username;
        }

        public OpaqueString password() {
            return this.password;
        }
    }
}

