/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.driver.cli.AbstractCommand;
import oracle.jdbc.driver.cli.Command;
import oracle.jdbc.driver.cli.CommandContext;
import oracle.jdbc.driver.cli.CommandRegistry;
import oracle.jdbc.driver.cli.Option;

class DefaultCommand
extends AbstractCommand {
    private final CommandRegistry commandRegistry;

    public DefaultCommand(CommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getShortUsage() {
        return "Show the driver's version";
    }

    @Override
    public String getLongUsage() {
        return "";
    }

    @Override
    public List<Option> getExpectedOptions() {
        Option help = new Option("help", "h", "Show help message", false, 1);
        Option version = new Option("version", "v", "Show driver's version", false, 1);
        return Arrays.asList(help, version);
    }

    @Override
    public void execute(CommandContext context) {
        try {
            if (context.hasOption("help")) {
                this.printHelp(context.getCommandPrefix());
                return;
            }
            if (context.hasOption("version")) {
                System.out.print(OracleDriver.getDriverVersion() + "\n");
                return;
            }
            DefaultCommand.printBanner();
            OracleDriver.printBuildInfo();
            System.out.println("\nTry 'java -jar " + OracleDriver.getJarName() + " --help' for more information.");
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private static void printBanner() throws Exception {
        String resourcePathInJar = "/oracle/jdbc/banner.txt";
        try (InputStream stream = oracle.jdbc.driver.OracleDriver.class.getResourceAsStream("/oracle/jdbc/banner.txt");){
            if (stream != null) {
                int length;
                byte[] buffer = new byte[4096];
                while ((length = stream.read(buffer)) > 0) {
                    System.out.print("\n" + new String(buffer, 0, length, StandardCharsets.UTF_8));
                }
                System.out.print("========================================= ");
                if (System.console() != null) {
                    System.out.print("\u001b[31mv." + OracleDriver.getDriverVersion() + "\u001b[0m");
                } else {
                    System.out.print("v." + OracleDriver.getDriverVersion());
                }
                System.out.println(" =====\n");
            }
        }
    }

    void printHelp(String prefix) throws Exception {
        System.out.println("\nUsage: " + prefix + "[--version] [--help] [<command>] [<args>]");
        System.out.println("\nThese are common commands used in various situations:\n");
        List<Command> commandList = this.commandRegistry.getAllCommands();
        int maxCommandLength = commandList.stream().mapToInt(command -> command.getName().isEmpty() ? "<no command>".length() : command.getName().length()).max().orElse(0);
        StringBuilder output = new StringBuilder();
        for (Command command2 : commandList) {
            String commandName;
            String string = commandName = command2.getName().isEmpty() ? "<no command>" : command2.getName();
            if (System.console() != null) {
                output.append("\t\u001b[34m");
            }
            output.append(commandName);
            if (System.console() != null) {
                output.append("\u001b[0m");
            }
            int padding = maxCommandLength - commandName.length();
            for (int i = 0; i < padding + 5; ++i) {
                output.append(" ");
            }
            output.append(command2.getShortUsage()).append("\n");
        }
        System.out.print(output.toString());
    }
}

