/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;

public final class OsonBuffer {
    final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    final ByteBuffer buffer;
    char[] charBuffer;
    public Map<Integer, String> cache = new HashMap<Integer, String>();

    public OsonBuffer(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer = byteBuffer;
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public int position() {
        return this.buffer.position();
    }

    public void position(int n2) {
        this.buffer.position(n2);
    }

    public int getUB1() {
        return 0xFF & this.buffer.get();
    }

    public int getUB1(int n2) {
        return 0xFF & this.buffer.get(n2);
    }

    public int getUB2() {
        return 0xFFFF & this.buffer.getShort();
    }

    public short getShort(int n2) {
        return this.buffer.getShort(n2);
    }

    public int getUB2(int n2) {
        return 0xFFFF & this.buffer.getShort(n2);
    }

    public String readString(int n2) {
        if (!this.buffer.hasArray()) {
            throw new UnsupportedOperationException();
        }
        byte[] byArray = this.buffer.array();
        if (this.charBuffer == null || this.charBuffer.length < n2) {
            this.charBuffer = new char[n2];
        }
        int n3 = this.buffer.position() + this.buffer.arrayOffset();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray[i2 + n3];
            if (by < 0) {
                String string = new String(this.buffer.array(), this.buffer.position() + this.buffer.arrayOffset(), n2, StandardCharsets.UTF_8);
                this.buffer.position(n3 + n2);
                return string;
            }
            this.charBuffer[i2] = (char)by;
        }
        this.buffer.position(n3 + n2);
        return new String(this.charBuffer, 0, n2);
    }

    public void readBytes(OutputStream outputStream, int n2) throws IOException {
        if (!this.buffer.hasArray()) {
            throw new UnsupportedOperationException();
        }
        int n3 = this.buffer.position() + this.buffer.arrayOffset();
        outputStream.write(this.buffer.array(), n3, n2);
    }

    public int getUB4int() {
        int n2 = this.buffer.getInt();
        if (n2 < 0) {
            throw OracleJsonExceptions.OVERFLOW.create(null, n2);
        }
        return n2;
    }

    public int getUB4int(int n2) {
        int n3 = this.buffer.getInt(n2);
        if (n3 < 0) {
            throw OracleJsonExceptions.OVERFLOW.create(null, n3);
        }
        return n3;
    }

    public int getInt(int n2) {
        return this.buffer.getInt(n2);
    }

    public void get(byte[] byArray) {
        this.buffer.get(byArray);
    }

    public double readDtyDouble() {
        byte[] byArray = new byte[8];
        this.buffer.get(byArray);
        return OsonPrimitiveConversions.canonicalFormatBytesToDouble(byArray);
    }

    public float readDtyFloat() {
        byte[] byArray = new byte[4];
        this.buffer.get(byArray);
        return OsonPrimitiveConversions.canonicalFormatBytesToFloat(byArray);
    }

    int binarySearchUb1(int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n3 - 1;
        byte[] byArray = this.buffer.array();
        while (n5 <= n6) {
            int n7 = n5 + n6 >>> 1;
            int n8 = byArray[n2 + n7] & 0xFF;
            if (n8 < n4) {
                n5 = n7 + 1;
                continue;
            }
            if (n8 > n4) {
                n6 = n7 - 1;
                continue;
            }
            return n7;
        }
        return -1;
    }

    int binarySearchUb2(int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n3 - 1;
        while (n5 <= n6) {
            int n7 = n5 + n6 >>> 1;
            int n8 = this.getUB2(n2 + n7 * 2);
            if (n8 < n4) {
                n5 = n7 + 1;
                continue;
            }
            if (n8 > n4) {
                n6 = n7 - 1;
                continue;
            }
            return n7;
        }
        return -1;
    }

    int binarySearchUb4(int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n3 - 1;
        while (n5 <= n6) {
            int n7 = n5 + n6 >>> 1;
            int n8 = this.getUB4int(n2 + n7 * 4);
            if (n8 < n4) {
                n5 = n7 + 1;
                continue;
            }
            if (n8 > n4) {
                n6 = n7 - 1;
                continue;
            }
            return n7;
        }
        return -1;
    }

    public int linearSearchUb1(int n2, int n3, int n4) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (this.getUB1(i2) != n4) continue;
            return i2 - n2;
        }
        return -1;
    }

    int linearSearchUb2(int n2, int n3, int n4) {
        int n5 = n2 + n3 * 2;
        for (int i2 = n2; i2 < n5; i2 += 2) {
            if (this.getUB2(i2) != n4) continue;
            return (i2 - n2) / 2;
        }
        return -1;
    }

    public int linearSearchUb4(int n2, int n3, int n4) {
        int n5 = n2 + n3 * 4;
        for (int i2 = n2; i2 < n5; i2 += 4) {
            if (this.getUB4int(i2) != n4) continue;
            return (i2 - n2) / 4;
        }
        return -1;
    }
}

