/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.AttributeDescriptor;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

public class StructDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Struct,
Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public static StructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(string, connection, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructDescriptor createDescriptor(String string, Connection connection, boolean bl, boolean bl2) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 60Invalid arguments");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 60, "Invalid arguments");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor(sQLName, connection, bl, bl2);
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl, boolean bl2) throws SQLException {
        String string = sQLName.getName();
        StructDescriptor structDescriptor = null;
        if (!bl2 && (structDescriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string)) == null) {
            structDescriptor = new StructDescriptor(sQLName, connection);
            if (bl) {
                structDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(sQLName, connection, false, false);
    }

    public static StructDescriptor createDescriptor(OracleTypeADT oracleTypeADT) throws SQLException {
        String string = oracleTypeADT.getFullName();
        OracleConnection oracleConnection = oracleTypeADT.getConnection();
        StructDescriptor structDescriptor = (StructDescriptor)oracleConnection.getDescriptor(string);
        if (structDescriptor == null) {
            SQLName sQLName = new SQLName(oracleTypeADT.getSchemaName(), oracleTypeADT.getSimpleName(), oracleTypeADT.getConnection());
            structDescriptor = new StructDescriptor(sQLName, oracleTypeADT, (Connection)oracleConnection);
            oracleConnection.putDescriptor(string, (Object)structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        OracleTypeADT oracleTypeADT = new OracleTypeADT(sQLName, byArray, n2, byArray2, oracleConnection);
        return new StructDescriptor(sQLName, oracleTypeADT, (Connection)oracleConnection);
    }

    public StructDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super((short)108, oracleTypeADT, connection);
    }

    public StructDescriptor(String string, Connection connection) throws SQLException {
        super((short)108, string, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super((short)108, sQLName, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super((short)108, sQLName, oracleTypeADT, connection);
        this.toid = oracleTypeADT.getTOID();
    }

    StructDescriptor(byte[] byArray, int n2, Connection connection) throws SQLException {
        super((short)108);
        this.toid = byArray;
        this.toidVersion = n2;
        this.setPhysicalConnectionOf(connection);
        this.initPickler();
    }

    StructDescriptor(AttributeDescriptor[] attributeDescriptorArray, Connection connection) throws SQLException {
        super((short)108);
        this.attributesDescriptor = attributeDescriptorArray;
        this.setPhysicalConnectionOf(connection);
        this.isTransient = true;
        this.initPickler();
        this.isInstanciable = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPickler() throws SQLException {
        try {
            if (this.isTransient) {
                this.pickler = new OracleTypeADT(this.attributesDescriptor, this.connection);
            } else {
                this.pickler = new OracleTypeADT(this.getName(), (Connection)this.connection);
                ((OracleTypeADT)this.pickler).init(this.connection);
                this.toid = ((OracleTypeADT)this.pickler).getTOID();
            }
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 60 + "Unable to resolve type \"" + this.getName() + "\"");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"" + this.getName() + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleTypeMetaData.Kind getKind() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)OracleTypeMetaData.Kind.STRUCT));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleTypeMetaData.Kind kind = OracleTypeMetaData.Kind.STRUCT;
            return kind;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTypeCode() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.getOracleTypeADT().getTypeCode();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTypeVersion() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.getOracleTypeADT().getTypeVersion();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void setAttributesDescriptor(AttributeDescriptor[] attributeDescriptorArray) {
        this.attributesDescriptor = attributeDescriptorArray;
    }

    public AttributeDescriptor[] getAttributesDescriptor() {
        return this.attributesDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] toBytes(STRUCT sTRUCT, boolean bl) throws SQLException {
        byte[] byArray = sTRUCT.shareBytes();
        if (byArray == null) {
            if (sTRUCT.datumArray != null) {
                byArray = this.pickler.linearize(sTRUCT);
                if (bl) return byArray;
                sTRUCT.setShareBytes(null);
                return byArray;
            }
            if (sTRUCT.objectArray != null) {
                sTRUCT.datumArray = this.toOracleArray(sTRUCT.objectArray);
                byArray = this.pickler.linearize(sTRUCT);
                if (bl) return byArray;
                sTRUCT.datumArray = null;
                sTRUCT.setShareBytes(null);
                return byArray;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (sTRUCT.imageLength == 0L) return byArray;
        if (sTRUCT.imageOffset == 0L) {
            if (sTRUCT.imageLength == (long)byArray.length) return byArray;
        }
        byte[] byArray2 = new byte[(int)sTRUCT.imageLength];
        System.arraycopy(byArray, (int)sTRUCT.imageOffset, byArray2, 0, (int)sTRUCT.imageLength);
        sTRUCT.setImage(byArray2, 0L, 0L);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum[] toOracleArray(STRUCT sTRUCT, boolean bl) throws SQLException {
        Datum[] datumArray = sTRUCT.datumArray;
        Datum[] datumArray2 = null;
        if (datumArray == null) {
            if (sTRUCT.objectArray != null) {
                datumArray = this.toOracleArray(sTRUCT.objectArray);
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                    this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                }
                this.pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.imageOffset, sTRUCT, 1, null);
                datumArray = sTRUCT.datumArray;
                if (!bl) {
                    sTRUCT.datumArray = null;
                }
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (bl) {
            sTRUCT.datumArray = datumArray;
            datumArray2 = (Datum[])datumArray.clone();
        } else {
            datumArray2 = datumArray;
        }
        return datumArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object[] toArray(STRUCT sTRUCT, Map map, boolean bl) throws SQLException {
        Object[] objectArray = null;
        if (sTRUCT.objectArray != null) return (Object[])sTRUCT.objectArray.clone();
        if (sTRUCT.datumArray != null) {
            objectArray = new Object[sTRUCT.datumArray.length];
            int n2 = 0;
            while (n2 < sTRUCT.datumArray.length) {
                if (sTRUCT.datumArray[n2] != null) {
                    objectArray[n2] = sTRUCT.datumArray[n2] instanceof STRUCT ? ((STRUCT)sTRUCT.datumArray[n2]).toJdbc(map) : sTRUCT.datumArray[n2].toJdbc();
                }
                ++n2;
            }
            return objectArray;
        }
        if (sTRUCT.shareBytes() != null) {
            if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
            }
        } else {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.imageOffset, sTRUCT, 2, map);
        objectArray = sTRUCT.objectArray;
        sTRUCT.objectArray = null;
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLength() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.getFieldTypes().length;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public OracleTypeADT getOracleTypeADT() throws SQLException {
        if (this.pickler == null) {
            this.initPickler();
        }
        OracleTypeADT oracleTypeADT = (OracleTypeADT)this.pickler;
        return oracleTypeADT;
    }

    private OracleType[] getFieldTypes() throws SQLException {
        return ((OracleTypeADT)this.pickler).getAttrTypes();
    }

    public SQLInput toJdbc2SQLInput(STRUCT sTRUCT, Map map) throws SQLException {
        return new OracleJdbc2SQLInput(this.toOracleArray(sTRUCT, false), map, this.connection);
    }

    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        return new OracleSQLOutput(this, this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toOracleArray(Object[] objectArray) throws SQLException {
        Datum[] datumArray = null;
        if (objectArray != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n2 = oracleTypeArray.length;
            if (objectArray.length != n2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 49 + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            datumArray = new Datum[n2];
            OracleConnection oracleConnection = this.connection;
            for (int i2 = 0; i2 < n2; ++i2) {
                datumArray[i2] = oracleTypeArray[i2].toDatum(objectArray[i2], oracleConnection);
            }
        }
        return datumArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toOracleArray(Map map) throws SQLException {
        Datum[] datumArray = null;
        int n2 = 0;
        if (map != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n3 = oracleTypeArray.length;
            int n4 = map.size();
            datumArray = new Datum[n3];
            OracleConnection oracleConnection = this.connection;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object v = map.get(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1));
                datumArray[i2] = oracleTypeArray[i2].toDatum(v, oracleConnection);
                if (v == null && !map.containsKey(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1))) continue;
                ++n2;
            }
            if (n2 < n4) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return datumArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSetMetaData resultSetMetaData = this.connection.newStructMetaData(this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + resultSetMetaData);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSetMetaData resultSetMetaData2 = resultSetMetaData;
            return resultSetMetaData2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinalType() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.getOracleTypeADT().isFinalType();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubtype() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.getOracleTypeADT().isSubType();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public boolean isInHierarchyOf(String string) throws SQLException {
        StructDescriptor structDescriptor = this;
        String string2 = structDescriptor.getName();
        boolean bl = false;
        if (string.equals(string2)) {
            bl = true;
        } else {
            while (true) {
                if ((string2 = structDescriptor.getSupertypeName()) == null) {
                    bl = false;
                    break;
                }
                if (string.equals(string2)) {
                    bl = true;
                    break;
                }
                structDescriptor = StructDescriptor.createDescriptor(string2, (Connection)this.connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInstantiable() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.isInstanciable == null) {
                this.isInstanciable = this.getOracleTypeADT().isInstanciable();
            }
            boolean bl = this.isInstanciable;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaObject() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.getOracleTypeADT().isJavaObject();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSupertypeName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            if (this.isSubtype()) {
                if (this.supertype == null) {
                    this.supertype = this.getOracleTypeADT().getSuperTypeName();
                }
                string = this.supertype;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocalAttributeCount() throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isSubtype()) {
                n2 = this.getOracleTypeADT().getAttrTypes().length;
            } else {
                if (this.numLocalAttrs == -1) {
                    this.numLocalAttrs = this.getOracleTypeADT().getNumberOfLocalAttributes();
                }
                n2 = this.numLocalAttrs;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSubtypeNames() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.subtypes == null) {
                this.subtypes = this.getOracleTypeADT().getSubtypeNames();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.subtypes);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String[] stringArray = this.subtypes;
            return stringArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavaClassName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            if (this.isJavaObject()) {
                string = StructDescriptor.getJavaObjectClassName(this.connection, this);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public String getAttributeJavaName(int n2) throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            string = this.attrJavaNames[n2];
        }
        return string;
    }

    public String[] getAttributeJavaNames() throws SQLException {
        String[] stringArray = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            stringArray = this.attrJavaNames;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLanguage() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            string = this.isJavaObject() ? "JAVA" : "SQL";
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public Class getClass(Map map) throws SQLException {
        String string = this.getName();
        Class clazz = this.connection.getClassForType(string, map);
        String string2 = this.getSchemaName();
        String string3 = this.getTypeName();
        if (clazz == null) {
            clazz = (Class)map.get(string3);
        }
        if (SQLName.s_parseAllFormat) {
            if (clazz == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(string2)) {
                clazz = (Class)map.get("\"" + string3 + "\"");
            }
            if (clazz == null) {
                clazz = (Class)map.get("\"" + string2 + "\"" + "." + "\"" + string3 + "\"");
            }
            if (clazz == null) {
                clazz = (Class)map.get("\"" + string2 + "\"" + "." + string3);
            }
            if (clazz == null) {
                clazz = (Class)map.get(string2 + "." + "\"" + string3 + "\"");
            }
        }
        return clazz;
    }

    public static String getJavaObjectClassName(Connection connection, StructDescriptor structDescriptor) throws SQLException {
        return StructDescriptor.getJavaObjectClassName(connection, structDescriptor.getSchemaName(), structDescriptor.getTypeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaObjectClassName(Connection connection, String string, String string2) throws SQLException {
        String string3;
        block12: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            string3 = null;
            try {
                preparedStatement = connection.prepareStatement("select external_name from all_sqlj_types where owner = :1 and type_name = :2");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string3 = resultSet.getString(1);
                    break block12;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        StructDescriptor.logger().log(Level.SEVERE, "         Throwing SQLException: 100");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(null, 100);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String descType() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.descType(stringBuffer, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    StructDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("Subtype=" + this.getOracleTypeADT().isSubType());
        stringBuffer.append(" JavaObject=" + this.getOracleTypeADT().isJavaObject());
        stringBuffer.append(" FinalType=" + this.getOracleTypeADT().isFinalType());
        stringBuffer.append("\n");
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        for (int i3 = 0; i3 < n3; ++i3) {
            TypeDescriptor typeDescriptor;
            int n4 = resultSetMetaData.getColumnType(i3 + 1);
            if (n4 == 2002 || n4 == 2008) {
                typeDescriptor = StructDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((StructDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            if (n4 == 2003) {
                typeDescriptor = ArrayDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((ArrayDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            if (n4 == 2007) {
                typeDescriptor = OpaqueDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((OpaqueDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append(resultSetMetaData.getColumnTypeName(i3 + 1));
            stringBuffer.append("\n");
        }
        return stringBuffer.substring(0, stringBuffer.length());
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toOracleArray(objectArray);
        return this.toBytes(datumArray);
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, (byte[])null, this.connection);
        sTRUCT.setDatumArray(datumArray);
        return this.pickler.linearize(sTRUCT);
    }

    public Datum[] toArray(Object[] objectArray) throws SQLException {
        return this.toOracleArray(objectArray);
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, byArray, this.connection);
        return this.toOracleArray(sTRUCT, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData3() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            if (this.attrJavaNames == null) {
                String[] stringArray = null;
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = this.connection.prepareStatement("select EXTERNAL_ATTR_NAME from all_sqlj_type_attrs where owner = :1 and type_name = :2");
                    preparedStatement.setString(1, this.getSchemaName());
                    preparedStatement.setString(2, this.getTypeName());
                    resultSet = preparedStatement.executeQuery();
                    stringArray = new String[this.getOracleTypeADT().getAttrTypes().length];
                    int n2 = 0;
                    while (resultSet.next()) {
                        stringArray[n2] = resultSet.getString(1);
                        ++n2;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                this.attrJavaNames = stringArray;
            }
        }
    }

    @Override
    String tagName() {
        return "StructDescriptor";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.StructDescriptor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

