/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Wrapper;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

public class OracleDataSource
implements DataSource,
Serializable,
Referenceable {
    static final long serialVersionUID = 3349652938965166731L;
    protected static int unnamedInstanceCount = 0;
    protected static final String DMS_ROOT_NAME = "JDBC";
    protected static final String DMS_DEFAULT_DATASOURCE_NAME = "OracleDataSource";
    protected PrintWriter logWriter = null;
    protected int loginTimeout = 0;
    protected String databaseName = null;
    protected String serviceName = null;
    protected String dataSourceName = "OracleDataSource";
    protected String description = null;
    protected String networkProtocol = "tcp";
    protected int portNumber = 0;
    protected String user = null;
    protected String password = null;
    protected String serverName = null;
    protected String url = null;
    protected String driverType = null;
    protected String tnsEntry = null;
    protected int maxStatements = 0;
    protected boolean implicitCachingEnabled = false;
    protected boolean explicitCachingEnabled = false;
    protected transient OracleImplicitConnectionCache odsCache = null;
    protected transient OracleConnectionCacheManager cacheManager = null;
    protected String connCacheName = null;
    protected Properties connCacheProperties = null;
    protected Properties connectionProperties = null;
    protected boolean connCachingEnabled = false;
    protected boolean fastConnFailover = false;
    protected String onsConfigStr = null;
    public boolean isOracleDataSource = true;
    private static final boolean fastConnectionFailoverSysProperty = "true".equalsIgnoreCase(OracleDriver.getSystemPropertyFastConnectionFailover("false"));
    private boolean urlExplicit = false;
    private boolean useDefaultConnection = false;
    protected transient OracleDriver driver = new OracleDriver();
    private static final String spawnNewThreadToCancelProperty = "oracle.jdbc.spawnNewThreadToCancel";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    protected static String dms_data_source_type() {
        return "JDBC_DataSource";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleDataSource() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.processFastConnectionFailoverSysProperty();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void processFastConnectionFailoverSysProperty() {
        if (this.isOracleDataSource && fastConnectionFailoverSysProperty) {
            this.connCachingEnabled = true;
            if (this.cacheManager == null) {
                try {
                    this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.fastConnFailover = true;
            this.setSpawnNewThreadToCancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            String string2 = null;
            Wrapper wrapper = this;
            synchronized (wrapper) {
                string = this.user;
                string2 = this.password;
            }
            wrapper = this.getConnection(string, string2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + wrapper);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Wrapper wrapper2 = wrapper;
            return wrapper2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = null;
            Properties properties = null;
            if (this.connCachingEnabled) {
                connection = this.getConnection(string, string2, null);
            } else {
                object = this;
                synchronized (object) {
                    this.makeURL();
                    Properties properties2 = properties = this.connectionProperties == null ? new Properties() : (Properties)this.connectionProperties.clone();
                    if (this.url != null) {
                        properties.setProperty("connection_url", this.url);
                    }
                    if (string != null) {
                        properties.setProperty("user", string);
                    }
                    if (string2 != null) {
                        properties.setProperty("password", string2);
                    }
                    if (this.loginTimeout != 0) {
                        properties.setProperty("LoginTimeout", "" + this.loginTimeout);
                    }
                    if (this.maxStatements != 0) {
                        properties.setProperty("stmt_cache_size", "" + this.maxStatements);
                    }
                }
                connection = this.getPhysicalConnection(properties);
                if (connection == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleDataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
                    ((Throwable)object).fillInStackTrace();
                    throw object;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + connection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = connection;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getPhysicalConnection(Properties properties) throws SQLException {
        Connection connection = null;
        Properties properties2 = properties;
        String string = properties.getProperty("connection_url");
        String string2 = properties.getProperty("user");
        String string3 = properties2.getProperty("password");
        String string4 = null;
        boolean bl = false;
        Serializable serializable = this;
        synchronized (serializable) {
            String string5;
            if (this.connectionProperties != null) {
                properties2 = (Properties)this.connectionProperties.clone();
                if (string2 != null) {
                    properties2.put("user", string2);
                }
                if (string3 != null) {
                    properties2.put("password", string3);
                }
            }
            if (string2 == null && this.user != null) {
                properties2.put("user", this.user);
            }
            if (string3 == null && this.password != null) {
                properties2.put("password", this.password);
            }
            if (string == null) {
                string = this.url;
            }
            if ((string5 = properties.getProperty("LoginTimeout")) != null) {
                properties2.put("oracle.net.CONNECT_TIMEOUT", "" + Integer.parseInt(string5) * 1000);
            }
            bl = this.useDefaultConnection;
            if (this.driver == null) {
                this.driver = new OracleDriver();
            }
            String string6 = this.dataSourceName == null || this.dataSourceName.length() == 0 ? "OracleDataSource_" + unnamedInstanceCount++ : this.dataSourceName;
            properties2.setProperty("DMSName", string6);
            properties2.setProperty("DMSType", OracleDataSource.dms_data_source_type());
        }
        connection = bl ? this.driver.defaultConnection() : this.driver.connect(string, properties2);
        if (connection == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            serializable = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
            ((Throwable)serializable).fillInStackTrace();
            throw serializable;
        }
        string4 = properties.getProperty("stmt_cache_size");
        int n2 = 0;
        if (string4 != null) {
            n2 = Integer.parseInt(string4);
            ((OracleConnection)connection).setStatementCacheSize(n2);
        }
        boolean bl2 = false;
        string4 = properties.getProperty("ExplicitStatementCachingEnabled");
        if (string4 != null) {
            bl2 = string4.equals("true");
            ((OracleConnection)connection).setExplicitCachingEnabled(bl2);
        }
        boolean bl3 = false;
        string4 = properties.getProperty("ImplicitStatementCachingEnabled");
        if (string4 != null) {
            bl3 = string4.equals("true");
            ((OracleConnection)connection).setImplicitCachingEnabled(bl3);
        }
        if (n2 > 0 && !bl2 && !bl3) {
            ((OracleConnection)connection).setImplicitCachingEnabled(true);
            ((OracleConnection)connection).setExplicitCachingEnabled(true);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(Properties properties) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(properties));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            String string2 = null;
            Wrapper wrapper = this;
            synchronized (wrapper) {
                if (!this.connCachingEnabled) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleDataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 137);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                string = this.user;
                string2 = this.password;
            }
            wrapper = this.getConnection(string, string2, properties);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + wrapper);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Wrapper wrapper2 = wrapper;
            return wrapper2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2) + ", " + OracleLog.argument(properties));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.connCachingEnabled) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 137);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.odsCache == null) {
                this.cacheInitialize();
            }
            Connection connection = this.odsCache.getConnection(string, string2, properties);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + connection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private synchronized void cacheInitialize() throws SQLException {
        if (this.odsCache == null) {
            if (this.connCacheName != null) {
                this.cacheManager.createCache(this.connCacheName, this, this.connCacheProperties);
            } else {
                this.connCacheName = this.cacheManager.createCache(this, this.connCacheProperties);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.connCachingEnabled && this.odsCache != null) {
                this.cacheManager.removeCache(this.odsCache.cacheName, 0L);
                this.odsCache = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnectionCachingEnabled(boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.isOracleDataSource) {
                if (bl) {
                    this.connCachingEnabled = true;
                    if (this.cacheManager == null) {
                        this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                    }
                } else if (this.odsCache == null) {
                    this.connCachingEnabled = false;
                    this.fastConnFailover = false;
                    this.setSpawnNewThreadToCancel(false);
                    this.connCacheName = null;
                    this.connCacheProperties = null;
                }
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 137);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConnectionCachingEnabled() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connCachingEnabled);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.connCachingEnabled;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnectionCacheName(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (string == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 138);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 138);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.connCacheName = string;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionCacheName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.connCachingEnabled && this.odsCache != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.odsCache.cacheName);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = this.odsCache.cacheName;
                return string;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connCacheName);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.connCacheName;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnectionCacheProperties(Properties properties) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(properties));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.connCacheProperties = properties;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getConnectionCacheProperties() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.connCachingEnabled && this.odsCache != null) {
                Properties properties = this.odsCache.getConnectionCacheProperties();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + properties);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Properties properties2 = properties;
                return properties2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connCacheProperties);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Properties properties = this.connCacheProperties;
            return properties;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFastConnectionFailoverEnabled(boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.fastConnFailover) {
                this.fastConnFailover = bl;
                this.setSpawnNewThreadToCancel(bl);
            } else if (!bl) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 255);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 255);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFastConnectionFailoverEnabled() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.fastConnFailover);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.fastConnFailover;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getONSConfiguration() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.onsConfigStr);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.onsConfigStr;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setONSConfiguration(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.onsConfigStr = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getLoginTimeout() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.loginTimeout);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.loginTimeout;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setLoginTimeout(int n2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.loginTimeout = n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setLogWriter(PrintWriter printWriter) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(printWriter));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.logWriter = printWriter;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PrintWriter getLogWriter() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.logWriter);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PrintWriter printWriter = this.logWriter;
            return printWriter;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTNSEntryName(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.tnsEntry = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getTNSEntryName() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.tnsEntry);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.tnsEntry;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDataSourceName(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.dataSourceName = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getDataSourceName() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.dataSourceName);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.dataSourceName;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getDatabaseName() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.databaseName);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.databaseName;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDatabaseName(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.databaseName = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setServiceName(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.serviceName = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getServiceName() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.serviceName);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.serviceName;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setServerName(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.serverName = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getServerName() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.serverName);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.serverName;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setURL(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.url = string;
            if (this.url != null) {
                this.urlExplicit = true;
            }
            if (this.connCachingEnabled && this.odsCache != null && this.odsCache.connectionPoolDS != null) {
                this.odsCache.connectionPoolDS.url = string;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getURL() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.urlExplicit) {
                this.makeURL();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.url);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.url;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setUser(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.user = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUser() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.user);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.user;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPassword(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.password = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    protected String getPassword() {
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getDescription() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.description);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.description;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDescription(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.description = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getDriverType() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.driverType);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.driverType;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDriverType(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.driverType = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getNetworkProtocol() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.networkProtocol);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.networkProtocol;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNetworkProtocol(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.networkProtocol = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPortNumber(int n2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.portNumber = n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getPortNumber() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.portNumber);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.portNumber;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Reference getReference() throws NamingException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
            this.addRefProperties(reference);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reference);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reference reference2 = reference;
            return reference2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    protected void addRefProperties(Reference reference) {
        if (this.url != null) {
            reference.add(new StringRefAddr("url", this.url));
        }
        if (this.user != null) {
            reference.add(new StringRefAddr("userName", this.user));
        }
        if (this.password != null) {
            reference.add(new StringRefAddr("passWord", this.password));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description));
        }
        if (this.driverType != null) {
            reference.add(new StringRefAddr("driverType", this.driverType));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.serviceName != null) {
            reference.add(new StringRefAddr("serviceName", this.serviceName));
        }
        if (this.networkProtocol != null) {
            reference.add(new StringRefAddr("networkProtocol", this.networkProtocol));
        }
        if (this.portNumber != 0) {
            reference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        }
        if (this.tnsEntry != null) {
            reference.add(new StringRefAddr("tnsentryname", this.tnsEntry));
        }
        if (this.maxStatements != 0) {
            reference.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
        }
        if (this.implicitCachingEnabled) {
            reference.add(new StringRefAddr("implicitCachingEnabled", "true"));
        }
        if (this.explicitCachingEnabled) {
            reference.add(new StringRefAddr("explicitCachingEnabled", "true"));
        }
        if (this.connCachingEnabled) {
            reference.add(new StringRefAddr("connectionCachingEnabled", "true"));
        }
        if (this.connCacheName != null) {
            reference.add(new StringRefAddr("connectionCacheName", this.connCacheName));
        }
        if (this.connCacheProperties != null) {
            reference.add(new StringRefAddr("connectionCacheProperties", this.connCacheProperties.toString()));
        }
        if (this.fastConnFailover) {
            reference.add(new StringRefAddr("fastConnectionFailoverEnabled", "true"));
        }
        if (this.onsConfigStr != null) {
            reference.add(new StringRefAddr("onsConfigStr", this.onsConfigStr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeURL() throws SQLException {
        if (this.urlExplicit) {
            return;
        }
        if (this.driverType == null || !this.driverType.equals("oci8") && !this.driverType.equals("oci") && !this.driverType.equals("thin") && !this.driverType.equals("kprb")) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67 + "OracleDataSource.makeURL");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67, "OracleDataSource.makeURL");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.driverType.equals("kprb")) {
            this.useDefaultConnection = true;
            this.url = "jdbc:oracle:kprb:@";
            return;
        }
        if ((this.driverType.equals("oci8") || this.driverType.equals("oci")) && this.networkProtocol != null && this.networkProtocol.equals("ipc")) {
            this.url = "jdbc:oracle:oci:@";
            return;
        }
        if (this.tnsEntry != null) {
            this.url = "jdbc:oracle:" + this.driverType + ":@" + this.tnsEntry;
            return;
        }
        if (this.serviceName != null) {
            this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")))";
        } else {
            this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SID=" + this.databaseName + ")))";
            DatabaseError.addSqlWarning(null, new SQLWarning("URL with SID jdbc:subprotocol:@host:port:sid will be deprecated in 10i\nPlease use URL with SERVICE_NAME as jdbc:subprotocol:@//host:port/service_name"));
            if (this.fastConnFailover) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleDataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67 + "OracleDataSource.makeURL");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67, "OracleDataSource.makeURL");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    protected void trace(String string) {
        if (this.logWriter != null) {
            // empty if block
        }
    }

    protected void copy(OracleDataSource oracleDataSource) throws SQLException {
        oracleDataSource.setUser(this.user);
        oracleDataSource.setPassword(this.password);
        oracleDataSource.setTNSEntryName(this.tnsEntry);
        this.makeURL();
        oracleDataSource.setURL(this.url);
        if (this.loginTimeout > 0) {
            oracleDataSource.setLoginTimeout(this.loginTimeout);
        }
        oracleDataSource.connectionProperties = this.connectionProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxStatements(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.maxStatements = n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxStatements() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.maxStatements);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.maxStatements;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.implicitCachingEnabled = bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getImplicitCachingEnabled() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.implicitCachingEnabled);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.implicitCachingEnabled;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.explicitCachingEnabled = bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getExplicitCachingEnabled() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.explicitCachingEnabled);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.explicitCachingEnabled;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionProperties(Properties properties) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(properties));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.connectionProperties = properties == null ? properties : (Properties)properties.clone();
            this.setSpawnNewThreadToCancel(this.fastConnFailover);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getConnectionProperties() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Properties properties = OracleDataSource.filterConnectionProperties(this.connectionProperties);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + properties);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static final Properties filterConnectionProperties(Properties properties) {
        Properties properties2 = null;
        if (properties != null) {
            properties2 = (Properties)properties.clone();
            Enumeration<?> enumeration = properties2.propertyNames();
            Object var3_3 = null;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null || !string.matches(".*[P,p][A,a][S,s][S,s][W,w][O,o][R,r][D,d].*")) continue;
                properties2.remove(string);
            }
            properties.remove(spawnNewThreadToCancelProperty);
        }
        return properties2;
    }

    private void setSpawnNewThreadToCancel(boolean bl) {
        if (bl) {
            if (this.connectionProperties == null) {
                this.connectionProperties = new Properties();
            }
            this.connectionProperties.setProperty(spawnNewThreadToCancelProperty, "true");
        } else if (this.connectionProperties != null) {
            this.connectionProperties.remove(spawnNewThreadToCancelProperty);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        objectInputStream.defaultReadObject();
        if (this.connCachingEnabled) {
            this.setConnectionCachingEnabled(this.connCachingEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (clazz.isInterface()) {
                boolean bl = clazz.isInstance(this);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 177);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (clazz.isInterface() && clazz.isInstance(this)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleDataSource oracleDataSource = this;
                return (T)oracleDataSource;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 177);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleDataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

