/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.CharCommonAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.sql.ROWID;

class VarcharAccessor
extends CharCommonAccessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    VarcharAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        int n4 = 4000;
        if (oracleStatement.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK) {
            n4 = oracleStatement.connection.plsqlVarcharParameter4KOnly ? 4000 : 32766;
        }
        this.init(oracleStatement, 1, 9, n2, s2, n3, bl, n4, 2000);
    }

    VarcharAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        int n8 = 4000;
        if (oracleStatement.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK) {
            n8 = oracleStatement.connection.plsqlVarcharParameter4KOnly ? 4000 : 32766;
        }
        this.init(oracleStatement, 1, 9, n2, bl, n3, n4, n5, n6, n7, s2, n8, 2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ROWID getROWID(int n2) throws SQLException {
        byte[] byArray;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    VarcharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        ROWID rOWID = null;
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1 && (byArray = this.getBytesInternal(n2)) != null) {
            rOWID = new ROWID(byArray);
        }
        return rOWID;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.VarcharAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

