/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.Datum;

class OracleBlobInputStream
extends OracleBufferedStream {
    long lobOffset;
    Datum lob;
    long markedByte;
    boolean endOfStream = false;
    long maxPosition = Long.MAX_VALUE;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public OracleBlobInputStream(BLOB bLOB) throws SQLException {
        this(bLOB, ((PhysicalConnection)bLOB.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleBlobInputStream(BLOB bLOB, int n2) throws SQLException {
        this(bLOB, n2, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleBlobInputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        super(n2);
        if (bLOB == null || n2 <= 0 || l2 < 1L) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "Illegal Arguments");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.lob = bLOB;
        this.markedByte = -1L;
        this.lobOffset = l2;
    }

    public OracleBlobInputStream(BLOB bLOB, int n2, long l2, long l3) throws SQLException {
        this(bLOB, n2, l2);
        this.maxPosition = l2 + l3;
    }

    public OracleBlobInputStream(BFILE bFILE) throws SQLException {
        this(bFILE, ((PhysicalConnection)bFILE.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleBlobInputStream(BFILE bFILE, int n2) throws SQLException {
        this(bFILE, n2, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleBlobInputStream(BFILE bFILE, int n2, long l2) throws SQLException {
        super(n2);
        if (bFILE == null || n2 <= 0 || l2 < 1L) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "Illegal Arguments");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.lob = bFILE;
        this.markedByte = -1L;
        this.lobOffset = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needBytes(int n2) throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.ensureOpen();
            if (this.pos >= this.count) {
                int n3;
                block47: {
                    if (!this.endOfStream) {
                        if (n2 > this.currentBufferSize) {
                            this.currentBufferSize = Math.max(n2, this.initialBufferSize);
                            this.resizableBuffer = new byte[this.currentBufferSize];
                        }
                        try {
                            n3 = (long)this.currentBufferSize < this.maxPosition - this.lobOffset ? this.currentBufferSize : (int)(this.maxPosition - this.lobOffset);
                            this.count = this.lob instanceof BLOB ? ((BLOB)this.lob).getBytes(this.lobOffset, n3, this.resizableBuffer) : ((BFILE)this.lob).getBytes(this.lobOffset, n3, this.resizableBuffer);
                            if (this.count < this.currentBufferSize) {
                                this.endOfStream = true;
                            }
                            if (this.count <= 0) break block47;
                            this.pos = 0;
                            this.lobOffset += (long)this.count;
                            if (this.lobOffset > this.maxPosition) {
                                this.endOfStream = true;
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                                    }
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            boolean bl = true;
                            return bl;
                        }
                        catch (SQLException sQLException) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleBlobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            IOException iOException = DatabaseError.createIOException(sQLException);
                            iOException.fillInStackTrace();
                            throw iOException;
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n3 = 0;
                return n3 != 0;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws IOException {
        block10: {
            try {
                if (!this.closed) break block10;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (n2 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "Read-ahead limit < 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalArgumentException("Read-ahead limit < 0");
            }
            this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public void markInternal(int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.ensureOpen();
            if (this.markedByte < 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleBlobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + "Mark invalid or stream not marked.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IOException("Mark invalid or stream not marked.");
            }
            this.lobOffset = this.markedByte;
            this.pos = this.count;
            this.endOfStream = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l2) throws IOException {
        try {
            long l3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.ensureOpen();
            long l4 = 0L;
            if ((long)(this.count - this.pos) >= l2) {
                this.pos = (int)((long)this.pos + l2);
                l4 += l2;
            } else {
                l4 += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    l3 = 0L;
                    l3 = this.lob instanceof BLOB ? ((BLOB)this.lob).length() - this.lobOffset + 1L : ((BFILE)this.lob).length() - this.lobOffset + 1L;
                    if (l3 >= l2 - l4) {
                        this.lobOffset += l2 - l4;
                        l4 += l2 - l4;
                    } else {
                        this.lobOffset += l3;
                        l4 += l3;
                    }
                }
                catch (SQLException sQLException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleBlobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    IOException iOException = DatabaseError.createIOException(sQLException);
                    iOException.fillInStackTrace();
                    throw iOException;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l4);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            l3 = l4;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleBlobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection = null;
        if (this.lob != null) {
            try {
                oracleConnection = this.lob instanceof BLOB ? ((BLOB)this.lob).getInternalConnection() : ((BFILE)this.lob).getInternalConnection();
            }
            catch (Exception exception) {
                oracleConnection = null;
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleBlobInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

