/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import oracle.jdbc.driver.OracleLog;

public class OracleConnectionManager
implements ConnectionManager {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConnectionManager() {
        block13: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(managedConnectionFactory) + ", " + OracleLog.argument(connectionRequestInfo));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ManagedConnection managedConnection = managedConnectionFactory.createManagedConnection(null, connectionRequestInfo);
            Object object = managedConnection.getConnection(null, connectionRequestInfo);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConnectionManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.connector");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.connector.OracleConnectionManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

