/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.aq;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.driver.OracleLog;

public class AQEnqueueOptions {
    private byte[] attrRelativeMessageId;
    private SequenceDeviationOption attrSequenceDeviation;
    private VisibilityOption attrVisibility;
    private DeliveryMode attrDeliveryMode;
    private boolean retrieveMsgId;
    private String transformation;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AQEnqueueOptions() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrRelativeMessageId = null;
            this.attrSequenceDeviation = SequenceDeviationOption.BOTTOM;
            this.attrVisibility = VisibilityOption.ON_COMMIT;
            this.attrDeliveryMode = DeliveryMode.PERSISTENT;
            this.retrieveMsgId = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelativeMessageId(byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(byArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrRelativeMessageId = byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRelativeMessageId() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.attrRelativeMessageId);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.attrRelativeMessageId;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSequenceDeviation(SequenceDeviationOption sequenceDeviationOption) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument((Object)sequenceDeviationOption));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrSequenceDeviation = sequenceDeviationOption;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceDeviationOption getSequenceDeviation() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.attrSequenceDeviation));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SequenceDeviationOption sequenceDeviationOption = this.attrSequenceDeviation;
            return sequenceDeviationOption;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibility(VisibilityOption visibilityOption) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument((Object)visibilityOption));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrVisibility = visibilityOption;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisibilityOption getVisibility() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.attrVisibility));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            VisibilityOption visibilityOption = this.attrVisibility;
            return visibilityOption;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeliveryMode(DeliveryMode deliveryMode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument((Object)deliveryMode));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.attrDeliveryMode = deliveryMode;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeliveryMode getDeliveryMode() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)this.attrDeliveryMode));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DeliveryMode deliveryMode = this.attrDeliveryMode;
            return deliveryMode;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetrieveMessageId(boolean bl) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.retrieveMsgId = bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRetrieveMessageId() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.retrieveMsgId);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.retrieveMsgId;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransformation(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.transformation = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransformation() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.transformation);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.transformation;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQEnqueueOptions.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.aq");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.aq.AQEnqueueOptions"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum DeliveryMode {
        PERSISTENT(AQDequeueOptions.DeliveryFilter.PERSISTENT.getCode()),
        BUFFERED(AQDequeueOptions.DeliveryFilter.BUFFERED.getCode());

        private final int mode;

        private DeliveryMode(int n3) {
            this.mode = n3;
        }

        public final int getCode() {
            return this.mode;
        }
    }

    public static enum SequenceDeviationOption {
        BOTTOM(0),
        BEFORE(2),
        TOP(3);

        private final int mode;

        private SequenceDeviationOption(int n3) {
            this.mode = n3;
        }

        public final int getCode() {
            return this.mode;
        }
    }

    public static enum VisibilityOption {
        ON_COMMIT(2),
        IMMEDIATE(1);

        private final int mode;

        private VisibilityOption(int n3) {
            this.mode = n3;
        }

        public final int getCode() {
            return this.mode;
        }
    }
}

