/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.AttributeDescriptor;
import oracle.sql.TypeDescriptor;

class Kotad {
    static final int KOTADSIG = -1365573631;
    static final int KOTPDSIG = -1365442559;
    static final int KOTRDSIG = -1365377023;
    static final int KOTCDSIG = -1365311487;
    static final int KOTODSIG = -1365307391;
    static final int KOTADXSIG = -1365303295;
    static final int KOTADPRV = 1;
    static final int KOTADPUB = 2;
    static final int KOTADCNT = 4;
    static final int KOTADCFM = 248;
    static final int KOTADSUB = 256;
    static final int KOTADPTR = 16384;
    static final int KOTADREF = 32768;
    static final int KOTADCNN = 65536;
    static final int KOTADCFN = 131072;
    static final int KOTADCVN = 262144;
    static final int KOTADTRN = 512;
    static final int KOTADCPT = 4096;
    static final int KOTADIN = 256;
    static final int KOTADOUT = 512;
    static final int KOTADCBR = 1024;
    static final int KOTADREQ = 2048;
    static final int KOTADNCP = 0x100000;
    private int kotadkvn;
    private byte[] kotadnam;
    private byte[] kotadtrf;
    private short kotadtvn;
    private short kotadid;
    private byte[] kotadprf;
    private short kotadpvn;
    private int kotadflg;
    private long kotadpre;
    private int kotadcid;
    private byte kotadscl;
    private int kotadcne;
    private byte[] kotaddft;
    private long kotadtyp;
    private byte[] kotadadd;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    private Kotad() throws SQLException {
    }

    private static Kotad unpickleKotad(PickleContext pickleContext) throws SQLException {
        Kotad kotad = new Kotad();
        pickleContext.skipBytes(2);
        long l2 = pickleContext.readLength(true) - 2;
        pickleContext.skipBytes(1);
        kotad.kotadkvn = (int)pickleContext.readUB4();
        kotad.kotadnam = pickleContext.readDataValue();
        kotad.kotadtrf = pickleContext.readDataValue();
        pickleContext.skipBytes(1);
        kotad.kotadtvn = (short)pickleContext.readUB2();
        pickleContext.skipBytes(1);
        kotad.kotadid = (short)pickleContext.readUB2();
        kotad.kotadprf = pickleContext.readDataValue();
        pickleContext.skipBytes(1);
        kotad.kotadpvn = (short)pickleContext.readUB2();
        pickleContext.skipBytes(1);
        kotad.kotadflg = (int)pickleContext.readUB4();
        pickleContext.skipBytes(1);
        kotad.kotadpre = pickleContext.readUB4();
        pickleContext.skipBytes(1);
        kotad.kotadcid = pickleContext.readUB2();
        pickleContext.skipBytes(1);
        kotad.kotadscl = pickleContext.readByte();
        pickleContext.skipBytes(1);
        kotad.kotadcne = (int)pickleContext.readUB4();
        kotad.kotaddft = pickleContext.readDataValue();
        pickleContext.skipBytes(1);
        kotad.kotadtyp = pickleContext.readUB4();
        kotad.kotadadd = pickleContext.readDataValue();
        return kotad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final TypeDescriptor unpickleTypeDescriptorImage(PickleContext pickleContext) throws SQLException {
        Kotad kotad = Kotad.unpickleKotad(pickleContext);
        if (kotad.kotadkvn != -1365311487) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 179");
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 179);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        TypeDescriptor typeDescriptor = Kotad.constructPredefinedTypeDescriptor(kotad);
        return typeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final AttributeDescriptor unpickleAttributeImage(boolean bl, PickleContext pickleContext) throws SQLException {
        Kotad kotad = Kotad.unpickleKotad(pickleContext);
        if (kotad.kotadkvn != -1365573631) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 179");
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 179);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        TypeDescriptor typeDescriptor = null;
        if (bl) {
            typeDescriptor = Kotad.constructPredefinedTypeDescriptor(kotad);
        }
        AttributeDescriptor attributeDescriptor = new AttributeDescriptor(new String(kotad.kotadnam), kotad.kotadid, kotad.kotadflg, typeDescriptor);
        return attributeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TypeDescriptor constructPredefinedTypeDescriptor(Kotad kotad) throws SQLException {
        short s2;
        if (kotad.kotadtrf.length != 36) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 180");
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 180);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        for (s2 = 4; s2 < 18; ++s2) {
            if (kotad.kotadtrf[s2] == 0) continue;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 180");
                    Object var4_8 = null;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 180);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        s2 = TypeDescriptor.OID_TO_TYPECODE[kotad.kotadtrf[19]];
        TypeDescriptor typeDescriptor = new TypeDescriptor(s2);
        typeDescriptor.setPrecision(kotad.kotadpre);
        typeDescriptor.setScale(kotad.kotadscl);
        return typeDescriptor;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.Kotad"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

