/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T4CXAConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int rmid = -1;
    private String xaOpenString = null;
    private static boolean libraryLoaded = false;
    private static final String dbSuffix = "HeteroXA";
    private static final String dllName = "heteroxa11";
    private static final char atSignChar = '@';
    private static int rmidSeed = 0;
    private static final int MAX_RMID_SEED = 65536;
    private String driverCharSetIdString = null;
    private String oldTnsEntry = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXADataSource() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.isOracleDataSource = true;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XAConnection getXAConnection() throws SQLException {
        XAConnection xAConnection;
        try {
            XAConnection xAConnection2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    xAConnection2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Properties properties = new Properties(this.connectionProperties);
            if (this.user != null && this.password != null) {
                properties.setProperty("user", this.user);
                properties.setProperty("password", this.password);
            }
            xAConnection2 = this.getXAConnection(properties);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + xAConnection2);
                    }
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            xAConnection = xAConnection2;
            Object var6_9 = null;
            if (!TRACE) return xAConnection;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return xAConnection;
        try {
            OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_11 = null;
            OracleLog.recursiveExit();
            return xAConnection;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        Object object;
        try {
            Object object2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                    object2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Properties properties = new Properties(this.connectionProperties);
            if (string == null || string2 == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXADataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                object2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                ((Throwable)object2).fillInStackTrace();
                throw object2;
            }
            properties.setProperty("user", string);
            properties.setProperty("password", string2);
            object2 = this.getXAConnection(properties);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                    }
                    Object var8_11 = null;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = object2;
            Object var10_14 = null;
            if (!TRACE) return object;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_18 = null;
            }
            catch (Throwable throwable2) {
                Object var12_19 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return object;
        try {
            OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAConnection getXAConnection(Properties properties) throws SQLException {
        XAConnection xAConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(properties));
                    }
                    xAConnection = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.connCachingEnabled) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXADataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 163);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 163);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            XAConnection xAConnection2 = (XAConnection)this.getPooledConnection(properties);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + xAConnection2);
                    }
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            xAConnection = xAConnection2;
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return xAConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection;
        try {
            PooledConnection pooledConnection2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                    pooledConnection2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Properties properties = new Properties();
            properties.setProperty("user", string);
            properties.setProperty("password", string2);
            pooledConnection2 = this.getPooledConnection(properties);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pooledConnection2);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            pooledConnection = pooledConnection2;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return pooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public PooledConnection getPooledConnection(Properties properties) throws SQLException {
        try {
            String string;
            String string2;
            block79: {
                String string3;
                block78: {
                    Object object;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.enter()) {
                                OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(properties));
                            }
                            string2 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    try {
                        Class<OracleXADataSource> clazz;
                        string3 = this.getURL();
                        string2 = properties.getProperty("user");
                        string = properties.getProperty("password");
                        String string4 = null;
                        String string5 = null;
                        String string6 = null;
                        int n2 = 0;
                        if (!this.useNativeXA || !string3.startsWith("jdbc:oracle:oci8") && !string3.startsWith("jdbc:oracle:oci")) break block78;
                        long[] lArray = new long[]{0L, 0L};
                        String string7 = null;
                        String string8 = null;
                        OracleXADataSource oracleXADataSource = this;
                        // MONITORENTER : oracleXADataSource
                        string7 = this.tnsEntry != null ? this.tnsEntry : this.getTNSEntryFromUrl(string3);
                        if (string7 != null && string7.length() == 0 || string7.startsWith("(DESCRIPTION")) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXADataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 207);
                                    Object var14_29 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var14_30 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 207);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        if (!libraryLoaded) {
                            clazz = OracleXADataSource.class;
                            // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                            if (!libraryLoaded) {
                                try {
                                    System.loadLibrary(dllName);
                                    libraryLoaded = true;
                                }
                                catch (Error error) {
                                    libraryLoaded = false;
                                    throw error;
                                }
                            }
                            // MONITOREXIT : clazz
                        }
                        if (this.connectionProperties != null) {
                            string8 = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
                        }
                        // MONITOREXIT : oracleXADataSource
                        if (string8 != null && string8.equalsIgnoreCase("true")) {
                            short s2 = T2CConnection.getDriverCharSetIdFromNLS_LANG();
                            this.driverCharSetIdString = Integer.toString(s2);
                        } else if (!string7.equals(this.oldTnsEntry)) {
                            short s3 = T2CConnection.getClientCharSetId();
                            this.driverCharSetIdString = Integer.toString(s3);
                            this.oldTnsEntry = string7;
                        }
                        OracleXADataSource oracleXADataSource2 = this;
                        // MONITORENTER : oracleXADataSource2
                        string4 = this.databaseName + dbSuffix + rmidSeed;
                        this.rmid = n2 = rmidSeed;
                        clazz = OracleXADataSource.class;
                        // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                        rmidSeed = (rmidSeed + 1) % 65536;
                        // MONITOREXIT : clazz
                        int n3 = 0;
                        Object object2 = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                        this.xaOpenString = string6 = this.generateXAOpenString(string4, string7, string2, string, 60, 2000, true, true, ".", n3, false, object2 != null && ((String)object2).equalsIgnoreCase("true"), this.driverCharSetIdString, this.driverCharSetIdString);
                        string5 = this.generateXACloseString(string4, false);
                        // MONITOREXIT : oracleXADataSource2
                        int n4 = this.t2cDoXaOpen(string6, n2, 0, 0);
                        if (n4 != 0) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXADataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + -1 * n4);
                                    Object var20_40 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var20_41 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1 * n4);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        n4 = this.t2cConvertOciHandles(string4, lArray);
                        if (n4 != 0) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXADataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + -1 * n4);
                                    Object var22_43 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var22_44 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1 * n4);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        properties.put("OCISvcCtxHandle", String.valueOf(lArray[0]));
                        properties.put("OCIEnvHandle", String.valueOf(lArray[1]));
                        properties.put("JDBCDriverCharSetId", this.driverCharSetIdString);
                        if (this.loginTimeout != 0) {
                            properties.put("oracle.net.CONNECT_TIMEOUT", "" + this.loginTimeout * 1000);
                        }
                        Connection connection = this.driver.connect(this.getURL(), properties);
                        ((OracleConnection)connection).setStatementCacheSize(this.maxStatements);
                        ((OracleConnection)connection).setExplicitCachingEnabled(this.explicitCachingEnabled);
                        ((OracleConnection)connection).setImplicitCachingEnabled(this.implicitCachingEnabled);
                        if (this.maxStatements > 0 && !this.explicitCachingEnabled && !this.implicitCachingEnabled) {
                            ((OracleConnection)connection).setImplicitCachingEnabled(true);
                            ((OracleConnection)connection).setExplicitCachingEnabled(true);
                        }
                        object2 = new OracleXAHeteroConnection(connection);
                        if (string2 != null && string != null) {
                            ((OraclePooledConnection)object2).setUserName(string2, string);
                        }
                        ((OracleXAHeteroConnection)object2).setRmid(n2);
                        ((OracleXAHeteroConnection)object2).setXaCloseString(string5);
                        ((OraclePooledConnection)object2).registerCloseCallback(new OracleXAHeteroCloseCallback(), object2);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                                }
                                Object var24_46 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var24_47 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        object = object2;
                    }
                    catch (XAException xAException) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                                }
                                Object var33_76 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var33_77 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        PooledConnection pooledConnection = null;
                        Object var35_53 = null;
                        if (!TRACE) return pooledConnection;
                        if (!OracleLog.recursiveEnter()) return pooledConnection;
                        try {}
                        catch (Throwable throwable) {
                            Object var37_62 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var37_61 = null;
                        OracleLog.recursiveExit();
                        return pooledConnection;
                    }
                    Object var35_50 = null;
                    if (!TRACE) return object;
                    if (!OracleLog.recursiveEnter()) return object;
                    try {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var37_55 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    catch (Throwable throwable) {
                        Object var37_56 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (!this.thinUseNativeXA || !string3.startsWith("jdbc:oracle:thin")) break block79;
                Properties properties2 = new Properties();
                Serializable serializable = this;
                // MONITORENTER : serializable
                Class<OracleXADataSource> clazz = OracleXADataSource.class;
                // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                this.rmid = rmidSeed = (rmidSeed + 1) % 65536;
                // MONITOREXIT : clazz
                if (this.connectionProperties == null) {
                    this.connectionProperties = new Properties();
                }
                this.connectionProperties.put("RessourceManagerId", Integer.toString(this.rmid));
                if (string2 != null) {
                    properties2.setProperty("user", string2);
                }
                if (string != null) {
                    properties2.setProperty("password", string);
                }
                properties2.setProperty("stmt_cache_size", "" + this.maxStatements);
                properties2.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                properties2.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                if (this.loginTimeout != 0) {
                    properties2.setProperty("LoginTimeout", "" + this.loginTimeout);
                }
                // MONITOREXIT : serializable
                serializable = new T4CXAConnection(super.getPhysicalConnection(properties2));
                if (string2 != null && string != null) {
                    ((OraclePooledConnection)serializable).setUserName(string2, string);
                }
                clazz = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                boolean bl = ((OracleXAConnection)serializable).isXAResourceTransLoose = clazz != null && (((String)((Object)clazz)).equals("true") || ((String)((Object)clazz)).equalsIgnoreCase("true"));
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + serializable);
                        }
                        Object var28_70 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var28_71 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Serializable serializable2 = serializable;
                Object var35_51 = null;
                if (!TRACE) return serializable2;
                if (!OracleLog.recursiveEnter()) return serializable2;
                try {}
                catch (Throwable throwable) {
                    Object var37_58 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var37_57 = null;
                OracleLog.recursiveExit();
                return serializable2;
            }
            Properties properties3 = new Properties();
            Serializable serializable = this;
            // MONITORENTER : serializable
            if (string2 != null) {
                properties3.setProperty("user", string2);
            }
            if (string != null) {
                properties3.setProperty("password", string);
            }
            properties3.setProperty("stmt_cache_size", "" + this.maxStatements);
            properties3.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
            properties3.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
            if (this.loginTimeout != 0) {
                properties3.setProperty("LoginTimeout", "" + this.loginTimeout);
            }
            // MONITOREXIT : serializable
            serializable = new OracleXAConnection(super.getPhysicalConnection(properties3));
            if (string2 != null && string != null) {
                ((OraclePooledConnection)serializable).setUserName(string2, string);
            }
            String string9 = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
            boolean bl = ((OracleXAConnection)serializable).isXAResourceTransLoose = string9 != null && (string9.equals("true") || string9.equalsIgnoreCase("true"));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + serializable);
                    }
                    Object var31_73 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var31_74 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Serializable serializable3 = serializable;
            Object var35_52 = null;
            if (!TRACE) return serializable3;
            if (!OracleLog.recursiveEnter()) return serializable3;
            try {}
            catch (Throwable throwable) {
                Object var37_60 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var37_59 = null;
            OracleLog.recursiveExit();
            return serializable3;
        }
        catch (Throwable throwable) {
            Object var35_54 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var37_64 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var37_63 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private native int t2cDoXaOpen(String var1, int var2, int var3, int var4);

    private native int t2cConvertOciHandles(String var1, long[] var2);

    synchronized void setRmid(int n2) {
        this.rmid = n2;
    }

    synchronized int getRmid() {
        return this.rmid;
    }

    synchronized void setXaOpenString(String string) {
        this.xaOpenString = string;
    }

    synchronized String getXaOpenString() {
        return this.xaOpenString;
    }

    private String generateXAOpenString(String string, String string2, String string3, String string4, int n2, int n3, boolean bl, boolean bl2, String string5, int n4, boolean bl3, boolean bl4, String string6, String string7) {
        return "ORACLE_XA+DB=" + string + "+ACC=P/" + string3 + "/" + string4 + "+SESTM=" + n3 + "+SESWT=" + n2 + "+LOGDIR=" + string5 + "+SQLNET=" + string2 + (bl ? "+THREADS=true" : "") + (bl2 ? "+OBJECTS=true" : "") + "+DBGFL=0x" + n4 + (bl3 ? "+CONNCACHE=t" : "+CONNCACHE=f") + (bl4 ? "+Loose_Coupling=t" : "") + "+CharSet=" + string6 + "+NCharSet=" + string7;
    }

    private String generateXACloseString(String string, boolean bl) {
        return "ORACLE_XA+DB=" + string + (bl ? "+CONNCACHE=t" : "+CONNCACHE=f");
    }

    private String getTNSEntryFromUrl(String string) {
        int n2 = string.indexOf(64);
        return string.substring(n2 + 1);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXADataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

