/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;

class OracleRuntimeLoadBalancingEventHandlerThread
extends Thread {
    private Notification event = null;
    private OracleConnectionCacheManager cacheManager = null;
    String m_service;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleRuntimeLoadBalancingEventHandlerThread(String string) throws SQLException {
        this.m_service = string;
        this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
    }

    public void run() {
        Subscriber subscriber = null;
        final String string = "%\"eventType=database/event/servicemetrics/" + this.m_service + "\"";
        while (this.cacheManager.failoverEnabledCacheExists()) {
            try {
                subscriber = (Subscriber)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        try {
                            return new Subscriber(string, "", 30000L);
                        }
                        catch (SubscriptionException subscriptionException) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception " + subscriptionException.getMessage());
                                    Object var3_2 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var3_3 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            return null;
                        }
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            if (subscriber != null) {
                try {
                    while (this.cacheManager.failoverEnabledCacheExists()) {
                        this.event = subscriber.receive(300000L);
                        if (this.event == null) continue;
                        this.handleEvent(this.event);
                    }
                }
                catch (ONSException oNSException) {
                    subscriber.close();
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void handleEvent(Notification notification) {
        try {
            this.cacheManager.parseRuntimeLoadBalancingEvent(this.m_service, notification == null ? null : notification.body());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleRuntimeLoadBalancingEventHandlerThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

