/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

public class OracleTypeTIMESTAMP
extends OracleType
implements Serializable {
    static final long serialVersionUID = 3948043338303602796L;
    int precision = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    protected OracleTypeTIMESTAMP() {
    }

    public OracleTypeTIMESTAMP(OracleConnection oracleConnection) {
    }

    public int getTypeCode() {
        return 93;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.precision = tDSReader.readByte();
    }

    public int getScale() throws SQLException {
        return 0;
    }

    public int getPrecision() throws SQLException {
        return this.precision;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.precision = objectInputStream.readByte();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.precision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                return new TIMESTAMP(byArray);
            }
            case 2: {
                return TIMESTAMP.toTimestamp(byArray);
            }
            case 3: {
                return byArray;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeTIMESTAMP.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        TIMESTAMP tIMESTAMP;
        block16: {
            tIMESTAMP = null;
            if (object != null) {
                try {
                    if (object instanceof TIMESTAMP) {
                        tIMESTAMP = (TIMESTAMP)object;
                        break block16;
                    }
                    if (object instanceof byte[]) {
                        tIMESTAMP = new TIMESTAMP((byte[])object);
                        break block16;
                    }
                    if (object instanceof Timestamp) {
                        tIMESTAMP = new TIMESTAMP((Timestamp)object);
                        break block16;
                    }
                    if (object instanceof DATE) {
                        tIMESTAMP = new TIMESTAMP((DATE)object);
                        break block16;
                    }
                    if (object instanceof String) {
                        tIMESTAMP = new TIMESTAMP((String)object);
                        break block16;
                    }
                    if (object instanceof Date) {
                        tIMESTAMP = new TIMESTAMP((Date)object);
                        break block16;
                    }
                    if (object instanceof Time) {
                        tIMESTAMP = new TIMESTAMP((Time)object);
                        break block16;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeTIMESTAMP.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + object);
                            Object var5_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                catch (Exception exception) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeTIMESTAMP.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + object);
                            Object var7_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_11 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unpickle81rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeTIMESTAMP.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeTIMESTAMP"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

