/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;

class SensitiveScrollableResultSet
extends ScrollableResultSet {
    int beginLastFetchedIndex;
    int endLastFetchedIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    SensitiveScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n2, int n3) throws SQLException {
        super(scrollRsetStatement, oracleResultSetImpl, n2, n3);
        int n4 = oracleResultSetImpl.getValidRows();
        if (n4 > 0) {
            this.beginLastFetchedIndex = 1;
            this.endLastFetchedIndex = n4;
        } else {
            this.beginLastFetchedIndex = 0;
            this.endLastFetchedIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean next() throws SQLException {
        boolean bl;
        PhysicalConnection physicalConnection = this.connection;
        // MONITORENTER : physicalConnection
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (super.next()) {
                this.handle_refetch();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl2 = true;
                Object var9_10 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_13 = null;
                        OracleLog.recursiveExit();
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                // MONITOREXIT : physicalConnection
                return bl2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    Object var7_22 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = false;
            Object var9_11 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_18 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var11_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var11_15 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        Object var3_2 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (super.first()) {
                    this.handle_refetch();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                            Object var5_7 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    boolean bl = true;
                    Object var9_10 = null;
                    if (!TRACE) return bl;
                    if (!OracleLog.recursiveEnter()) return bl;
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_13 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    return bl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var7_22 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_23 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl = false;
                Object var9_11 = null;
                if (!TRACE) return bl;
                if (!OracleLog.recursiveEnter()) return bl;
                try {}
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
                OracleLog.recursiveExit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {}
                catch (Throwable throwable2) {
                    Object var11_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        Object var3_2 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (super.last()) {
                    this.handle_refetch();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                            Object var5_7 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    boolean bl = true;
                    Object var9_10 = null;
                    if (!TRACE) return bl;
                    if (!OracleLog.recursiveEnter()) return bl;
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_13 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    return bl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var7_22 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_23 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl = false;
                Object var9_11 = null;
                if (!TRACE) return bl;
                if (!OracleLog.recursiveEnter()) return bl;
                try {}
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
                OracleLog.recursiveExit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {}
                catch (Throwable throwable2) {
                    Object var11_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean absolute(int n2) throws SQLException {
        boolean bl;
        PhysicalConnection physicalConnection = this.connection;
        // MONITORENTER : physicalConnection
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (super.absolute(n2)) {
                this.handle_refetch();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl2 = true;
                Object var10_11 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var12_14 = null;
                        OracleLog.recursiveExit();
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                // MONITOREXIT : physicalConnection
                return bl2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    Object var8_23 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var8_24 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = false;
            Object var10_12 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var12_19 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_18 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var12_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var12_16 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean relative(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                        Object var4_3 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (super.relative(n2)) {
                    this.handle_refetch();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                            Object var6_8 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    boolean bl = true;
                    Object var10_11 = null;
                    if (!TRACE) return bl;
                    if (!OracleLog.recursiveEnter()) return bl;
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var12_14 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    return bl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var8_23 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_24 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl = false;
                Object var10_12 = null;
                if (!TRACE) return bl;
                if (!OracleLog.recursiveEnter()) return bl;
                try {}
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_16 = null;
                OracleLog.recursiveExit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {}
                catch (Throwable throwable2) {
                    Object var12_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean previous() throws SQLException {
        var1_1 = this.connection;
        synchronized (var1_1) {
            try {
                block20: {
                    if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.enter()) {
                                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                            }
                            var3_2 = null;
                        }
                        catch (Throwable var2_4) {
                            var3_3 = null;
                            OracleLog.recursiveExit();
                            throw var2_4;
                        }
                        OracleLog.recursiveExit();
                    }
                    if (!super.previous()) break block20;
                    this.handle_refetch();
                    if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                            var5_7 = null;
                        }
                        catch (Throwable var4_9) {
                            var5_8 = null;
                            OracleLog.recursiveExit();
                            throw var4_9;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_5 = true;
                    var9_10 = null;
                    if (SensitiveScrollableResultSet.TRACE == false) return var2_5;
                    ** GOTO lbl70
                }
                if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        var7_22 = null;
                    }
                    catch (Throwable var6_24) {
                        var7_23 = null;
                        OracleLog.recursiveExit();
                        throw var6_24;
                    }
                    OracleLog.recursiveExit();
                }
                var2_6 = false;
                ** GOTO lbl83
            }
            catch (Throwable var8_25) {
                var9_12 = null;
                if (SensitiveScrollableResultSet.TRACE == false) throw var8_25;
                if (OracleLog.recursiveEnter() == false) throw var8_25;
                try {
                    SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var11_17 = null;
                }
                catch (Throwable var10_21) {
                    var11_18 = null;
                    OracleLog.recursiveExit();
                    throw var10_21;
                }
lbl70:
                // 1 sources

                if (OracleLog.recursiveEnter() == false) return var2_5;
                try {}
                catch (Throwable var10_19) {
                    var11_14 = null;
                    OracleLog.recursiveExit();
                    throw var10_19;
                }
                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var11_13 = null;
                OracleLog.recursiveExit();
                return var2_5;
lbl83:
                // 1 sources

                var9_11 = null;
                if (SensitiveScrollableResultSet.TRACE == false) return var2_6;
                if (OracleLog.recursiveEnter() == false) return var2_6;
                try {}
                catch (Throwable var10_20) {
                    var11_16 = null;
                    OracleLog.recursiveExit();
                    throw var10_20;
                }
                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var11_15 = null;
                OracleLog.recursiveExit();
                return var2_6;
                OracleLog.recursiveExit();
                throw var8_25;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (!this.isValidRow(this.currentRow)) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                            Object var5_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n2 = this.getFetchDirection();
                int n3 = 0;
                try {
                    n3 = this.refreshRowsInCache(this.currentRow, this.getFetchSize(), n2);
                }
                catch (SQLException sQLException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + sQLException + 90 + "Unsupported syntax for refreshRow()");
                            Object var7_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_14 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), sQLException, 90, "Unsupported syntax for refreshRow()");
                    sQLException2.fillInStackTrace();
                    throw sQLException2;
                }
                if (n3 != 0) {
                    this.beginLastFetchedIndex = this.currentRow;
                    this.endLastFetchedIndex = this.currentRow + n3 - 1;
                }
                Object var9_16 = null;
            }
            catch (Throwable throwable) {
                Object var9_17 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_20 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeRowInCache(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n3 = super.removeRowInCache(n2);
            if (n3 != 0) {
                if (n2 >= this.beginLastFetchedIndex && n2 <= this.endLastFetchedIndex && this.beginLastFetchedIndex != this.endLastFetchedIndex) {
                    --this.endLastFetchedIndex;
                } else {
                    this.endLastFetchedIndex = 0;
                    this.beginLastFetchedIndex = 0;
                }
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handle_refetch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.currentRow >= this.beginLastFetchedIndex && this.currentRow <= this.endLastFetchedIndex || this.currentRow >= this.endLastFetchedIndex && this.currentRow <= this.beginLastFetchedIndex) {
                return false;
            }
            this.refreshRow();
            return true;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.SensitiveScrollableResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

