/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

class OracleConversionReader
extends Reader {
    static final int CHUNK_SIZE = 4096;
    DBConversion dbConversion;
    int conversion;
    InputStream istream;
    char[] buf;
    byte[] byteBuf;
    int pos;
    int count;
    int numUnconvertedBytes;
    boolean isClosed;
    boolean endOfStream;
    private short csform;
    int[] nbytes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionReader(DBConversion dBConversion, InputStream inputStream, int n2) throws SQLException {
        if (dBConversion == null || inputStream == null || n2 != 8 && n2 != 9) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.dbConversion = dBConversion;
        this.conversion = n2;
        this.istream = inputStream;
        this.count = 0;
        this.pos = 0;
        this.numUnconvertedBytes = 0;
        this.isClosed = false;
        this.nbytes = new int[1];
        if (n2 == 8) {
            this.byteBuf = new byte[2048];
            this.buf = new char[4096];
        } else if (n2 == 9) {
            this.byteBuf = new byte[4096];
            this.buf = new char[4096];
        }
    }

    public void setFormOfUse(short s2) {
        this.csform = s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        block23: {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cArray) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (this.needChars()) break block23;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                    }
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int n5 = -1;
            Object var11_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_17 = null;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n5;
        }
        try {
            int n6 = n2;
            int n7 = n6 + Math.min(n3, cArray.length - n2);
            n6 += this.writeChars(cArray, n6, n7 - n6);
            while (n6 < n7 && this.needChars()) {
                n6 += this.writeChars(cArray, n6, n7 - n6);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (n6 - n2));
                    }
                    Object var9_26 = null;
                }
                catch (Throwable throwable) {
                    Object var9_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n4 = n6 - n2;
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_19 = null;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean needChars() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            block21: {
                if (!this.endOfStream) {
                    try {
                        int n2 = this.istream.read(this.byteBuf, this.numUnconvertedBytes, this.byteBuf.length - this.numUnconvertedBytes);
                        if (n2 == -1) {
                            this.endOfStream = true;
                            this.istream.close();
                            if (this.numUnconvertedBytes != 0) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 55);
                                        Object var3_3 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_4 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55);
                                sQLException.fillInStackTrace();
                                throw sQLException;
                            }
                        }
                        if ((n2 += this.numUnconvertedBytes) <= 0) break block21;
                        switch (this.conversion) {
                            case 8: {
                                this.count = DBConversion.RAWBytesToHexChars(this.byteBuf, n2, this.buf);
                                break;
                            }
                            case 9: {
                                this.nbytes[0] = n2;
                                this.count = this.csform == 2 ? this.dbConversion.NCHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length) : this.dbConversion.CHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length);
                                this.numUnconvertedBytes = this.nbytes[0];
                                for (int i2 = 0; i2 < this.numUnconvertedBytes; ++i2) {
                                    this.byteBuf[i2] = this.byteBuf[n2 - this.numUnconvertedBytes + i2];
                                }
                                break;
                            }
                            default: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                                        Object var5_10 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var5_11 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
                                sQLException.fillInStackTrace();
                                throw sQLException;
                            }
                        }
                        if (this.count > 0) {
                            this.pos = 0;
                            return true;
                        }
                    }
                    catch (SQLException sQLException) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                                Object var7_13 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_14 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        IOException iOException = DatabaseError.createIOException(sQLException);
                        iOException.fillInStackTrace();
                        throw iOException;
                    }
                }
            }
            return false;
        }
        return true;
    }

    protected int writeChars(char[] cArray, int n2, int n3) {
        int n4 = Math.min(n3, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, cArray, n2, n4);
        this.pos += n4;
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (this.pos < this.count));
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = this.pos < this.count;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!this.isClosed) {
                this.isClosed = true;
                this.istream.close();
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws IOException {
        block8: {
            try {
                if (!this.isClosed) break block8;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                        Object var4_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleConversionReader"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

