/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobInputStream
extends OracleBufferedStream {
    protected long lobOffset;
    protected CLOB clob;
    protected long markedByte;
    protected boolean endOfStream;
    protected char[] charBuf;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public OracleClobInputStream(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleClobInputStream(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobInputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        super(n2);
        if (cLOB == null || n2 <= 0 || l2 < 1L) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "");
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new IllegalArgumentException();
        }
        this.lobOffset = l2;
        this.clob = cLOB;
        this.markedByte = -1L;
        this.endOfStream = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean needBytes(int n2) throws IOException {
        boolean bl;
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    object = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.ensureOpen();
            if (this.pos >= this.count) {
                int n3;
                block35: {
                    if (!this.endOfStream) {
                        try {
                            if (n2 > this.currentBufferSize) {
                                this.currentBufferSize = Math.max(n2, this.initialBufferSize);
                                PhysicalConnection physicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
                                object = physicalConnection;
                                // MONITORENTER : object
                                this.resizableBuffer = physicalConnection.getByteBuffer(this.currentBufferSize);
                                this.charBuf = physicalConnection.getCharBuffer(this.currentBufferSize);
                                // MONITOREXIT : object
                            }
                            this.count = this.clob.getChars(this.lobOffset, this.currentBufferSize, this.charBuf);
                            for (n3 = 0; n3 < this.count; n3 += 1) {
                                this.resizableBuffer[n3] = (byte)this.charBuf[n3];
                            }
                            if (this.count < this.currentBufferSize) {
                                this.endOfStream = true;
                            }
                            if (this.count <= 0) break block35;
                            this.pos = 0;
                            this.lobOffset += (long)this.count;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                                    }
                                    Object var6_9 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var6_10 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            n3 = 1;
                        }
                        catch (SQLException sQLException) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                                    Object var8_28 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var8_29 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            object = DatabaseError.createIOException(sQLException);
                            ((Throwable)object).fillInStackTrace();
                            throw object;
                        }
                        Object var14_12 = null;
                        if (!TRACE) return n3 != 0;
                        if (!OracleLog.recursiveEnter()) return n3 != 0;
                        try {
                            OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var16_16 = null;
                            OracleLog.recursiveExit();
                            return n3 != 0;
                        }
                        catch (Throwable throwable) {
                            Object var16_17 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var10_31 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var10_32 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                n3 = 0;
                Object var14_13 = null;
                if (!TRACE) return n3 != 0;
                if (!OracleLog.recursiveEnter()) return n3 != 0;
                try {}
                catch (Throwable throwable) {
                    Object var16_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_18 = null;
                OracleLog.recursiveExit();
                return n3 != 0;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    Object var12_34 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var12_35 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = true;
            Object var14_14 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var16_23 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var16_22 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var16_21 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var16_20 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureOpen() throws IOException {
        block8: {
            try {
                if (!this.closed) break block8;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                        Object var4_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markSupported() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = true;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (n2 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + DatabaseError.findMessage(196, null));
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new IllegalArgumentException(DatabaseError.findMessage(196, null));
            }
            this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    public void markInternal(int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (this.markedByte < 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + DatabaseError.findMessage(195, null));
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new IOException(DatabaseError.findMessage(195, null));
            }
            this.lobOffset = this.markedByte;
            this.pos = this.count;
            this.endOfStream = false;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l2) throws IOException {
        long l3;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2));
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            long l4 = 0L;
            if ((long)(this.count - this.pos) >= l2) {
                this.pos = (int)((long)this.pos + l2);
                l4 += l2;
            } else {
                l4 += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    l3 = 0L;
                    l3 = this.clob.length() - this.lobOffset + 1L;
                    if (l3 >= l2 - l4) {
                        this.lobOffset += l2 - l4;
                        l4 += l2 - l4;
                    } else {
                        this.lobOffset += l3;
                        l4 += l3;
                    }
                }
                catch (SQLException sQLException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                            Object var8_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    IOException iOException = DatabaseError.createIOException(sQLException);
                    iOException.fillInStackTrace();
                    throw iOException;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l4);
                    }
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l3 = l4;
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            super.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                PhysicalConnection physicalConnection;
                PhysicalConnection physicalConnection2 = physicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
                synchronized (physicalConnection2) {
                    if (this.charBuf != null) {
                        physicalConnection.cacheBuffer(this.charBuf);
                        this.charBuf = null;
                    }
                    if (this.resizableBuffer != null) {
                        physicalConnection.cacheBuffer(this.resizableBuffer);
                        this.resizableBuffer = null;
                    }
                    this.currentBufferSize = 0;
                }
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                        Object var7_15 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var7_16 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
            throw throwable;
        }
        try {
            PhysicalConnection physicalConnection;
            PhysicalConnection physicalConnection3 = physicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
            synchronized (physicalConnection3) {
                if (this.charBuf != null) {
                    physicalConnection.cacheBuffer(this.charBuf);
                    this.charBuf = null;
                }
                if (this.resizableBuffer != null) {
                    physicalConnection.cacheBuffer(this.resizableBuffer);
                    this.resizableBuffer = null;
                }
                this.currentBufferSize = 0;
            }
        }
        catch (SQLException sQLException) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                    Object var7_13 = null;
                }
                catch (Throwable throwable) {
                    Object var7_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            IOException iOException = DatabaseError.createIOException(sQLException);
            iOException.fillInStackTrace();
            throw iOException;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.clob.getInternalConnection();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleClobInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

