/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ArrayDataResultSet
extends BaseResultSet {
    Datum[] data;
    Map map;
    private int currentIndex;
    private int lastIndex;
    PhysicalConnection connection;
    private Boolean wasNull;
    private int fetchSize;
    ARRAY array;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public ArrayDataResultSet(OracleConnection oracleConnection, Datum[] datumArray, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = 0;
        this.lastIndex = this.data == null ? 0 : this.data.length;
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection oracleConnection, Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.data == null ? 0 : this.data.length;
        this.lastIndex = this.currentIndex + Math.min(n3 - this.currentIndex, n2);
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection oracleConnection, ARRAY aRRAY, long l2, int n2, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.array = aRRAY;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.array == null ? 0 : aRRAY.length();
        this.lastIndex = this.currentIndex + (n2 == -1 ? n3 - this.currentIndex : Math.min(n3 - this.currentIndex, n2));
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10 + "next");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "next");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            ++this.currentIndex;
            boolean bl2 = bl = this.currentIndex <= this.lastIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                super.close();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.wasNull == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 24 + null);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24, null);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                boolean bl2 = this.wasNull;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = bl2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    String string = datum.stringValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string2 = string;
                    return string2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = null;
                return string;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCursor");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum getOracleObject(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.currentIndex <= 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 14 + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n2 == 1) {
                this.wasNull = Boolean.FALSE;
                NUMBER nUMBER = new NUMBER(this.currentIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nUMBER);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                NUMBER nUMBER2 = nUMBER;
                return nUMBER2;
            }
            if (n2 == 2) {
                Object object;
                if (this.data != null) {
                    Boolean bl = this.wasNull = this.data[this.currentIndex - 1] == null ? Boolean.TRUE : Boolean.FALSE;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.data[this.currentIndex - 1]);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Datum datum = this.data[this.currentIndex - 1];
                    return datum;
                }
                if (this.array != null && (object = this.array.getOracleArray(this.currentIndex, 1)) != null && ((Object)object).length >= 1) {
                    Boolean bl = this.wasNull = object[0] == null ? Boolean.TRUE : Boolean.FALSE;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object[0]);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Object object2 = object[0];
                    return object2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Out of sync");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Out of sync");
                ((Throwable)object).fillInStackTrace();
                throw object;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, null);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof ROWID) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (ROWID)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        ROWID rOWID = (ROWID)datum;
                        return rOWID;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getROWID");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ROWID rOWID = null;
                return rOWID;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof NUMBER) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (NUMBER)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        NUMBER nUMBER = (NUMBER)datum;
                        return nUMBER;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getNUMBER");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                NUMBER nUMBER = null;
                return nUMBER;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof DATE) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (DATE)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        DATE dATE = (DATE)datum;
                        return dATE;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getDATE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                DATE dATE = null;
                return dATE;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof ARRAY) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (ARRAY)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        ARRAY aRRAY = (ARRAY)datum;
                        return aRRAY;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getARRAY");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ARRAY aRRAY = null;
                return aRRAY;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof STRUCT) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (STRUCT)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        STRUCT sTRUCT = (STRUCT)datum;
                        return sTRUCT;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getSTRUCT");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                STRUCT sTRUCT = null;
                return sTRUCT;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof OPAQUE) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (OPAQUE)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        OPAQUE oPAQUE = (OPAQUE)datum;
                        return oPAQUE;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getOPAQUE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OPAQUE oPAQUE = null;
                return oPAQUE;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof REF) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (REF)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        REF rEF = (REF)datum;
                        return rEF;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getREF");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                REF rEF = null;
                return rEF;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof CHAR) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (CHAR)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        CHAR cHAR = (CHAR)datum;
                        return cHAR;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCHAR");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CHAR cHAR = null;
                return cHAR;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof RAW) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (RAW)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        RAW rAW = (RAW)datum;
                        return rAW;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getRAW");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                RAW rAW = null;
                return rAW;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof BLOB) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (BLOB)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        BLOB bLOB = (BLOB)datum;
                        return bLOB;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getBLOB");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BLOB bLOB = null;
                return bLOB;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof CLOB) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (CLOB)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        CLOB cLOB = (CLOB)datum;
                        return cLOB;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCLOB");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CLOB cLOB = null;
                return cLOB;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof BFILE) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (BFILE)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        BFILE bFILE = (BFILE)datum;
                        return bFILE;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getBFILE");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BFILE bFILE = null;
                return bFILE;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof INTERVALDS) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (INTERVALDS)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        INTERVALDS iNTERVALDS = (INTERVALDS)datum;
                        return iNTERVALDS;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                INTERVALDS iNTERVALDS = null;
                return iNTERVALDS;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof INTERVALYM) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (INTERVALYM)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        INTERVALYM iNTERVALYM = (INTERVALYM)datum;
                        return iNTERVALYM;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                INTERVALYM iNTERVALYM = null;
                return iNTERVALYM;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BFILE bFILE2 = this.getBFILE(n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bFILE2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bFILE = bFILE2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof TIMESTAMP) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (TIMESTAMP)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        TIMESTAMP tIMESTAMP = (TIMESTAMP)datum;
                        return tIMESTAMP;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMP");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                TIMESTAMP tIMESTAMP = null;
                return tIMESTAMP;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof TIMESTAMPTZ) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (TIMESTAMPTZ)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        TIMESTAMPTZ tIMESTAMPTZ = (TIMESTAMPTZ)datum;
                        return tIMESTAMPTZ;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMPTZ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                TIMESTAMPTZ tIMESTAMPTZ = null;
                return tIMESTAMPTZ;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof TIMESTAMPLTZ) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (TIMESTAMPLTZ)datum);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        TIMESTAMPLTZ tIMESTAMPLTZ = (TIMESTAMPLTZ)datum;
                        return tIMESTAMPLTZ;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMPLTZ");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                TIMESTAMPLTZ tIMESTAMPLTZ = null;
                return tIMESTAMPLTZ;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    boolean bl = datum.booleanValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl2 = bl;
                    return bl2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleResultSet.AuthorizationIndicator authorizationIndicator = null;
            return authorizationIndicator;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    byte by = datum.byteValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    byte by2 = by;
                    return by2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by = 0;
                return by;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            short s2;
            try {
                long l2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((l2 = this.getLong(n2)) > 65537L || l2 < -65538L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 26 + "getShort");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (short)l2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                s2 = (short)l2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    int n3 = datum.intValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n4 = n3;
                    return n4;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n5 = 0;
                return n5;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    long l2 = datum.longValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l2);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long l3 = l2;
                    return l3;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l4 = 0L;
                return l4;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    float f2 = datum.floatValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + f2);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    float f3 = f2;
                    return f3;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                float f4 = 0.0f;
                return f4;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    double d2 = datum.doubleValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d2);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    double d3 = d2;
                    return d3;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                double d4 = 0.0;
                return d4;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    BigDecimal bigDecimal = datum.bigDecimalValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    BigDecimal bigDecimal2 = bigDecimal;
                    return bigDecimal2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BigDecimal bigDecimal = null;
                return bigDecimal;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof RAW) {
                        byte[] byArray = ((RAW)datum).shareBytes();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        byte[] byArray2 = byArray;
                        return byArray2;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getBytes");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    Date date = datum.dateValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Date date2 = date;
                    return date2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Date date = null;
                return date;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    Time time = datum.timeValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Time time2 = time;
                    return time2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Time time = null;
                return time;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    Timestamp timestamp = datum.timestampValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Timestamp timestamp2 = timestamp;
                    return timestamp2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Timestamp timestamp = null;
                return timestamp;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            InputStream inputStream;
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    datum.asciiStreamValue();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = null;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    DBConversion dBConversion = this.connection.conversion;
                    byte[] byArray = datum.shareBytes();
                    if (datum instanceof RAW) {
                        InputStream inputStream = dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        InputStream inputStream2 = inputStream;
                        return inputStream2;
                    }
                    if (datum instanceof CHAR) {
                        InputStream inputStream = dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        InputStream inputStream3 = inputStream;
                        return inputStream3;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getUnicodeStream");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                InputStream inputStream = null;
                return inputStream;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    InputStream inputStream = datum.binaryStreamValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    InputStream inputStream2 = inputStream;
                    return inputStream2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                InputStream inputStream = null;
                return inputStream;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleData oracleData;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(oracleDataFactory));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object object = this.getObject(n2);
                OracleData oracleData2 = oracleDataFactory.create(object, 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleData2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleData = oracleData2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object object2 = this.getObject(n2, this.map);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                object = object2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CustomDatum customDatum;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(customDatumFactory));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum datum = this.getOracleObject(n2);
                CustomDatum customDatum2 = customDatumFactory.create(datum, 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + customDatum2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                customDatum = customDatum2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ORAData oRAData;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(oRADataFactory));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum datum = this.getOracleObject(n2);
                ORAData oRAData2 = oRADataFactory.create(datum, 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oRAData2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oRAData = oRAData2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oRAData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10 + "getMetaData");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getMetaData");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23 + "getMetaData");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getMetaData");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (string.equalsIgnoreCase("index")) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n2 = 1;
                    return n2;
                }
                if (string.equalsIgnoreCase("value")) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 2);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n3 = 2;
                    return n3;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6 + "get_column_index");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, "get_column_index");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Statement statement = null;
            return statement;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(map));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    if (datum instanceof STRUCT) {
                        Object object = ((STRUCT)datum).toJdbc(map);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        Object object2 = object;
                        return object2;
                    }
                    Object object = datum.toJdbc();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Object object3 = object;
                    return object3;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object var5_8 = null;
                return var5_8;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                REF rEF2 = this.getREF(n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rEF2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rEF = rEF2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BLOB bLOB2 = this.getBLOB(n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bLOB2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bLOB = bLOB2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CLOB cLOB2 = this.getCLOB(n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cLOB2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cLOB = cLOB2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ARRAY aRRAY2 = this.getARRAY(n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + aRRAY2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                aRRAY = aRRAY2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    Reader reader = datum.characterStreamValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reader);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Reader reader2 = reader;
                    return reader2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Reader reader = null;
                return reader;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    BigDecimal bigDecimal = datum.bigDecimalValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    BigDecimal bigDecimal2 = bigDecimal;
                    return bigDecimal2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BigDecimal bigDecimal = null;
                return bigDecimal;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                DATE dATE;
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    dATE = null;
                    dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                    if (dATE != null) {
                        Date date = dATE.dateValue(calendar);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        Date date2 = date;
                        return date2;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                dATE = null;
                return dATE;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                DATE dATE;
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    dATE = null;
                    dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                    if (dATE != null) {
                        Time time = dATE.timeValue(calendar);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        Time time2 = time;
                        return time2;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                dATE = null;
                return dATE;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                DATE dATE;
                Datum datum;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(n2)) != null) {
                    dATE = null;
                    dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
                    if (dATE != null) {
                        Timestamp timestamp = dATE.timestampValue(calendar);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        Timestamp timestamp2 = timestamp;
                        return timestamp2;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                dATE = null;
                return dATE;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23 + "getCursorName");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl2 = bl = this.currentIndex < 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl2 = bl = this.currentIndex > this.lastIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl2 = bl = this.currentIndex == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl2 = bl = this.currentIndex == this.lastIndex;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.currentIndex);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.currentIndex;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (n2 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDataResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.fetchSize = n2 == 0 ? OracleConnection.DEFAULT_ROW_PREFETCH : n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.fetchSize);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.fetchSize;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDataResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ArrayDataResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

