/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ANYDATA;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;
import oracle.xdb.XMLType;

class AQMessageI
implements AQMessage {
    private byte[] id = null;
    private AQMessagePropertiesI properties = null;
    private byte[] toid = null;
    private byte[] payload;
    private STRUCT payLoadSTRUCT;
    private ANYDATA payLoadANYDATA;
    private RAW payLoadRAW;
    private XMLType payLoadXMLType;
    private Connection conn;
    private String typeName;
    private TypeDescriptor sd;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    AQMessageI(AQMessagePropertiesI aQMessagePropertiesI, Connection connection) {
        this.properties = aQMessagePropertiesI;
        this.conn = connection;
    }

    AQMessageI(AQMessagePropertiesI aQMessagePropertiesI) throws SQLException {
        this.properties = aQMessagePropertiesI;
    }

    void setTypeName(String string) {
        this.typeName = string;
    }

    void setTypeDescriptor(TypeDescriptor typeDescriptor) {
        this.sd = typeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMessageId() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.id);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.id;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void setMessageId(byte[] byArray) throws SQLException {
        this.id = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AQMessageProperties getMessageProperties() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.properties);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            AQMessagePropertiesI aQMessagePropertiesI = this.properties;
            return aQMessagePropertiesI;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    AQMessagePropertiesI getMessagePropertiesI() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(byArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = byArray;
            this.toid = TypeDescriptor.RAWTOID;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(byte[] byArray, byte[] byArray2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(byArray) + ", " + OracleLog.argument(byArray2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = byArray;
            this.toid = byArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(STRUCT sTRUCT) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sTRUCT));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = sTRUCT.toBytes();
            this.payLoadSTRUCT = sTRUCT;
            this.toid = sTRUCT.getDescriptor().getOracleTypeADT().getTOID();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(ANYDATA aNYDATA) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(aNYDATA));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = aNYDATA.toDatum(this.conn).shareBytes();
            this.payLoadANYDATA = aNYDATA;
            this.toid = TypeDescriptor.ANYDATATOID;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(RAW rAW) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rAW));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = rAW.shareBytes();
            this.payLoadRAW = rAW;
            this.toid = TypeDescriptor.RAWTOID;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPayload(XMLType xMLType) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xMLType));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.payload = xMLType.toBytes();
            this.payLoadXMLType = xMLType;
            this.toid = TypeDescriptor.XMLTYPETOID;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPayload() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.payload);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.payload;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW getRAWPayload() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RAW rAW = null;
            if (this.payLoadRAW != null) {
                rAW = this.payLoadRAW;
            } else if (this.isRAWPayload()) {
                rAW = this.payLoadRAW = new RAW(this.payload);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 193);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rAW);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RAW rAW2 = rAW;
            return rAW2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRAWPayload() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.toid == null || this.toid.length != 16) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 252);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (AQMessageI.compareToid(this.toid, TypeDescriptor.RAWTOID)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT getSTRUCTPayload() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT sTRUCT = null;
            if (!this.isSTRUCTPayload()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 193);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.payLoadSTRUCT != null) {
                sTRUCT = this.payLoadSTRUCT;
            } else {
                if (this.sd == null) {
                    this.typeName = OracleTypeADT.toid2typename(this.conn, this.toid);
                    this.sd = TypeDescriptor.getTypeDescriptor(this.typeName, (OracleConnection)this.conn);
                }
                if (this.sd instanceof StructDescriptor) {
                    this.payLoadSTRUCT = sTRUCT = new STRUCT((StructDescriptor)this.sd, this.payload, this.conn);
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 193);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sTRUCT);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT sTRUCT2 = sTRUCT;
            return sTRUCT2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSTRUCTPayload() throws SQLException {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.toid == null || this.toid.length != 16) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 252);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl2 = true;
            boolean bl3 = true;
            for (bl = false; bl < 15 != 0; bl += 1) {
                if (this.toid[bl] == 0) continue;
                bl3 = false;
                break;
            }
            if (bl3 || this.isRAWPayload() || this.isANYDATAPayload()) {
                bl2 = false;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = bl2;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ANYDATA getANYDATAPayload() throws SQLException {
        try {
            ORAData oRAData;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ANYDATA aNYDATA = null;
            if (this.payLoadANYDATA != null) {
                aNYDATA = this.payLoadANYDATA;
            } else if (this.isANYDATAPayload()) {
                oRAData = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", this.conn);
                OPAQUE oPAQUE = new OPAQUE((OpaqueDescriptor)oRAData, this.payload, this.conn);
                aNYDATA = this.payLoadANYDATA = new ANYDATA(oPAQUE);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 193);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + aNYDATA);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            oRAData = aNYDATA;
            return oRAData;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isANYDATAPayload() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.toid == null || this.toid.length != 16) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 252);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.typeName != null && this.typeName.equals("SYS.ANYDATA") || AQMessageI.compareToid(this.toid, TypeDescriptor.ANYDATATOID)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLType getXMLTypePayload() throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            XMLType xMLType = null;
            if (this.payLoadXMLType != null) {
                xMLType = this.payLoadXMLType;
            } else if (this.isXMLTypePayload()) {
                object = OpaqueDescriptor.createDescriptor("SYS.XMLTYPE", this.conn);
                OPAQUE oPAQUE = new OPAQUE((OpaqueDescriptor)object, this.payload, this.conn);
                xMLType = this.payLoadXMLType = XMLType.createXML((OPAQUE)oPAQUE);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 193);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + xMLType);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = xMLType;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXMLTypePayload() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.toid == null || this.toid.length != 16) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQMessageI.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 252);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.typeName != null && this.typeName.equals("SYS.XMLTYPE") || AQMessageI.compareToid(this.toid, TypeDescriptor.XMLTYPETOID)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public byte[] getPayloadTOID() {
        return this.toid;
    }

    static boolean compareToid(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        if (byArray != null) {
            if (byArray == byArray2) {
                bl = true;
            } else if (byArray.length == byArray2.length) {
                boolean bl2 = true;
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    if (byArray[i2] == byArray2[i2]) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Message Properties={");
            stringBuffer.append(this.properties);
            stringBuffer.append("} ");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + stringBuffer.toString());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AQMessageI.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.AQMessageI"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

