/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleShardingKeyBuilder;
import oracle.jdbc.OracleType;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AbstractShardingPreparedStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;

class ShardingKeyInfo {
    private static final String CLASS_NAME = ShardingKeyInfo.class.getName();
    static ConcurrentHashMap<Integer, KeyTokenInfo> sqlToShardingKeyTokensMap = new ConcurrentHashMap();
    protected static final int DEPTH = 128;
    public static final int GWS_KEY_RESERVED = 255;
    public static final int GWS_KEY_UNUSED = 0;
    public static final int GWS_KEY_RETURN_TUPLE_20_1 = 82;
    public static final int GWS_KEY_APPEND_KEY_TUPLE_20_1 = 125;
    public static final int GWS_KEY_APPEND_VALUE_KEY_20_1 = 93;
    public static final int GWS_KEY_PUSH_BIND_INDEX_20_1 = 73;
    public static final int GWS_KEY_PUSH_PARAMETER_20_1 = 80;
    public static final int GWS_KEY_PUSH_LITERAL_20_1 = 76;
    public static final int GWS_KEY_PUSH_SQL_TYPE_20_1 = 84;
    public static final int GWS_KEY_PUSH_SHORT_20_1 = 83;
    public static final int GWS_KEY_PUSH_EMPTY_KEY_20_1 = 91;
    public static final int GWS_KEY_PUSH_EMPTY_TUPLE_20_1 = 123;
    protected Stack stack = new Stack(128);

    ShardingKeyInfo() {
    }

    List<List<Object>> evaluateShardingKeys(OracleStatement statement, byte[] keyRpnTokens, short dbCharSet) throws SQLException, IOException {
        List keyTuple = null;
        byte b = 0;
        int len = keyRpnTokens.length;
        int index = 0;
        block12: while (index < len) {
            b = keyRpnTokens[index++];
            List tuple = null;
            List key = null;
            int type = 0;
            Object value = null;
            int num = 0;
            byte[] buf = null;
            switch (b) {
                case 82: {
                    keyTuple = this.stack.pop(List.class);
                    if (index == len) {
                        return keyTuple;
                    }
                    throw new SQLException("more than expected sharding key information expression");
                }
                case 125: {
                    key = this.stack.pop(List.class);
                    tuple = this.stack.pop(List.class);
                    tuple.add(key);
                    this.stack.push(tuple);
                    continue block12;
                }
                case 93: {
                    value = this.stack.pop(Object.class);
                    key = this.stack.pop(List.class);
                    key.add(value);
                    this.stack.push(key);
                    continue block12;
                }
                case 80: {
                    type = this.stack.pop(Integer.class);
                    num = this.stack.pop(Integer.class);
                    this.stack.push(((AbstractShardingPreparedStatement)((Object)statement)).getBindValue(num, type));
                    continue block12;
                }
                case 76: {
                    type = this.stack.pop(Integer.class);
                    buf = new byte[this.stack.pop(Short.class).shortValue()];
                    System.arraycopy(keyRpnTokens, index, buf, 0, buf.length);
                    index += buf.length;
                    this.stack.push(this.convertDatumToJavaObject(buf, type, dbCharSet));
                    continue block12;
                }
                case 84: {
                    num = (short)(((keyRpnTokens[index++] & 0xFF) << 8) + (keyRpnTokens[index++] & 0xFF));
                    this.stack.push(num);
                    continue block12;
                }
                case 83: {
                    num = (short)(((keyRpnTokens[index++] & 0xFF) << 8) + (keyRpnTokens[index++] & 0xFF));
                    this.stack.push((short)num);
                    continue block12;
                }
                case 73: {
                    num = ((keyRpnTokens[index++] & 0xFF) << 24) + ((keyRpnTokens[index++] & 0xFF) << 16) + ((keyRpnTokens[index++] & 0xFF) << 8) + (keyRpnTokens[index++] & 0xFF);
                    this.stack.push(num);
                    continue block12;
                }
                case 91: {
                    this.stack.push(new ArrayList());
                    continue block12;
                }
                case 123: {
                    this.stack.push(new ArrayList());
                    continue block12;
                }
            }
            throw (SQLException)DatabaseError.createSqlException(1704).fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createSqlException(1704).fillInStackTrace();
    }

    Object convertDatumToJavaObject(byte[] buf, int internalType, short dbCharSet) throws SQLException {
        Datum subkeyDatum = SQLUtil.makeDatum(null, buf, internalType, null, 0, (short)873, dbCharSet);
        Object subkeyVal = ShardingKeyInfo.SQLToJavaKeyObject(subkeyDatum, internalType);
        return subkeyVal;
    }

    OracleShardingKey[] getShardingKeys(OracleStatement statement, byte[] keyRpnTokens, short dbCharSet) throws SQLException, IOException {
        OracleShardingKey[] shardingKeys = new OracleShardingKey[2];
        List<List<Object>> keyTuple = this.evaluateShardingKeys(statement, keyRpnTokens, dbCharSet);
        OracleShardingKeyBuilder shardingKeyBuilder = new OracleShardingKeyBuilderImpl();
        if (keyTuple != null && !keyTuple.isEmpty()) {
            shardingKeyBuilder = this.addSubKeys(shardingKeyBuilder, keyTuple.get(0));
            shardingKeys[0] = shardingKeyBuilder.build();
            if (keyTuple.size() > 1) {
                OracleShardingKeyBuilder superShardingKeyBuilder = new OracleShardingKeyBuilderImpl();
                superShardingKeyBuilder = this.addSubKeys(superShardingKeyBuilder, keyTuple.get(1));
                shardingKeys[1] = superShardingKeyBuilder.build();
            }
        }
        return shardingKeys;
    }

    OracleShardingKeyBuilder addSubKeys(OracleShardingKeyBuilder shardingKeyBuilder, List<Object> subkeyVals) throws SQLException {
        for (Object subkeyVal : subkeyVals) {
            SQLType subkeyType = this.getKeyType(subkeyVal);
            shardingKeyBuilder.subkey(subkeyVal, subkeyType);
        }
        return shardingKeyBuilder;
    }

    SQLType getKeyType(Object val) throws SQLException {
        int externalType = this.sqlTypeForObject(val);
        OracleType sqltype = OracleType.toOracleType(externalType);
        return sqltype;
    }

    private int sqlTypeForObject(Object x) {
        if (x == null) {
            return 0;
        }
        if (!(x instanceof Datum)) {
            if (x instanceof String) {
                return 12;
            }
            if (x instanceof BigDecimal) {
                return 2;
            }
            if (x instanceof BigInteger) {
                return 2;
            }
            if (x instanceof Boolean) {
                return 2;
            }
            if (x instanceof Integer) {
                return 2;
            }
            if (x instanceof Long) {
                return 2;
            }
            if (x instanceof Float) {
                return 6;
            }
            if (x instanceof Double) {
                return 8;
            }
            if (x instanceof byte[]) {
                return -2;
            }
            if (x instanceof Short) {
                return 2;
            }
            if (x instanceof Byte) {
                return 2;
            }
            if (x instanceof Date) {
                return 91;
            }
            if (x instanceof Time) {
                return 92;
            }
            if (x instanceof Timestamp) {
                return 93;
            }
            if (x instanceof URL) {
                return 12;
            }
        } else {
            if (x instanceof BINARY_FLOAT) {
                return 100;
            }
            if (x instanceof BINARY_DOUBLE) {
                return 101;
            }
            if (x instanceof NUMBER) {
                return 2;
            }
            if (x instanceof DATE) {
                return 91;
            }
            if (x instanceof TIMESTAMP) {
                return 93;
            }
            if (x instanceof CHAR) {
                return 1;
            }
            if (x instanceof RAW) {
                return -2;
            }
        }
        return 1111;
    }

    static Object SQLToJavaKeyObject(Datum datum, int internalType) throws SQLException {
        Object ret_obj = null;
        if (datum == null) {
            return null;
        }
        switch (internalType) {
            case 1: 
            case 96: {
                ret_obj = datum.stringValue();
                break;
            }
            case 2: 
            case 6: {
                ret_obj = datum.bigDecimalValue();
                break;
            }
            case 12: {
                ret_obj = datum.dateValue();
                break;
            }
            case 180: {
                ret_obj = datum.timestampValue();
                break;
            }
            default: {
                ret_obj = datum.toJdbc();
            }
        }
        return ret_obj;
    }

    static KeyTokenInfo putKeyRpnTokens(String sql, String serviceName, String userName, String schemaName, byte[] keyRpnTokens, OracleStatement.SqlKind sqlkind) {
        KeyTokenInfo keyTokenInfo = new KeyTokenInfo(keyRpnTokens, sqlkind);
        int mapKey = ShardingKeyInfo.calculateTokensHashKey(sql, serviceName, userName, schemaName);
        Diagnosable diag = CommonDiagnosable.getInstance();
        diag.trace(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "putKeyRpnTokens", "sql={0} serviceName={1} userName={2} schemaName={3} keyRpnTokens={4} mapKey={5}", null, null, sql, serviceName, userName, schemaName, Arrays.toString(keyRpnTokens), mapKey);
        return sqlToShardingKeyTokensMap.put(mapKey, keyTokenInfo);
    }

    static KeyTokenInfo getKeyRpnTokens(String sql, String serviceName, String userName, String schemaName) {
        int mapKey = ShardingKeyInfo.calculateTokensHashKey(sql, serviceName, userName, schemaName);
        return sqlToShardingKeyTokensMap.get(mapKey);
    }

    static int calculateTokensHashKey(String ... strKeys) {
        int tempHashCode = 1;
        for (String key : strKeys) {
            tempHashCode = 31 * tempHashCode + key.hashCode();
        }
        return tempHashCode;
    }

    protected static final class Stack {
        private final Object[] stack;
        private int top = -1;

        public Stack(int depth) {
            this.stack = new Object[depth];
        }

        public boolean isEmpty() {
            return this.top == -1;
        }

        public Stack push(Object value) {
            this.stack[++this.top] = value;
            return this;
        }

        public <T> T pop(Class<T> type) {
            Object v = this.stack[this.top];
            this.stack[this.top--] = null;
            return (T)v;
        }
    }

    protected static final class KeyTokenInfo {
        private byte[] keyTokens;
        private OracleStatement.SqlKind sqlkind;

        public KeyTokenInfo(byte[] keyTokens, OracleStatement.SqlKind sqlkind) {
            this.keyTokens = keyTokens;
            this.sqlkind = sqlkind;
        }

        public byte[] getKeyTokens() {
            return this.keyTokens;
        }

        public OracleStatement.SqlKind getSqlKind() {
            return this.sqlkind;
        }
    }
}

