/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

abstract class NumberCommonAccessor
extends Accessor {
    protected final byte[] tmpBytes;
    static final boolean GET_XXX_ROUNDS = false;
    int[] digs = new int[27];
    static final int LNXSGNBT = 128;
    static final byte LNXDIGS = 20;
    static final byte LNXEXPBS = 64;
    static final int LNXEXPMX = 127;
    static final BigDecimal BIGDEC_ZERO = BigDecimal.valueOf(0L);
    static final byte MAX_LONG_EXPONENT = 9;
    static final byte MIN_LONG_EXPONENT = 9;
    static final byte MAX_INT_EXPONENT = 4;
    static final byte MIN_INT_EXPONENT = 4;
    static final byte MAX_SHORT_EXPONENT = 2;
    static final byte MIN_SHORT_EXPONENT = 2;
    static final byte MAX_BYTE_EXPONENT = 1;
    static final byte MIN_BYTE_EXPONENT = 1;
    static final int[] MAX_LONG = new int[]{202, 10, 23, 34, 73, 4, 69, 55, 78, 59, 8};
    static final int[] MIN_LONG = new int[]{53, 92, 79, 68, 29, 98, 33, 47, 24, 43, 93, 102};
    static final int MAX_LONG_length = 11;
    static final int MIN_LONG_length = 12;
    static final double[] factorTable = new double[]{1.0E254, 1.0E252, 1.0E250, 1.0E248, 1.0E246, 1.0E244, 1.0E242, 1.0E240, 1.0E238, 1.0E236, 1.0E234, 1.0E232, 1.0E230, 1.0E228, 1.0E226, 1.0E224, 1.0E222, 1.0E220, 1.0E218, 1.0E216, 1.0E214, 1.0E212, 1.0E210, 1.0E208, 1.0E206, 1.0E204, 1.0E202, 1.0E200, 1.0E198, 1.0E196, 1.0E194, 1.0E192, 1.0E190, 1.0E188, 1.0E186, 1.0E184, 1.0E182, 1.0E180, 1.0E178, 1.0E176, 1.0E174, 1.0E172, 1.0E170, 1.0E168, 1.0E166, 1.0E164, 1.0E162, 1.0E160, 1.0E158, 1.0E156, 1.0E154, 1.0E152, 1.0E150, 1.0E148, 1.0E146, 1.0E144, 1.0E142, 1.0E140, 1.0E138, 1.0E136, 1.0E134, 1.0E132, 1.0E130, 1.0E128, 1.0E126, 1.0E124, 1.0E122, 1.0E120, 1.0E118, 1.0E116, 1.0E114, 1.0E112, 1.0E110, 1.0E108, 1.0E106, 1.0E104, 1.0E102, 1.0E100, 1.0E98, 1.0E96, 1.0E94, 1.0E92, 1.0E90, 1.0E88, 1.0E86, 1.0E84, 1.0E82, 1.0E80, 1.0E78, 1.0E76, 1.0E74, 1.0E72, 1.0E70, 1.0E68, 1.0E66, 1.0E64, 1.0E62, 1.0E60, 1.0E58, 1.0E56, 1.0E54, 1.0E52, 1.0E50, 1.0E48, 1.0E46, 1.0E44, 1.0E42, 1.0E40, 1.0E38, 1.0E36, 1.0E34, 1.0E32, 1.0E30, 1.0E28, 1.0E26, 1.0E24, 1.0E22, 1.0E20, 1.0E18, 1.0E16, 1.0E14, 1.0E12, 1.0E10, 1.0E8, 1000000.0, 10000.0, 100.0, 1.0, 0.01, 1.0E-4, 1.0E-6, 1.0E-8, 1.0E-10, 1.0E-12, 1.0E-14, 1.0E-16, 1.0E-18, 1.0E-20, 1.0E-22, 1.0E-24, 1.0E-26, 1.0E-28, 1.0E-30, 1.0E-32, 1.0E-34, 1.0E-36, 1.0E-38, 1.0E-40, 1.0E-42, 1.0E-44, 1.0E-46, 1.0E-48, 1.0E-50, 1.0E-52, 1.0E-54, 1.0E-56, 1.0E-58, 1.0E-60, 1.0E-62, 1.0E-64, 1.0E-66, 1.0E-68, 1.0E-70, 1.0E-72, 1.0E-74, 1.0E-76, 1.0E-78, 1.0E-80, 1.0E-82, 1.0E-84, 1.0E-86, 1.0E-88, 1.0E-90, 1.0E-92, 1.0E-94, 1.0E-96, 1.0E-98, 1.0E-100, 1.0E-102, 1.0E-104, 1.0E-106, 1.0E-108, 1.0E-110, 1.0E-112, 1.0E-114, 1.0E-116, 1.0E-118, 1.0E-120, 1.0E-122, 1.0E-124, 1.0E-126, 1.0E-128, 1.0E-130, 1.0E-132, 1.0E-134, 1.0E-136, 1.0E-138, 1.0E-140, 1.0E-142, 1.0E-144, 1.0E-146, 1.0E-148, 1.0E-150, 1.0E-152, 1.0E-154, 1.0E-156, 1.0E-158, 1.0E-160, 1.0E-162, 1.0E-164, 1.0E-166, 1.0E-168, 1.0E-170, 1.0E-172, 1.0E-174, 1.0E-176, 1.0E-178, 1.0E-180, 1.0E-182, 1.0E-184, 1.0E-186, 1.0E-188, 1.0E-190, 1.0E-192, 1.0E-194, 1.0E-196, 1.0E-198, 1.0E-200, 1.0E-202, 1.0E-204, 1.0E-206, 1.0E-208, 1.0E-210, 1.0E-212, 1.0E-214, 1.0E-216, 1.0E-218, 1.0E-220, 1.0E-222, 1.0E-224, 1.0E-226, 1.0E-228, 1.0E-230, 1.0E-232, 1.0E-234, 1.0E-236, 1.0E-238, 1.0E-240, 1.0E-242, 1.0E-244, 1.0E-246, 1.0E-248, 1.0E-250, 1.0E-252, 1.0E-254};
    static final double[] small10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    static final int tablemax = factorTable.length;
    static final double tablemaxexponent = 127.0;
    static final double tableminexponent = 127.0 - (double)(tablemax - 20);
    static final int MANTISSA_SIZE = 53;
    static final int[] expdigs0 = new int[]{25597, 55634, 18440, 18324, 42485, 50370, 56862, 11593, 45703, 57341, 10255, 12549, 59579, 5};
    static final int[] expdigs1 = new int[]{50890, 19916, 24149, 23777, 11324, 41057, 14921, 56274, 30917, 19462, 54968, 47943, 38791, 3872};
    static final int[] expdigs2 = new int[]{24101, 29690, 40218, 29073, 29604, 22037, 27674, 9082, 56670, 55244, 20865, 54874, 47573, 38};
    static final int[] expdigs3 = new int[]{22191, 40873, 1607, 45622, 23883, 24544, 32988, 43530, 61694, 55616, 43150, 32976, 27418, 25379};
    static final int[] expdigs4 = new int[]{55927, 44317, 6569, 54851, 238, 63160, 51447, 12231, 55667, 25459, 5674, 40962, 52047, 253};
    static final int[] expdigs5 = new int[]{56264, 8962, 51839, 64773, 39323, 49783, 15587, 30924, 36601, 56615, 27581, 36454, 35254, 2};
    static final int[] expdigs6 = new int[]{21545, 25466, 59727, 37873, 13099, 7602, 15571, 49963, 37664, 46896, 14328, 59258, 17403, 1663};
    static final int[] expdigs7 = new int[]{12011, 4842, 3874, 57395, 38141, 46606, 49307, 60792, 31833, 21440, 9318, 47123, 41461, 16};
    static final int[] expdigs8 = new int[]{52383, 25023, 56409, 43947, 51036, 17420, 62725, 5735, 53692, 44882, 64439, 36137, 24719, 10900};
    static final int[] expdigs9 = new int[]{65404, 27119, 57580, 26653, 42453, 19179, 26186, 42000, 1847, 62708, 14406, 12813, 247, 109};
    static final int[] expdigs10 = new int[]{36698, 50078, 40552, 35000, 49576, 56552, 261, 49572, 31475, 59609, 45363, 46658, 5900, 1};
    static final int[] expdigs11 = new int[]{33321, 54106, 42443, 60698, 47535, 24088, 45785, 18352, 47026, 40291, 5183, 35843, 24059, 714};
    static final int[] expdigs12 = new int[]{12129, 44450, 22706, 34030, 37175, 8760, 31915, 56544, 23407, 52176, 7260, 41646, 9415, 7};
    static final int[] expdigs13 = new int[]{43054, 17160, 43698, 6780, 36385, 52800, 62346, 52747, 33988, 2855, 31979, 38083, 44325, 4681};
    static final int[] expdigs14 = new int[]{60723, 40803, 16165, 19073, 2985, 9703, 41911, 37227, 41627, 1994, 38986, 27250, 53527, 46};
    static final int[] expdigs15 = new int[]{36481, 57623, 45627, 58488, 53274, 7238, 2063, 31221, 62631, 25319, 35409, 25293, 54667, 30681};
    static final int[] expdigs16 = new int[]{52138, 47106, 3077, 4517, 41165, 38738, 39997, 10142, 13078, 16637, 53438, 54647, 53630, 306};
    static final int[] expdigs17 = new int[]{25425, 24719, 55736, 8564, 12208, 3664, 51518, 17140, 61079, 30312, 2500, 30693, 4468, 3};
    static final int[] expdigs18 = new int[]{58368, 65134, 52675, 3178, 26300, 7986, 11833, 515, 23109, 63525, 29138, 19030, 50114, 2010};
    static final int[] expdigs19 = new int[]{41216, 15724, 12323, 26246, 59245, 58406, 46648, 13767, 11372, 15053, 61895, 48686, 7054, 20};
    static final int[] expdigs20 = new int[]{0, 29248, 62416, 1433, 14025, 43846, 39905, 44375, 137, 47955, 62409, 33386, 48983, 13177};
    static final int[] expdigs21 = new int[]{0, 21264, 53708, 60962, 25043, 64008, 31200, 50906, 9831, 56185, 43877, 36378, 50952, 131};
    static final int[] expdigs22 = new int[]{0, 50020, 25440, 60247, 44814, 39961, 6865, 26068, 34832, 9081, 17478, 44928, 20825, 1};
    static final int[] expdigs23 = new int[]{0, 0, 52929, 10084, 25506, 6346, 61348, 31525, 52689, 61296, 27615, 15903, 40426, 863};
    static final int[] expdigs24 = new int[]{0, 16384, 24122, 53840, 43508, 13170, 51076, 37670, 58198, 31414, 57292, 61762, 41691, 8};
    static final int[] expdigs25 = new int[]{0, 0, 4096, 29077, 42481, 30581, 10617, 59493, 46251, 1892, 5557, 4505, 52391, 5659};
    static final int[] expdigs26 = new int[]{0, 0, 58368, 11431, 1080, 29797, 47947, 36639, 42405, 50481, 29546, 9875, 39190, 56};
    static final int[] expdigs27 = new int[]{0, 0, 0, 57600, 63028, 53094, 12749, 18174, 21993, 48265, 14922, 59933, 4030, 37092};
    static final int[] expdigs28 = new int[]{0, 0, 0, 576, 1941, 35265, 9302, 42780, 50682, 28007, 29640, 28124, 60333, 370};
    static final int[] expdigs29 = new int[]{0, 0, 0, 5904, 8539, 12149, 36793, 43681, 12958, 60573, 21267, 35015, 46478, 3};
    static final int[] expdigs30 = new int[]{0, 0, 0, 0, 7268, 50548, 47962, 3644, 22719, 26999, 41893, 7421, 56711, 2430};
    static final int[] expdigs31 = new int[]{0, 0, 0, 0, 7937, 49002, 60772, 28216, 38893, 55975, 63988, 59711, 20227, 24};
    static final int[] expdigs32 = new int[]{0, 0, 0, 16384, 38090, 63404, 55657, 8801, 62648, 13666, 57656, 60234, 15930};
    static final int[] expdigs33 = new int[]{0, 0, 0, 4096, 37081, 37989, 16940, 55138, 17665, 39458, 9751, 20263, 159};
    static final int[] expdigs34 = new int[]{0, 0, 0, 58368, 35104, 16108, 61773, 14313, 30323, 54789, 57113, 38868, 1};
    static final int[] expdigs35 = new int[]{0, 0, 0, 8448, 18701, 29652, 51080, 65023, 27172, 37903, 3192, 1044};
    static final int[] expdigs36 = new int[]{0, 0, 0, 37440, 63101, 2917, 39177, 50457, 25830, 50186, 28867, 10};
    static final int[] expdigs37 = new int[]{0, 0, 0, 56080, 45850, 37384, 3668, 12301, 38269, 18196, 6842};
    static final int[] expdigs38 = new int[]{0, 0, 0, 46436, 13565, 50181, 34770, 37478, 5625, 27707, 68};
    static final int[] expdigs39 = new int[]{0, 0, 0, 32577, 45355, 38512, 38358, 3651, 36101, 44841};
    static final int[] expdigs40 = new int[]{0, 0, 16384, 28506, 5696, 56746, 15456, 50499, 27230, 448};
    static final int[] expdigs41 = new int[]{0, 0, 4096, 285, 9232, 58239, 57170, 38515, 31729, 4};
    static final int[] expdigs42 = new int[]{0, 0, 58368, 41945, 57108, 12378, 28752, 48226, 2938};
    static final int[] expdigs43 = new int[]{0, 0, 24832, 47605, 49067, 23716, 61891, 25385, 29};
    static final int[] expdigs44 = new int[]{0, 0, 8768, 2442, 50298, 23174, 19624, 19259};
    static final int[] expdigs45 = new int[]{0, 0, 40720, 45899, 1813, 31689, 38862, 192};
    static final int[] expdigs46 = new int[]{0, 0, 36452, 14221, 34752, 48813, 60681, 1};
    static final int[] expdigs47 = new int[]{0, 0, 61313, 34220, 16731, 11629, 1262};
    static final int[] expdigs48 = new int[]{0, 16384, 60906, 18036, 40144, 40748, 12};
    static final int[] expdigs49 = new int[]{0, 4096, 609, 15909, 52830, 8271};
    static final int[] expdigs50 = new int[]{0, 58368, 3282, 56520, 47058, 82};
    static final int[] expdigs51 = new int[]{0, 41216, 52461, 7118, 54210};
    static final int[] expdigs52 = new int[]{0, 45632, 51642, 6624, 542};
    static final int[] expdigs53 = new int[]{0, 25360, 24109, 27591, 5};
    static final int[] expdigs54 = new int[]{0, 42852, 46771, 3552};
    static final int[] expdigs55 = new int[]{0, 28609, 34546, 35};
    static final int[] expdigs56 = new int[]{16384, 4218, 23283};
    static final int[] expdigs57 = new int[]{4096, 54437, 232};
    static final int[] expdigs58 = new int[]{58368, 21515, 2};
    static final int[] expdigs59 = new int[]{57600, 1525};
    static final int[] expdigs60 = new int[]{16960, 15};
    static final int[] expdigs61 = new int[]{10000};
    static final int[] expdigs62 = new int[]{100};
    static final int[] expdigs63 = new int[]{1};
    static final int[] expdigs64 = new int[]{36700, 62914, 23592, 49807, 10485, 36700, 62914, 23592, 49807, 10485, 36700, 62914, 23592, 655};
    static final int[] expdigs65 = new int[]{14784, 18979, 33659, 19503, 2726, 9542, 629, 2202, 40475, 10590, 4299, 47815, 36280, 6};
    static final int[] expdigs66 = new int[]{16332, 9978, 33613, 31138, 35584, 64252, 13857, 14424, 62281, 46279, 36150, 46573, 63392, 4294};
    static final int[] expdigs67 = new int[]{6716, 24348, 22618, 23904, 21327, 3919, 44703, 19149, 28803, 48959, 6259, 50273, 62237, 42};
    static final int[] expdigs68 = new int[]{8471, 23660, 38254, 26440, 33662, 38879, 9869, 11588, 41479, 23225, 60127, 24310, 32615, 28147};
    static final int[] expdigs69 = new int[]{13191, 6790, 63297, 30410, 12788, 42987, 23691, 28296, 32527, 38898, 41233, 4830, 31128, 281};
    static final int[] expdigs70 = new int[]{4064, 53152, 62236, 29139, 46658, 12881, 31694, 4870, 19986, 24637, 9587, 28884, 53395, 2};
    static final int[] expdigs71 = new int[]{26266, 10526, 16260, 55017, 35680, 40443, 19789, 17356, 30195, 55905, 28426, 63010, 44197, 1844};
    static final int[] expdigs72 = new int[]{38273, 7969, 37518, 26764, 23294, 63974, 18547, 17868, 24550, 41191, 17323, 53714, 29277, 18};
    static final int[] expdigs73 = new int[]{16739, 37738, 38090, 26589, 43521, 1543, 15713, 10671, 11975, 41533, 18106, 9348, 16921, 12089};
    static final int[] expdigs74 = new int[]{14585, 61981, 58707, 16649, 25994, 39992, 28337, 17801, 37475, 22697, 31638, 16477, 58496, 120};
    static final int[] expdigs75 = new int[]{58472, 2585, 40564, 27691, 44824, 27269, 58610, 54572, 35108, 30373, 35050, 10650, 13692, 1};
    static final int[] expdigs76 = new int[]{50392, 58911, 41968, 49557, 29112, 29939, 43526, 63500, 55595, 27220, 25207, 38361, 18456, 792};
    static final int[] expdigs77 = new int[]{26062, 32046, 3696, 45060, 46821, 40931, 50242, 60272, 24148, 20588, 6150, 44948, 60477, 7};
    static final int[] expdigs78 = new int[]{12430, 30407, 320, 41980, 58777, 41755, 41041, 13609, 45167, 13348, 40838, 60354, 19454, 5192};
    static final int[] expdigs79 = new int[]{30926, 26518, 13110, 43018, 54982, 48258, 24658, 15209, 63366, 11929, 20069, 43857, 60487, 51};
    static final int[] expdigs80 = new int[]{51263, 54048, 48761, 48627, 30576, 49046, 4414, 61195, 61755, 48474, 19124, 55906, 15511, 34028};
    static final int[] expdigs81 = new int[]{39834, 11681, 47018, 3107, 64531, 54229, 41331, 41899, 51735, 42427, 59173, 13010, 18505, 340};
    static final int[] expdigs82 = new int[]{27268, 6670, 31272, 9861, 45865, 10372, 12865, 62678, 23454, 35158, 20252, 29621, 26399, 3};
    static final int[] expdigs83 = new int[]{57738, 46147, 66, 48154, 11239, 21430, 55809, 46003, 15044, 25138, 52780, 48043, 4883, 2230};
    static final int[] expdigs84 = new int[]{20893, 62065, 64225, 52254, 59094, 55919, 60195, 5702, 48647, 50058, 7736, 41768, 19709, 22};
    static final int[] expdigs85 = new int[]{37714, 32321, 45840, 36031, 33290, 47121, 5146, 28127, 9887, 25390, 52929, 2698, 1073, 14615};
    static final int[] expdigs86 = new int[]{35111, 8187, 18153, 56721, 40309, 59453, 51824, 4868, 45974, 3530, 43783, 8546, 9841, 146};
    static final int[] expdigs87 = new int[]{23288, 61030, 42779, 19572, 29894, 47780, 45082, 32816, 43713, 33458, 25341, 63655, 30244, 1};
    static final int[] expdigs88 = new int[]{58138, 33000, 62869, 37127, 61799, 298, 46353, 5693, 63898, 62040, 989, 23191, 53065, 957};
    static final int[] expdigs89 = new int[]{42524, 32442, 36673, 15444, 22900, 658, 61412, 32824, 21610, 64190, 1975, 11373, 37886, 9};
    static final int[] expdigs90 = new int[]{26492, 4357, 32437, 10852, 34233, 53968, 55056, 34692, 64553, 38226, 41929, 21646, 6667, 6277};
    static final int[] expdigs91 = new int[]{61213, 698, 16053, 50571, 2963, 50347, 13657, 48188, 46520, 19387, 33187, 25775, 50529, 62};
    static final int[] expdigs92 = new int[]{42864, 54351, 45226, 20476, 23443, 17724, 3780, 44701, 52910, 23402, 28374, 46862, 40234, 41137};
    static final int[] expdigs93 = new int[]{23366, 62147, 58123, 44113, 55284, 39498, 3314, 9622, 9704, 27759, 25187, 43722, 24650, 411};
    static final int[] expdigs94 = new int[]{38899, 44530, 19586, 37141, 1863, 9570, 32801, 31553, 51870, 62536, 51369, 30583, 7455, 4};
    static final int[] expdigs95 = new int[]{10421, 4321, 43699, 3472, 65252, 17057, 13858, 29819, 14733, 21490, 40602, 31315, 65186, 2695};
    static final int[] expdigs96 = new int[]{6002, 54438, 29272, 34113, 17036, 25074, 36183, 953, 25051, 12011, 20722, 4245, 62911, 26};
    static final int[] expdigs97 = new int[]{14718, 45935, 8408, 42891, 21312, 56531, 44159, 45581, 20325, 36295, 35509, 24455, 30844, 17668};
    static final int[] expdigs98 = new int[]{54542, 45023, 23021, 3050, 31015, 20881, 50904, 40432, 33626, 14125, 44264, 60537, 44872, 176};
    static final int[] expdigs99 = new int[]{60183, 8969, 14648, 17725, 11451, 50016, 34587, 46279, 19341, 42084, 16826, 5848, 50256, 1};
    static final int[] expdigs100 = new int[]{64999, 53685, 60382, 19151, 25736, 5357, 31302, 23283, 14225, 52622, 56781, 39489, 60351, 1157};
    static final int[] expdigs101 = new int[]{1305, 4469, 39270, 18541, 63827, 59035, 54707, 16616, 32910, 48367, 64137, 2360, 37959, 11};
    static final int[] expdigs102 = new int[]{45449, 32125, 19705, 56098, 51958, 5225, 18285, 13654, 9341, 25888, 50946, 26855, 36068, 7588};
    static final int[] expdigs103 = new int[]{27324, 53405, 43450, 25464, 3796, 3329, 46058, 53220, 26307, 53998, 33932, 23861, 58032, 75};
    static final int[] expdigs104 = new int[]{63080, 50735, 1844, 21406, 57926, 63607, 24936, 52889, 23469, 64488, 539, 8859, 21210, 49732};
    static final int[] expdigs105 = new int[]{62890, 39828, 3950, 32982, 39245, 21607, 40226, 50991, 18584, 10475, 59643, 40720, 21183, 497};
    static final int[] expdigs106 = new int[]{37329, 64623, 11835, 985, 46923, 48712, 28582, 21481, 28366, 41392, 13703, 49559, 63781, 4};
    static final int[] expdigs107 = new int[]{3316, 60011, 41933, 47959, 54404, 39790, 12283, 941, 46090, 42226, 18108, 38803, 16879, 3259};
    static final int[] expdigs108 = new int[]{46563, 56305, 5006, 45044, 49040, 12849, 778, 6563, 46336, 3043, 7390, 2354, 38835, 32};
    static final int[] expdigs109 = new int[]{28653, 3742, 33331, 2671, 39772, 29981, 56489, 1973, 26280, 26022, 56391, 56434, 57039, 21359};
    static final int[] expdigs110 = new int[]{9461, 17732, 7542, 26241, 8917, 24548, 61513, 13126, 59245, 41547, 1874, 41852, 39236, 213};
    static final int[] expdigs111 = new int[]{36794, 22459, 63645, 14024, 42032, 53329, 25518, 11272, 18287, 20076, 62933, 3039, 8912, 2};
    static final int[] expdigs112 = new int[]{14926, 15441, 32337, 42579, 26354, 35154, 22815, 36955, 12564, 8047, 856, 41917, 55080, 1399};
    static final int[] expdigs113 = new int[]{8668, 50617, 10153, 17465, 1574, 28532, 15301, 58041, 38791, 60373, 663, 29255, 65431, 13};
    static final int[] expdigs114 = new int[]{21589, 32199, 24754, 45321, 9349, 26230, 35019, 37508, 20896, 42986, 31405, 12458, 65173, 9173};
    static final int[] expdigs115 = new int[]{46746, 1632, 61196, 50915, 64318, 41549, 2971, 23968, 59191, 58756, 61917, 779, 48493, 91};
    static final int[] expdigs116 = new int[]{1609, 63382, 15744, 15685, 51627, 56348, 33838, 52458, 44148, 11077, 56293, 41906, 45227, 60122};
    static final int[] expdigs117 = new int[]{19676, 45198, 6055, 38823, 8380, 49060, 17377, 58196, 43039, 21737, 59545, 12870, 14870, 601};
    static final int[] expdigs118 = new int[]{4128, 2418, 28241, 13495, 26298, 3767, 31631, 5169, 8950, 27087, 56956, 4060, 804, 6};
    static final int[] expdigs119 = new int[]{39930, 40673, 19029, 54677, 38145, 23200, 41325, 24564, 24955, 54484, 23863, 52998, 13147, 3940};
    static final int[] expdigs120 = new int[]{3676, 24655, 34924, 27416, 23974, 887, 10899, 4833, 21221, 28725, 19899, 57546, 26345, 39};
    static final int[] expdigs121 = new int[]{28904, 41324, 18596, 42292, 12070, 52013, 30810, 61057, 55753, 32324, 38953, 6752, 32688, 25822};
    static final int[] expdigs122 = new int[]{42232, 26627, 2807, 27948, 50583, 49016, 32420, 64180, 3178, 3600, 21361, 52496, 14744, 258};
    static final int[] expdigs123 = new int[]{2388, 59904, 28863, 7488, 31963, 8354, 47510, 15059, 2653, 58363, 31670, 21496, 38158, 2};
    static final int[] expdigs124 = new int[]{50070, 5266, 26158, 10774, 15148, 6873, 30230, 33898, 63720, 51799, 4515, 50124, 19875, 1692};
    static final int[] expdigs125 = new int[]{54240, 3984, 12058, 2729, 13914, 11865, 38313, 39660, 10467, 20834, 36745, 57517, 60491, 16};
    static final int[] expdigs126 = new int[]{5387, 58214, 9214, 13883, 14445, 34873, 21745, 13490, 23334, 25008, 58535, 19372, 44484, 11090};
    static final int[] expdigs127 = new int[]{27578, 64807, 12543, 794, 13907, 61297, 12013, 64360, 15961, 20566, 24178, 15922, 59427, 110};
    static final int[] expdigs128 = new int[]{49427, 41935, 46000, 59645, 45358, 51075, 15848, 32756, 38170, 14623, 35631, 57175, 7147, 1};
    static final int[] expdigs129 = new int[]{33941, 39160, 55469, 45679, 22878, 60091, 37210, 18508, 1638, 57398, 65026, 41643, 54966, 726};
    static final int[] expdigs130 = new int[]{60632, 24639, 41842, 62060, 20544, 59583, 52800, 1495, 48513, 43827, 10480, 1727, 17589, 7};
    static final int[] expdigs131 = new int[]{5590, 60244, 53985, 26632, 53049, 33628, 58267, 54922, 21641, 62744, 58109, 2070, 26887, 4763};
    static final int[] expdigs132 = new int[]{62970, 37957, 34618, 29757, 24123, 2302, 17622, 58876, 44780, 6525, 33349, 36065, 41556, 47};
    static final int[] expdigs133 = new int[]{1615, 24878, 20040, 11487, 23235, 27766, 59005, 57847, 60881, 11588, 63635, 61281, 31817, 31217};
    static final int[] expdigs134 = new int[]{14434, 2870, 65081, 44023, 40864, 40254, 47120, 6476, 32066, 23053, 17020, 19618, 11459, 312};
    static final int[] expdigs135 = new int[]{43398, 40005, 36695, 8304, 12205, 16131, 42414, 38075, 63890, 2851, 61774, 59833, 7978, 3};
    static final int[] expdigs136 = new int[]{56426, 22060, 15473, 31824, 19088, 38788, 64386, 12875, 35770, 65519, 11824, 19623, 56959, 2045};
    static final int[] expdigs137 = new int[]{16292, 32333, 10640, 47504, 29026, 30534, 23581, 6682, 10188, 24248, 44027, 51969, 30060, 20};
    static final int[] expdigs138 = new int[]{29432, 37518, 55373, 2727, 33243, 22572, 16689, 35625, 34145, 15830, 59880, 32552, 52948, 13407};
    static final int[] expdigs139 = new int[]{61898, 27244, 41841, 33450, 18682, 13988, 24415, 11497, 1652, 34237, 34677, 325, 5117, 134};
    static final int[] expdigs140 = new int[]{16347, 3549, 48915, 22616, 21158, 51913, 32356, 21086, 3293, 8862, 1002, 26873, 22333, 1};
    static final int[] expdigs141 = new int[]{25966, 63733, 28215, 31946, 40858, 58538, 11004, 6877, 6109, 3965, 35478, 37365, 45488, 878};
    static final int[] expdigs142 = new int[]{45479, 34060, 17321, 19980, 1719, 16314, 29601, 8588, 58388, 22321, 14117, 63288, 51572, 8};
    static final int[] expdigs143 = new int[]{46861, 47640, 11481, 23766, 46730, 53756, 8682, 60589, 42028, 27453, 29714, 31598, 39954, 5758};
    static final int[] expdigs144 = new int[]{29304, 58803, 51232, 27762, 60760, 17576, 19092, 26820, 11561, 48771, 6850, 27841, 38410, 57};
    static final int[] expdigs145 = new int[]{2916, 49445, 34666, 46387, 18627, 58279, 60468, 190, 3545, 51889, 51605, 47909, 40910, 37739};
    static final int[] expdigs146 = new int[]{19034, 62098, 15419, 33887, 38852, 53011, 28129, 37357, 11176, 48360, 9035, 9654, 25968, 377};
    static final int[] expdigs147 = new int[]{25094, 10451, 7363, 55389, 57404, 27399, 11422, 39695, 28947, 12935, 61694, 26310, 50722, 3};
    static final int[][] expdigstable = new int[][]{expdigs0, expdigs1, expdigs2, expdigs3, expdigs4, expdigs5, expdigs6, expdigs7, expdigs8, expdigs9, expdigs10, expdigs11, expdigs12, expdigs13, expdigs14, expdigs15, expdigs16, expdigs17, expdigs18, expdigs19, expdigs20, expdigs21, expdigs22, expdigs23, expdigs24, expdigs25, expdigs26, expdigs27, expdigs28, expdigs29, expdigs30, expdigs31, expdigs32, expdigs33, expdigs34, expdigs35, expdigs36, expdigs37, expdigs38, expdigs39, expdigs40, expdigs41, expdigs42, expdigs43, expdigs44, expdigs45, expdigs46, expdigs47, expdigs48, expdigs49, expdigs50, expdigs51, expdigs52, expdigs53, expdigs54, expdigs55, expdigs56, expdigs57, expdigs58, expdigs59, expdigs60, expdigs61, expdigs62, expdigs63, expdigs64, expdigs65, expdigs66, expdigs67, expdigs68, expdigs69, expdigs70, expdigs71, expdigs72, expdigs73, expdigs74, expdigs75, expdigs76, expdigs77, expdigs78, expdigs79, expdigs80, expdigs81, expdigs82, expdigs83, expdigs84, expdigs85, expdigs86, expdigs87, expdigs88, expdigs89, expdigs90, expdigs91, expdigs92, expdigs93, expdigs94, expdigs95, expdigs96, expdigs97, expdigs98, expdigs99, expdigs100, expdigs101, expdigs102, expdigs103, expdigs104, expdigs105, expdigs106, expdigs107, expdigs108, expdigs109, expdigs110, expdigs111, expdigs112, expdigs113, expdigs114, expdigs115, expdigs116, expdigs117, expdigs118, expdigs119, expdigs120, expdigs121, expdigs122, expdigs123, expdigs124, expdigs125, expdigs126, expdigs127, expdigs128, expdigs129, expdigs130, expdigs131, expdigs132, expdigs133, expdigs134, expdigs135, expdigs136, expdigs137, expdigs138, expdigs139, expdigs140, expdigs141, expdigs142, expdigs143, expdigs144, expdigs145, expdigs146, expdigs147};
    static final int[] nexpdigstable = new int[]{14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 13, 13, 13, 12, 12, 11, 11, 10, 10, 10, 9, 9, 8, 8, 8, 7, 7, 6, 6, 5, 5, 5, 4, 4, 3, 3, 3, 2, 2, 1, 1, 1, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
    static final int[] binexpstable = new int[]{90, 89, 89, 88, 88, 88, 87, 87, 86, 86, 86, 85, 85, 84, 84, 83, 83, 83, 82, 82, 81, 81, 81, 80, 80, 79, 79, 78, 78, 78, 77, 77, 76, 76, 76, 75, 75, 74, 74, 73, 73, 73, 72, 72, 71, 71, 71, 70, 70, 69, 69, 68, 68, 68, 67, 67, 66, 66, 66, 65, 65, 64, 64, 64, 63, 63, 62, 62, 61, 61, 61, 60, 60, 59, 59, 59, 58, 58, 57, 57, 56, 56, 56, 55, 55, 54, 54, 54, 53, 53, 52, 52, 51, 51, 51, 50, 50, 49, 49, 49, 48, 48, 47, 47, 46, 46, 46, 45, 45, 44, 44, 44, 43, 43, 42, 42, 41, 41, 41, 40, 40, 39, 39, 39, 38, 38, 37, 37, 37, 36, 36, 35, 35, 34, 34, 34, 33, 33, 32, 32, 32, 31, 31, 30, 30, 29, 29, 29};

    NumberCommonAccessor(OracleStatement _statement, int _representationMaxLength, boolean isStoredInBindData) {
        super(Representation.NUMBER, _statement, _representationMaxLength, isStoredInBindData);
        this.tmpBytes = new byte[this.representationMaxLength];
    }

    void init(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind) throws SQLException {
        this.init(stmt, 6, 6, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    void init(OracleStatement stmt, int internal_type, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        this.init(stmt, 6, 6, form, false);
        this.initForDescribe(internal_type, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        super.initForDataAccess(external_type, max_len, typeName);
        ++this.byteLength;
    }

    @Override
    int getInt(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0;
        }
        int len = this.getLength(currentRow);
        this.rowData.get(this.getOffset(currentRow), this.tmpBytes, 0, len);
        return NumberCommonAccessor.decodeInt(this.tmpBytes, len, this.getConnectionDuringExceptionHandling());
    }

    @Override
    boolean getBoolean(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return false;
        }
        int len = this.getLength(currentRow);
        this.rowData.get(this.getOffset(currentRow), this.tmpBytes, 0, len);
        return NumberCommonAccessor.decodeBoolean(this.tmpBytes, len);
    }

    @Override
    short getShort(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0;
        }
        int len = this.getLength(currentRow);
        this.rowData.get(this.getOffset(currentRow), this.tmpBytes, 0, len);
        return NumberCommonAccessor.decodeShort(this.tmpBytes, len, this.getConnectionDuringExceptionHandling());
    }

    @Override
    byte getByte(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0;
        }
        int len = this.getLength(currentRow);
        this.rowData.get(this.getOffset(currentRow), this.tmpBytes, 0, len);
        return NumberCommonAccessor.decodeByte(this.tmpBytes, len, this.getConnectionDuringExceptionHandling());
    }

    @Override
    long getLong(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0L;
        }
        int len = this.getLength(currentRow);
        this.rowData.get(this.getOffset(currentRow), this.tmpBytes, 0, len);
        return NumberCommonAccessor.decodeLong(this.tmpBytes, len, this.getConnectionDuringExceptionHandling());
    }

    @Override
    float getFloat(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0.0f;
        }
        int len = this.getLength(currentRow);
        this.rowData.get(this.getOffset(currentRow), this.tmpBytes, 0, len);
        return NumberCommonAccessor.decodeFloat(this.tmpBytes, len);
    }

    @Override
    double getDouble(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0.0;
        }
        int len = this.getLength(currentRow);
        this.rowData.get(this.getOffset(currentRow), this.tmpBytes, 0, len);
        return NumberCommonAccessor.decodeDouble(this.tmpBytes, len);
    }

    double getDoubleImprecise(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return 0.0;
        }
        int len = this.getLength(currentRow);
        this.rowData.get(this.getOffset(currentRow), this.tmpBytes, 0, len);
        byte expbyte = this.tmpBytes[0];
        double number = 0.0;
        int digidx = 1;
        if ((expbyte & 0xFFFFFF80) != 0) {
            if (expbyte == -128 && len == 1) {
                return 0.0;
            }
            if (len == 2 && expbyte == -1 && this.tmpBytes[1] == 101) {
                return Double.POSITIVE_INFINITY;
            }
            byte exponent = (byte)((expbyte & 0xFFFFFF7F) - 65);
            int ndigits = len - 1;
            int factidx = (int)(127.0 - (double)exponent);
            int i = ndigits % 4;
            switch (i) {
                case 1: {
                    number = (double)(this.tmpBytes[digidx] - 1) * factorTable[factidx];
                    break;
                }
                case 2: {
                    number = (double)((this.tmpBytes[digidx] - 1) * 100 + (this.tmpBytes[digidx + 1] - 1)) * factorTable[factidx + 1];
                    break;
                }
                case 3: {
                    number = (double)((this.tmpBytes[digidx] - 1) * 10000 + (this.tmpBytes[digidx + 1] - 1) * 100 + (this.tmpBytes[digidx + 2] - 1)) * factorTable[factidx + 2];
                    break;
                }
            }
            while (i < ndigits) {
                number += (double)((this.tmpBytes[digidx + i] - 1) * 1000000 + (this.tmpBytes[digidx + i + 1] - 1) * 10000 + (this.tmpBytes[digidx + i + 2] - 1) * 100 + (this.tmpBytes[digidx + i + 3] - 1)) * factorTable[factidx + i + 3];
                i += 4;
            }
        } else {
            if (expbyte == 0 && len == 1) {
                return Double.NEGATIVE_INFINITY;
            }
            byte exponent = (byte)((~expbyte & 0xFFFFFF7F) - 65);
            int ndigits = len - 1;
            if (ndigits != 20 || this.tmpBytes[ndigits] == 102) {
                --ndigits;
            }
            int factidx = (int)(127.0 - (double)exponent);
            int i = ndigits % 4;
            switch (i) {
                case 1: {
                    number = (double)(101 - this.tmpBytes[digidx]) * factorTable[factidx];
                    break;
                }
                case 2: {
                    number = (double)((101 - this.tmpBytes[digidx]) * 100 + (101 - this.tmpBytes[digidx + 1])) * factorTable[factidx + 1];
                    break;
                }
                case 3: {
                    number = (double)((101 - this.tmpBytes[digidx]) * 10000 + (101 - this.tmpBytes[digidx + 1]) * 100 + (101 - this.tmpBytes[digidx + 2])) * factorTable[factidx + 2];
                    break;
                }
            }
            while (i < ndigits) {
                number += (double)((101 - this.tmpBytes[digidx + i]) * 1000000 + (101 - this.tmpBytes[digidx + i + 1]) * 10000 + (101 - this.tmpBytes[digidx + i + 2]) * 100 + (101 - this.tmpBytes[digidx + i + 3])) * factorTable[factidx + i + 3];
                i += 4;
            }
            number = -number;
        }
        return number;
    }

    @Override
    BigDecimal getBigDecimal(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        int len = this.getLength(currentRow);
        assert (len > 0) : "Length not positive";
        this.rowData.get(this.getOffset(currentRow), this.tmpBytes, 0, len);
        for (int i = 0; i < 27; ++i) {
            this.digs[i] = 0;
        }
        return NumberCommonAccessor.decodeBigDecimal(this.tmpBytes, len, this.digs, this.getConnectionDuringExceptionHandling());
    }

    @Override
    BigDecimal getBigDecimal(int currentRow, int scale) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return this.getBigDecimal(currentRow).setScale(scale, 6);
    }

    @Override
    BigInteger getBigInteger(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return this.getBigDecimal(currentRow).toBigInteger();
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        byte[] bytes = this.getBytesInternal(currentRow);
        return NumberCommonAccessor.decodeString(bytes, bytes.length);
    }

    @Override
    NUMBER getNUMBER(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return new NUMBER(this.getBytesInternal(currentRow));
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        Number result = null;
        if (this.externalType == 0) {
            result = this.statement.connection.j2ee13Compliant && this.precision != 0 && this.scale == -127 ? new Double(this.getDouble(currentRow)) : this.getBigDecimal(currentRow);
        } else {
            switch (this.externalType) {
                case -7: {
                    return this.getBoolean(currentRow);
                }
                case -6: {
                    return this.getByte(currentRow);
                }
                case 5: {
                    return this.getShort(currentRow);
                }
                case 4: {
                    return this.getInt(currentRow);
                }
                case -5: {
                    return this.getLong(currentRow);
                }
                case 6: 
                case 8: {
                    return this.getDouble(currentRow);
                }
                case 7: {
                    return Float.valueOf(this.getFloat(currentRow));
                }
                case 2: 
                case 3: {
                    return this.getBigDecimal(currentRow);
                }
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
        return result;
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(currentRow);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getNUMBER(currentRow);
    }

    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return this.getBytesInternal(currentRow);
    }

    void throwOverflow() throws SQLException {
        NumberCommonAccessor.throwOverflow(this.getConnectionDuringExceptionHandling());
    }

    static byte decodeByte(byte[] encodedNumber, int encodingLength, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        byte expbyte = encodedNumber[0];
        int intNum = 0;
        if ((expbyte & 0xFFFFFF80) != 0) {
            byte mantlen;
            byte exponent = (byte)((expbyte & 0xFFFFFF7F) - 65);
            if (exponent > 1) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
            if ((mantlen = (byte)(encodingLength - 1)) > exponent + 1) {
                switch (exponent) {
                    default: {
                        break;
                    }
                    case -1: {
                        break;
                    }
                    case 0: {
                        intNum = encodedNumber[1] - 1;
                        break;
                    }
                    case 1: {
                        intNum = (encodedNumber[1] - 1) * 100 + (encodedNumber[2] - 1);
                        if (intNum > 127) {
                            NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (mantlen == 1) {
                if (exponent == 1) {
                    intNum = (encodedNumber[1] - 1) * 100;
                    if (intNum > 127) {
                        NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                    }
                } else {
                    intNum = encodedNumber[1] - 1;
                }
            } else if (mantlen == 2 && (intNum = (encodedNumber[1] - 1) * 100 + (encodedNumber[2] - 1)) > 127) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
        } else {
            byte mantlen;
            byte exponent = (byte)((~expbyte & 0xFFFFFF7F) - 65);
            if (exponent > 1) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
            if ((mantlen = (byte)(encodingLength - 1)) != 20 || encodedNumber[mantlen] == 102) {
                mantlen = (byte)(mantlen - 1);
            }
            if (mantlen > exponent + 1) {
                switch (exponent) {
                    default: {
                        break;
                    }
                    case -1: {
                        break;
                    }
                    case 0: {
                        intNum = -(101 - encodedNumber[1]);
                        break;
                    }
                    case 1: {
                        intNum = -((101 - encodedNumber[1]) * 100 + (101 - encodedNumber[2]));
                        if (intNum < -128) {
                            NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (mantlen == 1) {
                if (exponent == 1) {
                    intNum = -(101 - encodedNumber[1]) * 100;
                    if (intNum < -128) {
                        NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                    }
                } else {
                    intNum = -(101 - encodedNumber[1]);
                }
            } else if (mantlen == 2 && (intNum = -((101 - encodedNumber[1]) * 100 + (101 - encodedNumber[2]))) < -128) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
        }
        return (byte)intNum;
    }

    static short decodeShort(byte[] encodedNumber, int encodingLength, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        byte expbyte = encodedNumber[0];
        int intNum = 0;
        if ((expbyte & 0xFFFFFF80) != 0) {
            int i;
            byte mantlen;
            int convDigs;
            byte exponent = (byte)((expbyte & 0xFFFFFF7F) - 65);
            if (exponent > 2) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
            int convDigsOffset = convDigs = (mantlen = (byte)(encodingLength - 1)) > exponent + 1 ? exponent + 2 : mantlen + 1;
            if (convDigs > 1) {
                intNum = encodedNumber[1] - 1;
                for (i = 2; i < convDigsOffset; ++i) {
                    intNum = intNum * 100 + (encodedNumber[i] - 1);
                }
            }
            for (i = exponent - mantlen; i >= 0; --i) {
                intNum *= 100;
            }
            if (exponent == 2 && intNum > Short.MAX_VALUE) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
        } else {
            int i;
            int convDigs;
            byte mantlen;
            byte exponent = (byte)((~expbyte & 0xFFFFFF7F) - 65);
            if (exponent > 2) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
            if ((mantlen = (byte)(encodingLength - 1)) != 20 || encodedNumber[mantlen] == 102) {
                mantlen = (byte)(mantlen - 1);
            }
            int convDigsOffset = convDigs = mantlen > exponent + 1 ? exponent + 2 : mantlen + 1;
            if (convDigs > 1) {
                intNum = 101 - encodedNumber[1];
                for (i = 2; i < convDigsOffset; ++i) {
                    intNum = intNum * 100 + (101 - encodedNumber[i]);
                }
            }
            for (i = exponent - mantlen; i >= 0; --i) {
                intNum *= 100;
            }
            intNum = -intNum;
            if (exponent == 2 && intNum < Short.MIN_VALUE) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
        }
        return (short)intNum;
    }

    static int decodeInt(byte[] encodedNumber, int encodingLength, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        byte expbyte = encodedNumber[0];
        int intNum = 0;
        if ((expbyte & 0xFFFFFF80) != 0) {
            int convDigs;
            byte mantlen = (byte)(encodingLength - 1);
            byte exponent = (byte)((expbyte & 0xFFFFFF7F) - 65);
            int convDigsOffset = convDigs = mantlen > exponent + 1 ? exponent + 2 : mantlen + 1;
            if (exponent >= 4) {
                int i;
                if (exponent > 4) {
                    NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                }
                long longNum = 0L;
                if (convDigs > 1) {
                    longNum = encodedNumber[1] - 1;
                    for (i = 2; i < convDigsOffset; ++i) {
                        longNum = longNum * 100L + (long)(encodedNumber[i] - 1);
                    }
                }
                for (i = exponent - mantlen; i >= 0; --i) {
                    longNum *= 100L;
                }
                if (longNum > Integer.MAX_VALUE) {
                    NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                }
                intNum = (int)longNum;
            } else {
                int i;
                if (convDigs > 1) {
                    intNum = encodedNumber[1] - 1;
                    for (i = 2; i < convDigsOffset; ++i) {
                        intNum = intNum * 100 + (encodedNumber[i] - 1);
                    }
                }
                for (i = exponent - mantlen; i >= 0; --i) {
                    intNum *= 100;
                }
            }
        } else {
            int convDigs;
            byte exponent = (byte)((~expbyte & 0xFFFFFF7F) - 65);
            byte mantlen = (byte)(encodingLength - 1);
            if (mantlen != 20 || encodedNumber[mantlen] == 102) {
                mantlen = (byte)(mantlen - 1);
            }
            int convDigsOffset = convDigs = mantlen > exponent + 1 ? exponent + 2 : mantlen + 1;
            if (exponent >= 4) {
                int i;
                if (exponent > 4) {
                    NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                }
                long longNum = 0L;
                if (convDigs > 1) {
                    longNum = 101 - encodedNumber[1];
                    for (i = 2; i < convDigsOffset; ++i) {
                        longNum = longNum * 100L + (long)(101 - encodedNumber[i]);
                    }
                }
                for (i = exponent - mantlen; i >= 0; --i) {
                    longNum *= 100L;
                }
                if ((longNum = -longNum) < Integer.MIN_VALUE) {
                    NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                }
                intNum = (int)longNum;
            } else {
                int i;
                if (convDigs > 1) {
                    intNum = 101 - encodedNumber[1];
                    for (i = 2; i < convDigsOffset; ++i) {
                        intNum = intNum * 100 + (101 - encodedNumber[i]);
                    }
                }
                for (i = exponent - mantlen; i >= 0; --i) {
                    intNum *= 100;
                }
                intNum = -intNum;
            }
        }
        return intNum;
    }

    static long decodeLong(byte[] encodedNumber, int encodingLength, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        byte expbyte = encodedNumber[0];
        long longNum = 0L;
        if ((expbyte & 0xFFFFFF80) != 0) {
            int i;
            byte mantlen;
            int convDigs;
            if (expbyte == -128 && encodingLength == 1) {
                return 0L;
            }
            byte exponent = (byte)((expbyte & 0xFFFFFF7F) - 65);
            if (exponent > 9) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
            if (exponent == 9) {
                int ci = 1;
                int cl = encodingLength;
                if (encodingLength > 11) {
                    cl = 11;
                }
                while (ci < cl) {
                    int ubytes = encodedNumber[ci] & 0xFF;
                    int umax = MAX_LONG[ci];
                    if (ubytes != umax) {
                        if (ubytes < umax) break;
                        NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                    }
                    ++ci;
                }
                if (ci == cl && encodingLength > 11) {
                    NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                }
            }
            int convDigsOffset = convDigs = (mantlen = (byte)(encodingLength - 1)) > exponent + 1 ? exponent + 2 : mantlen + 1;
            if (convDigs > 1) {
                longNum = encodedNumber[1] - 1;
                for (i = 2; i < convDigsOffset; ++i) {
                    longNum = longNum * 100L + (long)(encodedNumber[i] - 1);
                }
            }
            for (i = exponent - mantlen; i >= 0; --i) {
                longNum *= 100L;
            }
        } else {
            int i;
            int convDigs;
            byte mantlen;
            byte exponent = (byte)((~expbyte & 0xFFFFFF7F) - 65);
            if (exponent > 9) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
            if (exponent == 9) {
                int ci = 1;
                int cl = encodingLength;
                if (encodingLength > 12) {
                    cl = 12;
                }
                while (ci < cl) {
                    int ubytes = encodedNumber[ci] & 0xFF;
                    int umin = MIN_LONG[ci];
                    if (ubytes != umin) {
                        if (ubytes > umin) break;
                        NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                    }
                    ++ci;
                }
                if (ci == cl && encodingLength < 12) {
                    NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
                }
            }
            if ((mantlen = (byte)(encodingLength - 1)) != 20 || encodedNumber[mantlen] == 102) {
                mantlen = (byte)(mantlen - 1);
            }
            int convDigsOffset = convDigs = mantlen > exponent + 1 ? exponent + 2 : mantlen + 1;
            if (convDigs > 1) {
                longNum = 101 - encodedNumber[1];
                for (i = 2; i < convDigsOffset; ++i) {
                    longNum = longNum * 100L + (long)(101 - encodedNumber[i]);
                }
            }
            for (i = exponent - mantlen; i >= 0; --i) {
                longNum *= 100L;
            }
            longNum = -longNum;
        }
        return longNum;
    }

    static float decodeFloat(byte[] encodedNumber, int encodingLength) {
        byte expbyte = encodedNumber[0];
        double number = 0.0;
        int digidx = 1;
        if ((expbyte & 0xFFFFFF80) != 0) {
            if (expbyte == -128 && encodingLength == 1) {
                return 0.0f;
            }
            if (encodingLength == 2 && expbyte == -1 && encodedNumber[1] == 101) {
                return Float.POSITIVE_INFINITY;
            }
            byte exponent = (byte)((expbyte & 0xFFFFFF7F) - 65);
            int ndigits = encodingLength - 1;
            while (encodedNumber[digidx] == 1 && ndigits > 0) {
                ++digidx;
                --ndigits;
                exponent = (byte)(exponent - 1);
            }
            int factidx = (int)(127.0 - (double)exponent);
            switch (ndigits) {
                case 1: {
                    number = (double)(encodedNumber[digidx] - 1) * factorTable[factidx];
                    break;
                }
                case 2: {
                    number = (double)((encodedNumber[digidx] - 1) * 100 + (encodedNumber[digidx + 1] - 1)) * factorTable[factidx + 1];
                    break;
                }
                case 3: {
                    number = (double)((encodedNumber[digidx] - 1) * 10000 + (encodedNumber[digidx + 1] - 1) * 100 + (encodedNumber[digidx + 2] - 1)) * factorTable[factidx + 2];
                    break;
                }
                case 4: {
                    number = (double)((encodedNumber[digidx] - 1) * 1000000 + (encodedNumber[digidx + 1] - 1) * 10000 + (encodedNumber[digidx + 2] - 1) * 100 + (encodedNumber[digidx + 3] - 1)) * factorTable[factidx + 3];
                    break;
                }
                case 5: {
                    number = (double)((encodedNumber[digidx + 1] - 1) * 1000000 + (encodedNumber[digidx + 2] - 1) * 10000 + (encodedNumber[digidx + 3] - 1) * 100 + (encodedNumber[digidx + 4] - 1)) * factorTable[factidx + 4] + (double)(encodedNumber[digidx] - 1) * factorTable[factidx];
                    break;
                }
                case 6: {
                    number = (double)((encodedNumber[digidx + 2] - 1) * 1000000 + (encodedNumber[digidx + 3] - 1) * 10000 + (encodedNumber[digidx + 4] - 1) * 100 + (encodedNumber[digidx + 5] - 1)) * factorTable[factidx + 5] + (double)((encodedNumber[digidx] - 1) * 100 + (encodedNumber[digidx + 1] - 1)) * factorTable[factidx + 1];
                    break;
                }
                default: {
                    number = (double)((encodedNumber[digidx + 3] - 1) * 1000000 + (encodedNumber[digidx + 4] - 1) * 10000 + (encodedNumber[digidx + 5] - 1) * 100 + (encodedNumber[digidx + 6] - 1)) * factorTable[factidx + 6] + (double)((encodedNumber[digidx] - 1) * 10000 + (encodedNumber[digidx + 1] - 1) * 100 + (encodedNumber[digidx + 2] - 1)) * factorTable[factidx + 2];
                    break;
                }
            }
        } else {
            if (expbyte == 0 && encodingLength == 1) {
                return Float.NEGATIVE_INFINITY;
            }
            byte exponent = (byte)((~expbyte & 0xFFFFFF7F) - 65);
            int ndigits = encodingLength - 1;
            if (ndigits != 20 || encodedNumber[ndigits] == 102) {
                --ndigits;
            }
            while (encodedNumber[digidx] == 1 && ndigits > 0) {
                ++digidx;
                --ndigits;
                exponent = (byte)(exponent - 1);
            }
            int factidx = (int)(127.0 - (double)exponent);
            switch (ndigits) {
                case 1: {
                    number = (double)(-(101 - encodedNumber[digidx])) * factorTable[factidx];
                    break;
                }
                case 2: {
                    number = (double)(-((101 - encodedNumber[digidx]) * 100 + (101 - encodedNumber[digidx + 1]))) * factorTable[factidx + 1];
                    break;
                }
                case 3: {
                    number = (double)(-((101 - encodedNumber[digidx]) * 10000 + (101 - encodedNumber[digidx + 1]) * 100 + (101 - encodedNumber[digidx + 2]))) * factorTable[factidx + 2];
                    break;
                }
                case 4: {
                    number = (double)(-((101 - encodedNumber[digidx]) * 1000000 + (101 - encodedNumber[digidx + 1]) * 10000 + (101 - encodedNumber[digidx + 2]) * 100 + (101 - encodedNumber[digidx + 3]))) * factorTable[factidx + 3];
                    break;
                }
                case 5: {
                    number = -((double)((101 - encodedNumber[digidx + 1]) * 1000000 + (101 - encodedNumber[digidx + 2]) * 10000 + (101 - encodedNumber[digidx + 3]) * 100 + (101 - encodedNumber[digidx + 4])) * factorTable[factidx + 4] + (double)(101 - encodedNumber[digidx]) * factorTable[factidx]);
                    break;
                }
                case 6: {
                    number = -((double)((101 - encodedNumber[digidx + 2]) * 1000000 + (101 - encodedNumber[digidx + 3]) * 10000 + (101 - encodedNumber[digidx + 4]) * 100 + (101 - encodedNumber[digidx + 5])) * factorTable[factidx + 5] + (double)((101 - encodedNumber[digidx]) * 100 + (101 - encodedNumber[digidx + 1])) * factorTable[factidx + 1]);
                    break;
                }
                default: {
                    number = -((double)((101 - encodedNumber[digidx + 3]) * 1000000 + (101 - encodedNumber[digidx + 4]) * 10000 + (101 - encodedNumber[digidx + 5]) * 100 + (101 - encodedNumber[digidx + 6])) * factorTable[factidx + 6] + (double)((101 - encodedNumber[digidx]) * 10000 + (101 - encodedNumber[digidx + 1]) * 100 + (101 - encodedNumber[digidx + 2])) * factorTable[factidx + 2]);
                }
            }
        }
        return (float)number;
    }

    /*
     * Exception decompiling
     */
    static double decodeDouble(byte[] tmpBytes, int len) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ArithmeticOperation.applyExpressionRewriter(ArithmeticOperation.java:171)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:97)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static BigDecimal decodeBigDecimal(byte[] encodedNumber, int encodingLength, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        return NumberCommonAccessor.decodeBigDecimal(encodedNumber, encodingLength, new int[27], connectionDuringExceptionHandling);
    }

    static BigDecimal decodeBigDecimal(byte[] tmpBytes, int len, int[] digs, OracleConnection connectionDuringExceptionHandling) throws SQLException {
        byte[] barray;
        int numbytes;
        int scale;
        int clen;
        int mantlen;
        int signval;
        int dig26 = 0;
        int oidx = 1;
        int cnt = 26;
        int value = 0;
        byte expbyte = tmpBytes[0];
        boolean trailingZeroP = false;
        if ((expbyte & 0xFFFFFF80) != 0) {
            if (expbyte == -128 && len == 1) {
                return BIGDEC_ZERO;
            }
            if (len == 2 && expbyte == -1 && tmpBytes[1] == 101) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
            signval = 1;
            exponent = (byte)((expbyte & 0xFFFFFF7F) - 65);
            mantlen = len - 1;
            clen = mantlen - 1;
            scale = exponent - mantlen + 1 << 1;
            if (scale > 0) {
                scale = 0;
                clen = exponent;
            } else if (scale < 0) {
                trailingZeroP = (tmpBytes[mantlen] - 1) % 10 == 0;
            }
            int n = oidx;
            oidx = (byte)(oidx + 1);
            dig26 = tmpBytes[n] - 1;
            while ((clen & 1) != 0) {
                if (oidx > mantlen) {
                    dig26 *= 100;
                } else {
                    int n2 = oidx;
                    oidx = (byte)(oidx + 1);
                    dig26 = dig26 * 100 + (tmpBytes[n2] - 1);
                }
                --clen;
            }
        } else {
            if (expbyte == 0 && len == 1) {
                NumberCommonAccessor.throwOverflow(connectionDuringExceptionHandling);
            }
            signval = -1;
            exponent = (byte)((~expbyte & 0xFFFFFF7F) - 65);
            mantlen = len - 1;
            if (mantlen != 20 || tmpBytes[mantlen] == 102) {
                --mantlen;
            }
            clen = mantlen - 1;
            scale = exponent - mantlen + 1 << 1;
            if (scale > 0) {
                scale = 0;
                clen = exponent;
            } else if (scale < 0) {
                trailingZeroP = (101 - tmpBytes[mantlen]) % 10 == 0;
            }
            int n = oidx;
            oidx = (byte)(oidx + 1);
            dig26 = 101 - tmpBytes[n];
            while ((clen & 1) != 0) {
                if (oidx > mantlen) {
                    dig26 *= 100;
                } else {
                    int n3 = oidx;
                    oidx = (byte)(oidx + 1);
                    dig26 = dig26 * 100 + (101 - tmpBytes[n3]);
                }
                --clen;
            }
        }
        if (trailingZeroP) {
            ++scale;
            dig26 /= 10;
        }
        int lim = mantlen - 1;
        while (clen != 0) {
            int i;
            if (signval == 1) {
                if (trailingZeroP) {
                    value = (tmpBytes[oidx - 1] - 1) % 10 * 1000 + (tmpBytes[oidx] - 1) * 10 + (tmpBytes[oidx + 1] - 1) / 10 + dig26 * 10000;
                    oidx = (byte)(oidx + 2);
                } else if (oidx < lim) {
                    value = (tmpBytes[oidx] - 1) * 100 + (tmpBytes[oidx + 1] - 1) + dig26 * 10000;
                    oidx = (byte)(oidx + 2);
                } else {
                    value = 0;
                    if (oidx <= mantlen) {
                        i = 0;
                        while (oidx <= mantlen) {
                            int n = oidx;
                            oidx = (byte)(oidx + 1);
                            value = value * 100 + (tmpBytes[n] - 1);
                            ++i;
                        }
                        while (i < 2) {
                            value *= 100;
                            ++i;
                        }
                    }
                    value += dig26 * 10000;
                }
            } else if (trailingZeroP) {
                value = (101 - tmpBytes[oidx - 1]) % 10 * 1000 + (101 - tmpBytes[oidx]) * 10 + (101 - tmpBytes[oidx + 1]) / 10 + dig26 * 10000;
                oidx = (byte)(oidx + 2);
            } else if (oidx < lim) {
                value = (101 - tmpBytes[oidx]) * 100 + (101 - tmpBytes[oidx + 1]) + dig26 * 10000;
                oidx = (byte)(oidx + 2);
            } else {
                value = 0;
                if (oidx <= mantlen) {
                    i = 0;
                    while (oidx <= mantlen) {
                        int n = oidx;
                        oidx = (byte)(oidx + 1);
                        value = value * 100 + (101 - tmpBytes[n]);
                        ++i;
                    }
                    while (i < 2) {
                        value *= 100;
                        ++i;
                    }
                }
                value += dig26 * 10000;
            }
            dig26 = value & 0xFFFF;
            for (i = 25; i >= cnt; --i) {
                value = (value >> 16) + digs[i] * 10000;
                digs[i] = value & 0xFFFF;
            }
            if (cnt > 0 && (value >>= 16) != 0) {
                cnt = (byte)(cnt - 1);
                digs[cnt] = value;
            }
            clen -= 2;
        }
        digs[26] = dig26;
        byte x = (byte)(digs[cnt] >> 8 & 0xFF);
        if (x == 0) {
            numbytes = 53 - (cnt << 1);
            barray = new byte[numbytes];
            for (i = 26; i > cnt; --i) {
                j = i - cnt << 1;
                barray[j - 1] = (byte)(digs[i] >> 8 & 0xFF);
                barray[j] = (byte)(digs[i] & 0xFF);
            }
            barray[0] = (byte)(digs[cnt] & 0xFF);
        } else {
            numbytes = 54 - (cnt << 1);
            barray = new byte[numbytes];
            for (i = 26; i > cnt; --i) {
                j = i - cnt << 1;
                barray[j] = (byte)(digs[i] >> 8 & 0xFF);
                barray[j + 1] = (byte)(digs[i] & 0xFF);
            }
            barray[0] = x;
            barray[1] = (byte)(digs[cnt] & 0xFF);
        }
        if (scale == 0 && numbytes < 8 && numbytes > 0) {
            long bits = (long)barray[0] & 0xFFL;
            for (int i = 1; i < numbytes; ++i) {
                bits = bits << 8 | (long)(barray[i] & 0xFF);
            }
            return new BigDecimal(bits *= (long)signval);
        }
        BigInteger bigtemp = new BigInteger(signval, barray);
        return new BigDecimal(bigtemp, -scale);
    }

    static boolean decodeBoolean(byte[] encodedNumber, int encodingLength) {
        if (encodedNumber[0] == 0 && encodingLength == 1) {
            return false;
        }
        return encodingLength != 1 || encodedNumber[0] != -128;
    }

    static String decodeString(byte[] encodedNumber, int encodingLength) throws SQLException {
        String result;
        NUMBER oranum = new NUMBER(encodedNumber);
        String s = oracle.sql.NUMBER.toString(encodedNumber);
        int numlength = s.length();
        if (s.startsWith("0.") || s.startsWith("-0.")) {
            --numlength;
        }
        if (numlength > 38) {
            s = oranum.toText(-44, null);
            int idxe = s.indexOf(69);
            int idxpls = s.indexOf(43);
            if (idxe == -1) {
                idxe = s.indexOf(101);
            }
            int idx = idxe - 1;
            while (s.charAt(idx) == '0') {
                --idx;
            }
            String left = s.substring(0, idx + 1);
            String right = null;
            right = idxpls > 0 ? s.substring(idxpls + 1) : s.substring(idxe + 1);
            result = (left + "E" + right).trim();
        } else {
            result = oranum.toText(38, null).trim();
        }
        if (result.startsWith("-.")) {
            return "-0" + result.substring(1);
        }
        if (result.startsWith(".")) {
            return "0" + result;
        }
        return result;
    }

    static void throwOverflow(OracleConnection connectionDuringExceptionHandling) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(connectionDuringExceptionHandling, 26).fillInStackTrace();
    }
}

