/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class OracleTypeNUMBER
extends OracleType
implements Serializable {
    static final long serialVersionUID = -7182242886677299812L;
    int precision;
    int scale;

    protected OracleTypeNUMBER() {
    }

    protected OracleTypeNUMBER(int typecode) {
        super(typecode);
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(value, conn);
    }

    @Override
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(obj, conn, beginIdx, count);
    }

    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        this.precision = tdsReader.readUnsignedByte();
        this.scale = tdsReader.readByte();
    }

    protected static Object unpickle81NativeArray(PickleContext context, long beginIdx, int size, int style) throws SQLException {
        int i = 1;
        while ((long)i < beginIdx && size > 0) {
            context.skipDataValue();
            ++i;
        }
        byte[] val = null;
        switch (style) {
            case 4: {
                int[] holder = new int[size];
                for (int i2 = 0; i2 < size; ++i2) {
                    val = context.readDataValue();
                    if (val == null) continue;
                    holder[i2] = NUMBER.toInt(val);
                }
                return holder;
            }
            case 5: {
                double[] holder = new double[size];
                for (int i3 = 0; i3 < size; ++i3) {
                    val = context.readDataValue();
                    if (val == null) continue;
                    holder[i3] = NUMBER.toDouble(val);
                }
                return holder;
            }
            case 7: {
                long[] holder = new long[size];
                for (int i4 = 0; i4 < size; ++i4) {
                    val = context.readDataValue();
                    if (val == null) continue;
                    holder[i4] = NUMBER.toLong(val);
                }
                return holder;
            }
            case 6: {
                float[] holder = new float[size];
                for (int i5 = 0; i5 < size; ++i5) {
                    val = context.readDataValue();
                    if (val == null) continue;
                    holder[i5] = NUMBER.toFloat(val);
                }
                return holder;
            }
            case 8: {
                short[] holder = new short[size];
                for (int i6 = 0; i6 < size; ++i6) {
                    val = context.readDataValue();
                    if (val == null) continue;
                    holder[i6] = NUMBER.toShort(val);
                }
                return holder;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(23).fillInStackTrace();
    }

    @Override
    protected Object toObject(byte[] bytes, int style, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(bytes, style, map);
    }

    static Object toNumericObject(byte[] bytes, int style, Map map) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        switch (style) {
            case 1: {
                return new NUMBER(bytes);
            }
            case 2: {
                return NUMBER.toBigDecimal(bytes);
            }
            case 3: {
                return bytes;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(23).fillInStackTrace();
    }

    public static NUMBER toNUMBER(Object value, OracleConnection conn) throws SQLException {
        NUMBER datum = null;
        if (value != null) {
            try {
                datum = value instanceof NUMBER ? (NUMBER)value : new NUMBER(value);
            }
            catch (SQLException e) {
                throw (SQLException)DatabaseError.createSqlException(59, value).fillInStackTrace();
            }
        }
        return datum;
    }

    public static Datum[] toNUMBERArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof Object[] && !(obj instanceof char[][])) {
                Object[] objArray = (Object[])obj;
                int length = (int)(count == -1 ? (long)objArray.length : Math.min((long)objArray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[length];
                for (int i = 0; i < length; ++i) {
                    datumArray[i] = OracleTypeNUMBER.toNUMBER(objArray[(int)beginIdx + i - 1], conn);
                }
            } else {
                datumArray = OracleTypeNUMBER.cArrayToNUMBERArray(obj, conn, beginIdx, count);
            }
        }
        return datumArray;
    }

    static Datum[] cArrayToNUMBERArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof short[]) {
                short[] parray = (short[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(parray[(int)beginIdx + i - 1]);
                }
            } else if (obj instanceof int[]) {
                int[] parray = (int[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(parray[(int)beginIdx + i - 1]);
                }
            } else if (obj instanceof long[]) {
                long[] parray = (long[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(parray[(int)beginIdx + i - 1]);
                }
            } else if (obj instanceof float[]) {
                float[] parray = (float[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(parray[(int)beginIdx + i - 1]);
                }
            } else if (obj instanceof double[]) {
                double[] parray = (double[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(parray[(int)beginIdx + i - 1]);
                }
            } else if (obj instanceof boolean[]) {
                boolean[] parray = (boolean[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER((Object)parray[(int)beginIdx + i - 1]);
                }
            } else if (obj instanceof char[][]) {
                char[][] parray = (char[][])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(new String(parray[(int)beginIdx + i - 1]));
                }
            } else {
                throw (SQLException)DatabaseError.createSqlException(59, obj).fillInStackTrace();
            }
        }
        return datumArray;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.scale);
        out.writeInt(this.precision);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.scale = in.readInt();
        this.precision = in.readInt();
    }
}

