/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli.urlbuilder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import oracle.jdbc.driver.cli.urlbuilder.BuildUrlCommand;
import oracle.jdbc.driver.cli.urlbuilder.ConnectionOptionsHandler;
import oracle.jdbc.driver.cli.urlbuilder.DescriptionInfo;
import oracle.net.url.builder.ConnectDescriptorBuilder;

public class ConnectionOptionsIntegrator {
    private final ConnectionOptionsHandler optionsHandler = new ConnectionOptionsHandler();

    public boolean promptAndAttachOptions(Scanner scanner, DescriptionInfo description) {
        if (description == null) {
            return false;
        }
        System.out.println("\n=== Advanced Connection Options ===");
        boolean wantsAdvanced = BuildUrlCommand.promptBoolean(scanner, "Would you like to configure advanced connection options?", false);
        if (!wantsAdvanced) {
            return false;
        }
        Map<String, String> options = this.optionsHandler.promptConnectionOptions(scanner);
        if (options == null) {
            options = new HashMap<String, String>();
        }
        description.setAdvancedOptions(options);
        return !options.isEmpty();
    }

    public boolean promptAndAttachOptionsForDescriptions(Scanner scanner, List<DescriptionInfo> descriptions) {
        if (descriptions == null || descriptions.isEmpty()) {
            return false;
        }
        System.out.println("\n=== Advanced Connection Options ===");
        System.out.print("Would you like to configure advanced connection options for the descriptions? [y/n]: ");
        boolean optionsConfigured = false;
        while (true) {
            String response;
            if ((response = scanner.nextLine().trim().toLowerCase()).equals("y")) {
                for (int i = 0; i < descriptions.size(); ++i) {
                    System.out.println("\n--- Options for Description " + (i + 1) + " ---");
                    Map<String, String> options = this.optionsHandler.promptConnectionOptions(scanner);
                    descriptions.get(i).setAdvancedOptions(options);
                    if (options.isEmpty()) continue;
                    optionsConfigured = true;
                }
                break;
            }
            if (response.equals("n")) break;
            System.out.println("Invalid input. Please enter 'y' or 'n'.");
        }
        return optionsConfigured;
    }

    public void applyOptions(ConnectDescriptorBuilder.DescriptionNode description, Map<String, String> options) {
        if (description == null || options == null || options.isEmpty()) {
            return;
        }
        this.optionsHandler.applyConnectionOptions(description, options);
    }

    public String formatOptionsForReview(Map<String, String> options) {
        if (options == null || options.isEmpty()) {
            return "None";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            sb.append("\n    ").append(entry.getKey()).append(" = ").append(entry.getValue());
        }
        return sb.toString();
    }

    public String formatAdvancedOptionsForDescriptionReview(List<DescriptionInfo> descriptions) {
        if (descriptions == null || descriptions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < descriptions.size(); ++i) {
            DescriptionInfo desc = descriptions.get(i);
            Map<String, String> options = desc.getAdvancedOptions();
            if (options == null || options.isEmpty()) continue;
            sb.append("\n  Description ").append(i + 1).append(" Advanced Options:");
            sb.append(this.formatOptionsForReview(options));
        }
        return sb.toString();
    }

    public String appendOptionsToReview(String currentReview, DescriptionInfo description) {
        if (description == null || description.getAdvancedOptions() == null || description.getAdvancedOptions().isEmpty()) {
            return currentReview;
        }
        return currentReview + "\nAdvanced Options:" + this.formatOptionsForReview(description.getAdvancedOptions());
    }
}

