/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIaqjms;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.sql.TypeDescriptor;

class T4CTTIaqi
implements Diagnosable {
    private static final String CLASS_NAME = T4CTTIaqi.class.getName();
    static final int AQIVER_DEFAULT = 1;
    static final int AQIVER_12_2 = 2;
    static final int AQIVER_12_1 = 1;
    static final int AQTTC_ENQ_STREAMING_DISABLED = 0;
    static final int AQTTC_ENQ_STREAMING_ENABLED = 1;
    static final int AQTCC_OCI_ONE_PIECE = 0;
    static final int AQTCC_OCI_FIRST_PIECE = 1;
    static final int AQTCC_OCI_NEXT_PIECE = 2;
    static final int AQTCC_OCI_LAST_PIECE = 3;
    T4CConnection connection;
    T4CMAREngine meg;
    T4CTTIaqm aqm;
    T4Ctoh toh;
    private AQMessagePropertiesI messageProperties = null;
    private JMSEnqueueOptions jmsEnqueueOptions = null;
    private JMSMessageProperties jmsProp = null;
    private JMSDequeueOptions jmsDequeueOptions = null;
    private AQEnqueueOptions aqEnqueueOptions = null;
    private AQDequeueOptions aqDequeueOptions = null;
    private int aqxaqopt = 0;
    private boolean isAQMsg = false;
    private byte[] aqmcorBytes;
    private byte[] aqmeqnBytes;
    private byte[] senderAgentName = null;
    private byte[] senderAgentAddress = null;
    private byte senderAgentProtocol = 0;
    private byte[] queueNameBytes = null;
    private AQAgentI[] attrRecipientList = null;
    private byte[][] recipientTextValues = null;
    private byte[][] recipientBinaryValues = null;
    private int[] recipientKeywords = null;
    private byte[] consumerNameBytes = null;
    private byte[] correlationBytes = null;
    private byte[] conditionBytes = null;
    private int nbExtensions = 0;
    private byte[][] extensionTextValues = null;
    private byte[][] extensionBinaryValues = null;
    private int[] extensionKeywords = null;
    private byte[] messageOid = null;
    private int aqiver = 1;
    private byte[] messageData = null;
    private boolean isRawQueue = false;
    private boolean isJsonQueue = false;
    private boolean bStreamingMode = false;
    private int blockSize = 8192;
    private InputStream payloadStream = null;
    private int bitMappedEnqueueOption = 0;
    private byte[] headerPropBytes = null;
    private byte[] userPropBytes = null;
    private long aqiflg = 0L;
    private boolean useEnqOpt = false;
    private boolean lcrx2y = false;
    private T4CTTIaqjms aqjms;

    @Override
    public Diagnosable getDiagnosable() {
        return this.connection.getDiagnosable();
    }

    T4CTTIaqi(T4CConnection _connection, int _aqxaqopt, String _queueName, JMSEnqueueOptions _enqueueOptions, JMSMessage _mesg, AQMessagePropertiesI _messageProperties, JMSMessageProperties _jmsProp, JMSDequeueOptions _jmsDequeueOpt) throws IOException, SQLException {
        this.isAQMsg = false;
        this.initCommon(_connection, _aqxaqopt, _queueName, _messageProperties);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "<init>", "_aqxaqopt={0}, _queueName={1}, _enqueueOptions={2}, _mesg={3}, _messageProperties={4}, _jmsProp={5}, _jmsDequeueOpt={6}", (String)null, (Throwable)null, (Object)_aqxaqopt, (Object)_queueName, (Object)_enqueueOptions, (Object)_mesg, (Object)_messageProperties, (Object)_jmsProp, (Object)_jmsDequeueOpt);
        this.aqjms = new T4CTTIaqjms(_connection);
        this.jmsProp = _jmsProp;
        this.isRawQueue = true;
        if (this.aqxaqopt == 1) {
            this.jmsEnqueueOptions = _enqueueOptions;
            if (_mesg.getStreamPayload() == null) {
                this.setStreamingMode(false);
                this.setInputStream(null);
                this.messageData = _mesg.getPayload();
            } else {
                this.setStreamingMode(true);
                this.setBlockSize(_mesg.getChunkSize());
                this.setInputStream(_mesg.getStreamPayload());
                this.messageData = null;
            }
            this.messageOid = _mesg.getToid();
            this.bitMappedEnqueueOption = _enqueueOptions.getDeliveryMode().getCode() + _enqueueOptions.getVisibility().getCode();
            if (this.jmsProp != null) {
                this.headerPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getHeaderProperties());
                this.userPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getUserProperties());
            } else {
                this.headerPropBytes = null;
                this.userPropBytes = null;
            }
        } else {
            this.jmsDequeueOptions = _jmsDequeueOpt;
            this.messageOid = TypeDescriptor.RAWTOID;
            String consumerNameStr = this.jmsDequeueOptions.getConsumerName();
            this.consumerNameBytes = (byte[])(consumerNameStr != null && consumerNameStr.length() > 0 ? this.meg.conv.StringToCharBytes(consumerNameStr) : null);
            String correlation = this.jmsDequeueOptions.getCorrelation();
            this.correlationBytes = (byte[])(correlation != null && correlation.length() != 0 ? this.meg.conv.StringToCharBytes(correlation) : null);
            String condition = this.jmsDequeueOptions.getCondition();
            this.conditionBytes = (byte[])(condition != null && condition.length() > 0 ? this.meg.conv.StringToCharBytes(condition) : null);
        }
        this.initVersion();
        this.initFlag();
    }

    T4CTTIaqi(T4CConnection _connection, int _aqxaqopt, String _queueName, AQEnqueueOptions _aqEnqueueOptions, AQMessage _mesg, AQMessagePropertiesI _messageProperties, AQDequeueOptions _aqDequeueOptions, byte[] _tdo, int _version) throws IOException, SQLException {
        String transformation = null;
        this.isAQMsg = true;
        this.initCommon(_connection, _aqxaqopt, _queueName, _messageProperties);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "<init>", "_aqxaqopt={0}, _queueName={1}, _aqEnqueueOptions={2}, _mesg={3}, _messageProperties={4}, _aqDequeueOptions={5}, _version={6}", (String)null, (Throwable)null, (Object)_aqxaqopt, (Object)_queueName, (Object)_aqEnqueueOptions, (Object)_mesg, (Object)_messageProperties, (Object)_aqDequeueOptions, (Object)_version);
        if (this.aqxaqopt == 1) {
            this.aqEnqueueOptions = _aqEnqueueOptions;
            AQMessageI imesg = (AQMessageI)_mesg;
            this.messageData = imesg.getPayload();
            this.messageOid = imesg.getPayloadTOID();
            this.aqiver = imesg.getPayloadVersion();
            this.isRawQueue = imesg.isRAWPayload();
            this.isJsonQueue = AQMessageI.compareToid(this.messageOid, TypeDescriptor.JSONTOID);
            transformation = this.aqEnqueueOptions.getTransformation();
        } else {
            this.messageOid = _tdo;
            this.aqiver = _version;
            this.isRawQueue = AQMessageI.compareToid(_tdo, TypeDescriptor.RAWTOID);
            this.aqDequeueOptions = _aqDequeueOptions;
            this.isJsonQueue = AQMessageI.compareToid(this.messageOid, TypeDescriptor.JSONTOID);
            String consumerNameStr = this.aqDequeueOptions.getConsumerName();
            this.consumerNameBytes = (byte[])(consumerNameStr != null && consumerNameStr.length() > 0 ? this.meg.conv.StringToCharBytes(consumerNameStr) : null);
            String correlation = this.aqDequeueOptions.getCorrelation();
            this.correlationBytes = (byte[])(correlation != null && correlation.length() != 0 ? this.meg.conv.StringToCharBytes(correlation) : null);
            String condition = this.aqDequeueOptions.getCondition();
            this.conditionBytes = (byte[])(condition != null && condition.length() > 0 ? this.meg.conv.StringToCharBytes(condition) : null);
            transformation = this.aqDequeueOptions.getTransformation();
        }
        if (transformation != null && transformation.length() > 0) {
            this.nbExtensions = 1;
            this.extensionTextValues = new byte[this.nbExtensions][];
            this.extensionBinaryValues = new byte[this.nbExtensions][];
            this.extensionKeywords = new int[this.nbExtensions];
            this.extensionTextValues[0] = this.meg.conv.StringToCharBytes(transformation);
            this.extensionBinaryValues[0] = null;
            this.extensionKeywords[0] = 196;
        } else {
            this.nbExtensions = 0;
        }
        this.initFlag();
    }

    void initCommon(T4CConnection _connection, int _aqxaqopt, String _queueName, AQMessagePropertiesI _messageProperties) throws IOException, SQLException {
        this.connection = _connection;
        this.meg = this.connection.getMarshalEngine();
        this.aqxaqopt = _aqxaqopt;
        this.toh = new T4Ctoh(_connection);
        this.aqm = new T4CTTIaqm(this.connection, this.toh);
        this.messageProperties = _messageProperties;
        if (this.aqxaqopt == 1 && this.messageProperties != null) {
            String aqmcor = this.messageProperties.getCorrelation();
            this.aqmcorBytes = (byte[])(aqmcor != null && aqmcor.length() != 0 ? this.meg.conv.StringToCharBytes(aqmcor) : null);
            String aqmeqn = this.messageProperties.getExceptionQueue();
            this.aqmeqnBytes = (byte[])(aqmeqn != null && aqmeqn.length() != 0 ? this.meg.conv.StringToCharBytes(aqmeqn) : null);
            AQAgentI senderAgent = (AQAgentI)this.messageProperties.getSender();
            if (senderAgent != null) {
                this.senderAgentName = (byte[])(senderAgent.getName() != null ? this.meg.conv.StringToCharBytes(senderAgent.getName()) : null);
                this.senderAgentAddress = (byte[])(senderAgent.getAddress() != null ? this.meg.conv.StringToCharBytes(senderAgent.getAddress()) : null);
                this.senderAgentProtocol = (byte)senderAgent.getProtocol();
            } else {
                this.senderAgentName = null;
                this.senderAgentAddress = null;
                this.senderAgentProtocol = 0;
            }
            this.attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
            if (this.attrRecipientList != null && this.attrRecipientList.length > 0) {
                this.recipientTextValues = new byte[this.attrRecipientList.length * 3][];
                this.recipientBinaryValues = new byte[this.attrRecipientList.length * 3][];
                this.recipientKeywords = new int[this.attrRecipientList.length * 3];
                for (int i = 0; i < this.attrRecipientList.length; ++i) {
                    if (this.attrRecipientList[i].getName() != null) {
                        this.recipientTextValues[3 * i] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i].getName());
                    }
                    if (this.attrRecipientList[i].getAddress() != null) {
                        this.recipientTextValues[3 * i + 1] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i].getAddress());
                    }
                    this.recipientBinaryValues[3 * i + 2] = new byte[1];
                    this.recipientBinaryValues[3 * i + 2][0] = (byte)this.attrRecipientList[i].getProtocol();
                    this.recipientKeywords[3 * i] = 3 * i;
                    this.recipientKeywords[3 * i + 1] = 3 * i + 1;
                    this.recipientKeywords[3 * i + 2] = 3 * i + 2;
                }
            }
        } else {
            this.aqmcorBytes = null;
            this.aqmeqnBytes = null;
            this.senderAgentName = null;
            this.senderAgentAddress = null;
            this.senderAgentProtocol = 0;
        }
        this.queueNameBytes = (byte[])(_queueName != null && _queueName.length() != 0 ? this.meg.conv.StringToCharBytes(_queueName) : null);
    }

    void initVersion() {
        try {
            this.aqiver = this.connection.getVersionNumber() >= 12200 && TypeDescriptor.isV2available(this.messageOid) ? 2 : 1;
        }
        catch (Exception e) {
            this.aqiver = 1;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "initVersion", "aqiver={0}", (String)null, (Throwable)null, (Object)this.aqiver);
    }

    void initFlag() {
        this.aqiflg = 0L;
        if (this.aqxaqopt == 1) {
            if (this.connection.autocommit) {
                this.aqiflg = 32L;
            }
            if (!this.isAQMsg && this.jmsEnqueueOptions.getDeliveryMode() == JMSEnqueueOptions.DeliveryMode.BUFFERED || this.isAQMsg && this.aqEnqueueOptions.getDeliveryMode() == AQEnqueueOptions.DeliveryMode.BUFFERED) {
                this.aqiflg |= 2L;
            }
            this.aqiflg = this.bStreamingMode ? (this.aqiflg |= 1L) : (this.aqiflg |= 0L);
        } else {
            this.aqiflg = this.connection.autocommit ? 2L : 1L;
            if (this.isAQMsg) {
                if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.BUFFERED) {
                    this.aqiflg |= 2L;
                } else if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.PERSISTENT_OR_BUFFERED) {
                    this.aqiflg |= 0x10L;
                }
            } else {
                this.aqiflg |= (long)this.jmsDequeueOptions.getDeliveryMode().getCode();
                this.aqiflg |= (long)this.jmsDequeueOptions.getDequeueMode().getCode();
                this.aqiflg |= (long)this.jmsDequeueOptions.getVisibility().getCode();
                if (this.jmsDequeueOptions.getWait() == 4) {
                    this.aqiflg |= 4L;
                }
            }
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "initFlag", "aqiflg={0}", (String)null, (Throwable)null, (Object)this.aqiflg);
    }

    void marshalPropagation() throws IOException {
        byte[] attrRelativeMessageId = this.isAQMsg ? this.aqEnqueueOptions.getRelativeMessageId() : null;
        this.meg.marshalDALC(attrRelativeMessageId);
        if (attrRelativeMessageId != null) {
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
            } else {
                this.meg.marshalSB4(0);
            }
        }
    }

    void marshalHeader() throws IOException {
        this.meg.marshalUB1((short)6);
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalSWORD(this.queueNameBytes.length);
            this.meg.marshalCHR(this.queueNameBytes);
        } else {
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalB1Array(this.messageOid);
        this.meg.marshalUB2(this.aqiver);
        this.meg.marshalUB4(this.aqiflg);
        if (this.useEnqOpt) {
            byte[] attrRelativeMessageId;
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqEnqueueOptions.getVisibility().getCode());
            } else {
                this.meg.marshalSB4(this.jmsEnqueueOptions.getVisibility().getCode());
            }
            byte[] byArray = attrRelativeMessageId = this.isAQMsg ? this.aqEnqueueOptions.getRelativeMessageId() : null;
            if (attrRelativeMessageId != null && attrRelativeMessageId.length > 0) {
                this.meg.marshalSWORD(attrRelativeMessageId.length);
                this.meg.marshalB1Array(attrRelativeMessageId);
            } else {
                this.meg.marshalSWORD(0);
            }
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
            } else {
                this.meg.marshalSB4(0);
            }
            if (this.nbExtensions > 0) {
                this.meg.marshalSWORD(this.nbExtensions);
                this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
            } else {
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalSB4(0);
        }
    }

    void marshalData() throws IOException {
        AQAgentI[] attrRecipientList;
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalData", "aqiflg={0}, lcrx2y={1}, useEnqOpt={2}, isRawQueue={3}", (String)null, (Throwable)null, (Object)this.aqiflg, (Object)this.lcrx2y, (Object)this.useEnqOpt, (Object)this.isRawQueue);
        this.meg.marshalUB1((short)7);
        this.meg.marshalUB4(this.aqiflg);
        if (!this.lcrx2y) {
            this.marshalAQM();
        }
        if ((attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList()) != null && attrRecipientList.length > 0) {
            this.meg.marshalSWORD(attrRecipientList.length * 3);
            this.meg.marshalKPDKV(this.recipientTextValues, this.recipientBinaryValues, this.recipientKeywords);
        } else {
            this.meg.marshalSWORD(0);
        }
        if (!this.useEnqOpt) {
            this.meg.marshalSB4(this.aqEnqueueOptions.getVisibility().getCode());
            byte[] attrRelativeMessageId = this.aqEnqueueOptions.getRelativeMessageId();
            if (attrRelativeMessageId != null && attrRelativeMessageId.length > 0) {
                this.meg.marshalSWORD(attrRelativeMessageId.length);
                this.meg.marshalB1Array(attrRelativeMessageId);
            } else {
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
        }
        if (this.messageData != null) {
            if (this.isJsonQueue) {
                byte[] quasiLocator = this.connection.setupJsonQuasiLocator(this.messageData.length);
                this.meg.marshalUB4(quasiLocator.length);
                this.meg.marshalB1Array(quasiLocator);
                if (this.connection.isZeroCopyIOEnabled(quasiLocator)) {
                    this.meg.writeZeroCopyIO(this.messageData, 0, this.messageData.length);
                } else {
                    this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
                }
            } else if (!this.isRawQueue) {
                this.toh.init(this.messageOid, this.messageData.length);
                this.toh.marshal(this.meg);
                this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
            } else {
                this.meg.marshalUB4(this.messageData.length);
                this.meg.marshalB1Array(this.messageData);
            }
        } else {
            this.meg.marshalUB4(0L);
        }
    }

    void marshalJmsData() throws IOException {
        this.meg.marshalUB1((short)7);
        this.marshalAQM();
        int bitMappedEnqueueOption = this.jmsEnqueueOptions.getDeliveryMode().getCode() + this.jmsEnqueueOptions.getVisibility().getCode();
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalJmsData", "bitMappedEnqueueOption={0},", (String)null, (Throwable)null, (Object)bitMappedEnqueueOption);
        this.meg.marshalSB4(bitMappedEnqueueOption);
        if (this.jmsProp != null) {
            this.aqjms.aqjmsflags = this.jmsProp.getJMSMessageType().getCode();
            this.aqjms.aqjmshdrpcnt = 0;
            this.aqjms.aqjmsusrprpcnt = 0;
        } else {
            this.aqjms.aqjmsflags = 0;
            this.aqjms.aqjmshdrpcnt = 0;
            this.aqjms.aqjmsusrprpcnt = 0;
        }
        this.aqjms.aqjmshdrprop = this.headerPropBytes;
        this.aqjms.aqjmsuserprop = this.userPropBytes;
        this.aqjms.marshal();
        if (this.messageOid != null) {
            this.meg.marshalSWORD(16);
            this.meg.marshalB1Array(this.messageOid);
        } else {
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalUB2(this.aqiver);
        if (this.messageData != null) {
            this.meg.marshalUB4(this.messageData.length);
            this.meg.marshalB1Array(this.messageData);
        } else {
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalSB4((int)this.aqiflg);
    }

    void marshalAQM() throws IOException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalAQM", "senderAgentName={0}, senderAgentAddress={1}, senderAgentProtocol{2}", (String)null, (Throwable)null, (Object)this.senderAgentName, (Object)this.senderAgentAddress, (Object)this.senderAgentProtocol);
        this.aqm.initToDefaultValues();
        if (this.messageProperties != null) {
            this.aqm.aqmpri = this.messageProperties.getPriority();
            this.aqm.aqmdel = this.messageProperties.getDelay();
            this.aqm.aqmexp = this.messageProperties.getExpiration();
            this.aqm.originalMsgId = this.messageProperties.getPreviousQueueMessageId();
            this.aqm.aqmshardNum = this.messageProperties.getShardNum();
        }
        this.aqm.aqmcorBytes = this.aqmcorBytes;
        this.aqm.aqmeqnBytes = this.aqmeqnBytes;
        this.aqm.senderAgentName = this.senderAgentName;
        this.aqm.senderAgentAddress = this.senderAgentAddress;
        this.aqm.senderAgentProtocol = this.senderAgentProtocol;
        this.aqm.marshal();
    }

    void marshalDone() throws IOException {
        this.meg.marshalUB1((short)9);
    }

    void marshal() throws IOException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshal", "aqxaqopt={0}, isAQMsg={1}, queueNameBytes={2},isRawQueue={3}", (String)null, (Throwable)null, (Object)this.aqxaqopt, (Object)this.isAQMsg, (Object)this.queueNameBytes, (Object)this.isRawQueue);
        this.meg.marshalDALC(this.queueNameBytes);
        this.marshalAQM();
        AQAgentI[] attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
        if (attrRecipientList != null && attrRecipientList.length > 0) {
            this.meg.marshalSWORD(attrRecipientList.length * 3);
            this.meg.marshalKPDKV(this.recipientTextValues, this.recipientBinaryValues, this.recipientKeywords);
        } else {
            this.meg.marshalSWORD(0);
        }
        if (this.aqxaqopt == 2) {
            this.meg.marshalDALC(this.consumerNameBytes);
        } else {
            this.meg.marshalSWORD(0);
        }
        if (this.aqxaqopt == 2) {
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqDequeueOptions.getDequeueMode().getCode());
            } else {
                this.meg.marshalSB4(this.jmsDequeueOptions.getDequeueMode().getCode());
            }
        } else {
            this.meg.marshalSB4(0);
        }
        if (this.isAQMsg) {
            if (this.aqxaqopt == 2) {
                this.meg.marshalSB4(this.aqDequeueOptions.getNavigation().getCode());
            } else {
                this.meg.marshalSB4(0);
            }
        } else {
            this.meg.marshalSB4(0);
        }
        if (this.aqxaqopt == 1) {
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqEnqueueOptions.getVisibility().getCode());
            } else {
                this.meg.marshalSB4(this.jmsEnqueueOptions.getVisibility().getCode());
            }
        } else if (this.isAQMsg) {
            this.meg.marshalSB4(this.aqDequeueOptions.getVisibility().getCode());
        } else {
            this.meg.marshalSB4(this.jmsDequeueOptions.getVisibility().getCode());
        }
        if (this.aqxaqopt == 2) {
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqDequeueOptions.getWait());
            } else {
                this.meg.marshalSB4(this.jmsDequeueOptions.getWait());
            }
        } else {
            this.meg.marshalSB4(0);
        }
        byte[] mesgId = null;
        if (this.aqxaqopt == 2) {
            mesgId = this.isAQMsg ? this.aqDequeueOptions.getDequeueMessageId() : this.jmsDequeueOptions.getDequeueMessageId();
        }
        this.meg.marshalDALC(mesgId);
        if (this.aqxaqopt == 2) {
            this.meg.marshalDALC(this.correlationBytes);
        } else {
            this.meg.marshalSWORD(0);
        }
        if (this.connection.getTTCVersion() >= 1) {
            this.meg.marshalDALC(this.conditionBytes);
            this.meg.marshalSWORD(0);
        }
        byte[] attrRelativeMessageId = null;
        if (this.aqxaqopt == 1) {
            attrRelativeMessageId = this.isAQMsg ? this.aqEnqueueOptions.getRelativeMessageId() : null;
        }
        this.meg.marshalDALC(attrRelativeMessageId);
        if (this.aqxaqopt == 1) {
            if (this.isAQMsg) {
                this.meg.marshalSB4(this.aqEnqueueOptions.getSequenceDeviation().getCode());
            } else {
                this.meg.marshalSB4(0);
            }
        } else {
            this.meg.marshalSB4(0);
        }
        this.meg.marshalDALC(this.messageOid);
        this.meg.marshalUB2(this.aqiver);
        if (this.aqxaqopt == 1) {
            if (this.messageData != null) {
                if (!this.isRawQueue) {
                    this.meg.marshalSWORD(this.messageData.length);
                    this.toh.init(this.messageOid, this.messageData.length);
                    this.toh.marshal(this.meg);
                    this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
                    this.meg.marshalUB4(0L);
                } else {
                    this.meg.marshalSWORD(0);
                    this.meg.marshalDALC(this.messageData);
                }
            } else {
                this.meg.marshalSWORD(0);
                this.meg.marshalUB4(0L);
            }
        } else {
            this.meg.marshalSWORD(0);
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalUB4(0L);
        long aqiflg = 0L;
        if (this.aqxaqopt == 1) {
            if (this.connection.autocommit) {
                aqiflg = 32L;
            }
            if (!this.isAQMsg && this.jmsEnqueueOptions.getDeliveryMode() == JMSEnqueueOptions.DeliveryMode.BUFFERED || this.isAQMsg && this.aqEnqueueOptions.getDeliveryMode() == AQEnqueueOptions.DeliveryMode.BUFFERED) {
                aqiflg |= 2L;
            }
            aqiflg = this.bStreamingMode ? (aqiflg |= 1L) : (aqiflg |= 0L);
        } else {
            aqiflg = this.connection.autocommit ? 2L : 1L;
            if (this.isAQMsg) {
                if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.BUFFERED) {
                    aqiflg |= 2L;
                } else if (this.aqDequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.PERSISTENT_OR_BUFFERED) {
                    aqiflg |= 0x10L;
                }
            } else {
                aqiflg |= (long)this.jmsDequeueOptions.getDeliveryMode().getCode();
                aqiflg |= (long)this.jmsDequeueOptions.getDequeueMode().getCode();
                aqiflg |= (long)this.jmsDequeueOptions.getVisibility().getCode();
                if (this.jmsDequeueOptions.getWait() == 4) {
                    aqiflg |= 4L;
                }
            }
        }
        this.meg.marshalUB4(aqiflg);
        if (this.nbExtensions > 0) {
            this.meg.marshalSWORD(this.nbExtensions);
            this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
        } else {
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalSWORD(0);
        if (this.aqxaqopt == 1 && this.bStreamingMode) {
            this.writeStreamingPayload();
        }
    }

    private void setStreamingMode(boolean flag) {
        this.bStreamingMode = flag;
    }

    private void setBlockSize(int _blockSize) {
        if (_blockSize > 0) {
            this.blockSize = _blockSize;
        }
    }

    private void setInputStream(InputStream inputStream) {
        this.payloadStream = inputStream;
    }

    private void writeStreamingPayload() throws IOException {
        int noOfBytesRead;
        byte[] bytearray = new byte[this.blockSize];
        boolean firstTime = true;
        while (true) {
            if ((noOfBytesRead = this.payloadStream.read(bytearray)) < this.blockSize) break;
            if (firstTime) {
                this.writeFirst(bytearray, noOfBytesRead);
                firstTime = false;
                continue;
            }
            this.writeNext(bytearray, noOfBytesRead);
        }
        this.writeLast(bytearray, noOfBytesRead);
        this.payloadStream.close();
        this.payloadStream = null;
    }

    private void writeFirst(byte[] _byteArray, int length) throws IOException {
        this.meg.marshalUB1((short)1);
        this.meg.marshalSB8(length);
        this.meg.marshalB1Array(_byteArray, 0, length);
    }

    private void writeNext(byte[] _byteArray, int length) throws IOException {
        this.meg.marshalUB1((short)2);
        this.meg.marshalSB8(length);
        this.meg.marshalB1Array(_byteArray, 0, length);
    }

    private void writeLast(byte[] _byteArray, int length) throws IOException {
        if (length > 0) {
            this.meg.marshalUB1((short)3);
            this.meg.marshalSB8(length);
            this.meg.marshalB1Array(_byteArray, 0, length);
        } else {
            this.meg.marshalUB1((short)3);
            this.meg.marshalSB8(0L);
        }
    }

    boolean isRawQueue() {
        return this.isRawQueue;
    }

    boolean isJsonQueue() {
        return this.isJsonQueue;
    }
}

