/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleResultSet;
import oracle.jdbc.internal.OracleStatement;

class OracleDatabaseMetaData
extends oracle.jdbc.OracleDatabaseMetaData {
    static final int RSFS = 4284;
    static final boolean DEBUG = false;
    private static final long FOUR_GIG_MINUS_ONE = 0xFFFFFFFFL;
    private long maxLogicalLobSize = -1L;

    public OracleDatabaseMetaData(oracle.jdbc.internal.OracleConnection conn) {
        super(conn);
    }

    public OracleDatabaseMetaData(OracleConnection conn) {
        this((oracle.jdbc.internal.OracleConnection)conn);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            String bindColumn;
            String bindTable;
            String bindSchema;
            String plsql;
            boolean includeSynonyms = this.connection.getIncludeSynonyms();
            if (includeSynonyms && schemaPattern != null && !this.hasSqlWildcard(schemaPattern) && tableNamePattern != null && !this.hasSqlWildcard(tableNamePattern)) {
                plsql = this.getColumnsNoWildcardsPlsql();
                bindSchema = this.stripSqlEscapes(schemaPattern);
                bindTable = this.stripSqlEscapes(tableNamePattern);
                bindColumn = columnNamePattern == null ? "%" : columnNamePattern;
            } else {
                plsql = this.getColumnsWithWildcardsPlsql(includeSynonyms);
                bindSchema = schemaPattern == null ? "%" : schemaPattern;
                bindTable = tableNamePattern == null ? "%" : tableNamePattern;
                bindColumn = columnNamePattern == null ? "%" : columnNamePattern;
            }
            CallableStatement cstmt = this.connection.prepareCall(plsql);
            cstmt.unwrap(OracleStatement.class).setLongPrefetch(true);
            cstmt.setString(1, bindSchema);
            cstmt.setString(2, bindTable);
            cstmt.setString(3, bindColumn);
            cstmt.registerOutParameter(4, -10);
            cstmt.closeOnCompletion();
            cstmt.setPoolable(false);
            cstmt.execute();
            ResultSet rs = ((OracleCallableStatement)cstmt).getCursor(4);
            if (rs.getFetchSize() < 4284) {
                rs.setFetchSize(4284);
            }
            ResultSet resultSet = rs;
            return resultSet;
        }
    }

    String getColumnsNoWildcardsPlsql() throws SQLException {
        String searchPlsql = "declare\n  in_owner varchar2(256) := null;\n  in_name varchar2(256) := null;\n  my_user_name varchar2(256) := null;\n  cnt number := 0;\n  out_owner varchar2(256) := null;\n  out_name  varchar2(256):= null;\n  xxx SYS_REFCURSOR;\nbegin\n  in_owner := ?;\n  in_name := ?;\n  select user into my_user_name from dual;\n  if (my_user_name = in_owner) then\n    select count(*) into cnt from user_tables\n      where table_name = in_name;\n    if (cnt = 1) then\n      out_owner := in_owner;\n      out_name := in_name;\n    else\n      select count(*) into cnt from user_views\n        where view_name = in_name;\n      if (cnt = 1) then\n        out_owner := in_owner;\n        out_name := in_name;\n      else\n        begin\n          select table_owner, table_name into out_owner, out_name\n            from all_synonyms\n            where CONNECT_BY_ISLEAF = 1\n            and db_link is NULL\n            start with owner = in_owner and synonym_name = in_name\n            connect by prior table_name = synonym_name\n                    and prior table_owner = owner;\n        exception\n          when NO_DATA_FOUND then\n            out_owner := null;\n            out_name := null;\n        end;\n      end if;\n    end if;\n  else\n    select count(*) into cnt from all_tables\n      where owner = in_owner and table_name = in_name;\n    if (cnt = 1) then\n      out_owner := in_owner;\n      out_name := in_name;\n    else\n      select count(*) into cnt from all_views\n         where owner = in_owner and view_name = in_name;\n      if (cnt = 1) then\n        out_owner := in_owner;\n        out_name := in_name;\n      else\n        begin\n          select table_owner, table_name into out_owner, out_name\n            from all_synonyms\n            where CONNECT_BY_ISLEAF = 1\n            and db_link is NULL\n            start with owner = in_owner and synonym_name = in_name\n            connect by prior table_name = synonym_name\n                    and prior table_owner = owner;\n        exception\n          when NO_DATA_FOUND then\n            out_owner := null;\n            out_name := null;\n        end;\n      end if;\n    end if;\n  end if;\n";
        short db_version = this.connection.getVersionNumber();
        String queryPart1 = "open xxx for SELECT NULL AS table_cat,\n";
        String tableName = "       in_owner AS table_schem,\n       in_name AS table_name,\n";
        String charDataSize = "         DECODE (t.data_type, 'CHAR', t.char_length,                   'VARCHAR', t.char_length,                   'VARCHAR2', t.char_length,                   'NVARCHAR2', t.char_length,                   'NCHAR', t.char_length,                   'NUMBER', 0,           t.data_length)";
        String queryPart2 = "       t.column_name AS column_name,\n" + this.datatypeQuery(OracleDatabaseMetaData.DataTypeSource.COLS, "t") + "       t.data_type AS type_name,\n       DECODE (t.data_precision,                null, DECODE(t.data_type,                        'NUMBER', DECODE(t.data_scale,                                    null, " + (((PhysicalConnection)this.connection).j2ee13Compliant ? "38" : "0") + "                                   , 38), " + charDataSize + "                           ),         t.data_precision)\n              AS column_size,\n       0 AS buffer_length,\n       DECODE (t.data_type,                'NUMBER', DECODE(t.data_precision,                                 null, DECODE(t.data_scale,                                              null, " + (((PhysicalConnection)this.connection).j2ee13Compliant ? "0" : "-127") + "                                             , t.data_scale),                                  t.data_scale),                t.data_scale) AS decimal_digits,\n       10 AS num_prec_radix,\n       DECODE (t.nullable, 'N', 0, 1) AS nullable,\n";
        String remarks = "       c.comments AS remarks,\n";
        String noRemarks = "       NULL AS remarks,\n";
        String queryPart3 = "       t.data_default AS column_def,\n       0 AS sql_data_type,\n       0 AS sql_datetime_sub,\n       t.data_length AS char_octet_length,\n       t.column_id AS ordinal_position,\n       DECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable,\n";
        String queryPart4JDBC4 = "       null as SCOPE_CATALOG,\n       null as SCOPE_SCHEMA,\n       null as SCOPE_TABLE,\n       null as SOURCE_DATA_TYPE,\n" + (db_version >= 12000 ? "       t.identity_column as IS_AUTOINCREMENT,\n       t.virtual_column as IS_GENERATEDCOLUMN\n" : "       'NO' as IS_AUTOINCREMENT,\n       null as IS_GENERATEDCOLUMN\n");
        String fromClause = db_version >= 12000 ? "FROM all_tab_cols t" : "FROM all_tab_columns t";
        String remarksFrom = ", all_col_comments c";
        String whereClause = "WHERE t.owner = out_owner \n  AND t.table_name = out_name\n  AND t.column_name LIKE ? ESCAPE '/'\n" + (db_version >= 12000 ? "  AND t.user_generated = 'YES'\n" : "");
        String remarksWhere = "  AND t.owner = c.owner (+)\n  AND t.table_name = c.table_name (+)\n  AND t.column_name = c.column_name (+)\n";
        String orderBy = "ORDER BY table_schem, table_name, ordinal_position\n";
        Object queryPlsql = queryPart1;
        queryPlsql = (String)queryPlsql + tableName;
        queryPlsql = (String)queryPlsql + queryPart2;
        queryPlsql = this.connection.getRemarksReporting() ? (String)queryPlsql + remarks : (String)queryPlsql + noRemarks;
        queryPlsql = (String)queryPlsql + queryPart3 + queryPart4JDBC4 + fromClause;
        if (this.connection.getRemarksReporting()) {
            queryPlsql = (String)queryPlsql + remarksFrom;
        }
        queryPlsql = (String)queryPlsql + "\n" + whereClause;
        if (this.connection.getRemarksReporting()) {
            queryPlsql = (String)queryPlsql + remarksWhere;
        }
        queryPlsql = (String)queryPlsql + "\n" + orderBy;
        String plsqlPost = "; \n ? := xxx;\n end;";
        String finalProc = searchPlsql + (String)queryPlsql + plsqlPost;
        return finalProc;
    }

    String getColumnsWithWildcardsPlsql(boolean includeSynonyms) throws SQLException {
        short db_version = this.connection.getVersionNumber();
        String searchPlsql = "declare\n  in_owner varchar2(256) := null;\n  in_name varchar2(256) := null;\n  in_column varchar2(256) := null;\n  xyzzy SYS_REFCURSOR;\nbegin\n  in_owner := ?;\n  in_name := ?;\n  in_column := ?;\n";
        String unionClause = "UNION ALL\n ";
        String queryPart0 = "SELECT ";
        String queryPart1 = "NULL AS table_cat,\n";
        String queryHint = "";
        if (db_version >= 10200 & db_version < 11100 & includeSynonyms) {
            queryHint = "/*+ CHOOSE */";
        }
        String tableName = "       t.owner AS table_schem,\n       t.table_name AS table_name,\n";
        String synonymName = "       REGEXP_SUBSTR(LTRIM(s.owner, '/'), '[^/]+') AS table_schem,\n       REGEXP_SUBSTR(LTRIM(s.synonym_name, '/'),\n                           '[^/]+') AS table_name,\n";
        String charDataSize = "       DECODE (t.data_type,                'CHAR', t.char_length,                'VARCHAR', t.char_length,                'VARCHAR2', t.char_length,                'NVARCHAR2', t.char_length,                'NCHAR', t.char_length,                'NUMBER', 0,                t.data_length)";
        String queryPart2 = "       t.column_name AS column_name,\n" + this.datatypeQuery(OracleDatabaseMetaData.DataTypeSource.COLS, "t") + "       t.data_type AS type_name,\n       DECODE (t.data_precision,                null, DECODE(t.data_type,                        'NUMBER', DECODE(t.data_scale,                                    null, " + (((PhysicalConnection)this.connection).j2ee13Compliant ? "38" : "0") + "                                   , 38), " + charDataSize + "                           ),         t.data_precision)\n              AS column_size,\n       0 AS buffer_length,\n       DECODE (t.data_type,                'NUMBER', DECODE(t.data_precision,                                 null, DECODE(t.data_scale,                                              null, " + (((PhysicalConnection)this.connection).j2ee13Compliant ? "0" : "-127") + "                                             , t.data_scale),                                  t.data_scale),                t.data_scale) AS decimal_digits,\n       10 AS num_prec_radix,\n       DECODE (t.nullable, 'N', 0, 1) AS nullable,\n";
        String remarks = "       c.comments AS remarks,\n";
        String noRemarks = "       NULL AS remarks,\n";
        String queryPart3 = "       t.data_default AS column_def,\n       0 AS sql_data_type,\n       0 AS sql_datetime_sub,\n       t.data_length AS char_octet_length,\n       t.column_id AS ordinal_position,\n       DECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable,\n";
        String queryPart4JDBC4 = "       null as SCOPE_CATALOG,\n       null as SCOPE_SCHEMA,\n       null as SCOPE_TABLE,\n       null as SOURCE_DATA_TYPE,\n" + (db_version >= 12000 ? "       t.identity_column as IS_AUTOINCREMENT,\n       t.virtual_column as IS_GENERATEDCOLUMN\n" : "       'NO' as IS_AUTOINCREMENT,\n       null as IS_GENERATEDCOLUMN\n");
        String fromClause = db_version >= 12000 ? "FROM all_tab_cols t" : "FROM all_tab_columns t";
        String synonymFrom = ", (SELECT SYS_CONNECT_BY_PATH(owner, '/') owner,\n          SYS_CONNECT_BY_PATH(synonym_name, '/')\n                              synonym_name,\n          table_owner, table_name\n  FROM all_synonyms\n   WHERE CONNECT_BY_ISLEAF = 1\n    AND db_link is NULL\n  START WITH owner LIKE in_owner ESCAPE '/'\n    AND synonym_name LIKE in_name ESCAPE '/'\n  CONNECT BY PRIOR table_name = synonym_name\n    AND PRIOR table_owner = owner) s";
        String remarksFrom = ", all_col_comments c";
        String whereClause = "WHERE t.owner LIKE in_owner ESCAPE '/'\n  AND t.table_name LIKE in_name ESCAPE '/'\n  AND t.column_name LIKE in_column ESCAPE '/'\n" + (db_version >= 12000 ? "  AND t.user_generated = 'YES'\n" : "");
        String synonymWhereClause = "WHERE t.owner = s.table_owner\n  AND t.table_name = s.table_name\n  AND t.column_name LIKE in_column ESCAPE '/'\n" + (db_version >= 12000 ? "  AND t.user_generated = 'YES'\n" : "");
        String remarksWhere = "  AND t.owner = c.owner (+)\n  AND t.table_name = c.table_name (+)\n  AND t.column_name = c.column_name (+)\n";
        String orderBy = "ORDER BY table_schem, table_name, ordinal_position\n";
        String openCursor = "open xyzzy for\n";
        String finalQuery = openCursor + queryPart0 + queryHint + queryPart1 + tableName;
        finalQuery = finalQuery + queryPart2;
        finalQuery = this.connection.getRemarksReporting() ? finalQuery + remarks : finalQuery + noRemarks;
        finalQuery = finalQuery + queryPart3 + queryPart4JDBC4 + fromClause;
        if (this.connection.getRemarksReporting()) {
            finalQuery = finalQuery + remarksFrom;
        }
        finalQuery = finalQuery + "\n" + whereClause;
        if (this.connection.getRemarksReporting()) {
            finalQuery = finalQuery + remarksWhere;
        }
        if (this.connection.getIncludeSynonyms()) {
            finalQuery = finalQuery + unionClause + queryPart0 + queryHint + queryPart1;
            finalQuery = finalQuery + synonymName;
            finalQuery = finalQuery + queryPart2;
            finalQuery = this.connection.getRemarksReporting() ? finalQuery + remarks : finalQuery + noRemarks;
            finalQuery = finalQuery + queryPart3 + queryPart4JDBC4 + fromClause;
            finalQuery = finalQuery + synonymFrom;
            if (this.connection.getRemarksReporting()) {
                finalQuery = finalQuery + remarksFrom;
            }
            finalQuery = finalQuery + "\n" + synonymWhereClause;
            if (this.connection.getRemarksReporting()) {
                finalQuery = finalQuery + remarksWhere;
            }
        }
        finalQuery = finalQuery + orderBy;
        String plsqlPost = "; \n ? := xyzzy;\n end;";
        String finalProc = searchPlsql + finalQuery + plsqlPost;
        return finalProc;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet rs;
            boolean isExtended;
            Statement s;
            block16: {
                s = this.connection.createStatement();
                short db_version = this.connection.getVersionNumber();
                int varTypeMaxLenCompat = this.connection.getVarTypeMaxLenCompat();
                boolean bl = isExtended = varTypeMaxLenCompat == 2;
                if (isExtended) {
                    try (CallableStatement cstmt = this.connection.prepareCall("begin ? := private_jdbc.get_max_string_size(); end;");){
                        cstmt.registerOutParameter(1, 12);
                        cstmt.execute();
                        isExtended = "EXTENDED".equalsIgnoreCase(cstmt.getString(1));
                    }
                    catch (SQLException ex) {
                        if (ex.getErrorCode() == 6550) break block16;
                        throw ex;
                    }
                }
            }
            int charPrecision = 2000;
            int ncharPrecision = 2000;
            int varcharPrecision = 4000;
            int nvarcharPrecision = 4000;
            int rawPrecision = 2000;
            if (isExtended) {
                charPrecision = 2000;
                ncharPrecision = 2000;
                varcharPrecision = Short.MAX_VALUE;
                nvarcharPrecision = 32766;
                rawPrecision = Short.MAX_VALUE;
            }
            String number_query = "select\n 'NUMBER' as type_name, 2 as data_type, 38 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n 'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String bit_query = "union select 'NUMBER' as type_name, -7 as data_type, 1 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(1)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String tinyint_query = "union select 'NUMBER' as type_name, -6 as data_type, 3 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(3)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String smallint_query = "union select 'NUMBER' as type_name, 5 as data_type, 5 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(5)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String integer_query = "union select 'NUMBER' as type_name, 4 as data_type, 10 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(10)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String bigint_query = "union select 'NUMBER' as type_name, -5 as data_type, 38 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String float_query = "union select 'FLOAT' as type_name, 6 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'FLOAT' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String real_query = "union select 'REAL' as type_name, 7 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'REAL' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String char_query = "union select\n 'CHAR' as type_name, 1 as data_type, " + charPrecision + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'CHAR' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String nchar_query = "union select\n 'NCHAR' as type_name, -15 as data_type, " + ncharPrecision + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'NCHAR' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String varchar2_query = "union select\n 'VARCHAR2' as type_name, 12 as data_type, " + varcharPrecision + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'VARCHAR2' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String nvarchar2_query = "union select\n 'NVARCHAR2' as type_name, -9 as data_type, " + nvarcharPrecision + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'nVARCHAR2' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String long_query = "union select\n 'LONG' as type_name, -1 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String date_query = "union select\n 'DATE' as type_name, " + (((PhysicalConnection)this.connection).mapDateToTimestamp ? "93" : "91") + "as data_type, 7 as precision,\n 'DATE ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'DATE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String time_query = "union select\n 'DATE' as type_name, 92 as data_type, 7 as precision,\n 'DATE ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'DATE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String intervalym_query = "union select\n 'INTERVALYM' as type_name, -103 as data_type, 5 as precision,\n 'INTERVAL ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALYM' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String intervalds_query = "union select\n 'INTERVALDS' as type_name, -104 as data_type, 4 as precision,\n 'INTERVAL ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALDS' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String timestamp_query = "union select\n 'TIMESTAMP' as type_name, 93 as data_type, 11 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String timestamptz_query = "union select\n 'TIMESTAMP WITH TIME ZONE' as type_name, -101 as data_type, 13 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String timestampltz_query = "union select\n 'TIMESTAMP WITH LOCAL TIME ZONE' as type_name, -102 as data_type, 11 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH LOCAL TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String raw_query = "union select\n 'RAW' as type_name, -3 as data_type, " + rawPrecision + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String long_raw_query = "union select\n 'LONG RAW' as type_name, -4 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String _lobSz = "-1";
            String blob_query = "union select\n 'BLOB' as type_name, 2004 as data_type, " + _lobSz + " as precision,\n null as literal_prefix, null as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'BLOB' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String clob_query = "union select\n 'CLOB' as type_name, 2005 as data_type, " + _lobSz + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'CLOB' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String nclob_query = "union select\n 'NCLOB' as type_name, 2011 as data_type, " + _lobSz + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'NCLOB' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String array_query = "union select\n 'ARRAY' as type_name, 2003 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'ARRAY' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String ref_query = "union select\n 'REF' as type_name, 2006 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'REF' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String struct_query = "union select\n 'STRUCT' as type_name, 2002 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'STRUCT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String vector_query = this.connection.getMajorVersionNumber() > 23 || this.connection.getMajorVersionNumber() == 23 && this.connection.getMinorVersionNumber() >= 4 ? "union select\n 'VECTOR' as type_name, -105 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'VECTOR' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, NULL as num_prec_radix\nfrom dual\n" : "";
            String boolean_query = this.connection.getMajorVersionNumber() > 23 || this.connection.getMajorVersionNumber() == 23 && this.connection.getMinorVersionNumber() >= 1 ? "union select\n 'BOOLEAN' as type_name, 16 as data_type, 0 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n 'BOOLEAN' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\n from dual\n" : "";
            String json_query = this.connection.getMajorVersionNumber() >= 21 ? "union select\n 'JSON' as type_name, 2016 as data_type, -1 as precision,\nNULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n1 as nullable, 0 as case_sensitive, 0 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'JSON' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" : "";
            String order_by = "order by data_type\n";
            String query = "select\n 'NUMBER' as type_name, 2 as data_type, 38 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n 'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + char_query + nchar_query + varchar2_query + nvarchar2_query + date_query + "union select\n 'DATE' as type_name, 92 as data_type, 7 as precision,\n 'DATE ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'DATE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'TIMESTAMP' as type_name, 93 as data_type, 11 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'TIMESTAMP WITH TIME ZONE' as type_name, -101 as data_type, 13 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'TIMESTAMP WITH LOCAL TIME ZONE' as type_name, -102 as data_type, 11 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH LOCAL TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'INTERVALYM' as type_name, -103 as data_type, 5 as precision,\n 'INTERVAL ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALYM' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'INTERVALDS' as type_name, -104 as data_type, 4 as precision,\n 'INTERVAL ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALDS' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + raw_query + "union select\n 'LONG' as type_name, -1 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'LONG RAW' as type_name, -4 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'NUMBER' as type_name, -7 as data_type, 1 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(1)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'NUMBER' as type_name, -6 as data_type, 3 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(3)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'NUMBER' as type_name, 5 as data_type, 5 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(5)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'NUMBER' as type_name, 4 as data_type, 10 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(10)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'NUMBER' as type_name, -5 as data_type, 38 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'FLOAT' as type_name, 6 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'FLOAT' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select 'REAL' as type_name, 7 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'REAL' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + blob_query + clob_query + nclob_query + "union select\n 'REF' as type_name, 2006 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'REF' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'ARRAY' as type_name, 2003 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'ARRAY' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\nunion select\n 'STRUCT' as type_name, 2002 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'STRUCT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + boolean_query + vector_query + json_query + "order by data_type\n";
            s.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s.executeQuery(query);
            return oracleResultSet;
        }
    }

    @Override
    public String getAuditBanner() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            String string = ((PhysicalConnection)this.connection).getAuditBanner();
            return string;
        }
    }

    @Override
    public String getAccessBanner() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            String string = ((PhysicalConnection)this.connection).getAccessBanner();
            return string;
        }
    }

    @Override
    public boolean isServerBigSCN() throws SQLException {
        return ((PhysicalConnection)this.connection).isServerBigSCN();
    }

    @Override
    public boolean isCompatible122OrGreater() throws SQLException {
        return ((PhysicalConnection)this.connection).isCompatible122OrGreater();
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.maxLogicalLobSize == -1L) {
                try (Statement s = this.connection.createStatement();
                     ResultSet rs = s.executeQuery("select value from v$parameter where name = 'db_block_size'");){
                    this.maxLogicalLobSize = rs.next() ? 0xFFFFFFFFL * rs.getLong(1) : 0L;
                }
                catch (SQLException e) {
                    this.maxLogicalLobSize = 0L;
                    if (e.getErrorCode() == 942) {
                        throw (SQLException)DatabaseError.createSqlException(295).fillInStackTrace();
                    }
                    throw e;
                }
            }
            long l = this.maxLogicalLobSize;
            return l;
        }
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        return true;
    }

    @Override
    public Map<String, String> getAnnotations(String objectName, String columnName, String domainName, String domainOwner) throws SQLException {
        if (objectName == null || objectName.trim().length() == 0) {
            throw new SQLException("Invalid ObjectName : " + objectName);
        }
        if (columnName == null || columnName.trim().length() == 0) {
            throw new SQLException("Invalid ColumnName : " + columnName);
        }
        return this.getAnnotationsInternal(objectName, columnName, domainName, domainOwner);
    }

    @Override
    public Map<String, String> getAnnotations(String objectName, String domainName, String domainOwner) throws SQLException {
        if (objectName == null || objectName.trim().length() == 0) {
            throw new SQLException("Invalid ObjectName : " + objectName);
        }
        return this.getAnnotationsInternal(objectName, null, domainName, domainOwner);
    }

    private Map<String, String> getAnnotationsInternal(String objectName, String columnName, String domainName, String domainOwner) throws SQLException {
        Object sql = "SELECT ANNOTATION_NAME, ANNOTATION_VALUE FROM USER_ANNOTATIONS_USAGE WHERE OBJECT_NAME = ?";
        sql = (String)sql + (columnName == null ? " AND COLUMN_NAME IS NULL" : "AND COLUMN_NAME = ?");
        sql = (String)sql + (domainName == null ? " AND DOMAIN_NAME IS NULL" : "AND DOMAIN_NAME = ?");
        sql = (String)sql + (domainOwner == null ? " AND DOMAIN_OWNER IS NULL" : "AND DOMAIN_OWNER = ?");
        LinkedHashMap<String, String> annotations = new LinkedHashMap<String, String>();
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
             PreparedStatement pstmt = this.connection.prepareStatement((String)sql);){
            int indx = 1;
            pstmt.setString(indx++, objectName.toUpperCase(Locale.ROOT));
            if (columnName != null) {
                pstmt.setString(indx++, columnName.toUpperCase(Locale.ROOT));
            }
            if (domainName != null) {
                pstmt.setString(indx++, domainName.toUpperCase(Locale.ROOT));
            }
            if (domainOwner != null) {
                pstmt.setString(indx++, domainOwner.toUpperCase(Locale.ROOT));
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                String value = rs.getString(2);
                annotations.put(name, value == null ? "" : value);
            }
            rs.close();
        }
        return annotations;
    }
}

