/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.CharCommonAccessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.NumberCommonAccessor;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.RawCommonAccessor;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleNClob;
import oracle.jdbc.internal.OracleOpaque;
import oracle.jdbc.util.RepConversion;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public abstract class JavaToJavaConverter<S, T> {
    protected static final long MILLIS_IN_SECOND = 1000L;
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final Calendar UTC_US_CALENDAR = Calendar.getInstance(UTC_TIME_ZONE, Locale.US);
    protected Calendar cachedUTCUSCalendar = (Calendar)UTC_US_CALENDAR.clone();
    protected static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    protected static final DateTimeFormatter OFFSET_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSZ");
    private static int INTYMYEAROFFSET = Integer.MIN_VALUE;
    private static int INTYMMONTHOFFSET = 60;
    private static int INTERVALDSOFFSET = 60;
    private static int INTERVALDAYOFFSET = Integer.MIN_VALUE;
    private static final Map<Key, JavaToJavaConverter<?, ?>> CONVERTERS = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S, T> T convert(S src, Class<T> target, OracleConnection conn, Object srcExtra, Object targetExtra) throws SQLException {
        if (src == null) {
            return target.cast(null);
        }
        if (target.isInstance(src)) {
            return target.cast(src);
        }
        Key desired = new Key(src.getClass(), target);
        JavaToJavaConverter<?, ?> c = CONVERTERS.get(desired);
        if (c != null) {
            try {
                return (T)c.convert(src, conn, srcExtra, targetExtra);
            }
            catch (SQLException x) {
                throw x;
            }
            catch (Throwable t) {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)conn, 132, src.getClass().getName() + " to " + target.getName(), t).fillInStackTrace();
            }
        }
        Throwable cause = null;
        for (Map.Entry<Key, JavaToJavaConverter<?, ?>> e : CONVERTERS.entrySet()) {
            if (!e.getKey().satisfies(desired)) continue;
            try {
                c = e.getValue();
                return (T)c.convert(src, conn, srcExtra, targetExtra);
            }
            catch (Throwable t) {
                try {
                    if (cause == null) continue;
                    t.initCause(cause);
                }
                catch (IllegalStateException illegalStateException) {}
                continue;
                finally {
                    cause = t;
                }
            }
        }
        throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)conn, 132, src.getClass().getName() + " to " + target.getName(), cause).fillInStackTrace();
    }

    private JavaToJavaConverter() {
    }

    protected abstract T convert(S var1, OracleConnection var2, Object var3, Object var4) throws Exception;

    static Calendar getSessionCalendar(OracleConnection conn) {
        Calendar sessTzCal;
        String locTimeZone = conn.getSessionTimeZone();
        if (locTimeZone == null) {
            sessTzCal = Calendar.getInstance();
        } else {
            TimeZone zone = TimeZone.getTimeZone(locTimeZone);
            sessTzCal = Calendar.getInstance(zone);
        }
        return sessTzCal;
    }

    private static Calendar getCalendarOrDefault(Object srcExtra, OracleConnection conn) throws SQLException {
        if (srcExtra instanceof Calendar) {
            return (Calendar)srcExtra;
        }
        return Calendar.getInstance(JavaToJavaConverter.getTimeZoneOrDefault(null, conn), Locale.US);
    }

    private static TimeZone getTimeZoneOrDefault(Object srcExtra, OracleConnection conn) throws SQLException {
        TimeZone defaultTimeZone;
        if (srcExtra instanceof TimeZone) {
            return (TimeZone)srcExtra;
        }
        if (conn != null && (defaultTimeZone = conn.getDefaultTimeZone()) != null) {
            return defaultTimeZone;
        }
        return TimeZone.getDefault();
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int result;
            byte[] buffer = new byte[1024];
            while (-1 != (result = inputStream.read(buffer))) {
                outputStream.write(buffer, 0, result);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    private static char[] readAllChars(Reader reader) throws IOException {
        try (CharArrayWriter writer = new CharArrayWriter();){
            int result;
            char[] buffer = new char[1024];
            while (-1 != (result = reader.read(buffer))) {
                writer.write(buffer, 0, result);
            }
            char[] cArray = writer.toCharArray();
            return cArray;
        }
    }

    private static void mapAssignableType(Class<?> superType, Class<?> subType) {
        if (!superType.isAssignableFrom(subType)) {
            throw new RuntimeException(String.valueOf(subType) + " is not a subtype of " + String.valueOf(superType));
        }
        CONVERTERS.putAll(CONVERTERS.entrySet().stream().filter(entry -> superType.equals(((Key)entry.getKey()).source)).collect(Collectors.toMap(entry -> new Key(subType, ((Key)entry.getKey()).target), Map.Entry::getValue)));
    }

    private static Time convertLocalTimeToTime(LocalTime localTime) {
        long milliseconds = localTime.getNano() / 1000000 + localTime.getSecond() * 1000 + localTime.getMinute() * 60000 + localTime.getHour() * 3600000;
        return new Time(milliseconds);
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        String result = args[i++];
        System.out.println("\toriginal:\t" + String.valueOf(result));
        while (i < args.length) {
            Class<?> target = Class.forName(args[i++]);
            System.out.println("\t" + result.getClass().getName() + "\tto:\t" + target.getName());
            result = JavaToJavaConverter.convert(result, target, null, null, null);
            System.out.println("\tresult:\t" + String.valueOf(result));
        }
    }

    static {
        CONVERTERS.put(new Key(BigDecimal.class, NUMBER.class), new JavaToJavaConverter<BigDecimal, NUMBER>(){

            @Override
            protected NUMBER convert(BigDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JDBCType.BIT == targetExtra ? new NUMBER(BigDecimal.ZERO.compareTo(src) == 0 ? 0 : 1) : new NUMBER(src);
            }
        });
        CONVERTERS.put(new Key(BigDecimal.class, Boolean.class), new JavaToJavaConverter<BigDecimal, Boolean>(){

            @Override
            protected Boolean convert(BigDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.compareTo(BigDecimal.ZERO) != 0;
            }
        });
        CONVERTERS.put(new Key(BigInteger.class, NUMBER.class), new JavaToJavaConverter<BigInteger, NUMBER>(){

            @Override
            protected NUMBER convert(BigInteger src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new NUMBER(src);
            }
        });
        CONVERTERS.put(new Key(BINARY_DOUBLE.class, Double.class), new JavaToJavaConverter<BINARY_DOUBLE, Double>(){

            @Override
            protected Double convert(BINARY_DOUBLE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.doubleValue();
            }
        });
        CONVERTERS.put(new Key(BINARY_DOUBLE.class, String.class), new JavaToJavaConverter<BINARY_DOUBLE, String>(){

            @Override
            protected String convert(BINARY_DOUBLE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue();
            }
        });
        CONVERTERS.put(new Key(BINARY_FLOAT.class, Float.class), new JavaToJavaConverter<BINARY_FLOAT, Float>(){

            @Override
            protected Float convert(BINARY_FLOAT src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Float.valueOf(src.floatValue());
            }
        });
        CONVERTERS.put(new Key(BINARY_FLOAT.class, String.class), new JavaToJavaConverter<BINARY_FLOAT, String>(){

            @Override
            protected String convert(BINARY_FLOAT src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue();
            }
        });
        CONVERTERS.put(new Key(Blob.class, RAW.class), new JavaToJavaConverter<Blob, RAW>(){

            @Override
            protected RAW convert(Blob src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                long length = src.length();
                if (length > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Blob length exceeds maximum length of RAW: " + length);
                }
                return new RAW(src.getBytes(1L, (int)length));
            }
        });
        CONVERTERS.put(new Key(Boolean.class, BigDecimal.class), new JavaToJavaConverter<Boolean, BigDecimal>(){

            @Override
            protected BigDecimal convert(Boolean src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        CONVERTERS.put(new Key(Boolean.class, BINARY_DOUBLE.class), new JavaToJavaConverter<Boolean, BINARY_DOUBLE>(){

            @Override
            protected BINARY_DOUBLE convert(Boolean src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src != false ? new BINARY_DOUBLE(1.0) : new BINARY_DOUBLE(0.0);
            }
        });
        CONVERTERS.put(new Key(Boolean.class, BINARY_FLOAT.class), new JavaToJavaConverter<Boolean, BINARY_FLOAT>(){

            @Override
            protected BINARY_FLOAT convert(Boolean src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src != false ? new BINARY_FLOAT(1.0f) : new BINARY_FLOAT(0.0f);
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Byte.class), new JavaToJavaConverter<Boolean, Byte>(){

            @Override
            protected Byte convert(Boolean src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src != false ? (byte)1 : 0;
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Double.class), new JavaToJavaConverter<Boolean, Double>(){

            @Override
            protected Double convert(Boolean src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src != false ? 1.0 : 0.0;
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Float.class), new JavaToJavaConverter<Boolean, Float>(){

            @Override
            protected Float convert(Boolean src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Float.valueOf(src != false ? 1.0f : 0.0f);
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Integer.class), new JavaToJavaConverter<Boolean, Integer>(){

            @Override
            protected Integer convert(Boolean src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src != false ? 1 : 0;
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Long.class), new JavaToJavaConverter<Boolean, Long>(){

            @Override
            protected Long convert(Boolean src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src != false ? 1L : 0L;
            }
        });
        CONVERTERS.put(new Key(Boolean.class, NUMBER.class), new JavaToJavaConverter<Boolean, NUMBER>(){

            @Override
            protected NUMBER convert(Boolean src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src != false ? new NUMBER(1) : new NUMBER(0);
            }
        });
        CONVERTERS.put(new Key(Boolean.class, Short.class), new JavaToJavaConverter<Boolean, Short>(){

            @Override
            protected Short convert(Boolean src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src != false ? (short)1 : 0;
            }
        });
        CONVERTERS.put(new Key(Boolean.class, String.class), new JavaToJavaConverter<Boolean, String>(){

            @Override
            protected String convert(Boolean src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src != false ? "1" : "0";
            }
        });
        CONVERTERS.put(new Key(Byte.class, NUMBER.class), new JavaToJavaConverter<Byte, NUMBER>(){

            @Override
            protected NUMBER convert(Byte src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JDBCType.BIT == targetExtra ? new NUMBER(src == 0 ? 0 : 1) : new NUMBER(src);
            }
        });
        CONVERTERS.put(new Key(byte[].class, CHAR.class), new JavaToJavaConverter<byte[], CHAR>(){

            @Override
            protected CHAR convert(byte[] src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                CharacterSet charSet = null;
                if (targetExtra != null && targetExtra instanceof CharacterSet) {
                    charSet = (CharacterSet)targetExtra;
                } else if (conn != null) {
                    charSet = CharacterSet.make(conn.getJdbcCsId());
                }
                if (charSet == null) {
                    throw new IllegalArgumentException("Charset needs to be defined while making CHAR type");
                }
                return new CHAR(src, charSet);
            }
        });
        CONVERTERS.put(new Key(byte[].class, DATE.class), new JavaToJavaConverter<byte[], DATE>(){

            @Override
            protected DATE convert(byte[] src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(src);
            }
        });
        CONVERTERS.put(new Key(byte[].class, InputStream.class), new JavaToJavaConverter<byte[], InputStream>(){

            @Override
            protected InputStream convert(byte[] src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new ByteArrayInputStream(src);
            }
        });
        CONVERTERS.put(new Key(byte[].class, NUMBER.class), new JavaToJavaConverter<byte[], NUMBER>(){

            @Override
            protected NUMBER convert(byte[] src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new NUMBER(src);
            }
        });
        CONVERTERS.put(new Key(byte[].class, RAW.class), new JavaToJavaConverter<byte[], RAW>(){

            @Override
            protected RAW convert(byte[] src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return RAW.newRAW(src);
            }
        });
        CONVERTERS.put(new Key(byte[].class, String.class), new JavaToJavaConverter<byte[], String>(){

            @Override
            protected String convert(byte[] src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new String(src);
            }
        });
        CONVERTERS.put(new Key(byte[].class, TIMESTAMP.class), new JavaToJavaConverter<byte[], TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(byte[] src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(byte[].class, TIMESTAMPLTZ.class), new JavaToJavaConverter<byte[], TIMESTAMPLTZ>(){

            @Override
            protected TIMESTAMPLTZ convert(byte[] src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPLTZ(src);
            }
        });
        CONVERTERS.put(new Key(Calendar.class, java.sql.Date.class), new JavaToJavaConverter<Calendar, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(Calendar src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new java.sql.Date(src.getTimeInMillis());
            }
        });
        CONVERTERS.put(new Key(Calendar.class, Date.class), new JavaToJavaConverter<Calendar, Date>(){

            @Override
            protected Date convert(Calendar src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getTime();
            }
        });
        CONVERTERS.put(new Key(Calendar.class, DATE.class), new JavaToJavaConverter<Calendar, DATE>(){

            @Override
            protected DATE convert(Calendar src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return DATE.of(LocalDateTime.of(src.get(1), src.get(2) + 1, src.get(5), src.get(11), src.get(12), src.get(13), src.get(14) * 1000000));
            }
        });
        CONVERTERS.put(new Key(Calendar.class, String.class), new JavaToJavaConverter<Calendar, String>(){

            @Override
            protected String convert(Calendar src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toString();
            }
        });
        CONVERTERS.put(new Key(Calendar.class, Time.class), new JavaToJavaConverter<Calendar, Time>(){

            @Override
            protected Time convert(Calendar src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Time(src.getTimeInMillis());
            }
        });
        CONVERTERS.put(new Key(Calendar.class, Timestamp.class), new JavaToJavaConverter<Calendar, Timestamp>(){

            @Override
            protected Timestamp convert(Calendar src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Timestamp(src.getTimeInMillis());
            }
        });
        CONVERTERS.put(new Key(Calendar.class, TIMESTAMP.class), new JavaToJavaConverter<Calendar, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(Calendar src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(new Timestamp(src.getTimeInMillis()));
            }
        });
        CONVERTERS.put(new Key(Calendar.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<Calendar, TIMESTAMPLTZ>(){

            @Override
            protected TIMESTAMPLTZ convert(Calendar src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPLTZ((Connection)conn, 36.getSessionCalendar(conn), new java.sql.Date(src.getTimeInMillis()));
            }
        });
        CONVERTERS.put(new Key(Calendar.class, TIMESTAMPTZ.class), new JavaToJavaConverter<Calendar, TIMESTAMPTZ>(){

            @Override
            protected TIMESTAMPTZ convert(Calendar src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPTZ((Connection)conn, new java.sql.Date(src.getTimeInMillis()), src);
            }
        });
        CONVERTERS.put(new Key(CHAR.class, BigDecimal.class), new JavaToJavaConverter<CHAR, BigDecimal>(){

            @Override
            protected BigDecimal convert(CHAR src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new BigDecimal(src.getString());
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Boolean.class), new JavaToJavaConverter<CHAR, Boolean>(){

            @Override
            protected Boolean convert(CHAR src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.booleanValue();
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Byte.class), new JavaToJavaConverter<CHAR, Byte>(){

            @Override
            protected Byte convert(CHAR src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.byteValue();
            }
        });
        CONVERTERS.put(new Key(CHAR.class, java.sql.Date.class), new JavaToJavaConverter<CHAR, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(CHAR src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new java.sql.Date(Date.parse(src.getString()));
            }
        });
        CONVERTERS.put(new Key(CHAR.class, InputStream.class), new JavaToJavaConverter<CHAR, InputStream>(){

            @Override
            protected InputStream convert(CHAR src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new ByteArrayInputStream(src.shareBytes());
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Long.class), new JavaToJavaConverter<CHAR, Long>(){

            @Override
            protected Long convert(CHAR src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Long(src.getString());
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Reader.class), new JavaToJavaConverter<CHAR, Reader>(){

            @Override
            protected Reader convert(CHAR src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new StringReader(src.getString());
            }
        });
        CONVERTERS.put(new Key(CHAR.class, String.class), new JavaToJavaConverter<CHAR, String>(){

            @Override
            protected String convert(CHAR src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getString();
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Time.class), new JavaToJavaConverter<CHAR, Time>(){

            @Override
            protected Time convert(CHAR src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Time(Date.parse(src.getString()));
            }
        });
        CONVERTERS.put(new Key(CHAR.class, Timestamp.class), new JavaToJavaConverter<CHAR, Timestamp>(){

            @Override
            protected Timestamp convert(CHAR src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Timestamp(Date.parse(src.getString()));
            }
        });
        CONVERTERS.put(new Key(Character.class, String.class), new JavaToJavaConverter<Character, String>(){

            @Override
            protected String convert(Character src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toString();
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, Calendar.class), new JavaToJavaConverter<java.sql.Date, Calendar>(){

            @Override
            protected Calendar convert(java.sql.Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar cal = Calendar.getInstance();
                cal.setTime(src);
                return cal;
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, Date.class), new JavaToJavaConverter<java.sql.Date, Date>(){

            @Override
            protected Date convert(java.sql.Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Date(src.getTime());
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, DATE.class), new JavaToJavaConverter<java.sql.Date, DATE>(){

            @Override
            protected DATE convert(java.sql.Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(src);
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, String.class), new JavaToJavaConverter<java.sql.Date, String>(){

            @Override
            protected String convert(java.sql.Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toString();
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, Timestamp.class), new JavaToJavaConverter<java.sql.Date, Timestamp>(){

            @Override
            protected Timestamp convert(java.sql.Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Timestamp(src.getTime());
            }
        });
        CONVERTERS.put(new Key(java.sql.Date.class, TIMESTAMP.class), new JavaToJavaConverter<java.sql.Date, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(java.sql.Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(Date.class, Calendar.class), new JavaToJavaConverter<Date, Calendar>(){

            @Override
            protected Calendar convert(Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar cal = Calendar.getInstance();
                cal.setTime(src);
                return cal;
            }
        });
        CONVERTERS.put(new Key(Date.class, Date.class), new JavaToJavaConverter<Date, Date>(){

            @Override
            protected Date convert(Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new java.sql.Date(src.getTime());
            }
        });
        CONVERTERS.put(new Key(Date.class, DATE.class), new JavaToJavaConverter<Date, DATE>(){

            @Override
            protected DATE convert(Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(new java.sql.Date(src.getTime()));
            }
        });
        CONVERTERS.put(new Key(Date.class, String.class), new JavaToJavaConverter<Date, String>(){

            @Override
            protected String convert(Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toString();
            }
        });
        CONVERTERS.put(new Key(Date.class, Timestamp.class), new JavaToJavaConverter<Date, Timestamp>(){

            @Override
            protected Timestamp convert(Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Timestamp(src.getTime());
            }
        });
        CONVERTERS.put(new Key(Date.class, TIMESTAMP.class), new JavaToJavaConverter<Date, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(Date src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(new Timestamp(src.getTime()));
            }
        });
        CONVERTERS.put(new Key(DATE.class, Calendar.class), new JavaToJavaConverter<DATE, Calendar>(){

            @Override
            protected Calendar convert(DATE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar cal = Calendar.getInstance();
                cal.setTime(src.dateValue());
                return cal;
            }
        });
        CONVERTERS.put(new Key(DATE.class, Date.class), new JavaToJavaConverter<DATE, Date>(){

            @Override
            protected Date convert(DATE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Date(src.dateValue().getTime());
            }
        });
        CONVERTERS.put(new Key(DATE.class, java.sql.Date.class), new JavaToJavaConverter<DATE, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(DATE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new java.sql.Date(src.dateValue().getTime());
            }
        });
        CONVERTERS.put(new Key(DATE.class, LocalDate.class), new JavaToJavaConverter<DATE, LocalDate>(){

            @Override
            protected LocalDate convert(DATE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.localDateValue();
            }
        });
        CONVERTERS.put(new Key(DATE.class, LocalDateTime.class), new JavaToJavaConverter<DATE, LocalDateTime>(){

            @Override
            protected LocalDateTime convert(DATE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.localDateTimeValue();
            }
        });
        CONVERTERS.put(new Key(DATE.class, LocalTime.class), new JavaToJavaConverter<DATE, LocalTime>(){

            @Override
            protected LocalTime convert(DATE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.localTimeValue();
            }
        });
        CONVERTERS.put(new Key(DATE.class, String.class), new JavaToJavaConverter<DATE, String>(){

            @Override
            protected String convert(DATE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue();
            }
        });
        CONVERTERS.put(new Key(DATE.class, Time.class), new JavaToJavaConverter<DATE, Time>(){

            @Override
            protected Time convert(DATE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.timeValue();
            }
        });
        CONVERTERS.put(new Key(DATE.class, Timestamp.class), new JavaToJavaConverter<DATE, Timestamp>(){

            @Override
            protected Timestamp convert(DATE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.timestampValue();
            }
        });
        CONVERTERS.put(new Key(DATE.class, TIMESTAMP.class), new JavaToJavaConverter<DATE, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(DATE src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(Double.class, NUMBER.class), new JavaToJavaConverter<Double, NUMBER>(){

            @Override
            protected NUMBER convert(Double src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                double value = src;
                if (JDBCType.BIT == targetExtra) {
                    return new NUMBER(value == 0.0 ? 0 : 1);
                }
                return new NUMBER(BigDecimal.valueOf(value));
            }
        });
        CONVERTERS.put(new Key(Duration.class, INTERVALDS.class), new JavaToJavaConverter<Duration, INTERVALDS>(){

            @Override
            protected INTERVALDS convert(Duration src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                long sec = src.getSeconds();
                int sign = (int)Math.signum(sec);
                sec = Math.abs(sec);
                int nano = Math.abs(src.getNano());
                int day = sign * (int)(sec / 86400L);
                int hour = sign * (int)((sec %= 86400L) / 3600L);
                int min = sign * (int)((sec %= 3600L) / 60L);
                sec %= 60L;
                byte[] bytes = new byte[11];
                bytes[0] = (byte)((day += INTERVALDAYOFFSET) >> 24 & 0xFF);
                bytes[1] = (byte)(day >> 16 & 0xFF);
                bytes[2] = (byte)(day >> 8 & 0xFF);
                bytes[3] = (byte)(day & 0xFF);
                bytes[4] = (byte)(hour + INTERVALDSOFFSET);
                bytes[5] = (byte)(min + INTERVALDSOFFSET);
                bytes[6] = (byte)(sec + (long)INTERVALDSOFFSET);
                nano = sign * nano + INTERVALDAYOFFSET;
                bytes[7] = (byte)(nano >> 24 & 0xFF);
                bytes[8] = (byte)(nano >> 16 & 0xFF);
                bytes[9] = (byte)(nano >> 8 & 0xFF);
                bytes[10] = (byte)(nano & 0xFF);
                return new INTERVALDS(bytes);
            }
        });
        CONVERTERS.put(new Key(Duration.class, String.class), new JavaToJavaConverter<Duration, String>(){

            @Override
            protected String convert(Duration src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JavaToJavaConverter.convert(src, INTERVALDS.class, conn, srcExtra, targetExtra).toString();
            }
        });
        CONVERTERS.put(new Key(Float.class, NUMBER.class), new JavaToJavaConverter<Float, NUMBER>(){

            @Override
            protected NUMBER convert(Float src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JDBCType.BIT == targetExtra ? new NUMBER(src.floatValue() == 0.0f ? 0 : 1) : new NUMBER(src.floatValue());
            }
        });
        CONVERTERS.put(new Key(InputStream.class, CLOB.class), new JavaToJavaConverter<InputStream, CLOB>(){

            @Override
            protected CLOB convert(InputStream src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                int c;
                CLOB result = (CLOB)conn.createClob();
                OutputStream w = result.setAsciiStream(1L);
                long max = Long.MAX_VALUE;
                if (srcExtra != null && srcExtra instanceof Number) {
                    max = ((Number)srcExtra).longValue();
                }
                for (long i = 0L; i < max && (c = src.read()) != -1; ++i) {
                    w.write(c);
                }
                w.close();
                return result;
            }
        });
        CONVERTERS.put(new Key(InputStream.class, NCLOB.class), new JavaToJavaConverter<InputStream, CLOB>(){

            @Override
            protected NCLOB convert(InputStream src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                int c;
                NCLOB result = (NCLOB)conn.createNClob();
                OutputStream w = result.setAsciiStream(1L);
                long max = Long.MAX_VALUE;
                if (srcExtra != null && srcExtra instanceof Number) {
                    max = ((Number)srcExtra).longValue();
                }
                for (long i = 0L; i < max && (c = src.read()) != -1; ++i) {
                    w.write(c);
                }
                w.close();
                return result;
            }
        });
        CONVERTERS.put(new Key(InputStream.class, RAW.class), new JavaToJavaConverter<InputStream, RAW>(){

            @Override
            protected RAW convert(InputStream src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new RAW(JavaToJavaConverter.readAllBytes(src));
            }
        });
        CONVERTERS.put(new Key(InputStream.class, String.class), new JavaToJavaConverter<InputStream, String>(){

            @Override
            protected String convert(InputStream src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                String result;
                block4: {
                    int c;
                    long max = Long.MAX_VALUE;
                    if (srcExtra != null && srcExtra instanceof Number) {
                        max = ((Number)srcExtra).longValue();
                    }
                    ByteArrayOutputStream w = new ByteArrayOutputStream();
                    for (long i = 0L; i < max && (c = src.read()) != -1; ++i) {
                        w.write(c);
                    }
                    result = null;
                    try {
                        result = w.toString("US-ASCII");
                    }
                    catch (UnsupportedEncodingException ex) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError((Object)"can't happen");
                    }
                }
                return result;
            }
        });
        CONVERTERS.put(new Key(Integer.class, NUMBER.class), new JavaToJavaConverter<Integer, NUMBER>(){

            @Override
            protected NUMBER convert(Integer src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JDBCType.BIT == targetExtra ? new NUMBER(src == 0 ? 0 : 1) : new NUMBER(src);
            }
        });
        CONVERTERS.put(new Key(INTERVALDS.class, String.class), new JavaToJavaConverter<INTERVALDS, String>(){

            @Override
            protected String convert(INTERVALDS src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue();
            }
        });
        CONVERTERS.put(new Key(INTERVALYM.class, String.class), new JavaToJavaConverter<INTERVALYM, String>(){

            @Override
            protected String convert(INTERVALYM src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue();
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, java.sql.Date.class), new JavaToJavaConverter<LocalDate, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(LocalDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return java.sql.Date.valueOf(src);
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, DATE.class), new JavaToJavaConverter<LocalDate, DATE>(){

            @Override
            protected DATE convert(LocalDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(src);
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, Date.class), new JavaToJavaConverter<LocalDate, Date>(){

            @Override
            protected Date convert(LocalDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Date.from(LocalDateTime.of(src, LocalTime.MIDNIGHT).toInstant(ZoneOffset.UTC));
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, String.class), new JavaToJavaConverter<LocalDate, String>(){

            @Override
            protected String convert(LocalDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.format(DateTimeFormatter.ISO_LOCAL_DATE);
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, Timestamp.class), new JavaToJavaConverter<LocalDate, Timestamp>(){

            @Override
            protected Timestamp convert(LocalDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Timestamp.valueOf(LocalDateTime.of(src, LocalTime.MIDNIGHT));
            }
        });
        CONVERTERS.put(new Key(LocalDate.class, TIMESTAMP.class), new JavaToJavaConverter<LocalDate, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(LocalDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, java.sql.Date.class), new JavaToJavaConverter<LocalDateTime, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(LocalDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return java.sql.Date.valueOf(src.toLocalDate());
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, DATE.class), new JavaToJavaConverter<LocalDateTime, DATE>(){

            @Override
            protected DATE convert(LocalDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JDBCType.TIME == targetExtra ? new DATE(src.toLocalTime()) : new DATE(src);
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, Date.class), new JavaToJavaConverter<LocalDateTime, Date>(){

            @Override
            protected Date convert(LocalDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Date.from(src.toInstant(ZoneOffset.UTC));
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, String.class), new JavaToJavaConverter<LocalDateTime, String>(){

            @Override
            protected String convert(LocalDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.format(DATE_TIME_FORMAT);
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, Time.class), new JavaToJavaConverter<LocalDateTime, Time>(){

            @Override
            protected Time convert(LocalDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JavaToJavaConverter.convertLocalTimeToTime(src.toLocalTime());
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, Timestamp.class), new JavaToJavaConverter<LocalDateTime, Timestamp>(){

            @Override
            protected Timestamp convert(LocalDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Timestamp.valueOf(src);
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, TIMESTAMP.class), new JavaToJavaConverter<LocalDateTime, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(LocalDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<LocalDateTime, TIMESTAMPLTZ>(){

            @Override
            protected TIMESTAMPLTZ convert(LocalDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPLTZ((Connection)conn, src);
            }
        });
        CONVERTERS.put(new Key(LocalDateTime.class, TIMESTAMPTZ.class), new JavaToJavaConverter<LocalDateTime, TIMESTAMPTZ>(){

            @Override
            protected TIMESTAMPTZ convert(LocalDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPTZ((Connection)conn, src);
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, DATE.class), new JavaToJavaConverter<LocalTime, DATE>(){

            @Override
            protected DATE convert(LocalTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(src);
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, Date.class), new JavaToJavaConverter<LocalTime, Date>(){

            @Override
            protected Date convert(LocalTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Date(src.getLong(ChronoField.MILLI_OF_DAY));
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, String.class), new JavaToJavaConverter<LocalTime, String>(){

            @Override
            protected String convert(LocalTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.format(DateTimeFormatter.ISO_LOCAL_TIME);
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, Time.class), new JavaToJavaConverter<LocalTime, Time>(){

            @Override
            protected Time convert(LocalTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JavaToJavaConverter.convertLocalTimeToTime(src);
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, Timestamp.class), new JavaToJavaConverter<LocalTime, Timestamp>(){

            @Override
            protected Timestamp convert(LocalTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Timestamp t = new Timestamp(src.getLong(ChronoField.MILLI_OF_DAY));
                t.setNanos(src.get(ChronoField.NANO_OF_SECOND));
                return t;
            }
        });
        CONVERTERS.put(new Key(LocalTime.class, TIMESTAMP.class), new JavaToJavaConverter<LocalTime, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(LocalTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(Long.class, NUMBER.class), new JavaToJavaConverter<Long, NUMBER>(){

            @Override
            protected NUMBER convert(Long src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JDBCType.BIT == targetExtra ? new NUMBER(src == 0L ? 0 : 1) : new NUMBER(src);
            }
        });
        CONVERTERS.put(new Key(Number.class, BigDecimal.class), new JavaToJavaConverter<Number, BigDecimal>(){

            @Override
            protected BigDecimal convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new BigDecimal(src.toString());
            }
        });
        CONVERTERS.put(new Key(Number.class, BINARY_DOUBLE.class), new JavaToJavaConverter<Number, BINARY_DOUBLE>(){

            @Override
            protected BINARY_DOUBLE convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new BINARY_DOUBLE(src.doubleValue());
            }
        });
        CONVERTERS.put(new Key(Number.class, BINARY_FLOAT.class), new JavaToJavaConverter<Number, BINARY_FLOAT>(){

            @Override
            protected BINARY_FLOAT convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new BINARY_FLOAT(src.floatValue());
            }
        });
        CONVERTERS.put(new Key(Number.class, Boolean.class), new JavaToJavaConverter<Number, Boolean>(){

            @Override
            protected Boolean convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.doubleValue() != 0.0;
            }
        });
        CONVERTERS.put(new Key(Number.class, Byte.class), new JavaToJavaConverter<Number, Byte>(){

            @Override
            protected Byte convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.byteValue();
            }
        });
        CONVERTERS.put(new Key(Number.class, Double.class), new JavaToJavaConverter<Number, Double>(){

            @Override
            protected Double convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.doubleValue();
            }
        });
        CONVERTERS.put(new Key(Number.class, Float.class), new JavaToJavaConverter<Number, Float>(){

            @Override
            protected Float convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Float.valueOf(src.floatValue());
            }
        });
        CONVERTERS.put(new Key(Number.class, Integer.class), new JavaToJavaConverter<Number, Integer>(){

            @Override
            protected Integer convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.intValue();
            }
        });
        CONVERTERS.put(new Key(Number.class, Long.class), new JavaToJavaConverter<Number, Long>(){

            @Override
            protected Long convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.longValue();
            }
        });
        CONVERTERS.put(new Key(Number.class, NUMBER.class), new JavaToJavaConverter<Number, NUMBER>(){

            @Override
            protected NUMBER convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new NUMBER(new BigDecimal(src.toString()));
            }
        });
        CONVERTERS.put(new Key(Number.class, Short.class), new JavaToJavaConverter<Number, Short>(){

            @Override
            protected Short convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.shortValue();
            }
        });
        CONVERTERS.put(new Key(Number.class, String.class), new JavaToJavaConverter<Number, String>(){

            @Override
            protected String convert(Number src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toString();
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, BigDecimal.class), new JavaToJavaConverter<NUMBER, BigDecimal>(){

            @Override
            protected BigDecimal convert(NUMBER src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.bigDecimalValue();
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, BigInteger.class), new JavaToJavaConverter<NUMBER, BigInteger>(){

            @Override
            protected BigInteger convert(NUMBER src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.bigIntegerValue();
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Boolean.class), new JavaToJavaConverter<NUMBER, Boolean>(){

            @Override
            protected Boolean convert(NUMBER src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.booleanValue();
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Byte.class), new JavaToJavaConverter<NUMBER, Byte>(){

            @Override
            protected Byte convert(NUMBER src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.byteValue();
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Double.class), new JavaToJavaConverter<NUMBER, Double>(){

            @Override
            protected Double convert(NUMBER src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.doubleValue();
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Float.class), new JavaToJavaConverter<NUMBER, Float>(){

            @Override
            protected Float convert(NUMBER src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Float.valueOf(src.floatValue());
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Integer.class), new JavaToJavaConverter<NUMBER, Integer>(){

            @Override
            protected Integer convert(NUMBER src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.intValue();
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Long.class), new JavaToJavaConverter<NUMBER, Long>(){

            @Override
            protected Long convert(NUMBER src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.longValue();
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, Short.class), new JavaToJavaConverter<NUMBER, Short>(){

            @Override
            protected Short convert(NUMBER src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.shortValue();
            }
        });
        CONVERTERS.put(new Key(NUMBER.class, String.class), new JavaToJavaConverter<NUMBER, String>(){

            @Override
            protected String convert(NUMBER src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue();
            }
        });
        CONVERTERS.put(new Key(Object.class, CHAR.class), new JavaToJavaConverter<Object, CHAR>(){

            @Override
            protected CHAR convert(Object src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                CharacterSet charSet = null;
                if (targetExtra != null && targetExtra instanceof CharacterSet) {
                    charSet = (CharacterSet)targetExtra;
                } else if (conn != null) {
                    charSet = CharacterSet.make(conn.getJdbcCsId());
                }
                if (charSet == null) {
                    throw new IllegalArgumentException("Charset needs to be defined while coverting to CHAR type");
                }
                if (src instanceof InputStream) {
                    return new CHAR(JavaToJavaConverter.readAllBytes((InputStream)src), charSet);
                }
                if (src instanceof Reader) {
                    return new CHAR(new String(JavaToJavaConverter.readAllChars((Reader)src)), charSet);
                }
                if (src instanceof Clob) {
                    Clob clob = (Clob)src;
                    long length = clob.length();
                    if (length > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Clob length exceeds maximum length of CHAR: " + length);
                    }
                    return new CHAR(clob.getSubString(1L, (int)length), charSet);
                }
                return new CHAR(src, charSet);
            }
        });
        CONVERTERS.put(new Key(Object.class, OracleJsonBinary.class), new JavaToJavaConverter<Object, OracleJsonBinary>(){

            @Override
            protected OracleJsonBinary convert(Object src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return ((OracleJsonFactory)targetExtra).createBinary(127.convert(src, byte[].class, conn, srcExtra, null));
            }
        });
        CONVERTERS.put(new Key(Object.class, OracleJsonDate.class), new JavaToJavaConverter<Object, OracleJsonDate>(){

            @Override
            protected OracleJsonDate convert(Object src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return ((OracleJsonFactory)targetExtra).createDate(128.convert(src, LocalDateTime.class, conn, srcExtra, null));
            }
        });
        CONVERTERS.put(new Key(Object.class, OracleJsonDecimal.class), new JavaToJavaConverter<Object, OracleJsonDecimal>(){

            @Override
            protected OracleJsonDecimal convert(Object src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return ((OracleJsonFactory)targetExtra).createDecimal(129.convert(src, BigDecimal.class, conn, srcExtra, null));
            }
        });
        CONVERTERS.put(new Key(Object.class, OracleJsonDouble.class), new JavaToJavaConverter<Object, OracleJsonDouble>(){

            @Override
            protected OracleJsonDouble convert(Object src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return ((OracleJsonFactory)targetExtra).createDouble(130.convert(src, Double.class, conn, srcExtra, null));
            }
        });
        CONVERTERS.put(new Key(Object.class, OracleJsonFloat.class), new JavaToJavaConverter<Object, OracleJsonFloat>(){

            @Override
            protected OracleJsonFloat convert(Object src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return ((OracleJsonFactory)targetExtra).createFloat(131.convert(src, Float.class, conn, srcExtra, null).floatValue());
            }
        });
        CONVERTERS.put(new Key(Object.class, OracleJsonIntervalDS.class), new JavaToJavaConverter<Object, OracleJsonIntervalDS>(){

            @Override
            protected OracleJsonIntervalDS convert(Object src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return ((OracleJsonFactory)targetExtra).createIntervalDS(132.convert(src, Duration.class, conn, srcExtra, null));
            }
        });
        CONVERTERS.put(new Key(Object.class, OracleJsonIntervalYM.class), new JavaToJavaConverter<Object, OracleJsonIntervalYM>(){

            @Override
            protected OracleJsonIntervalYM convert(Object src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return ((OracleJsonFactory)targetExtra).createIntervalYM(133.convert(src, Period.class, conn, srcExtra, null));
            }
        });
        CONVERTERS.put(new Key(Object.class, OracleJsonString.class), new JavaToJavaConverter<Object, OracleJsonString>(){

            @Override
            protected OracleJsonString convert(Object src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return ((OracleJsonFactory)targetExtra).createString(134.convert(src, String.class, conn, srcExtra, null));
            }
        });
        CONVERTERS.put(new Key(Object.class, OracleJsonTimestamp.class), new JavaToJavaConverter<Object, OracleJsonTimestamp>(){

            @Override
            protected OracleJsonTimestamp convert(Object src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return ((OracleJsonFactory)targetExtra).createTimestamp(135.convert(src, LocalDateTime.class, conn, srcExtra, null));
            }
        });
        CONVERTERS.put(new Key(Object.class, OracleJsonTimestampTZ.class), new JavaToJavaConverter<Object, OracleJsonTimestampTZ>(){

            @Override
            protected OracleJsonTimestampTZ convert(Object src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return ((OracleJsonFactory)targetExtra).createTimestampTZ(136.convert(src, OffsetDateTime.class, conn, srcExtra, null));
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, java.sql.Date.class), new JavaToJavaConverter<OffsetDateTime, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(OffsetDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return java.sql.Date.valueOf(src.toLocalDate());
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, DATE.class), new JavaToJavaConverter<OffsetDateTime, DATE>(){

            @Override
            protected DATE convert(OffsetDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(src);
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, Date.class), new JavaToJavaConverter<OffsetDateTime, Date>(){

            @Override
            protected Date convert(OffsetDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Date.from(src.toInstant());
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, String.class), new JavaToJavaConverter<OffsetDateTime, String>(){

            @Override
            protected String convert(OffsetDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.format(OFFSET_DATE_TIME_FORMAT);
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, Time.class), new JavaToJavaConverter<OffsetDateTime, Time>(){

            @Override
            protected Time convert(OffsetDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JavaToJavaConverter.convertLocalTimeToTime(src.toLocalTime());
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, Timestamp.class), new JavaToJavaConverter<OffsetDateTime, Timestamp>(){

            @Override
            protected Timestamp convert(OffsetDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Timestamp.valueOf(src.toLocalDateTime());
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, TIMESTAMP.class), new JavaToJavaConverter<OffsetDateTime, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(OffsetDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<OffsetDateTime, TIMESTAMPLTZ>(){

            @Override
            protected TIMESTAMPLTZ convert(OffsetDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPLTZ((Connection)conn, src);
            }
        });
        CONVERTERS.put(new Key(OffsetDateTime.class, TIMESTAMPTZ.class), new JavaToJavaConverter<OffsetDateTime, TIMESTAMPTZ>(){

            @Override
            protected TIMESTAMPTZ convert(OffsetDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPTZ(src);
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, DATE.class), new JavaToJavaConverter<OffsetTime, DATE>(){

            @Override
            protected DATE convert(OffsetTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(src);
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, Date.class), new JavaToJavaConverter<OffsetTime, Date>(){

            @Override
            protected Date convert(OffsetTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Date(src.getLong(ChronoField.MILLI_OF_DAY));
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, String.class), new JavaToJavaConverter<OffsetTime, String>(){

            @Override
            protected String convert(OffsetTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.format(DateTimeFormatter.ISO_OFFSET_TIME);
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, Time.class), new JavaToJavaConverter<OffsetTime, Time>(){

            @Override
            protected Time convert(OffsetTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JavaToJavaConverter.convertLocalTimeToTime(src.toLocalTime());
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, Timestamp.class), new JavaToJavaConverter<OffsetTime, Timestamp>(){

            @Override
            protected Timestamp convert(OffsetTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Timestamp t = new Timestamp(src.getLong(ChronoField.MILLI_OF_DAY));
                t.setNanos(src.get(ChronoField.NANO_OF_SECOND));
                return t;
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, TIMESTAMP.class), new JavaToJavaConverter<OffsetTime, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(OffsetTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<OffsetTime, TIMESTAMPLTZ>(){

            @Override
            protected TIMESTAMPLTZ convert(OffsetTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPLTZ((Connection)conn, src);
            }
        });
        CONVERTERS.put(new Key(OffsetTime.class, TIMESTAMPTZ.class), new JavaToJavaConverter<OffsetTime, TIMESTAMPTZ>(){

            @Override
            protected TIMESTAMPTZ convert(OffsetTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPTZ(src);
            }
        });
        CONVERTERS.put(new Key(OracleBfile.class, InputStream.class), new JavaToJavaConverter<OracleBfile, InputStream>(){

            @Override
            protected InputStream convert(OracleBfile src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.binaryStreamValue();
            }
        });
        CONVERTERS.put(new Key(OracleBfile.class, Reader.class), new JavaToJavaConverter<OracleBfile, Reader>(){

            @Override
            protected Reader convert(OracleBfile src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.characterStreamValue();
            }
        });
        CONVERTERS.put(new Key(OracleBlob.class, InputStream.class), new JavaToJavaConverter<OracleBlob, InputStream>(){

            @Override
            protected InputStream convert(OracleBlob src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getBinaryStream();
            }
        });
        CONVERTERS.put(new Key(OracleBlob.class, Reader.class), new JavaToJavaConverter<OracleBlob, Reader>(){

            @Override
            protected Reader convert(OracleBlob src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return ((BLOB)src).characterStreamValue();
            }
        });
        CONVERTERS.put(new Key(OracleClob.class, InputStream.class), new JavaToJavaConverter<OracleClob, InputStream>(){

            @Override
            protected InputStream convert(OracleClob src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.binaryStreamValue();
            }
        });
        CONVERTERS.put(new Key(OracleClob.class, Reader.class), new JavaToJavaConverter<OracleClob, Reader>(){

            @Override
            protected Reader convert(OracleClob src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getCharacterStream();
            }
        });
        CONVERTERS.put(new Key(OracleClob.class, String.class), new JavaToJavaConverter<OracleClob, String>(){

            @Override
            protected String convert(OracleClob src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue();
            }
        });
        CONVERTERS.put(new Key(OracleJsonBinary.class, byte[].class), new JavaToJavaConverter<OracleJsonBinary, byte[]>(){

            @Override
            protected byte[] convert(OracleJsonBinary src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return (byte[])src.getBytes().clone();
            }
        });
        CONVERTERS.put(new Key(OracleJsonBinary.class, InputStream.class), new JavaToJavaConverter<OracleJsonBinary, InputStream>(){

            @Override
            protected InputStream convert(OracleJsonBinary src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                ByteArrayInputStream binaryStream = new ByteArrayInputStream(src.getBytes());
                return targetExtra instanceof DBConversion ? ((DBConversion)targetExtra).ConvertStream(binaryStream, 2, conn) : binaryStream;
            }
        });
        CONVERTERS.put(new Key(OracleJsonBinary.class, Reader.class), new JavaToJavaConverter<OracleJsonBinary, Reader>(){

            @Override
            protected Reader convert(OracleJsonBinary src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return RawCommonAccessor.byteArrayToReader(src.getBytes());
            }
        });
        CONVERTERS.put(new Key(OracleJsonBinary.class, String.class), new JavaToJavaConverter<OracleJsonBinary, String>(){

            @Override
            protected String convert(OracleJsonBinary src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] bytes = src.getBytes();
                return bytes.length == 0 ? null : RepConversion.bArray2String(bytes);
            }
        });
        JavaToJavaConverter.mapAssignableType(OracleJsonBinary.class, OracleJsonBinaryImpl.class);
        CONVERTERS.put(new Key(OracleJsonDate.class, Calendar.class), new JavaToJavaConverter<OracleJsonDate, Calendar>(){

            @Override
            protected Calendar convert(OracleJsonDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar calendar = JavaToJavaConverter.getCalendarOrDefault(srcExtra, conn);
                byte[] encodedDate = src.getDATE().shareBytes();
                DateTimeCommonAccessor.decodeCalendar(encodedDate, encodedDate.length, calendar);
                return calendar;
            }
        });
        CONVERTERS.put(new Key(OracleJsonDate.class, java.sql.Date.class), new JavaToJavaConverter<OracleJsonDate, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(OracleJsonDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return DateTimeCommonAccessor.decodeDate(src.getDATE().shareBytes(), JavaToJavaConverter.getCalendarOrDefault(srcExtra, conn));
            }
        });
        CONVERTERS.put(new Key(OracleJsonDate.class, LocalDateTime.class), new JavaToJavaConverter<OracleJsonDate, LocalDateTime>(){

            @Override
            protected LocalDateTime convert(OracleJsonDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getLocalDateTime();
            }
        });
        CONVERTERS.put(new Key(OracleJsonDate.class, LocalDate.class), new JavaToJavaConverter<OracleJsonDate, LocalDate>(){

            @Override
            protected LocalDate convert(OracleJsonDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getDATE().localDateValue();
            }
        });
        CONVERTERS.put(new Key(OracleJsonDate.class, LocalTime.class), new JavaToJavaConverter<OracleJsonDate, LocalTime>(){

            @Override
            protected LocalTime convert(OracleJsonDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getDATE().localTimeValue();
            }
        });
        CONVERTERS.put(new Key(OracleJsonDate.class, String.class), new JavaToJavaConverter<OracleJsonDate, String>(){

            @Override
            protected String convert(OracleJsonDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] encodedDate = src.getDATE().shareBytes();
                return DateAccessor.timestampToString(DateTimeCommonAccessor.decodeTimestamp(encodedDate, encodedDate.length, JavaToJavaConverter.getCalendarOrDefault(srcExtra, conn)));
            }
        });
        CONVERTERS.put(new Key(OracleJsonDate.class, Time.class), new JavaToJavaConverter<OracleJsonDate, Time>(){

            @Override
            protected Time convert(OracleJsonDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                if (srcExtra instanceof Calendar) {
                    return DateTimeCommonAccessor.decodeTime(src.getDATE().shareBytes(), (Calendar)srcExtra);
                }
                return DateTimeCommonAccessor.decodeTime(src.getDATE().shareBytes(), JavaToJavaConverter.getTimeZoneOrDefault(srcExtra, conn));
            }
        });
        CONVERTERS.put(new Key(OracleJsonDate.class, Timestamp.class), new JavaToJavaConverter<OracleJsonDate, Timestamp>(){

            @Override
            protected Timestamp convert(OracleJsonDate src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] encodedDate = src.getDATE().shareBytes();
                return DateTimeCommonAccessor.decodeTimestamp(encodedDate, encodedDate.length, JavaToJavaConverter.getCalendarOrDefault(srcExtra, conn));
            }
        });
        JavaToJavaConverter.mapAssignableType(OracleJsonDate.class, OracleJsonDateImpl.class);
        CONVERTERS.put(new Key(OracleJsonDecimal.class, BigDecimal.class), new JavaToJavaConverter<OracleJsonDecimal, BigDecimal>(){

            @Override
            protected BigDecimal convert(OracleJsonDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] numberEncoding = src.getNUMBER().shareBytes();
                return NumberCommonAccessor.decodeBigDecimal(numberEncoding, numberEncoding.length, conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonDecimal.class, BigInteger.class), new JavaToJavaConverter<OracleJsonDecimal, BigInteger>(){

            @Override
            protected BigInteger convert(OracleJsonDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] numberEncoding = src.getNUMBER().shareBytes();
                return NumberCommonAccessor.decodeBigDecimal(numberEncoding, numberEncoding.length, conn == null ? null : conn.getConnectionDuringExceptionHandling()).toBigInteger();
            }
        });
        CONVERTERS.put(new Key(OracleJsonDecimal.class, Boolean.class), new JavaToJavaConverter<OracleJsonDecimal, Boolean>(){

            @Override
            protected Boolean convert(OracleJsonDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] numberEncoding = src.getNUMBER().shareBytes();
                return NumberCommonAccessor.decodeBoolean(numberEncoding, numberEncoding.length);
            }
        });
        CONVERTERS.put(new Key(OracleJsonDecimal.class, Byte.class), new JavaToJavaConverter<OracleJsonDecimal, Byte>(){

            @Override
            protected Byte convert(OracleJsonDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] numberEncoding = src.getNUMBER().shareBytes();
                return NumberCommonAccessor.decodeByte(numberEncoding, numberEncoding.length, conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonDecimal.class, Double.class), new JavaToJavaConverter<OracleJsonDecimal, Double>(){

            @Override
            protected Double convert(OracleJsonDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] numberEncoding = src.getNUMBER().shareBytes();
                return NumberCommonAccessor.decodeDouble(numberEncoding, numberEncoding.length);
            }
        });
        CONVERTERS.put(new Key(OracleJsonDecimal.class, Float.class), new JavaToJavaConverter<OracleJsonDecimal, Float>(){

            @Override
            protected Float convert(OracleJsonDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] numberEncoding = src.getNUMBER().shareBytes();
                return Float.valueOf(NumberCommonAccessor.decodeFloat(numberEncoding, numberEncoding.length));
            }
        });
        CONVERTERS.put(new Key(OracleJsonDecimal.class, Integer.class), new JavaToJavaConverter<OracleJsonDecimal, Integer>(){

            @Override
            protected Integer convert(OracleJsonDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] numberEncoding = src.getNUMBER().shareBytes();
                return NumberCommonAccessor.decodeInt(numberEncoding, numberEncoding.length, conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonDecimal.class, Long.class), new JavaToJavaConverter<OracleJsonDecimal, Long>(){

            @Override
            protected Long convert(OracleJsonDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] numberEncoding = src.getNUMBER().shareBytes();
                return NumberCommonAccessor.decodeLong(numberEncoding, numberEncoding.length, conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonDecimal.class, Short.class), new JavaToJavaConverter<OracleJsonDecimal, Short>(){

            @Override
            protected Short convert(OracleJsonDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] numberEncoding = src.getNUMBER().shareBytes();
                return NumberCommonAccessor.decodeShort(numberEncoding, numberEncoding.length, conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonDecimal.class, String.class), new JavaToJavaConverter<OracleJsonDecimal, String>(){

            @Override
            protected String convert(OracleJsonDecimal src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] numberEncoding = src.getNUMBER().shareBytes();
                return NumberCommonAccessor.decodeString(numberEncoding, numberEncoding.length);
            }
        });
        JavaToJavaConverter.mapAssignableType(OracleJsonDecimal.class, OracleJsonDecimalImpl.class);
        CONVERTERS.put(new Key(OracleJsonDouble.class, BigDecimal.class), new JavaToJavaConverter<OracleJsonDouble, BigDecimal>(){

            @Override
            protected BigDecimal convert(OracleJsonDouble src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryDoubleAccessor.doubleToBigDecimal(src.doubleValue());
            }
        });
        CONVERTERS.put(new Key(OracleJsonDouble.class, Boolean.class), new JavaToJavaConverter<OracleJsonDouble, Boolean>(){

            @Override
            protected Boolean convert(OracleJsonDouble src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryDoubleAccessor.doubleToBoolean(src.doubleValue());
            }
        });
        CONVERTERS.put(new Key(OracleJsonDouble.class, Byte.class), new JavaToJavaConverter<OracleJsonDouble, Byte>(){

            @Override
            protected Byte convert(OracleJsonDouble src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryDoubleAccessor.doubleToByte(src.doubleValue(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonDouble.class, Double.class), new JavaToJavaConverter<OracleJsonDouble, Double>(){

            @Override
            protected Double convert(OracleJsonDouble src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.doubleValue();
            }
        });
        CONVERTERS.put(new Key(OracleJsonDouble.class, Float.class), new JavaToJavaConverter<OracleJsonDouble, Float>(){

            @Override
            protected Float convert(OracleJsonDouble src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Float.valueOf(BinaryDoubleAccessor.doubleToFloat(src.doubleValue()));
            }
        });
        CONVERTERS.put(new Key(OracleJsonDouble.class, Integer.class), new JavaToJavaConverter<OracleJsonDouble, Integer>(){

            @Override
            protected Integer convert(OracleJsonDouble src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryDoubleAccessor.doubleToInt(src.doubleValue(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonDouble.class, Long.class), new JavaToJavaConverter<OracleJsonDouble, Long>(){

            @Override
            protected Long convert(OracleJsonDouble src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryDoubleAccessor.doubleToLong(src.doubleValue());
            }
        });
        CONVERTERS.put(new Key(OracleJsonDouble.class, Short.class), new JavaToJavaConverter<OracleJsonDouble, Short>(){

            @Override
            protected Short convert(OracleJsonDouble src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryDoubleAccessor.doubleToShort(src.doubleValue(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonDouble.class, String.class), new JavaToJavaConverter<OracleJsonDouble, String>(){

            @Override
            protected String convert(OracleJsonDouble src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryDoubleAccessor.doubleToString(src.doubleValue());
            }
        });
        JavaToJavaConverter.mapAssignableType(OracleJsonDouble.class, OracleJsonDoubleImpl.class);
        CONVERTERS.put(new Key(OracleJsonFloat.class, BigDecimal.class), new JavaToJavaConverter<OracleJsonFloat, BigDecimal>(){

            @Override
            protected BigDecimal convert(OracleJsonFloat src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryFloatAccessor.floatToBigDecimal(src.floatValue());
            }
        });
        CONVERTERS.put(new Key(OracleJsonFloat.class, Boolean.class), new JavaToJavaConverter<OracleJsonFloat, Boolean>(){

            @Override
            protected Boolean convert(OracleJsonFloat src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryFloatAccessor.floatToBoolean(src.floatValue());
            }
        });
        CONVERTERS.put(new Key(OracleJsonFloat.class, Byte.class), new JavaToJavaConverter<OracleJsonFloat, Byte>(){

            @Override
            protected Byte convert(OracleJsonFloat src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryFloatAccessor.floatToByte(src.floatValue(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonFloat.class, Double.class), new JavaToJavaConverter<OracleJsonFloat, Double>(){

            @Override
            protected Double convert(OracleJsonFloat src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryFloatAccessor.floatToDouble(src.floatValue());
            }
        });
        CONVERTERS.put(new Key(OracleJsonFloat.class, Float.class), new JavaToJavaConverter<OracleJsonFloat, Float>(){

            @Override
            protected Float convert(OracleJsonFloat src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Float.valueOf(src.floatValue());
            }
        });
        CONVERTERS.put(new Key(OracleJsonFloat.class, Integer.class), new JavaToJavaConverter<OracleJsonFloat, Integer>(){

            @Override
            protected Integer convert(OracleJsonFloat src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryFloatAccessor.floatToInt(src.floatValue(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonFloat.class, Long.class), new JavaToJavaConverter<OracleJsonFloat, Long>(){

            @Override
            protected Long convert(OracleJsonFloat src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryFloatAccessor.floatToLong(src.floatValue());
            }
        });
        CONVERTERS.put(new Key(OracleJsonFloat.class, Short.class), new JavaToJavaConverter<OracleJsonFloat, Short>(){

            @Override
            protected Short convert(OracleJsonFloat src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryFloatAccessor.floatToShort(src.floatValue(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonFloat.class, String.class), new JavaToJavaConverter<OracleJsonFloat, String>(){

            @Override
            protected String convert(OracleJsonFloat src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BinaryFloatAccessor.floatToString(src.floatValue());
            }
        });
        JavaToJavaConverter.mapAssignableType(OracleJsonFloat.class, OracleJsonFloatImpl.class);
        CONVERTERS.put(new Key(OracleJsonString.class, BigDecimal.class), new JavaToJavaConverter<OracleJsonString, BigDecimal>(){

            @Override
            protected BigDecimal convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToBigDecimal(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, BigInteger.class), new JavaToJavaConverter<OracleJsonString, BigInteger>(){

            @Override
            protected BigInteger convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToBigDecimal(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling()).toBigInteger();
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, Boolean.class), new JavaToJavaConverter<OracleJsonString, Boolean>(){

            @Override
            protected Boolean convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToBoolean(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, Byte.class), new JavaToJavaConverter<OracleJsonString, Byte>(){

            @Override
            protected Byte convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToByte(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, java.sql.Date.class), new JavaToJavaConverter<OracleJsonString, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToDate(src.getString(), JavaToJavaConverter.getCalendarOrDefault(srcExtra, conn), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, Double.class), new JavaToJavaConverter<OracleJsonString, Double>(){

            @Override
            protected Double convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToDouble(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, Float.class), new JavaToJavaConverter<OracleJsonString, Float>(){

            @Override
            protected Float convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Float.valueOf(CharCommonAccessor.stringToFloat(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling()));
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, InputStream.class), new JavaToJavaConverter<OracleJsonString, InputStream>(){

            @Override
            protected InputStream convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                if (targetExtra instanceof DBConversion) {
                    char[] chars = src.getString().toCharArray();
                    return CharCommonAccessor.charsToAsciiStream(chars, 0, chars.length, (DBConversion)targetExtra, conn);
                }
                return new ByteArrayInputStream(src.getString().getBytes(StandardCharsets.UTF_8));
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, Integer.class), new JavaToJavaConverter<OracleJsonString, Integer>(){

            @Override
            protected Integer convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToInt(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, LocalDate.class), new JavaToJavaConverter<OracleJsonString, LocalDate>(){

            @Override
            protected LocalDate convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.parseLocalDate(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, LocalDateTime.class), new JavaToJavaConverter<OracleJsonString, LocalDateTime>(){

            @Override
            protected LocalDateTime convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.parseLocalDateTime(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, LocalTime.class), new JavaToJavaConverter<OracleJsonString, LocalTime>(){

            @Override
            protected LocalTime convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.parseLocalTime(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, Long.class), new JavaToJavaConverter<OracleJsonString, Long>(){

            @Override
            protected Long convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToLong(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, OffsetDateTime.class), new JavaToJavaConverter<OracleJsonString, OffsetDateTime>(){

            @Override
            protected OffsetDateTime convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.parseOffsetDateTime(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, OffsetTime.class), new JavaToJavaConverter<OracleJsonString, OffsetTime>(){

            @Override
            protected OffsetTime convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.parseOffsetTime(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, Reader.class), new JavaToJavaConverter<OracleJsonString, Reader>(){

            @Override
            protected Reader convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToReader(src.getString());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, Short.class), new JavaToJavaConverter<OracleJsonString, Short>(){

            @Override
            protected Short convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToShort(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, String.class), new JavaToJavaConverter<OracleJsonString, String>(){

            @Override
            protected String convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getString();
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, Time.class), new JavaToJavaConverter<OracleJsonString, Time>(){

            @Override
            protected Time convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToTime(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, Timestamp.class), new JavaToJavaConverter<OracleJsonString, Timestamp>(){

            @Override
            protected Timestamp convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToTimestamp(src.getString(), JavaToJavaConverter.getCalendarOrDefault(srcExtra, conn), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        CONVERTERS.put(new Key(OracleJsonString.class, ZonedDateTime.class), new JavaToJavaConverter<OracleJsonString, ZonedDateTime>(){

            @Override
            protected ZonedDateTime convert(OracleJsonString src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.parseZonedDateTime(src.getString(), conn == null ? null : conn.getConnectionDuringExceptionHandling());
            }
        });
        JavaToJavaConverter.mapAssignableType(OracleJsonString.class, OracleJsonStringImpl.class);
        CONVERTERS.put(new Key(OracleJsonTimestamp.class, Calendar.class), new JavaToJavaConverter<OracleJsonTimestamp, Calendar>(){

            @Override
            protected Calendar convert(OracleJsonTimestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar calendar = JavaToJavaConverter.getCalendarOrDefault(srcExtra, conn);
                byte[] encodedTimestamp = src.getTIMESTAMP().shareBytes();
                DateTimeCommonAccessor.decodeCalendar(encodedTimestamp, encodedTimestamp.length, calendar);
                return calendar;
            }
        });
        CONVERTERS.put(new Key(OracleJsonTimestamp.class, java.sql.Date.class), new JavaToJavaConverter<OracleJsonTimestamp, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(OracleJsonTimestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return DateTimeCommonAccessor.decodeDate(src.getTIMESTAMP().shareBytes(), JavaToJavaConverter.getCalendarOrDefault(srcExtra, conn));
            }
        });
        CONVERTERS.put(new Key(OracleJsonTimestamp.class, LocalDate.class), new JavaToJavaConverter<OracleJsonTimestamp, LocalDate>(){

            @Override
            protected LocalDate convert(OracleJsonTimestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getTIMESTAMP().localDateValue();
            }
        });
        CONVERTERS.put(new Key(OracleJsonTimestamp.class, LocalDateTime.class), new JavaToJavaConverter<OracleJsonTimestamp, LocalDateTime>(){

            @Override
            protected LocalDateTime convert(OracleJsonTimestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getTIMESTAMP().localDateTimeValue();
            }
        });
        CONVERTERS.put(new Key(OracleJsonTimestamp.class, LocalTime.class), new JavaToJavaConverter<OracleJsonTimestamp, LocalTime>(){

            @Override
            protected LocalTime convert(OracleJsonTimestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getTIMESTAMP().localTimeValue();
            }
        });
        CONVERTERS.put(new Key(OracleJsonTimestamp.class, String.class), new JavaToJavaConverter<OracleJsonTimestamp, String>(){

            @Override
            protected String convert(OracleJsonTimestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] encodedDate = src.getTIMESTAMP().shareBytes();
                return TIMESTAMPTZ.toString(DateTimeCommonAccessor.oracleYear(encodedDate), DateTimeCommonAccessor.oracleMonth(encodedDate) + 1, DateTimeCommonAccessor.oracleDay(encodedDate), DateTimeCommonAccessor.oracleHour(encodedDate), DateTimeCommonAccessor.oracleMin(encodedDate), DateTimeCommonAccessor.oracleSec(encodedDate), encodedDate.length == 11 ? DateTimeCommonAccessor.oracleNanos(encodedDate) : -1, null);
            }
        });
        CONVERTERS.put(new Key(OracleJsonTimestamp.class, Time.class), new JavaToJavaConverter<OracleJsonTimestamp, Time>(){

            @Override
            protected Time convert(OracleJsonTimestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                if (srcExtra instanceof Calendar) {
                    return DateTimeCommonAccessor.decodeTime(src.getTIMESTAMP().shareBytes(), (Calendar)srcExtra);
                }
                return DateTimeCommonAccessor.decodeTime(src.getTIMESTAMP().shareBytes(), JavaToJavaConverter.getTimeZoneOrDefault(srcExtra, conn));
            }
        });
        CONVERTERS.put(new Key(OracleJsonTimestamp.class, Timestamp.class), new JavaToJavaConverter<OracleJsonTimestamp, Timestamp>(){

            @Override
            protected Timestamp convert(OracleJsonTimestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                byte[] encodedDate = src.getTIMESTAMP().shareBytes();
                return DateTimeCommonAccessor.decodeTimestamp(encodedDate, encodedDate.length, JavaToJavaConverter.getCalendarOrDefault(srcExtra, conn));
            }
        });
        JavaToJavaConverter.mapAssignableType(OracleJsonTimestamp.class, OracleJsonTimestampImpl.class);
        CONVERTERS.put(new Key(OracleJsonValue.FALSE.getClass(), Byte.class), new JavaToJavaConverter<OracleJsonValue, Byte>(){

            @Override
            protected Byte convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return (byte)0;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.FALSE.getClass(), Short.class), new JavaToJavaConverter<OracleJsonValue, Short>(){

            @Override
            protected Short convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return (short)0;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.FALSE.getClass(), Integer.class), new JavaToJavaConverter<OracleJsonValue, Integer>(){

            @Override
            protected Integer convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return 0;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.FALSE.getClass(), Long.class), new JavaToJavaConverter<OracleJsonValue, Long>(){

            @Override
            protected Long convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return 0L;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.FALSE.getClass(), Float.class), new JavaToJavaConverter<OracleJsonValue, Float>(){

            @Override
            protected Float convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Float.valueOf(0.0f);
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.FALSE.getClass(), Double.class), new JavaToJavaConverter<OracleJsonValue, Double>(){

            @Override
            protected Double convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return 0.0;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.FALSE.getClass(), BigDecimal.class), new JavaToJavaConverter<OracleJsonValue, BigDecimal>(){

            @Override
            protected BigDecimal convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BigDecimal.ZERO;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.FALSE.getClass(), Boolean.class), new JavaToJavaConverter<OracleJsonValue, Boolean>(){

            @Override
            protected Boolean convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return false;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.FALSE.getClass(), String.class), new JavaToJavaConverter<OracleJsonValue, String>(){

            @Override
            protected String convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return "false";
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.TRUE.getClass(), Byte.class), new JavaToJavaConverter<OracleJsonValue, Byte>(){

            @Override
            protected Byte convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return (byte)1;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.TRUE.getClass(), Short.class), new JavaToJavaConverter<OracleJsonValue, Short>(){

            @Override
            protected Short convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return (short)1;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.TRUE.getClass(), Integer.class), new JavaToJavaConverter<OracleJsonValue, Integer>(){

            @Override
            protected Integer convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return 1;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.TRUE.getClass(), Long.class), new JavaToJavaConverter<OracleJsonValue, Long>(){

            @Override
            protected Long convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return 1L;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.TRUE.getClass(), Float.class), new JavaToJavaConverter<OracleJsonValue, Float>(){

            @Override
            protected Float convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Float.valueOf(1.0f);
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.TRUE.getClass(), Double.class), new JavaToJavaConverter<OracleJsonValue, Double>(){

            @Override
            protected Double convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return 1.0;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.TRUE.getClass(), BigDecimal.class), new JavaToJavaConverter<OracleJsonValue, BigDecimal>(){

            @Override
            protected BigDecimal convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return BigDecimal.ONE;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.TRUE.getClass(), Boolean.class), new JavaToJavaConverter<OracleJsonValue, Boolean>(){

            @Override
            protected Boolean convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return true;
            }
        });
        CONVERTERS.put(new Key(OracleJsonValue.TRUE.getClass(), String.class), new JavaToJavaConverter<OracleJsonValue, String>(){

            @Override
            protected String convert(OracleJsonValue src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return "true";
            }
        });
        CONVERTERS.put(new Key(OracleNClob.class, InputStream.class), new JavaToJavaConverter<OracleNClob, InputStream>(){

            @Override
            protected InputStream convert(OracleNClob src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.binaryStreamValue();
            }
        });
        CONVERTERS.put(new Key(OracleNClob.class, Reader.class), new JavaToJavaConverter<OracleNClob, Reader>(){

            @Override
            protected Reader convert(OracleNClob src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getCharacterStream();
            }
        });
        CONVERTERS.put(new Key(OracleNClob.class, String.class), new JavaToJavaConverter<OracleNClob, String>(){

            @Override
            protected String convert(OracleNClob src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue();
            }
        });
        CONVERTERS.put(new Key(OracleOpaque.class, byte[].class), new JavaToJavaConverter<OracleOpaque, byte[]>(){

            @Override
            protected byte[] convert(OracleOpaque src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getBytes();
            }
        });
        CONVERTERS.put(new Key(Period.class, INTERVALYM.class), new JavaToJavaConverter<Period, INTERVALYM>(){

            @Override
            protected INTERVALYM convert(Period src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                if (src.getDays() > 0) {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)conn, 132, src.getClass().getName() + " to " + Period.class.getName()).fillInStackTrace();
                }
                int y = src.getYears();
                int m = src.getMonths();
                byte[] bytes = new byte[]{(byte)((y += INTYMYEAROFFSET) >> 24 & 0xFF), (byte)(y >> 16 & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(m + INTYMMONTHOFFSET)};
                return new INTERVALYM(bytes);
            }
        });
        CONVERTERS.put(new Key(Period.class, String.class), new JavaToJavaConverter<Period, String>(){

            @Override
            protected String convert(Period src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                if (src.getDays() > 0) {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)conn, 132, src.getClass().getName() + " to " + String.class.getName()).fillInStackTrace();
                }
                int y = src.getYears();
                int m = src.getMonths();
                if (Math.signum(y) != Math.signum(m)) {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)conn, 132, src.getClass().getName() + " to " + String.class.getName()).fillInStackTrace();
                }
                String sign = "";
                if (y < 0) {
                    y = Math.abs(y);
                    m = Math.abs(m);
                    sign = "-";
                }
                return sign + y + "-" + m;
            }
        });
        CONVERTERS.put(new Key(RAW.class, byte[].class), new JavaToJavaConverter<RAW, byte[]>(){

            @Override
            protected byte[] convert(RAW src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.getBytes();
            }
        });
        CONVERTERS.put(new Key(RAW.class, InputStream.class), new JavaToJavaConverter<RAW, InputStream>(){

            @Override
            protected InputStream convert(RAW src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.binaryStreamValue();
            }
        });
        CONVERTERS.put(new Key(RAW.class, Reader.class), new JavaToJavaConverter<RAW, Reader>(){

            @Override
            protected Reader convert(RAW src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.characterStreamValue();
            }
        });
        CONVERTERS.put(new Key(RAW.class, String.class), new JavaToJavaConverter<RAW, String>(){

            @Override
            protected String convert(RAW src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue();
            }
        });
        CONVERTERS.put(new Key(Reader.class, CLOB.class), new JavaToJavaConverter<Reader, CLOB>(){

            @Override
            protected CLOB convert(Reader src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                int c;
                CLOB result = (CLOB)((Object)conn.createNClob());
                Writer w = result.setCharacterStream(1L);
                long max = Long.MAX_VALUE;
                if (srcExtra != null && srcExtra instanceof Number) {
                    max = ((Number)srcExtra).longValue();
                }
                for (long i = 0L; i < max && (c = src.read()) != -1; ++i) {
                    w.write(c);
                }
                w.close();
                return result;
            }
        });
        CONVERTERS.put(new Key(Reader.class, NCLOB.class), new JavaToJavaConverter<Reader, NCLOB>(){

            @Override
            protected NCLOB convert(Reader src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                int c;
                NCLOB result = (NCLOB)conn.createNClob();
                Writer w = result.setCharacterStream(1L);
                long max = Long.MAX_VALUE;
                if (srcExtra != null && srcExtra instanceof Number) {
                    max = ((Number)srcExtra).longValue();
                }
                for (long i = 0L; i < max && (c = src.read()) != -1; ++i) {
                    w.write(c);
                }
                w.close();
                return result;
            }
        });
        CONVERTERS.put(new Key(Reader.class, String.class), new JavaToJavaConverter<Reader, String>(){

            @Override
            protected String convert(Reader src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                int c;
                StringBuilder b = new StringBuilder();
                long max = Long.MAX_VALUE;
                if (srcExtra != null && srcExtra instanceof Number) {
                    max = ((Number)srcExtra).longValue();
                }
                int i = 0;
                while ((long)i < max && (c = src.read()) != -1) {
                    b.appendCodePoint(c);
                    ++i;
                }
                return b.toString();
            }
        });
        CONVERTERS.put(new Key(RowId.class, String.class), new JavaToJavaConverter<RowId, String>(){

            @Override
            protected String convert(RowId src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toString();
            }
        });
        CONVERTERS.put(new Key(Short.class, NUMBER.class), new JavaToJavaConverter<Short, NUMBER>(){

            @Override
            protected NUMBER convert(Short src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return JDBCType.BIT == targetExtra ? new NUMBER(src == 0 ? 0 : 1) : new NUMBER(src);
            }
        });
        CONVERTERS.put(new Key(SQLXML.class, String.class), new JavaToJavaConverter<SQLXML, String>(){

            @Override
            protected String convert(SQLXML src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toString();
            }
        });
        CONVERTERS.put(new Key(String.class, BigDecimal.class), new JavaToJavaConverter<String, BigDecimal>(){

            @Override
            protected BigDecimal convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new BigDecimal(src);
            }
        });
        CONVERTERS.put(new Key(String.class, BigInteger.class), new JavaToJavaConverter<String, BigInteger>(){

            @Override
            protected BigInteger convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new BigInteger(src);
            }
        });
        CONVERTERS.put(new Key(String.class, BINARY_DOUBLE.class), new JavaToJavaConverter<String, BINARY_DOUBLE>(){

            @Override
            protected BINARY_DOUBLE convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new BINARY_DOUBLE(src);
            }
        });
        CONVERTERS.put(new Key(String.class, BINARY_FLOAT.class), new JavaToJavaConverter<String, BINARY_FLOAT>(){

            @Override
            protected BINARY_FLOAT convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new BINARY_FLOAT(src);
            }
        });
        CONVERTERS.put(new Key(String.class, Boolean.class), new JavaToJavaConverter<String, Boolean>(){

            @Override
            protected Boolean convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return CharCommonAccessor.stringToBoolean(src, conn);
            }
        });
        CONVERTERS.put(new Key(String.class, Byte.class), new JavaToJavaConverter<String, Byte>(){

            @Override
            protected Byte convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Byte(src);
            }
        });
        CONVERTERS.put(new Key(String.class, byte[].class), new JavaToJavaConverter<String, byte[]>(){

            @Override
            protected byte[] convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return srcExtra instanceof Charset ? src.getBytes((Charset)srcExtra) : src.getBytes();
            }
        });
        CONVERTERS.put(new Key(String.class, Calendar.class), new JavaToJavaConverter<String, Calendar>(){

            @Override
            protected Calendar convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar cal = Calendar.getInstance();
                cal.setTime(DateFormat.getInstance().parse(src));
                return cal;
            }
        });
        CONVERTERS.put(new Key(String.class, java.sql.Date.class), new JavaToJavaConverter<String, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new java.sql.Date(DateFormat.getInstance().parse(src).getTime());
            }
        });
        CONVERTERS.put(new Key(String.class, Date.class), new JavaToJavaConverter<String, Date>(){

            @Override
            protected Date convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return DateFormat.getInstance().parse(src);
            }
        });
        CONVERTERS.put(new Key(String.class, DATE.class), new JavaToJavaConverter<String, DATE>(){

            @Override
            protected DATE convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return targetExtra == JDBCType.DATE ? new DATE(java.sql.Date.valueOf(src)) : (targetExtra == JDBCType.TIME ? new DATE(Time.valueOf(src)) : new DATE(src));
            }
        });
        CONVERTERS.put(new Key(String.class, Double.class), new JavaToJavaConverter<String, Double>(){

            @Override
            protected Double convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Double(src);
            }
        });
        CONVERTERS.put(new Key(String.class, Float.class), new JavaToJavaConverter<String, Float>(){

            @Override
            protected Float convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Float(src);
            }
        });
        CONVERTERS.put(new Key(String.class, InputStream.class), new JavaToJavaConverter<String, InputStream>(){

            @Override
            protected InputStream convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new ByteArrayInputStream(src.getBytes());
            }
        });
        CONVERTERS.put(new Key(String.class, Integer.class), new JavaToJavaConverter<String, Integer>(){

            @Override
            protected Integer convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Integer(src);
            }
        });
        CONVERTERS.put(new Key(String.class, LocalDateTime.class), new JavaToJavaConverter<String, LocalDateTime>(){

            @Override
            protected LocalDateTime convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return LocalDateTime.parse(src);
            }
        });
        CONVERTERS.put(new Key(String.class, Long.class), new JavaToJavaConverter<String, Long>(){

            @Override
            protected Long convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Long(src);
            }
        });
        CONVERTERS.put(new Key(String.class, NUMBER.class), new JavaToJavaConverter<String, NUMBER>(){

            @Override
            protected NUMBER convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                if (targetExtra == JDBCType.BIT) {
                    if ("1".equals(src) || "true".equalsIgnoreCase(src)) {
                        return new NUMBER(1);
                    }
                    return new NUMBER(0);
                }
                return new NUMBER(new BigDecimal(src));
            }
        });
        CONVERTERS.put(new Key(String.class, Reader.class), new JavaToJavaConverter<String, Reader>(){

            @Override
            protected Reader convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new StringReader(src);
            }
        });
        CONVERTERS.put(new Key(String.class, Short.class), new JavaToJavaConverter<String, Short>(){

            @Override
            protected Short convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Short(src);
            }
        });
        CONVERTERS.put(new Key(String.class, Time.class), new JavaToJavaConverter<String, Time>(){

            @Override
            protected Time convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Time(DateFormat.getInstance().parse(src).getTime());
            }
        });
        CONVERTERS.put(new Key(String.class, Timestamp.class), new JavaToJavaConverter<String, Timestamp>(){

            @Override
            protected Timestamp convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Timestamp(DateFormat.getInstance().parse(src).getTime());
            }
        });
        CONVERTERS.put(new Key(String.class, TIMESTAMP.class), new JavaToJavaConverter<String, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(String.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<String, TIMESTAMPLTZ>(){

            @Override
            protected TIMESTAMPLTZ convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPLTZ((Connection)conn, src);
            }
        });
        CONVERTERS.put(new Key(String.class, TIMESTAMPTZ.class), new JavaToJavaConverter<String, TIMESTAMPTZ>(){

            @Override
            protected TIMESTAMPTZ convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPTZ((Connection)conn, src);
            }
        });
        CONVERTERS.put(new Key(String.class, URL.class), new JavaToJavaConverter<String, URL>(){

            @Override
            protected URL convert(String src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new URL(src);
            }
        });
        CONVERTERS.put(new Key(Time.class, Calendar.class), new JavaToJavaConverter<Time, Calendar>(){

            @Override
            protected Calendar convert(Time src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar cal = Calendar.getInstance();
                cal.setTime(new java.sql.Date(src.getTime()));
                return cal;
            }
        });
        CONVERTERS.put(new Key(Time.class, java.sql.Date.class), new JavaToJavaConverter<Time, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(Time src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new java.sql.Date(src.getTime());
            }
        });
        CONVERTERS.put(new Key(Time.class, Date.class), new JavaToJavaConverter<Time, Date>(){

            @Override
            protected Date convert(Time src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Date(src.getTime());
            }
        });
        CONVERTERS.put(new Key(Time.class, DATE.class), new JavaToJavaConverter<Time, DATE>(){

            @Override
            protected DATE convert(Time src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(new java.sql.Date(src.getTime()));
            }
        });
        CONVERTERS.put(new Key(Time.class, String.class), new JavaToJavaConverter<Time, String>(){

            @Override
            protected String convert(Time src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toString();
            }
        });
        CONVERTERS.put(new Key(Time.class, Timestamp.class), new JavaToJavaConverter<Time, Timestamp>(){

            @Override
            protected Timestamp convert(Time src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Timestamp(src.getTime());
            }
        });
        CONVERTERS.put(new Key(Time.class, TIMESTAMP.class), new JavaToJavaConverter<Time, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(Time src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(Time.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<Time, TIMESTAMPLTZ>(){

            @Override
            protected TIMESTAMPLTZ convert(Time src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPLTZ((Connection)conn, src);
            }
        });
        CONVERTERS.put(new Key(Time.class, TIMESTAMPTZ.class), new JavaToJavaConverter<Time, TIMESTAMPTZ>(){

            @Override
            protected TIMESTAMPTZ convert(Time src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPTZ((Connection)conn, src);
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, Calendar.class), new JavaToJavaConverter<Timestamp, Calendar>(){

            @Override
            protected Calendar convert(Timestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Timestamp(src.getTime()));
                return cal;
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, java.sql.Date.class), new JavaToJavaConverter<Timestamp, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(Timestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new java.sql.Date(src.getTime());
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, Date.class), new JavaToJavaConverter<Timestamp, Date>(){

            @Override
            protected Date convert(Timestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Date(src.getTime());
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, DATE.class), new JavaToJavaConverter<Timestamp, DATE>(){

            @Override
            protected DATE convert(Timestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(src);
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, String.class), new JavaToJavaConverter<Timestamp, String>(){

            @Override
            protected String convert(Timestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toString();
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, Time.class), new JavaToJavaConverter<Timestamp, Time>(){

            @Override
            protected Time convert(Timestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Time(src.getTime());
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, TIMESTAMP.class), new JavaToJavaConverter<Timestamp, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(Timestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<Timestamp, TIMESTAMPLTZ>(){

            @Override
            protected TIMESTAMPLTZ convert(Timestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPLTZ((Connection)conn, src);
            }
        });
        CONVERTERS.put(new Key(Timestamp.class, TIMESTAMPTZ.class), new JavaToJavaConverter<Timestamp, TIMESTAMPTZ>(){

            @Override
            protected TIMESTAMPTZ convert(Timestamp src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPTZ((Connection)conn, src);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, Calendar.class), new JavaToJavaConverter<TIMESTAMP, Calendar>(){

            @Override
            protected Calendar convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar cal = Calendar.getInstance();
                cal.setTime(src.timestampValue());
                return cal;
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, java.sql.Date.class), new JavaToJavaConverter<TIMESTAMP, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.dateValue();
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, Date.class), new JavaToJavaConverter<TIMESTAMP, Date>(){

            @Override
            protected Date convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Date(src.timestampValue().getTime());
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, DATE.class), new JavaToJavaConverter<TIMESTAMP, DATE>(){

            @Override
            protected DATE convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(src.dateValue());
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, LocalDate.class), new JavaToJavaConverter<TIMESTAMP, LocalDate>(){

            @Override
            protected LocalDate convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.localDateValue();
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, LocalDateTime.class), new JavaToJavaConverter<TIMESTAMP, LocalDateTime>(){

            @Override
            protected LocalDateTime convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.localDateTimeValue();
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, LocalTime.class), new JavaToJavaConverter<TIMESTAMP, LocalTime>(){

            @Override
            protected LocalTime convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.localTimeValue();
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, String.class), new JavaToJavaConverter<TIMESTAMP, String>(){

            @Override
            protected String convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue();
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, Time.class), new JavaToJavaConverter<TIMESTAMP, Time>(){

            @Override
            protected Time convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.timeValue();
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, Timestamp.class), new JavaToJavaConverter<TIMESTAMP, Timestamp>(){

            @Override
            protected Timestamp convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.timestampValue();
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<TIMESTAMP, TIMESTAMPLTZ>(){

            @Override
            protected TIMESTAMPLTZ convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPLTZ((Connection)conn, src.timestampValue());
            }
        });
        CONVERTERS.put(new Key(TIMESTAMP.class, TIMESTAMPTZ.class), new JavaToJavaConverter<TIMESTAMP, TIMESTAMPTZ>(){

            @Override
            protected TIMESTAMPTZ convert(TIMESTAMP src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPTZ((Connection)conn, src.timestampValue());
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, Calendar.class), new JavaToJavaConverter<TIMESTAMPLTZ, Calendar>(){

            @Override
            protected Calendar convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar cal = 320.getSessionCalendar(conn);
                cal.setTime(src.timestampValue(conn));
                return cal;
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, java.sql.Date.class), new JavaToJavaConverter<TIMESTAMPLTZ, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.dateValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, Date.class), new JavaToJavaConverter<TIMESTAMPLTZ, Date>(){

            @Override
            protected Date convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Date(src.timestampValue(conn).getTime());
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, DATE.class), new JavaToJavaConverter<TIMESTAMPLTZ, DATE>(){

            @Override
            protected DATE convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(src.timestampValue(conn));
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, LocalDateTime.class), new JavaToJavaConverter<TIMESTAMPLTZ, LocalDateTime>(){

            @Override
            protected LocalDateTime convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.localDateTimeValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, OffsetDateTime.class), new JavaToJavaConverter<TIMESTAMPLTZ, OffsetDateTime>(){

            @Override
            protected OffsetDateTime convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.offsetDateTimeValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, String.class), new JavaToJavaConverter<TIMESTAMPLTZ, String>(){

            @Override
            protected String convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, Time.class), new JavaToJavaConverter<TIMESTAMPLTZ, Time>(){

            @Override
            protected Time convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.timeValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, Timestamp.class), new JavaToJavaConverter<TIMESTAMPLTZ, Timestamp>(){

            @Override
            protected Timestamp convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.timestampValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, TIMESTAMP.class), new JavaToJavaConverter<TIMESTAMPLTZ, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src.timestampValue(conn));
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, TIMESTAMPTZ.class), new JavaToJavaConverter<TIMESTAMPLTZ, TIMESTAMPTZ>(){

            @Override
            protected TIMESTAMPTZ convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar cal = 330.getSessionCalendar(conn);
                return new TIMESTAMPTZ((Connection)conn, src.timestampValue(conn), cal);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPLTZ.class, ZonedDateTime.class), new JavaToJavaConverter<TIMESTAMPLTZ, ZonedDateTime>(){

            @Override
            protected ZonedDateTime convert(TIMESTAMPLTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.zonedDateTimeValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, Calendar.class), new JavaToJavaConverter<TIMESTAMPTZ, Calendar>(){

            @Override
            protected Calendar convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar cal = Calendar.getInstance();
                cal.setTime(src.timestampValue(conn));
                cal.setTimeZone(src.getTimeZone());
                return cal;
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, java.sql.Date.class), new JavaToJavaConverter<TIMESTAMPTZ, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.dateValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, Date.class), new JavaToJavaConverter<TIMESTAMPTZ, Date>(){

            @Override
            protected Date convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new Date(src.timestampValue(conn).getTime());
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, DATE.class), new JavaToJavaConverter<TIMESTAMPTZ, DATE>(){

            @Override
            protected DATE convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(src.timestampValue(conn));
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, LocalDateTime.class), new JavaToJavaConverter<TIMESTAMPTZ, LocalDateTime>(){

            @Override
            protected LocalDateTime convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.localDateTimeValue();
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, OffsetDateTime.class), new JavaToJavaConverter<TIMESTAMPTZ, OffsetDateTime>(){

            @Override
            protected OffsetDateTime convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.offsetDateTimeValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, OffsetTime.class), new JavaToJavaConverter<TIMESTAMPTZ, OffsetTime>(){

            @Override
            protected OffsetTime convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toOffsetTime();
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, String.class), new JavaToJavaConverter<TIMESTAMPTZ, String>(){

            @Override
            protected String convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.stringValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, Time.class), new JavaToJavaConverter<TIMESTAMPTZ, Time>(){

            @Override
            protected Time convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.timeValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, Timestamp.class), new JavaToJavaConverter<TIMESTAMPTZ, Timestamp>(){

            @Override
            protected Timestamp convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.timestampValue(conn);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, TIMESTAMP.class), new JavaToJavaConverter<TIMESTAMPTZ, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src.timestampValue(conn));
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<TIMESTAMPTZ, TIMESTAMPLTZ>(){

            @Override
            protected TIMESTAMPLTZ convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                Calendar cal = 343.getSessionCalendar(conn);
                return new TIMESTAMPLTZ((Connection)conn, src.timestampValue(conn), cal);
            }
        });
        CONVERTERS.put(new Key(TIMESTAMPTZ.class, ZonedDateTime.class), new JavaToJavaConverter<TIMESTAMPTZ, ZonedDateTime>(){

            @Override
            protected ZonedDateTime convert(TIMESTAMPTZ src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toZonedDateTime();
            }
        });
        CONVERTERS.put(new Key(URL.class, String.class), new JavaToJavaConverter<URL, String>(){

            @Override
            protected String convert(URL src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.toString();
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, java.sql.Date.class), new JavaToJavaConverter<ZonedDateTime, java.sql.Date>(){

            @Override
            protected java.sql.Date convert(ZonedDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return java.sql.Date.valueOf(src.toLocalDate());
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, DATE.class), new JavaToJavaConverter<ZonedDateTime, DATE>(){

            @Override
            protected DATE convert(ZonedDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new DATE(src);
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, Date.class), new JavaToJavaConverter<ZonedDateTime, Date>(){

            @Override
            protected Date convert(ZonedDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Date.from(src.toInstant());
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, String.class), new JavaToJavaConverter<ZonedDateTime, String>(){

            @Override
            protected String convert(ZonedDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return src.format(OFFSET_DATE_TIME_FORMAT);
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, Timestamp.class), new JavaToJavaConverter<ZonedDateTime, Timestamp>(){

            @Override
            protected Timestamp convert(ZonedDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return Timestamp.valueOf(src.toLocalDateTime());
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, TIMESTAMP.class), new JavaToJavaConverter<ZonedDateTime, TIMESTAMP>(){

            @Override
            protected TIMESTAMP convert(ZonedDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMP(src);
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, TIMESTAMPLTZ.class), new JavaToJavaConverter<ZonedDateTime, TIMESTAMPLTZ>(){

            @Override
            protected TIMESTAMPLTZ convert(ZonedDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return conn.createTIMESTAMPLTZ(Timestamp.valueOf(src.toLocalDateTime()), Calendar.getInstance(TimeZone.getTimeZone(src.getOffset())));
            }
        });
        CONVERTERS.put(new Key(ZonedDateTime.class, TIMESTAMPTZ.class), new JavaToJavaConverter<ZonedDateTime, TIMESTAMPTZ>(){

            @Override
            protected TIMESTAMPTZ convert(ZonedDateTime src, OracleConnection conn, Object srcExtra, Object targetExtra) throws Exception {
                return new TIMESTAMPTZ(src);
            }
        });
    }

    private static final class Key {
        private final Class<?> source;
        private final Class<?> target;
        private final int hash;

        Key(Class<?> s, Class<?> t) {
            this.source = s;
            this.target = t;
            this.hash = s.hashCode() ^ Integer.rotateRight(t.hashCode(), 1);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object rhs) {
            Key r = (Key)rhs;
            return this.hash == r.hash && this.source == r.source && this.target == r.target;
        }

        public boolean satisfies(Key that) {
            return this.source.isAssignableFrom(that.source) && that.target.isAssignableFrom(this.target);
        }

        public String toString() {
            return "[" + this.source.getName() + " to " + this.target.getName() + "]";
        }
    }
}

