/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AbstractShardingCallableStatement;
import oracle.jdbc.driver.AbstractShardingConnection;
import oracle.jdbc.driver.AbstractShardingDatabaseMetaData;
import oracle.jdbc.driver.AbstractShardingLob;
import oracle.jdbc.driver.AbstractShardingPreparedStatement;
import oracle.jdbc.driver.AbstractShardingResultSet;
import oracle.jdbc.driver.AbstractShardingStatement;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CInputStream;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.proxy.ProxyFactory;

class ShardingDriverExtension
extends OracleDriverExtension
implements Diagnosable {
    private static final String CLASS_NAME = ShardingDriverExtension.class.getName();
    static ProxyFactory PROXY_FACTORY = null;
    private static final Monitor proxyFactoryLock = Monitor.newInstance();

    ShardingDriverExtension() {
    }

    @Override
    Connection getConnection(String url, @Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties info, AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        Connection connection = null;
        try {
            connection = (Connection)PROXY_FACTORY.proxyForType(OracleConnection.class);
            ((AbstractShardingConnection)((Object)connection)).initialize(url, info, this, builder);
        }
        catch (SQLException ex) {
            int errorCode = ex.getErrorCode() - 17000;
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getConnection()", "failed to initialize sharding datasource connection, error code={0}", null, null, errorCode);
            if (errorCode == 1708 || errorCode == 1709) {
                try {
                    String driverExtensionClassName = "oracle.jdbc.driver.T4CDriverExtension";
                    OracleDriverExtension driverExtension = (OracleDriverExtension)Class.forName(driverExtensionClassName).newInstance();
                    T4CConnection conn = new T4CConnection(url, info, driverExtension);
                    conn.connect(builder);
                    conn.protocolId = 0;
                    return conn;
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }
            throw ex;
        }
        return connection;
    }

    final CompletionStage<Connection> getConnectionAsync(String url, @Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties info, AbstractConnectionBuilder<?, ?> builder) {
        return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connection is not supported by the sharding driver"));
    }

    @Override
    oracle.jdbc.internal.OracleStatement allocateStatement(OracleConnection conn, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        oracle.jdbc.internal.OracleStatement stmt = null;
        stmt = (oracle.jdbc.internal.OracleStatement)PROXY_FACTORY.proxyForType(oracle.jdbc.internal.OracleStatement.class, conn);
        ((AbstractShardingStatement)((Object)stmt)).initialize((AbstractShardingConnection)((Object)conn), resultSetType);
        return stmt;
    }

    @Override
    OraclePreparedStatement allocatePreparedStatement(OracleConnection conn, String sql, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        OraclePreparedStatement pstmt = null;
        pstmt = (OraclePreparedStatement)PROXY_FACTORY.proxyForType(OraclePreparedStatement.class, conn);
        ((AbstractShardingPreparedStatement)((Object)pstmt)).initialize((AbstractShardingConnection)((Object)conn), sql, resultSetType);
        return pstmt;
    }

    @Override
    OraclePreparedStatement allocatePreparedStatement(OracleConnection conn, String sql, AutoKeyInfo autoKeyInfo) throws SQLException {
        OraclePreparedStatement pstmt = null;
        pstmt = (OraclePreparedStatement)PROXY_FACTORY.proxyForType(OraclePreparedStatement.class, conn);
        ((AbstractShardingPreparedStatement)((Object)pstmt)).initialize((AbstractShardingConnection)((Object)conn), sql, autoKeyInfo);
        return pstmt;
    }

    @Override
    OracleCallableStatement allocateCallableStatement(OracleConnection conn, String sql, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        OracleCallableStatement cstmt = null;
        cstmt = (OracleCallableStatement)PROXY_FACTORY.proxyForType(OracleCallableStatement.class, conn);
        ((AbstractShardingCallableStatement)((Object)cstmt)).initialize((AbstractShardingConnection)((Object)conn), sql, resultSetType);
        return cstmt;
    }

    @Override
    OracleInputStream createInputStream(OracleStatement stmt, int index, Accessor accessor) throws SQLException {
        return new T4CInputStream(stmt, index, accessor);
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    static {
        try (Monitor.CloseableLock lock = proxyFactoryLock.acquireCloseableLock();){
            if (PROXY_FACTORY == null) {
                PROXY_FACTORY = ProxyFactory.createProxyFactory(AbstractShardingConnection.class, AbstractShardingStatement.class, AbstractShardingPreparedStatement.class, AbstractShardingCallableStatement.class, AbstractShardingResultSet.class, AbstractShardingDatabaseMetaData.class, AbstractShardingLob.class);
            }
        }
    }
}

