/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.DatabaseFunction;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;

final class ConnectionTraceContext
implements TraceEventListener.TraceContext {
    private T4CConnection connection;
    private DatabaseFunction databaseFunction;
    private Throwable error;
    private OracleStatement statement;
    private Properties properties;

    ConnectionTraceContext(T4CConnection connection, DatabaseFunction function, Throwable error) {
        this(connection, function, error, null);
    }

    ConnectionTraceContext(T4CConnection connection, DatabaseFunction function, Throwable error, OracleStatement statement) {
        this.connection = connection;
        this.databaseFunction = function;
        this.error = error;
        this.statement = statement;
        try {
            this.properties = connection.getServerSessionInfo();
        }
        catch (SQLException sqlException) {
            this.properties = null;
        }
    }

    @Override
    public String getConnectionId() {
        this.throwIfIllegalState();
        try {
            return this.connection.getNetConnectionId();
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public String databaseOperation() {
        this.throwIfIllegalState();
        return this.databaseFunction.getDescription();
    }

    @Override
    public DatabaseFunction databaseFunction() {
        this.throwIfIllegalState();
        return this.databaseFunction;
    }

    @Override
    public String originalSqlText() {
        this.throwIfIllegalState();
        if (this.statement == null) {
            return null;
        }
        return this.statement.sqlObject.getOriginalSql();
    }

    @Override
    public String actualSqlText() {
        this.throwIfIllegalState();
        if (this.statement == null) {
            return null;
        }
        return this.statement.sqlObject.actualSql;
    }

    @Override
    public String user() {
        this.throwIfIllegalState();
        try {
            return this.connection.getUserName();
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public String tenant() {
        this.throwIfIllegalState();
        return this.connection.getTenantName();
    }

    @Override
    public String getSqlId() {
        this.throwIfIllegalState();
        if (this.statement == null) {
            return null;
        }
        try {
            return this.statement.getSqlId();
        }
        catch (SQLException sqlException) {
            return null;
        }
    }

    @Override
    public Boolean isCompletedExceptionally() {
        this.throwIfIllegalState();
        return this.error != null;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.throwIfIllegalState();
        this.connection.setClientInfo(name, value);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.throwIfIllegalState();
        return this.connection.getClientInfo(name);
    }

    @Override
    public boolean isConnectionClosed() {
        this.throwIfIllegalState();
        try {
            return this.connection.isClosed();
        }
        catch (SQLException e) {
            return true;
        }
    }

    @Override
    public Throwable getThrowable() {
        return this.error;
    }

    @Override
    public String getServiceName() {
        this.throwIfIllegalState();
        if (this.properties != null && this.properties.containsKey("SERVICE_NAME")) {
            return this.properties.getProperty("SERVICE_NAME");
        }
        if (this.connection != null && this.connection.net() != null && this.connection.net().getSessionAttributes() != null && this.connection.net().getSessionAttributes().getcOption() != null) {
            return this.connection.net().getSessionAttributes().getcOption().service_name;
        }
        return null;
    }

    @Override
    public String getInstanceName() {
        this.throwIfIllegalState();
        if (this.properties != null && this.properties.containsKey("INSTANCE_NAME")) {
            return this.properties.getProperty("INSTANCE_NAME");
        }
        if (this.connection != null && this.connection.net() != null && this.connection.net().getSessionAttributes() != null && this.connection.net().getSessionAttributes().getcOption() != null) {
            return this.connection.net().getSessionAttributes().getcOption().instance_name;
        }
        return null;
    }

    @Override
    public int getServerPort() {
        this.throwIfIllegalState();
        if (this.connection != null && this.connection.net() != null && this.connection.net().getSessionAttributes() != null && this.connection.net().getSessionAttributes().getcOption() != null) {
            return this.connection.net().getSessionAttributes().getcOption().port;
        }
        return -1;
    }

    @Override
    public String getServerAddress() {
        this.throwIfIllegalState();
        if (this.connection != null && this.connection.net() != null && this.connection.net().getSessionAttributes() != null && this.connection.net().getSessionAttributes().getcOption() != null) {
            return this.connection.net().getSessionAttributes().getcOption().host;
        }
        return null;
    }

    @Override
    public String getProtocol() {
        this.throwIfIllegalState();
        if (this.connection != null && this.connection.net() != null && this.connection.net().getSessionAttributes() != null && this.connection.net().getSessionAttributes().getcOption() != null) {
            return this.connection.net().getSessionAttributes().getcOption().protocol;
        }
        return null;
    }

    @Override
    public String getSchema() {
        this.throwIfIllegalState();
        if (this.connection != null) {
            return this.connection.currentSchema;
        }
        return null;
    }

    @Override
    public String getDatabaseName() {
        this.throwIfIllegalState();
        if (this.connection != null) {
            return this.connection.dbName;
        }
        return null;
    }

    @Override
    public String getSqlType() {
        this.throwIfIllegalState();
        if (this.connection != null && this.connection.statements != null) {
            return this.connection.statements.sqlKind.toString();
        }
        return null;
    }

    @Override
    public String getConnectionUrl() {
        this.throwIfIllegalState();
        if (this.connection != null) {
            return this.connection.url;
        }
        return null;
    }

    @Override
    public String getShardName() {
        this.throwIfIllegalState();
        return this.properties != null ? this.properties.getProperty("SHARD_NAME") : null;
    }

    @Override
    public String getServerPID() {
        this.throwIfIllegalState();
        return this.properties != null ? this.properties.getProperty("AUTH_SERVER_PID") : null;
    }

    @Override
    public String getSessionID() {
        this.throwIfIllegalState();
        return this.properties != null ? this.properties.getProperty("AUTH_SESSION_ID") : null;
    }

    @Override
    public long getNumRows() {
        this.throwIfIllegalState();
        if (this.databaseFunction == DatabaseFunction.EXECUTE_QUERY || this.databaseFunction == DatabaseFunction.FETCH_ROW || this.databaseFunction == DatabaseFunction.OEXFEN) {
            long numRows = this.connection.all8.getNumRows();
            return numRows == -2L ? 1L : numRows;
        }
        return 0L;
    }

    private void throwIfIllegalState() {
        if (this.connection == null) {
            throw new IllegalStateException();
        }
    }

    void reset() {
        this.connection = null;
    }
}

