/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.replay.driver.TxnReplayableStruct;
import oracle.sql.ANYDATA;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;
import oracle.sql.json.OracleJsonDatum;
import oracle.xdb.XMLType;

class AQMessageI
implements AQMessage {
    private byte[] id = null;
    private AQMessagePropertiesI properties = null;
    private byte[] toid = null;
    private int version = 1;
    private byte[] payload;
    private OracleStruct payLoadStruct;
    private ANYDATA payLoadANYDATA;
    private RAW payLoadRAW;
    private XMLType payLoadXMLType;
    private OracleJsonDatum payloadJson;
    private Connection conn;
    private String typeName;
    private TypeDescriptor sd;

    AQMessageI(AQMessagePropertiesI _prop, Connection _conn) {
        this.properties = _prop;
        this.conn = _conn;
    }

    AQMessageI(AQMessagePropertiesI prop) throws SQLException {
        this.properties = prop;
    }

    void setTypeName(String _typeName) {
        this.typeName = _typeName;
    }

    void setTypeDescriptor(TypeDescriptor _sd) {
        this.sd = _sd;
    }

    @Override
    public byte[] getMessageId() {
        return this.id;
    }

    void setMessageId(byte[] _id) throws SQLException {
        this.id = _id;
    }

    @Override
    public AQMessageProperties getMessageProperties() {
        return this.properties;
    }

    AQMessagePropertiesI getMessagePropertiesI() {
        return this.properties;
    }

    @Override
    public void setPayload(byte[] _payload) throws SQLException {
        this.payload = _payload;
        this.toid = TypeDescriptor.RAWTOID;
    }

    @Override
    public void setPayload(byte[] _payload, byte[] _toid) throws SQLException {
        this.payload = _payload;
        this.toid = _toid;
    }

    @Override
    public void setPayload(Struct _payload) throws SQLException {
        assert (_payload instanceof OracleStruct) : "_payload is " + String.valueOf(_payload);
        this.payload = ((OracleStruct)_payload).toBytes();
        this.payLoadStruct = (OracleStruct)_payload;
        this.toid = ((OracleStruct)_payload).getDescriptor().getOracleTypeADT().getTOID();
        this.version = ((OracleStruct)_payload).getDescriptor().getOracleTypeADT().getTypeVersion();
    }

    @Override
    public void setPayload(STRUCT _payload) throws SQLException {
        this.payload = _payload.toBytes();
        this.payLoadStruct = _payload;
        this.toid = _payload.getDescriptor().getOracleTypeADT().getTOID();
        this.version = _payload.getDescriptor().getOracleTypeADT().getTypeVersion();
    }

    @Override
    public void setPayload(ANYDATA _payload) throws SQLException {
        this.payload = _payload.toDatum(this.conn).shareBytes();
        this.payLoadANYDATA = _payload;
        this.toid = TypeDescriptor.ANYDATATOID;
    }

    @Override
    public void setPayload(RAW _payload) throws SQLException {
        this.payload = _payload.shareBytes();
        this.payLoadRAW = _payload;
        this.toid = TypeDescriptor.RAWTOID;
    }

    @Override
    public void setPayload(XMLType _payload) throws SQLException {
        this.payload = _payload.toBytes();
        this.payLoadXMLType = _payload;
        this.toid = TypeDescriptor.XMLTYPETOID;
    }

    @Override
    public void setPayload(OracleJsonDatum jsonPayload) {
        this.payload = jsonPayload.shareBytes();
        this.payloadJson = jsonPayload;
        this.toid = TypeDescriptor.JSONTOID;
    }

    @Override
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public RAW getRAWPayload() throws SQLException {
        RAW ret = null;
        if (this.payLoadRAW != null) {
            ret = this.payLoadRAW;
        } else if (this.isRAWPayload()) {
            ret = this.payLoadRAW = new RAW(this.payload);
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
        }
        return ret;
    }

    @Override
    public boolean isRAWPayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
        }
        return AQMessageI.compareToid(this.toid, TypeDescriptor.RAWTOID);
    }

    @Override
    public OracleJsonDatum getJSONPayload() throws SQLException {
        OracleJsonDatum ret = null;
        if (this.payloadJson != null) {
            ret = this.payloadJson;
        } else if (this.isJSONPayload()) {
            ret = this.payloadJson = new OracleJsonDatum(this.payload);
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
        }
        return ret;
    }

    @Override
    public boolean isJSONPayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
        }
        return AQMessageI.compareToid(this.toid, TypeDescriptor.JSONTOID);
    }

    @Override
    public Struct getStructPayload() throws SQLException {
        return this.getSTRUCTPayload();
    }

    @Override
    public Struct getStructPayload(Connection conn) throws SQLException {
        return this.getSTRUCTPayload(conn);
    }

    @Override
    public STRUCT getSTRUCTPayload(Connection conn) throws SQLException {
        STRUCT ret = null;
        if (!this.isSTRUCTPayload()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
        }
        if (this.payLoadStruct != null) {
            ret = this.payLoadStruct instanceof STRUCT ? (STRUCT)this.payLoadStruct : (STRUCT)((TxnReplayableStruct)((Object)this.payLoadStruct)).getDelegateStruct();
        } else {
            if (this.sd == null) {
                this.typeName = OracleTypeADT.toid2typename(conn, this.toid);
                this.sd = TypeDescriptor.getTypeDescriptor(this.typeName, (OracleConnection)conn);
            }
            if (this.sd instanceof StructDescriptor) {
                ret = new STRUCT((StructDescriptor)this.sd, this.payload, conn);
                this.payLoadStruct = ret;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
            }
        }
        return ret;
    }

    @Override
    public STRUCT getSTRUCTPayload() throws SQLException {
        return this.getSTRUCTPayload(this.conn);
    }

    @Override
    public boolean isSTRUCTPayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
        }
        boolean isObjectPayload = true;
        boolean allzero = true;
        for (int i = 0; i < 15; ++i) {
            if (this.toid[i] == 0) continue;
            allzero = false;
            break;
        }
        if (allzero || this.isRAWPayload() || this.isANYDATAPayload()) {
            isObjectPayload = false;
        }
        return isObjectPayload;
    }

    @Override
    public ANYDATA getANYDATAPayload() throws SQLException {
        ANYDATA ret = null;
        if (this.payLoadANYDATA != null) {
            ret = this.payLoadANYDATA;
        } else if (this.isANYDATAPayload()) {
            OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", this.conn);
            OPAQUE opq = new OPAQUE(desc, this.payload, this.conn);
            ret = this.payLoadANYDATA = new ANYDATA(opq);
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
        }
        return ret;
    }

    @Override
    public boolean isANYDATAPayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
        }
        return this.typeName != null && this.typeName.equals("SYS.ANYDATA") || AQMessageI.compareToid(this.toid, TypeDescriptor.ANYDATATOID);
    }

    @Override
    public XMLType getXMLTypePayload() throws SQLException {
        XMLType ret = null;
        if (this.payLoadXMLType != null) {
            ret = this.payLoadXMLType;
        } else if (this.isXMLTypePayload()) {
            OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor("SYS.XMLTYPE", this.conn);
            OPAQUE opq = new OPAQUE(desc, this.payload, this.conn);
            ret = this.payLoadXMLType = XMLType.createXML((OPAQUE)opq);
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
        }
        return ret;
    }

    @Override
    public boolean isXMLTypePayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
        }
        return this.typeName != null && this.typeName.equals("SYS.XMLTYPE") || AQMessageI.compareToid(this.toid, TypeDescriptor.XMLTYPETOID);
    }

    @Override
    public byte[] getPayloadTOID() {
        return this.toid;
    }

    public int getPayloadVersion() {
        return this.version;
    }

    static boolean compareToid(byte[] toid, byte[] toid2) {
        boolean ret = false;
        if (toid != null) {
            if (toid == toid2) {
                ret = true;
            } else if (toid.length == toid2.length) {
                boolean identical = true;
                for (int i = 0; i < toid.length; ++i) {
                    if (toid[i] == toid2[i]) continue;
                    identical = false;
                    break;
                }
                if (identical) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Message Properties={");
        sb.append(this.properties);
        sb.append("} ");
        return sb.toString();
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

