/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OraclePreparedStatement;

class CopiedByteBinder
extends Binder {
    byte[] value;
    short len;

    CopiedByteBinder(short type, int bytelen, byte[] val, short l) {
        this.type = type;
        this.bytelen = bytelen;
        this.value = val;
        this.len = l;
    }

    @Override
    Binder copyingBinder() {
        return this;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = this.len;
        System.arraycopy(this.value, 0, bindBytes, byteoffset, this.value.length);
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.value, 0, this.value.length);
        }
        return localCheckSum;
    }
}

