/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.OPAQUE;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.OBJECT_METADATA})
public class OpaqueDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Opaque,
Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;

    public OpaqueDescriptor(String string, Connection connection) throws SQLException {
        this(string, connection, true);
    }

    private OpaqueDescriptor(String string, Connection connection, boolean bl) throws SQLException {
        super((short)58, string, connection);
        if (bl) {
            this.initPickler();
        }
    }

    public OpaqueDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super((short)58, sQLName, connection);
        this.initPickler();
    }

    public OpaqueDescriptor(SQLName sQLName, OracleTypeOPAQUE oracleTypeOPAQUE, Connection connection) throws SQLException {
        super((short)58, sQLName, oracleTypeOPAQUE, connection);
    }

    public OpaqueDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super((short)58, oracleTypeADT, connection);
    }

    OpaqueDescriptor(byte[] byArray, int n2, Connection connection) throws SQLException {
        super((short)108);
        this.toid = byArray;
        this.toidVersion = n2;
        this.setPhysicalConnectionOf(connection);
        this.initPickler();
    }

    public static OpaqueDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            throw (SQLException)DatabaseError.createSqlException(60, "Invalid argument, 'name' shouldn't be null nor an empty string and 'conn' should not be null").fillInStackTrace();
        }
        SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
        String string2 = sQLName.getName();
        OpaqueDescriptor opaqueDescriptor = null;
        if (connection != null) {
            opaqueDescriptor = (OpaqueDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string2);
        }
        if (opaqueDescriptor == null) {
            if (string2.equals("SYS.ANYTYPE")) {
                OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, 0, string2, 7L);
                opaqueDescriptor = new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, connection);
            } else if (string2.equals("SYS.ANYDATA")) {
                OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, 0, string2, 7L);
                opaqueDescriptor = new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, connection);
            } else {
                short s2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getVersionNumber();
                opaqueDescriptor = s2 >= 12000 ? new OpaqueDescriptor(string, connection) : new OpaqueDescriptor(sQLName, connection);
            }
            if (connection != null) {
                ((oracle.jdbc.OracleConnection)connection).putDescriptor(string2, opaqueDescriptor);
            }
        }
        return opaqueDescriptor;
    }

    public static CompletionStage<OpaqueDescriptor> createDescriptorAsync(String string, Connection connection) {
        if (string == null || string.length() == 0) {
            return CompletableFuture.failedStage((SQLException)DatabaseError.createSqlException(60, "Invalid argument, 'name' shouldn't be null nor an empty string and 'conn' should not be null").fillInStackTrace());
        }
        try {
            CompletionStage<OpaqueDescriptor> completionStage;
            OracleConnection oracleConnection = (OracleConnection)connection;
            SQLName sQLName = new SQLName(string, oracleConnection);
            String string2 = sQLName.getName();
            if (oracleConnection != null && (completionStage = (OpaqueDescriptor)oracleConnection.getDescriptor(string2)) != null) {
                return CompletableFuture.completedStage(completionStage);
            }
            if (string2.equals("SYS.ANYTYPE")) {
                OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, 0, string2, 7L);
                completionStage = CompletableFuture.completedStage(new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, (Connection)oracleConnection));
            } else if (string2.equals("SYS.ANYDATA")) {
                OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, 0, string2, 7L);
                completionStage = CompletableFuture.completedStage(new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, connection));
            } else {
                OpaqueDescriptor opaqueDescriptor2 = new OpaqueDescriptor(string, connection, false);
                completionStage = opaqueDescriptor2.initPicklerAsync().thenApply(void_ -> opaqueDescriptor2);
            }
            if (oracleConnection != null) {
                return completionStage.thenApply(CompletionStageUtil.normalCompletionHandler(opaqueDescriptor -> {
                    oracleConnection.putDescriptor(string2, opaqueDescriptor);
                    return opaqueDescriptor;
                }));
            }
            return completionStage;
        }
        catch (SQLException sQLException) {
            return CompletableFuture.failedStage(sQLException);
        }
    }

    public static OpaqueDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        String string = sQLName.getName();
        OpaqueDescriptor opaqueDescriptor = null;
        if (connection != null) {
            opaqueDescriptor = (OpaqueDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string);
        }
        if (opaqueDescriptor == null) {
            if (string.equals("SYS.ANYTYPE")) {
                OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, 0, string, 7L);
                opaqueDescriptor = new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, connection);
            } else if (string.equals("SYS.ANYDATA")) {
                OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, 0, string, 7L);
                opaqueDescriptor = new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, connection);
            } else {
                opaqueDescriptor = new OpaqueDescriptor(sQLName, connection);
            }
            if (connection != null) {
                ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, opaqueDescriptor);
            }
        }
        return opaqueDescriptor;
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        return OracleTypeMetaData.Kind.OPAQUE;
    }

    private void initPickler() throws SQLException {
        try {
            String string = this.typeNameByUser;
            if (string == null) {
                string = this.getName();
            }
            this.pickler = new OracleTypeADT(string, (Connection)this.connection);
            ((OracleTypeADT)this.pickler).init(this.connection);
            this.pickler = (OracleTypeOPAQUE)((OracleTypeADT)this.pickler).cleanup();
            this.pickler.setDescriptor(this);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw (SQLException)DatabaseError.createSqlException(60, "Unable to resolve type \"" + this.getName() + "\"").fillInStackTrace();
        }
    }

    private CompletionStage<Void> initPicklerAsync() {
        CompletionStage<Object> completionStage;
        try {
            String string = this.typeNameByUser;
            if (string == null) {
                string = this.getName();
            }
            this.pickler = new OracleTypeADT(string, (Connection)this.connection);
            completionStage = ((OracleTypeADT)this.pickler).initAsync(this.connection).thenApply(CompletionStageUtil.normalCompletionHandler(void_ -> {
                this.pickler = (OracleTypeOPAQUE)((OracleTypeADT)this.pickler).cleanup();
                this.pickler.setDescriptor(this);
                return void_;
            }));
        }
        catch (Exception exception) {
            completionStage = CompletableFuture.failedStage(exception);
        }
        return completionStage.exceptionally(throwable -> {
            SQLException sQLException;
            Throwable throwable2 = CompletionStageUtil.unwrapCompletionException(throwable);
            if (throwable2 instanceof SQLException) {
                sQLException = (SQLException)throwable2;
            } else {
                try {
                    sQLException = (SQLException)DatabaseError.createSqlException(60, "Unable to resolve type \"" + this.getName() + "\"").fillInStackTrace();
                }
                catch (SQLException sQLException2) {
                    throw new CompletionException(sQLException2);
                }
            }
            throw new CompletionException(sQLException);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toBytes(OPAQUE oPAQUE, boolean bl) throws SQLException {
        byte[] byArray = null;
        if (oPAQUE.shareBytes() != null) {
            byArray = oPAQUE.shareBytes();
        } else {
            try {
                byArray = this.pickler.linearize(oPAQUE);
            }
            finally {
                if (!bl) {
                    oPAQUE.setShareBytes(null);
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toValue(OPAQUE oPAQUE, boolean bl) throws SQLException {
        byte[] byArray = null;
        if (oPAQUE.value != null) {
            byArray = oPAQUE.value;
        } else {
            try {
                this.pickler.unlinearize(oPAQUE.shareBytes(), 0L, oPAQUE, 1, null);
                byArray = oPAQUE.value;
            }
            finally {
                if (!bl) {
                    oPAQUE.value = null;
                }
            }
        }
        return byArray;
    }

    @Override
    public int getTypeCode() throws SQLException {
        if (this.sqlName != null && "SYS.XMLTYPE".equalsIgnoreCase(this.sqlName.getName()) || this.typeNameByUser != null && "SYS.XMLTYPE".equals(this.typeNameByUser)) {
            return 2009;
        }
        return 2007;
    }

    @Override
    public boolean isInHierarchyOf(String string) throws SQLException {
        OpaqueDescriptor opaqueDescriptor = this;
        String string2 = opaqueDescriptor.getName();
        return string.equals(string2);
    }

    @Override
    public long getMaxLength() throws SQLException {
        long l2 = this.hasUnboundedSize() ? 0L : ((OracleTypeOPAQUE)this.pickler).getMaxLength();
        return l2;
    }

    @Override
    public boolean isTrustedLibrary() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isTrustedLibrary();
    }

    @Override
    public boolean isModeledInC() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isModeledInC();
    }

    @Override
    public boolean hasUnboundedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isUnboundedSized();
    }

    @Override
    public boolean hasFixedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.pickler).isFixedSized();
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        Object object = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            object = (String)object + "  ";
        }
        String string = (String)object + "  ";
        stringBuffer.append((String)object);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append(" maxLen=" + this.getMaxLength() + " isTrusted=" + this.isTrustedLibrary() + " hasUnboundedSize=" + this.hasUnboundedSize() + " hasFixedSize=" + this.hasFixedSize());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

