/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.util.Arrays;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.sql.RAW;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonBinaryImpl
implements OracleJsonBinary {
    protected static final char[] HEX_UPPER = "0123456789ABCDEF".toCharArray();
    protected static final char[] HEX_LOWER = "0123456789abcdef".toCharArray();
    private byte[] bytes;
    boolean isId;

    public OracleJsonBinaryImpl(byte[] byArray, boolean bl) {
        this.bytes = byArray;
        this.isId = bl;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.BINARY;
    }

    @Override
    public boolean isId() {
        return this.isId;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonBinary)) {
            return false;
        }
        OracleJsonBinary oracleJsonBinary = (OracleJsonBinary)object;
        byte[] byArray = this.getBytes();
        byte[] byArray2 = oracleJsonBinary.getBytes();
        return Arrays.equals(byArray, byArray2);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }

    @Override
    public String toString() {
        return JsonSerializerImpl.serializeString(this.getString());
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String getString() {
        return OracleJsonBinaryImpl.getString(this.bytes, this.isId);
    }

    public static String getString(byte[] byArray, boolean bl) {
        return new String(OracleJsonBinaryImpl.serializeBinary(byArray, bl ? HEX_LOWER : HEX_UPPER));
    }

    @Override
    public RAW getRAW() {
        return new RAW(this.getBytes());
    }

    private static char[] serializeBinary(byte[] byArray, char[] cArray) {
        char[] cArray2 = new char[byArray.length * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            byte by = byArray[n2++];
            cArray2[n3++] = cArray[by >> 4 & 0xF];
            cArray2[n3++] = cArray[by & 0xF];
        }
        return cArray2;
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        return clazz.cast(new JsonpPrimitive.JsonpBinaryImpl(this.bytes, this.isId));
    }
}

