/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public class StatisticsTracker
implements Serializable {
    private final Integer FIXED_VALUE = 1;
    private ConcurrentHashMap<oracle.jdbc.replay.internal.ReplayStatistics, Integer> acStatistics = new ConcurrentHashMap();
    private AtomicBoolean dsNameSet = new AtomicBoolean(false);
    private ReplayStatisticsImpl aggregateStats = new ReplayStatisticsImpl();
    private String dsName = null;

    public ReplayStatistics getReplayStatistics() {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        int[] nArray = new int[31];
        for (oracle.jdbc.replay.internal.ReplayStatistics replayStatistics : this.acStatistics.keySet()) {
            l2 += replayStatistics.getTotalRequests();
            l3 += replayStatistics.getTotalCompletedRequests();
            l4 += replayStatistics.getTotalCalls();
            l5 += replayStatistics.getTotalProtectedCalls();
            l6 += replayStatistics.getTotalCallsAffectedByOutages();
            l7 += replayStatistics.getTotalCallsTriggeringReplay();
            l8 += replayStatistics.getTotalCallsAffectedByOutagesDuringReplay();
            l9 += replayStatistics.getSuccessfulReplayCount();
            l10 += replayStatistics.getFailedReplayCount();
            l11 += replayStatistics.getReplayDisablingCount();
            l12 += replayStatistics.getTotalReplayAttempts();
            int[] nArray2 = replayStatistics.getRequestSizeHistogram();
            if (nArray2 == null || nArray2.length <= 0) continue;
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n2 = i2;
                nArray[n2] = nArray[n2] + nArray2[i2];
            }
        }
        ReplayStatisticsImpl replayStatisticsImpl = new ReplayStatisticsImpl(l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, 0);
        replayStatisticsImpl.setRequestSizeHistogram(nArray);
        replayStatisticsImpl.aggregate(this.aggregateStats);
        return replayStatisticsImpl;
    }

    @DisableTrace
    public String getReplayStatisticsString() {
        ReplayStatisticsImpl replayStatisticsImpl = (ReplayStatisticsImpl)this.getReplayStatistics();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(replayStatisticsImpl.toString()).append("\n\n").append(replayStatisticsImpl.getRequestSizeHistogramString()).append("\n\n");
        return stringBuilder.toString();
    }

    public void clearReplayStatistics() {
        this.acStatistics = new ConcurrentHashMap();
        this.aggregateStats = new ReplayStatisticsImpl();
    }

    public void updateReplayStatistics(String string, oracle.jdbc.replay.internal.ReplayStatistics replayStatistics) {
        if (this.dsNameSet.compareAndSet(false, true) && string != null) {
            this.dsName = string;
        }
        if (replayStatistics != null) {
            this.acStatistics.put(replayStatistics, this.FIXED_VALUE);
        }
    }

    public void removeReplayStatistics(final oracle.jdbc.replay.internal.ReplayStatistics replayStatistics) {
        try {
            OracleDriver.getExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (replayStatistics != null) {
                            StatisticsTracker.this.acStatistics.remove(replayStatistics);
                        }
                        StatisticsTracker.this.aggregateStats.aggregate(replayStatistics);
                    }
                    catch (Throwable throwable) {
                    }
                }
            });
        }
        catch (Throwable throwable) {
        }
    }

    public String getDataSourceName() {
        return this.dsName;
    }
}

