/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.time.OffsetDateTime;
import java.util.Arrays;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonTimestampTZImpl
implements OracleJsonTimestampTZ {
    byte[] raw;

    public OracleJsonTimestampTZImpl(byte[] byArray) {
        this.raw = byArray;
        OsonPrimitiveConversions.assertNoRegionTimestampTZ(this.getExceptionFactory(), byArray);
    }

    public OracleJsonTimestampTZImpl(OffsetDateTime offsetDateTime) {
        this.raw = OsonPrimitiveConversions.toOracleTimestampTZ(this.getExceptionFactory(), offsetDateTime);
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.TIMESTAMPTZ;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonTimestampTZ)) {
            return false;
        }
        if (!(object instanceof OracleJsonTimestampTZImpl)) {
            throw new UnsupportedOperationException();
        }
        OracleJsonTimestampTZImpl oracleJsonTimestampTZImpl = (OracleJsonTimestampTZImpl)object;
        return Arrays.equals(oracleJsonTimestampTZImpl.raw, this.raw);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }

    @Override
    public String getString() {
        return OsonPrimitiveConversions.timestampTZToString(this.getExceptionFactory(), this.raw);
    }

    @Override
    public String toString() {
        return JsonSerializerImpl.serializeString(this.getString());
    }

    public byte[] raw() {
        return this.raw;
    }

    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ() {
        return new TIMESTAMPTZ(this.raw());
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        if (Jsonp.isJakartaJson(clazz)) {
            return clazz.cast(new JakartaPrimitive.JakartaTimestampTZImpl(this.raw));
        }
        return clazz.cast(new JsonpPrimitive.JsonpTimestampTZImpl(this.raw));
    }

    public OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    @Override
    public OffsetDateTime getOffsetDateTime() {
        return OsonPrimitiveConversions.timestamptzToOffsetDateTime(this.getExceptionFactory(), this.raw);
    }
}

