/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JakartaOsonContext;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.JsonpOsonContext;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public class OsonObjectImpl
extends OsonAbstractObject
implements OracleJsonObject {
    public OsonObjectImpl(OsonContext osonContext, int n2) {
        super(osonContext);
        this.init(n2);
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        OsonContext osonContext = Jsonp.isJakartaJson(clazz) ? new JakartaOsonContext(this.ctx) : new JsonpOsonContext(this.ctx);
        return clazz.cast(osonContext.valueFactory.createObject(osonContext, this.pos));
    }

    @Override
    public OracleJsonValue get(Object object) {
        return (OracleJsonValue)this.getInternal(object);
    }

    public OracleJsonValue get(int n2) {
        return (OracleJsonValue)this.getInternal(n2);
    }

    @Override
    public Collection<OracleJsonValue> values() {
        return new OsonAbstractObject.OsonObjectValues<OracleJsonValue>();
    }

    @Override
    public Set<Map.Entry<String, OracleJsonValue>> entrySet() {
        return new OsonAbstractObject.OsonEntrySet<OracleJsonValue>();
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JsonSerializerImpl jsonSerializerImpl = new JsonSerializerImpl(stringWriter);
        jsonSerializerImpl.write(this);
        jsonSerializerImpl.close();
        return stringWriter.toString();
    }

    @Override
    public byte[] getBytes(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonBinary)this.getValueInternal(n2)).getBytes();
    }

    @Override
    public byte[] getBytes(String string, byte[] byArray) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return byArray;
        }
        OracleJsonValue oracleJsonValue = (OracleJsonValue)this.getValueInternal(n2);
        return oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.BINARY ? oracleJsonValue.asJsonBinary().getBytes() : byArray;
    }

    @Override
    public double getDouble(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonNumber)this.getValueInternal(n2)).doubleValue();
    }

    @Override
    public double getDouble(String string, double d2) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return d2;
        }
        OracleJsonNumber oracleJsonNumber = this.getNumeric(n2);
        return oracleJsonNumber == null ? d2 : oracleJsonNumber.doubleValue();
    }

    private OracleJsonNumber getNumeric(int n2) {
        Object object = this.getValueInternal(n2);
        return object instanceof OracleJsonNumber ? (OracleJsonNumber)object : null;
    }

    @Override
    public long getLong(String string, long l2) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return l2;
        }
        OracleJsonNumber oracleJsonNumber = this.getNumeric(n2);
        return oracleJsonNumber == null ? l2 : oracleJsonNumber.longValue();
    }

    @Override
    public BigDecimal getBigDecimal(String string, BigDecimal bigDecimal) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return bigDecimal;
        }
        OracleJsonNumber oracleJsonNumber = this.getNumeric(n2);
        return oracleJsonNumber == null ? bigDecimal : oracleJsonNumber.bigDecimalValue();
    }

    @Override
    public long getLong(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonNumber)this.getValueInternal(n2)).longValue();
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonNumber)this.getValueInternal(n2)).bigDecimalValue();
    }

    @Override
    public LocalDateTime getLocalDateTime(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        OracleJsonValue oracleJsonValue = (OracleJsonValue)this.getValueInternal(n2);
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return oracleJsonValue.asJsonDate().getLocalDateTime();
        }
        return oracleJsonValue.asJsonTimestamp().getLocalDateTime();
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        OracleJsonTimestampTZ oracleJsonTimestampTZ = (OracleJsonTimestampTZ)this.getValueInternal(n2);
        return oracleJsonTimestampTZ.getOffsetDateTime();
    }

    @Override
    public LocalDateTime getLocalDateTime(String string, LocalDateTime localDateTime) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return localDateTime;
        }
        OracleJsonValue oracleJsonValue = (OracleJsonValue)this.getValueInternal(n2);
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return oracleJsonValue.asJsonDate().getLocalDateTime();
        }
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMP) {
            return oracleJsonValue.asJsonTimestamp().getLocalDateTime();
        }
        return localDateTime;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String string, OffsetDateTime offsetDateTime) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return offsetDateTime;
        }
        OracleJsonValue oracleJsonValue = (OracleJsonValue)this.getValueInternal(n2);
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMPTZ) {
            return oracleJsonValue.asJsonTimestampTZ().getOffsetDateTime();
        }
        return offsetDateTime;
    }

    @Override
    public OracleJsonValue put(String string, String string2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, int n2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, long l2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, BigDecimal bigDecimal) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, double d2) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, boolean bl) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue putNull(String string) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, byte[] byArray) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, OracleJsonValue oracleJsonValue) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue remove(Object object) {
        throw this.createNotModifiable();
    }

    @Override
    public void putAll(Map<? extends String, ? extends OracleJsonValue> map) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, LocalDateTime localDateTime) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String string, OffsetDateTime offsetDateTime) {
        throw this.createNotModifiable();
    }

    @Override
    public void clear() {
        throw this.createNotModifiable();
    }

    private UnsupportedOperationException createNotModifiable() {
        throw OracleJsonExceptions.OBJ_NOT_MUTABLE.create(OracleJsonExceptions.ORACLE_FACTORY, new Object[0]);
    }
}

